<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.2.0
*/namespace
Adminer;const
VERSION="5.2.0";error_reporting(24575);set_error_handler(function($qc,$sc){return!!preg_match('~^Undefined (array key|offset|index)~',$sc);},E_WARNING|E_NOTICE);$Lc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Lc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$ei=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($ei)$$X=$ei;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($g=null){return($g?:Db::$Kd);}function
adminer(){return
Adminer::$Kd;}function
driver(){return
Driver::$Kd;}function
connect(){$vb=adminer()->credentials();$K=Driver::connect($vb[0],$vb[1],$vb[2]);return(is_object($K)?$K:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$de=substr($v,-1);return
str_replace($de.$de,$de,substr($v,1,-1));}function
q($ih){return
connection()->quote($ih);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($ta,$y,$k=null){return($ta&&array_key_exists($y,$ta)?$ta[$y]:$k);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$dg,$Lc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($dg)){foreach($X
as$Vd=>$W){unset($dg[$y][$Vd]);if(is_array($W)){$dg[$y][stripslashes($Vd)]=$W;$dg[]=&$dg[$y][stripslashes($Vd)];}else$dg[$y][stripslashes($Vd)]=($Lc?$W:stripslashes($W));}}}}function
bracket_escape($v,$Aa=false){static$Rh=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Aa?array_flip($Rh):$Rh));}function
min_version($ti,$qe="",$g=null){$g=connection($g);$Ng=$g->server_info;if($qe&&preg_match('~([\d.]+)-MariaDB~',$Ng,$B)){$Ng=$B[1];$ti=$qe;}return$ti&&version_compare($Ng,$ti)>=0;}function
charset(Db$f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
ini_bool($Fd){$X=ini_get($Fd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$K;if($K===null)$K=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$K;}function
set_password($si,$P,$V,$G){$_SESSION["pwds"][$si][$P][$V]=($_COOKIE["adminer_key"]&&is_string($G)?array(encrypt_string($G,$_COOKIE["adminer_key"])):$G);}function
get_password(){$K=get_session("pwds");if(is_array($K))$K=($_COOKIE["adminer_key"]?decrypt_string($K[0],$_COOKIE["adminer_key"]):false);return$K;}function
get_val($I,$m=0,$lb=null){$lb=connection($lb);$J=$lb->query($I);if(!is_object($J))return
false;$L=$J->fetch_row();return($L?$L[$m]:false);}function
get_vals($I,$c=0){$K=array();$J=connection()->query($I);if(is_object($J)){while($L=$J->fetch_row())$K[]=$L[$c];}return$K;}function
get_key_vals($I,$g=null,$Qg=true){$g=connection($g);$K=array();$J=$g->query($I);if(is_object($J)){while($L=$J->fetch_row()){if($Qg)$K[$L[0]]=$L[1];else$K[]=$L[0];}}return$K;}function
get_rows($I,$g=null,$l="<p class='error'>"){$lb=connection($g);$K=array();$J=$lb->query($I);if(is_object($J)){while($L=$J->fetch_assoc())$K[]=$L;}elseif(!$J&&!$g&&$l&&(defined('Adminer\PAGE_HEADER')||$l=="-- "))echo$l.error()."\n";return$K;}function
unique_array($L,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$K=array();foreach($w["columns"]as$y){if(!isset($L[$y]))continue
2;$K[$y]=$L[$y];}return$K;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($y);}function
where(array$Z,array$n=array()){$K=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$c=escape_key($y);$m=idx($n,$y,array());$Jc=$m["type"];$K[]=$c.(JUSH=="sql"&&$Jc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Jc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($m,q($X)))));if(JUSH=="sql"&&preg_match('~char|text~',$Jc)&&preg_match("~[^ -@]~",$X))$K[]="$c = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$K[]=escape_key($y)." IS NULL";return
implode(" AND ",$K);}function
where_check($X,array$n=array()){parse_str($X,$Sa);remove_slashes(array(&$Sa));return
where($Sa,$n);}function
where_link($t,$c,$Y,$if="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($c)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$if:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$d,array$n,array$O=array()){$K="";foreach($d
as$y=>$X){if($O&&!in_array(idf_escape($y),$O))continue;$ua=convert_field($n[$y]);if($ua)$K
.=", $ua AS ".idf_escape($y);}return$K;}function
cookie($D,$Y,$le=2592000){header("Set-Cookie: $D=".urlencode($Y).($le?"; expires=".gmdate("D, d M Y H:i:s",time()+$le)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($rb){parse_str($_COOKIE[$rb],$Rg);return$Rg;}function
get_setting($y,$rb="adminer_settings"){$Rg=get_settings($rb);return$Rg[$y];}function
save_settings(array$Rg,$rb="adminer_settings"){$Y=http_build_query($Rg+get_settings($rb));cookie($rb,$Y);$_COOKIE[$rb]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($Qc=false){$mi=ini_bool("session.use_cookies");if(!$mi||$Qc){session_write_close();if($mi&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($si,$P,$V,$j=null){$ii=remove_from_uri(implode("|",array_keys(SqlDriver::$Vb))."|username|ext|".($j!==null?"db|":"").($si=='mssql'||$si=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$ii,$B);return"$B[1]?".(sid()?SID."&":"").($si!="server"||$P!=""?urlencode($si)."=".urlencode($P)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$C=null){if($C!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$C;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($I,$A,$C,$lg=true,$xc=true,$Fc=false,$Eh=""){if($xc){$eh=microtime(true);$Fc=!connection()->query($I);$Eh=format_time($eh);}$Zg=($I?adminer()->messageQuery($I,$Eh,$Fc):"");if($Fc){adminer()->error
.=error().$Zg.script("messagesPrint();")."<br>";return
false;}if($lg)redirect($A,$C.$Zg);return
true;}class
Queries{static$gg=array();static$eh=0;}function
queries($I){if(!Queries::$eh)Queries::$eh=microtime(true);Queries::$gg[]=(preg_match('~;$~',$I)?"DELIMITER ;;\n$I;\nDELIMITER ":$I).";";return
connection()->query($I);}function
apply_queries($I,array$T,$tc='Adminer\table'){foreach($T
as$R){if(!queries("$I ".$tc($R)))return
false;}return
true;}function
queries_redirect($A,$C,$lg){$gg=implode("\n",Queries::$gg);$Eh=format_time(Queries::$eh);return
query_redirect($gg,$A,$C,$lg,false,!$lg,$Eh);}function
format_time($eh){return
lang(0,max(0,microtime(true)-$eh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Bf=""){return
substr(preg_replace("~(?<=[?&])($Bf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Gb=false,$Lb=""){$Kc=$_FILES[$y];if(!$Kc)return
null;foreach($Kc
as$y=>$X)$Kc[$y]=(array)$X;$K='';foreach($Kc["error"]as$y=>$l){if($l)return$l;$D=$Kc["name"][$y];$Mh=$Kc["tmp_name"][$y];$nb=file_get_contents($Gb&&preg_match('~\.gz$~',$D)?"compress.zlib://$Mh":$Mh);if($Gb){$eh=substr($nb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$eh))$nb=iconv("utf-16","utf-8",$nb);elseif($eh=="\xEF\xBB\xBF")$nb=substr($nb,3);}$K
.=$nb;if($Lb)$K
.=(preg_match("($Lb\\s*\$)",$nb)?"":$Lb)."\n\n";}return$K;}function
upload_error($l){$xe=($l==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($l?lang(1).($xe?" ".lang(2,$xe):""):lang(3));}function
repeat_pattern($Kf,$je){return
str_repeat("$Kf{0,65535}",$je/65535)."$Kf{0,".($je%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Gc=false){$K=table_status($R,$Gc);return($K?reset($K):array("Name"=>$R));}function
column_foreign_keys($R){$K=array();foreach(adminer()->foreignKeys($R)as$p){foreach($p["source"]as$X)$K[$X][]=$p;}return$K;}function
fields_from_edit(){$K=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$D=bracket_escape($y,true);$K[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$K;}function
dump_headers($xd,$Ke=false){$K=adminer()->dumpHeaders($xd,$Ke);$zf=$_POST["output"];if($zf!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($xd).".$K".($zf!="file"&&preg_match('~^[0-9a-z]+$~',$zf)?".$zf":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$K;}function
dump_csv(array$L){foreach($L
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$L[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$L)."\r\n";}function
apply_sql_function($r,$c){return($r?($r=="unixepoch"?"DATETIME($c, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$c)"):$c);}function
get_temp_dir(){$K=ini_get("upload_tmp_dir");if(!$K){if(function_exists('sys_get_temp_dir'))$K=sys_get_temp_dir();else{$o=@tempnam("","");if(!$o)return'';$K=dirname($o);unlink($o);}}return$K;}function
file_open_lock($o){if(is_link($o))return;$q=@fopen($o,"c+");if(!$q)return;chmod($o,0660);if(!flock($q,LOCK_EX)){fclose($q);return;}return$q;}function
file_write_unlock($q,$Ab){rewind($q);fwrite($q,$Ab);ftruncate($q,strlen($Ab));file_unlock($q);}function
file_unlock($q){flock($q,LOCK_UN);fclose($q);}function
first(array$ta){return
reset($ta);}function
password_file($h){$o=get_temp_dir()."/adminer.key";if(!$h&&!file_exists($o))return'';$q=file_open_lock($o);if(!$q)return'';$K=stream_get_contents($q);if(!$K){$K=rand_string();file_write_unlock($q,$K);}else
file_unlock($q);return$K;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$m,$Dh){if(is_array($X)){$K="";foreach($X
as$Vd=>$W)$K
.="<tr>".($X!=array_values($X)?"<th>".h($Vd):"")."<td>".select_value($W,$_,$m,$Dh);return"<table>$K</table>";}if(!$_)$_=adminer()->selectLink($X,$m);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$K=adminer()->editVal($X,$m);if($K!==null){if(!is_utf8($K))$K="\0";elseif($Dh!=""&&is_shortable($m))$K=shorten_utf8($K,max(0,+$Dh));else$K=h($K);}return
adminer()->selectVal($K,$_,$m,$X);}function
is_mail($gc){$va='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Ub='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Kf="$va+(\\.$va+)*@($Ub?\\.)+$Ub";return
is_string($gc)&&preg_match("(^$Kf(,\\s*$Kf)*\$)i",$gc);}function
is_url($ih){$Ub='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Ub?\\.)+$Ub(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$ih);}function
is_shortable(array$m){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$m["type"]);}function
count_rows($R,array$Z,$Pd,array$s){$I=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($Pd&&(JUSH=="sql"||count($s)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$s).")$I":"SELECT COUNT(*)".($Pd?" FROM (SELECT 1$I GROUP BY ".implode(", ",$s).") x":$I));}function
slow_query($I){$j=adminer()->database();$Fh=adminer()->queryTimeout();$Vg=driver()->slowQuery($I,$Fh);$g=null;if(!$Vg&&support("kill")){$g=connect();if($g&&($j==""||$g->select_db($j))){$Xd=get_val(connection_id(),0,$g);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Xd&token=".get_token()."'); }, 1000 * $Fh);");}}ob_flush();flush();$K=@get_key_vals(($Vg?:$I),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$K;}function
get_token(){$jg=rand(1,1e6);return($jg^$_SESSION["token"]).":$jg";}function
verify_token(){list($Nh,$jg)=explode(":",$_POST["token"]);return($jg^$_SESSION["token"])==$Nh;}function
lzw_decompress($Ga){$Qb=256;$Ha=8;$ab=array();$vg=0;$wg=0;for($t=0;$t<strlen($Ga);$t++){$vg=($vg<<8)+ord($Ga[$t]);$wg+=8;if($wg>=$Ha){$wg-=$Ha;$ab[]=$vg>>$wg;$vg&=(1<<$wg)-1;$Qb++;if($Qb>>$Ha)$Ha++;}}$Pb=range("\0","\xFF");$K="";$Bi="";foreach($ab
as$t=>$Za){$fc=$Pb[$Za];if(!isset($fc))$fc=$Bi.$Bi[0];$K
.=$fc;if($t)$Pb[]=$Bi.$fc[0];$Bi=$fc;}return$K;}function
script($Xg,$Qh="\n"){return"<script".nonce().">$Xg</script>$Qh";}function
script_src($ji,$Ib=false){return"<script src='".h($ji)."'".nonce().($Ib?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($D,$Y=""){return"<input type='hidden' name='".h($D)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($ih){return
str_replace("\0","&#0;",htmlspecialchars($ih,ENT_QUOTES,'utf-8'));}function
nl_br($ih){return
str_replace("\n","<br>",$ih);}function
checkbox($D,$Y,$Ua,$Zd="",$hf="",$Ya="",$be=""){$K="<input type='checkbox' name='$D' value='".h($Y)."'".($Ua?" checked":"").($be?" aria-labelledby='$be'":"").">".($hf?script("qsl('input').onclick = function () { $hf };",""):"");return($Zd!=""||$Ya?"<label".($Ya?" class='$Ya'":"").">$K".h($Zd)."</label>":$K);}function
optionlist($lf,$Ig=null,$ni=false){$K="";foreach($lf
as$Vd=>$W){$mf=array($Vd=>$W);if(is_array($W)){$K
.='<optgroup label="'.h($Vd).'">';$mf=$W;}foreach($mf
as$y=>$X)$K
.='<option'.($ni||is_string($y)?' value="'.h($y).'"':'').($Ig!==null&&($ni||is_string($y)?(string)$y:$X)===$Ig?' selected':'').'>'.h($X);if(is_array($W))$K
.='</optgroup>';}return$K;}function
html_select($D,array$lf,$Y="",$gf="",$be=""){static$Zd=0;$ae="";if(!$be&&substr($lf[""],0,1)=="("){$Zd++;$be="label-$Zd";$ae="<option value='' id='$be'>".h($lf[""]);unset($lf[""]);}return"<select name='".h($D)."'".($be?" aria-labelledby='$be'":"").">".$ae.optionlist($lf,$Y)."</select>".($gf?script("qsl('select').onchange = function () { $gf };",""):"");}function
html_radios($D,array$lf,$Y="",$Mg=""){$K="";foreach($lf
as$y=>$X)$K
.="<label><input type='radio' name='".h($D)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Mg";return$K;}function
confirm($C="",$Jg="qsl('input')"){return
script("$Jg.onclick = () => confirm('".($C?js_escape($C):lang(6))."');","");}function
print_fieldset($u,$ie,$wi=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$ie</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($wi?"":" class='hidden'").">\n";}function
bold($Ja,$Ya=""){return($Ja?" class='active $Ya'":($Ya?" class='$Ya'":""));}function
js_escape($ih){return
addcslashes($ih,"\r\n'\\/");}function
pagination($F,$yb){return" ".($F==$yb?$F+1:'<a href="'.h(remove_from_uri("page").($F?"&page=$F".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($F+1)."</a>");}function
hidden_fields(array$dg,array$zd=array(),$Wf=''){$K=false;foreach($dg
as$y=>$X){if(!in_array($y,$zd)){if(is_array($X))hidden_fields($X,array(),$y);else{$K=true;echo
input_hidden(($Wf?$Wf."[$y]":$y),$X);}}}return$K;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$wa,array$m,$Y,$jc=null){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$se);$K=($jc!==null?"<label><input type='$U'$wa value='$jc'".((is_array($Y)?in_array($jc,$Y):$Y===$jc)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($se[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=(is_array($Y)?in_array($X,$Y):$Y===$X);$K
.=" <label><input type='$U'$wa value='".h($X)."'".($Ua?' checked':'').'>'.h(adminer()->editVal($X,$m)).'</label>';}return$K;}function
input(array$m,$Y,$r,$_a=false){$D=h(bracket_escape($m["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$Y=json_encode($Y,128|64|256);$r="json";}$ug=(JUSH=="mssql"&&$m["auto_increment"]);if($ug&&!$_POST["save"])$r=null;$Zc=(isset($_GET["select"])||$ug?array("orig"=>lang(8)):array())+adminer()->editFunctions($m);$Rb=stripos($m["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$wa=" name='fields[$D]'$Rb".($_a?" autofocus":"");$pc=driver()->enumLength($m);if($pc){$m["type"]="enum";$m["length"]=$pc;}echo
driver()->unconvertFunction($m)." ";$R=$_GET["edit"]?:$_GET["select"];if($m["type"]=="enum")echo
h($Zc[""])."<td>".adminer()->editInput($R,$m,$wa,$Y);else{$ld=(in_array($r,$Zc)||isset($Zc[$r]));echo(count($Zc)>1?"<select name='function[$D]'$Rb>".optionlist($Zc,$r===null||$ld?$r:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Zc))).'<td>';$Hd=adminer()->editInput($R,$m,$wa,$Y);if($Hd!="")echo$Hd;elseif(preg_match('~bool~',$m["type"]))echo"<input type='hidden'$wa value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$wa value='1'>";elseif($m["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$se);foreach($se[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ua=in_array($X,explode(",",$Y),true);echo" <label><input type='checkbox' name='fields[$D][$t]' value='".h($X)."'".($Ua?' checked':'').">".h(adminer()->editVal($X,$m)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif($r=="json"||preg_match('~^jsonb?$~',$m["type"]))echo"<textarea$wa cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Ch=preg_match('~text|lob|memo~i',$m["type"]))||preg_match("~\n~",$Y)){if($Ch&&JUSH!="sqlite")$wa
.=" cols='50' rows='12'";else{$M=min(12,substr_count($Y,"\n")+1);$wa
.=" cols='30' rows='$M'";}echo"<textarea$wa>".h($Y).'</textarea>';}else{$Zh=driver()->types();$ze=(!preg_match('~int~',$m["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$m["length"],$B)?((preg_match("~binary~",$m["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$m["unsigned"]?1:0)):($Zh[$m["type"]]?$Zh[$m["type"]]+($m["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$m["type"]))$ze+=7;echo"<input".((!$ld||$r==="")&&preg_match('~(?<!o)int(?!er)~',$m["type"])&&!preg_match('~\[\]~',$m["full_type"])?" type='number'":"")." value='".h($Y)."'".($ze?" data-maxlength='$ze'":"").(preg_match('~char|binary~',$m["type"])&&$ze>20?" size='".($ze>99?60:40)."'":"")."$wa>";}echo
adminer()->editHint($R,$m,$Y);$Mc=0;foreach($Zc
as$y=>$X){if($y===""||!$X)break;$Mc++;}if($Mc&&count($Zc)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $Mc);");}}function
process_input(array$m){if(stripos($m["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($m["field"]);$r=idx($_POST["function"],$v);$Y=$_POST["fields"][$v];if($m["type"]=="enum"||driver()->enumLength($m)){if($Y==-1)return
false;if($Y=="")return"NULL";}if($m["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?idf_escape($m["field"]):false);if($r=="NULL")return"NULL";if($m["type"]=="set")$Y=implode(",",(array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads")){$Kc=get_file("fields-$v");if(!is_string($Kc))return
false;return
driver()->quoteBinary($Kc);}return
adminer()->processInput($m,$Y,$r);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Lg="<ul>\n";foreach(table_status('',true)as$R=>$S){$D=adminer()->tableName($S);if(isset($S["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$J=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$J||$J->fetch_row()){$Zf="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$Lg<li>".($J?$Zf:"<p class='error'>$Zf: ".error())."\n";$Lg="";}}}echo($Lg?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($fb,$Tg=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $fb, $Tg) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$n,$L,$hi,$l=''){$rh=adminer()->tableName(table_status1($R,true));page_header(($hi?lang(10):lang(11)),$l,array("select"=>array($R,$rh)),$rh);adminer()->editRowPrint($R,$n,$L,$hi);if($L===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$n)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$_a=!$_POST;foreach($n
as$D=>$m){echo"<tr><th>".adminer()->fieldName($m);$k=idx($_GET["set"],bracket_escape($D));if($k===null){$k=$m["default"];if($m["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$k,$sg))$k=$sg[1];if(JUSH=="sql"&&preg_match('~binary~',$m["type"]))$k=bin2hex($k);}$Y=($L!==null?($L[$D]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$m["type"])&&is_array($L[$D])?implode(",",$L[$D]):(is_bool($L[$D])?+$L[$D]:$L[$D])):(!$hi&&$m["auto_increment"]?"":(isset($_GET["select"])?false:$k)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$m);$r=($_POST["save"]?idx($_POST["function"],$D,""):($hi&&preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$hi&&$Y==$m["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$m["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}if($m["type"]=="uuid"&&$Y=="uuid()"){$Y="";$r="uuid";}if($_a!==false)$_a=($m["auto_increment"]||$r=="now"||$r=="uuid"?null:true);input($m,$Y,$r,$_a);if($_a)$_a=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($n){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($hi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($hi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($hi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($ih,$je=80,$mh=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$je).")($)?)u",$ih,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$je).")($)?)",$ih,$B);return
h($B[1]).$mh.(isset($B[2])?"":"<i>…</i>");}function
icon($wd,$D,$vd,$Hh){return"<button type='submit' name='$D' title='".h($Hh)."' class='icon icon-$wd'><span>$vd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",1);if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcCd<fa:;NBqR;1Lf9u7%d\\;3A`%E!e9&r4MAv2\r&:Φs0*3Má-;LC@i:dt3-8aI\$ãe	#9lT!Ѻ>e\0ddC:6\\cArhM4kZ|O+f9X7h\"Si|+9ƣ-4W~T:zkHb{&єt:ܸ.Kv8#\",7!pp2\0\\ \$r7ތ#i\"aT(L2#:\0ΤxXFǉd&jvڗ@dE!,9.+`JahbDP<|\"Cp>ˑ+b2	L{FQ|rKlɏ_t=bK|\r=R>0(kbJU,PUumI.tA-KX4z)MPk3e`N>D#9\\(YT@hL1]ȴͺNKն2\\73i/VlYҗBA/[JĘВ\r;'2^텪bۣ3T=0H8\r+6kfC]qW)²C2`A82!hmвGD2-CYc`<s629uyҝMgy=,CZO~^302<k0wM{d#`Zۀ޺6C%=Rq_+-K>\n'GA\$^j><gfhmb*/\$\$lشg)Aj w#ᣃTN]T%ZjJCf4zF'* xho&k\r,r:>s(LAs5Ctn6 ll\\9D\\!mv\0A{9`.סSlg6!.20PԠi\r\$7w;G\$0CI^J\nLPc'*Ehb;pB(x:DL.j9AC@I3jf5sI`X}Ҕ#7T`djhH49S\nqHJQ H`,FP0\\{m\r~@20u!	\$PoQ4ǚ\nZLMBk)@dSLpvyЃB^o*R\"#rͥS;\r4&GIT	r9=6QT\0\0f#=\$H6PY:G\$09:a3Hz;G\r!hJn7	oYWLvېi|%-d\$pDR2T\rpaUn5rj\$r%D)\$GڃBu:`(lSD)I	9*ꁗ\rt2 zIg[Xc,u\rvJ5?\":^.uJPo\$t\$18\nnKT%EZ,6DHV󆪹i&zxpdrx*}ʐR25+ѓf2wq0X12dXߢ̏WËV8f\"냐q(uEGqM#а#K3WAvYÞeK]t]Ej=SX@Ӈ\rӘ\$9ܬ0P7\"D.匎<;Nj=^mmڒG68 C%v'yk/^53@.ڛka*D:7C}```)7|	3 i騽4\0.:QL؜ͨf'%ݩM	Y3\0##tP6(Bdoy6|5IH7z?(Ŗ\$RWT谦:(`r϶is=D\\,kr1ٓ2`A9&n~Ҭ6;vp M#]ɴAiJ.tYsOPwĸmZAUʷJN?z3\$PqsU9,#5PnbuNѐ{N`饙۝iw\rb&E\\tgba1+mpw#vlU\0e.(wb@\\w()E;Z]/&|>Q\"c	<F\r7ϵ\\'Sfe\rRVlo/.\nFo ehejנTsa422 `o\\A?]IoB[{7'Q%6s7\$Ó~%u)5i0#\rfMXN\\ɇ\0,TETo\0{oRr^C @Z.C,c'J-BL\rPCD\"b^.\"h\0\r\0\n`	  no	\r\r0`0	\rp 	0\n F@` V\0\n\r\0\nj\n@\0\r\n	 \n@@\r\0& \n@ @ zƂ*wq0g5aPxG		\n\n\rp\rp\r	0\r`\r@@ ^\r \0\rd@3 1Q9AB<t1N?Sv-ap	pP\n0\0@Ѱ\r^\"i@\n 6 \0	 p\n\n` qޒQDBMd9TUq12	\n2rR#2+\r/#@\" Q\r\r@\nh\n〪\0`	@!;CoUҋ2e Qk p !P3с!r%p	 ,`\n`\n@ff ` \n@	F#`p# o\\%Bl?M-jPr3/3*Qlp	p\r`=\n\0_>1'#\0>\0\r \n@ f0'@Ā\0\rdFhI\$`,CȕPݔT>7\0]E̣ʉDGAC\\BMDԈfmd(\rOGFiDNɜn24tΔwFtFHCԈu+\$K6蔓E.AKԏL*1JK>MH\"GNPjE> H&5HLM#EPcc8l,CNPt@V t\nݴI	kGH	)D(JPl1jnlԍJ~*&n\\HUfLkKrF<|HNx\\ NlNI\0rzMtU|ZĸԘ\rHC΀B\"@bcnAJ9OrtA4\r@hA^`^V0^!LjU.^\r\"kalpd }\0NIGPUYtyMPrYEԥx6``jg1SB܂X8V?Id[IQ.`i̲vԞU)Ԝ\n2PV~ \"\"&r]- p*\0f\"Kj`q\nJ\"qF.\"@r(`3q>\"f\r\$ح R1h&H`ZV	u+Moʬ\n3J\r Đ2I D'!S0W0J?ypjZ.\n\r pw\"-+zr!`|v2\nlf(m<=F\rQ}~7\r#o3}x<~WiEã[8\nbjj\r: )v'{Vq\no{)C߂i\r%遀C(kk4ؐd jXLN(A}xe|wGxhXx\r%K޼oqx8s4exρn*4Fc8~hIp]{%( Ӓ<VCB{wOƣ}Q8[[{cT%&o:*bE`mIYWk8You)Y5o9ަى<8(?\0[s@*8}ߟ9g\rӟ\0\n'w±x)݌٩92Z1@[I+_57=Dqz!}KNd3\0q+CY_g8yډK4{S82ZzX\0ϨzSڱe \r>:Ǭ_ZÏe:u{UMaBzɈb2YSWJ(wOwӁwmتZNl˧C98BD6Zyx{;![m{})#4[(bɘՆu,O\"F7y?9nd}{ݍs{eʦ>\"ccdcs{vdCN[GMC瓭DE@");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!v}0fa	G2Na'3IdK%	m(\r&Xo;NBy>2S*^#Q1=JW^Loc!f6mal4&1Lf9u7VDc3n82IΆ,:5rP1m>5W/FcDh2L\rNWo&hke2ٌb12Ƽ~0 D}N\0f4MCn=pZشN~;-C %z99P\";\0f89p:m8@\nX:r3#C[Cx#I2\\\"p]#5Rr6#L7!H\$\$IRd'ˉ8]	x+>C@-;b<2ÔN4,-Mr6IcX4a5KETh@1@RK9\r(9#8GCpwID52l\"_'UBU9c@G=C\nS0j7PU9J]<׋\nƲσz?B24\r/P\rM[XF_jHbnC&¡f%@cC^.28׎C}^swL/5OMڳ	*X?b.Ig&aq݊>FN-`y4sj\\&:SaP;HXޯdkt?.,ZO@@8Z3c\"ß\n=AH1\\Z^/k΃LuC\\c)0OMlpr7\rqWRac@wmk/8*?̐45\\mk>d1nUQ#w憟Lo&hĪPrnR,5z\"\$3dYH(p\rALAC)pTPl!\"L8R&\0Z౒0P8J	`e0	1	DJsH)k [Cypjx,\rAm!<h1");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zcǁ2δA;nWz/AZhG~cc%[D&lFR77|I3g0Lac0RJ2%F S L^ trtʩ;.喚Ł>[aN^(!g@1Nz<bݖO,CuDtj޹I;)݀\nncȂW<s	\0hNP9{ueut뵕3=gJWQ0w9p-	'5\nOe)M)_kz\0V;jl\nxPf-`C.@&]#\0ڶpy͖ƛtd b}	G1mru*_xD3qBsQus%\n5sut{syN4,J{4@\0P^=l`e~F١h3o\"qR<iUT[QUM6T. 0'pe\\5pCe	ٕ\"*M	D?h2zU@7C4aiE!f\$B<9o*\$lH\$ @P\rNYn<\$	Q=F&*@]\0 W'd z\$jP[\$0#&_`+B)wv%	LcJRSi`Ů	FW	\nBP\n\r\0}	瑩0Z/`j\$: 8ieφxa GnsgOU%VU@Nϐd+(oJ@XzM'F٣WhVI^٢1>@\" QR!\\`[.0fbF;Fpp/t`(VbȲ(Hlԯ1vH1T3q1Ѫf\nT\$Nq+`ލvǜ\rVmr'ϸg%\"Lm((CLz\"hXm=\\H\n0U f&M\$g\$U`a\rP>`#gh`R4H'GK;\"MۨThBEn\"b>\r#\0N:#_	QQ1{	f:BR&)JBr+K.\$Pq-rS%TIT&Q{#2o(*P5`1H'	<Tds,N ^\r%3\r&4B/\0kLH\$4d>/ඵH*3JА<Hhp'O/&2I.x3V.s5e3ێZ(9Eg;R;JQ@vgz@'dZ&,UFb*DH! \r;%x'G#͠w#֠2;#BvXa\nb{4KG%GuE`\\\rB\r\0-mW\rM\"#EcFbFnz@4J[\$%2V%&TVd4hemN-;Eľ%EEr<\"@FPL ߭4Ez`u7N4\0F:hKh/:\"MZ\r+P4\r?SO;B0\$FCEpM\"%H4D|LNFtEg5=J\r\"޼54KP\rbZ\r\"pEQ'DwKW0g'l\"hQFC,CcIHPhF]5& fTiSTUS[4[uNe\$oKO b\" 5\0D)E%\"]/ЌJ6Ud`a)V-0DӔbM)`%ELt+6C7jd:V4ơ3 -R\rGIT#<4-CgCP{V\$'gR@'S=%Fk:k9e]aOG9;-68W*x\"UYlB	\nplZm\05Oq̨bW1s@K-pESpw\nGWoQqG}vpw}qq\\7RZ@tt;pG}w׀/%\"LE\0th)\rJ\\W@	|D#SƃVRz2v	}(\0y<X\rxq<Isk1S-Q4Yq8#vd.ֹS;q!,'(<.J7H\".u#Q\rerXv[h\${-YJBgiM8'\nƘtDZ~/b8\$DbROO`O5S>[Dꔸ_3X)'Jd\rXUDUX8x-旅PN`	\nZ@Ra48:\0xN\\0%f\\>\"@^\0ZxZ\0ZaBr#X\r{˕flFb\0[ވ\0[6	 =\nWB\$'kG(\$ye9(8& hRܔoȼ ǇY47_d9'z\r  vGO8MOh'XS0\0\0	9s?IMY8 9HO,4	xsP*Gc8QɠwB|z	@	9cKQGbFjXoS\$dFHĂP@ѧ<嶴,}mr\"'k`cxeCC::X T^dÆqhsLvҮ0\r,4\r_vLjjMb[  lsZ@;f`2Yce'MerF\$!\n	*0\rANLPjٓ;ƣVQ|(3[p8|^\rBf/DҞ B_N5M \$\naZЦ~UlerŧrZaZգs8RGZwN_ƱYϣm];ƚLcŰIQ3O|y*` 54;&v8#R8+`XbV6ƫi3FEoc82M\"GWb\rOCVdӭw\\ͯ*cSiQүR`d7}	)ϴ,+bd۹FN3L\\eRn\$&\\r+d]O5kq,&\"DCU6jp\\'@o~5N=|&!BwHyyz7(Ǎb5(3փ_\0`zbУr8	Zv8L˓)SM<*7\$\rRbB%ƴDszR>[Q&Q'\rppz/<}L#ΕZ\"t\n.4gPpDnʹNFd\0`^\rnȂ׳#_ w(2<7-X޹\0s,^hC,!:\rK.ӢŢ\\+vZ\0Q9eʛ˞Ew?>\$}D#c0MV3%Y\rtj57{ŝLz=<8IMGL\$2{(pe?u,Rd*X4\0\"@}<.@	N\$XUjs/<>\"* #\$&CPI	t? 	O\\_Q5YH@bch뱖O0T'8wj+Hv_#06w֎Xd+ܓ\\\n\0	\\>sA	PFd8m'@\nH\0cOwSY`RDna\"~?m|@6+GxV\0WӰnw.؃b9ÍE|E\rЈr\"x-\rN6n\$Ҭ-BH^)y&ךWǧbvR	N\0n	T`8XA\r:{O@\" !\$KqojY֪Jh}d<1IxdTT4NeeC0䥿:DF5L*::HjZFRMրnS\n>PO[\$V8;#K\\'BRدR_8j*Ej\\~vvp@TX\0002dE	HVD\"Q'EDJB~AAIl*'\nY.+9pg/\"180IAFCȨV*aPdУ5H\"A6sY;訞/0v}y\rץ1u\"ˋm_0焄`\\B1^\nk\r]lh}]HBW`0꨹rFf)W,ҧ]sm9'OxԽ,9J8?4\"҅۽<-SM;v6y|Z%a#8TC!p\nCZ(wa?9|0<BL\r\n]PB0&+tHօDx^,L}[Bx}ru\0\0005S@\"Uؔ@\0\$ސ\"Ҡ]l/	IB4.6d7\r@=߬*G jf`:HnbĀ71)C<@AY#eoY!IDM\nlt/)\\43)2ɸ)f[ ppp1#Ðp\0œl^{ATH6\n\0PH.\r|TFD0Sy'1KdBC&)Ws Hee+@4 rۚ*Lp1<fNY'-	XKVaL\"\"lq.YJHm HV/lC&H)o&\\2%z\n^Q(6D Jq\00a#6\0vr,M&A9%YdBh!W\0b\r{@1I22A)Ha@r0G7Dd.LM<2,k/Me}Ғ3=\0&B\nPd.\"F3XSd(*J6 F:)11?lQ&h<J͋fdEպ*x\n\0.\"B -#ΗtIΫ	I8 8dh	x~	L!K(BX-hc/rPIN2|׶|\"M'K,\\He5*o]4FP	2<)To\nIڢ!(_8Xr;uNJ[rDC:@ͳl\0e\\*x@Aȡ&(5,#1x !TD(QDJ|D D:\0Aй baE?rnWkxX=i,\$3[r9BƱd\0H4<(z?sIbJg U\n(}J\"AB19~I#\$%d  e\"`t'O=@\$O\nmTo+Z-PF?_IJX ģ2-V;?20*P3_T<EJ\\(2)IQ鬩RL&!ȯKiцtKHRlȬEsDxǴi!faBFe>V-QjI7\"%Rh gM-b58R*9ꊰ92Q0IR[ZN\020\\[@Q\0JxEC{\$lp1=\0Rо>E~:0%R+)\0	ƑQ@(\"_jTX\0\r1\0P9#\0H;B|LZ6/B\nB{|H,	*;(`2@6>	?P\0/\0|\\eB`jqU/\rc҆6(N\0/\$\n8j*U\$y*=;\$f8XBCEr\"/kځ%\\9kB0F('UƮm@kT\0EsEhye\n))b7(W%,Jr2DrhE\n0Q3 U9TPO8j|}R<0Zl T*\$U\r\". Ts~~(3a@+l`:`:OiBX?ʄ7Lj|:nK:ز}\0UMc`P%nn\n,4Q'%+H.\"#G3`\n1fg\0М'kqxD<\",a|{~C<SiB\nkNG}k:g)JDhÛf\"kV~mM`HOkD^0/tjl\r!f<GTv#@ek@2w0ܭtį1uyvː%8?1lxtmpfK3ZJ=\0@^pۑ]Ҳ't١@Cb\r[V-o-ݠe}Y	--mI\0+VD[B+(-4>qi>=/0-cLpJ b\nd)#Gs\"QN`.ȍyȐEtPqI]J8rWTIfaG.떄7ylA7'1	S-xImL:eΉAWζEIWz3W)*/)Cx*c]%}_IvͲ'\$US4k5WʏJC7*b%<WC@	c{޴3)X&&eLI,N 2k#p5f4Ǻz#\\NbUoyS4`q~1=8厉*OOJC'Dd,@kL\\j2ͩ<@_q2\0ձ)`sF\0\nF<*x*`-\r|@7H@wH]\0_wh0!s1ϏǬhW.=WR*A_EDԷ?1,Ub9=t4èW^;@(1<DÊHxT()0z`_;AL)\nK[fHWo@bBKiMd+>vI(z:.݀9uiѤDYO`]I\0RĆ,K,6L\"\"1g(|T.,9vb+\rk]u&|bSd[,gaJ(Ck\rF+	9L))UABUhgc3x-n9x2qibrY7kyf,)٪J:N8Rcly\n2W;.>v6Q#A0{έi7~@VX^11-+v|]Vf.{	\r;1lp/uFd\$PЮ0=@kS0hɈ@/*(OV.G>(r!6Y=XZ@:'&06kE|'|H;Ng%W+4;̓'x|f9(Odw%9]f}Gs¾XM0gQ8̄+O}͝0}9Nh/mgDs\n74勳P~}O)Ug9j8Pݸ(%j7oABi)Ku }s1=odV[Ĵ\nzlMзr:F#{*#xܰ<Dsk/mw :^1ύD2z*n%iÙ *!8-tH'\rк48`\"i]ZZ>Z\0ަ9+䟂~\$ޭLP\\쇁XAizh\$SMT'1D	5E\0Ğ\$ttԮ:\rMƷSӖlsAfKk,NlD^zzdS/rtN>o%i\0JBpoR/֘٫x\ny+,e4q5Q'JD]B@mRSki~t0[ 1z	&^\nOVGV@T*H9ωG0\0'`Ѱ\rbQKsLd*;\n.ĔUNp,L@TRebFyn> IKrG	@?cIݓu%GO1Ch5TyI:\\0X>ʊ0޾QBEI/-LBT!b6k`jp\0K>kd/ISk.+*R|gRW\\wt.)^Zc8Z~FSǵSm̕;b>\0jz=T'>qy}:u&WDQc-6<[exؠ[L\0wmltz<S&dbxoigK\r`µ?D5u@bNO𤷤Y[{Nr鉞t\0tMscBW?*D.p'2Ge\rp*#eC\"QI\nhiQ@\rl	_.t*^s9Whq~,YθdQs¦\rBjDǡ<<T)C\n&D{\rl-R\r@rkϢ+ZPu8Ȩsوo#gu\$F&\n-v\"Pjnnt1VAwbx߄D5-0a\0\r/!I|/hnGf-Mdna^(ea¨YZ,SEN\\=4~Mʹ\rFtŦu\"|`ERzD`{@k/KY3sJ䃿5XGͪ%9)Q Q1th!TRHQ\rCE0#wG2//=^ /ԺΐE\0{+t+qбIt|vqԈƌ&\r\\Vߠ=EbnOrnX({ɹuzK`=:\n\0[%:pq+RldY\"[Vu{H-H_8jV5\"\0\"N?E;+O~wN];L'SOF䁻D-!#sN< ¯muG8Tn]:zIMn O8z5o\\57<Ų#8?sNL	}x&4?[z󳷶<*We}{HZ,(<ooxWt2#A*o\\R}xH>NP|Qɚ|x'- 2\0?ƾ2*\r|]tp\"ڲJuuXybD\nZ|H7_WGuXyH>T\rGQln!u'*C5>U2!b	9Pw4}yW|a\$gTU&~9(\\*!b_w7\\]=\\*@#N7ͪ5QN`@<\06!9l\$wI\$42\$&.RZYuyᤳp&SI@EJiLcV1F1Z\r\rhkHH˿K?x-0\ndN3KC59)ľ:B#dN5A1ƉOd[3ڠh[s~)9DNy>X'ȽϐH,)ڂ\"e0;\0qeo>=|2G+B@z@]}rQ k/|G:ѯW\0a4>^|goXE9pLrgA6pe1*7[>]#?jB~/}3:U\$?<Ga\n>0#!i>.{A}'hQLw~W_Th#dûdFQ*{\"\"P{}4Ni\r_e?l42?\nF	qUĽ_`_j{_k_o~c*#(/!DnF`?@sB!?;E\0k	*ND;+d\nZZdB `B5P\n8c#oukˊMݯw.FJ!|Ĉ2FcY).XHy[~#/&[Y@(|\r\0,O0YbβŬ\$0aˑ A\$0,@Ӱ>>9\\ti<\0q\0}@`\0fVjdߠ'(	!_n0+ciig8a]'=-B!(8_xj)\rH5HYn	,fr}-d\$H2n鴆ܛ=-dFE-daN_z4@[n\$x!!i0Tu8ɸ\0PZ8Zc+ЊAAF(`mg*vS, ǆKcA۬ &9c0w+n=)\$Q~Aa\0004\0u{(\$y	!B A<aAz ZA4\$ZY9.aX\rdALv|oOz|Z(eZĆ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:NpA/# 0D\\'12a@+J.c,1@^.Bь`OK=`BP6>(eK%! ^!ϬBHSs8^93O1.Xj+M	#+F:7S\$0V(FQ\r!I*X/̊67=۪X3݆؇^gf#Wg8ߋh7Ek\rŹG)tWe4V؝&7\0RN!01WyCP!i|gn.\r09Aݸ۶^8vl\"b|yHY290߅.:y6:ؿn\0Q7bk<\0湸-B{;W&/nw2A׵A0yu)kLƹtk\0;d=%m.ŏc5f*@4 cƸ܆|\"맳h\\fPNqsf~PpHp\n~>T_QOQ\$VSpn1ʚ}=LJeucaA|;ȓN-Z@Rͳ 	.2`RE^iP1&ވ(\$CY5؃axh@=Ʋ+>`ע\r!br2p(=!esX4GHhc MS.|YjHzBSV0j\nf\rDo%\\1MI`(:!-3=0SgWe5z(hdrӫKi@Y.\$@sѱEI&DfSR}rڽ?x\"@ngPI\\U<5X\"E0t8Y=`=>Q4Bk+p`(8/NqSKriO*[JRJY&u7#>Xû?APCDD\$Y<X[dd:a\$ΠW/ɂ!+eYIw=9i;q\r\n1x0]Q<zI9~W9RDKI6LCz\"0NWWzH4xgתx&FaӃ\\x=^ԓKHxٓ0EÝ҂ɚXk,R~	̛NySz6\0D	؏hs|.=Ix}/uN'Rn'|so8rta\05P֠dẘ̕q5(XHp|K2`]FU~!= |,up\\CoTe╙C}*f#shp5mZxfn~v)DH4evVbyT̥,<y,̫֞2z^K2xo	 2 Iah~cej6)]5͍dG׊Et'N=Vɜ@b^p:k1StTԙFF``{{47pcPطV9ىLt	M{Cln47sPL!9{l a!pG%)<2*<9rV)|AIp=\n7d>j^6\09#՗7T[i:XD'&8/;#f%Kj3;Z^]NQwtȬ\$ҹǎ-;LX+P̄:N \0ǲPyjt>.[<w\"|so-;';ǟt\rt	IT\nL\n)(Aa\" 	&P@O\n師0(M&b\0@@\n`=*̔8/kHF\"FB&,<4beN)FEONSNO\r.x\"kD\r 0p[2RI0Z'fixP0d|hOmkHΒ7\nneP\"0xP02n6WχN[!6ﰣ\r.u\rpP.(mGt\rox1!\n\r:z+lV'|?PP:0 bTaux`co}O1Wq8l\\u@\$NePKqgA(mcL'`Bh\r-!b`k `N0	nN`D\0@~`K]|ʾA#iYxf\r4 ,v\0ދQɠNRom 1&Ǫpr np6%%ly\rbʕ(S)')@ޯDMIs {&KH@dlwf0x6~3OPh0\"D+A\$I`b\$\$RL Q\"R%RFVNy+F\n	 %fz*TMɾR%@ڝ6\"bN5.r\0Wd4'l|9.#`憀أj6Τvvڥ\rh\rs7i\"@\\DŰi8#q8	\0ֶbL. \rdTb@E c2`P( B'0/|3R.So*cA)4K}:S\0O8B@@CC@A'B\0N=;S7S;D	MW7sED\rŨp<DȺ9 }4_o.rԉI\rHQzEsB\0eJ KwHtJ4,^25h2i%;=LL6}7#w<lrT;tPl76PrJ\n@5\0P!`\\\r@\"C-\0RSH~F倵ņO@ǭg)F*h\0pCOu6ҎYORg w9BӚL\"䘵_63gU5\r7,6\"1yV%VğWX]OJ	#XQGIXɰSq+(qRGH.l6[R0\0%HC}Sr77cYK).Cr;Ц)M+3 4|Ϊ1ZJ`׉5WL-SmxHdR*JЦ\r|52-C-1RRT`Ne@'Ʀ**`>\0|C!nE,ag.bfÝ8ӓ_a`Gp`m6Rz\0[-#mO1H\rdMMNMqnMnqR6mOn-tvæ\r]`-`jXMo]`OUAF37p>'J'm('M=j9jVZbBn<@<fe:\0K(NuN-!1vҍH(QgµxC<@ c[c\\2o,5˃q0m}i~+eѶ*}Ƞ}M~|̘\r @\"hB\$B2c\$g\$5b?6!w+~l1`	s	.v7mEc`Qecb6`\"&fx\"2E~Fz\$[/0,w~`u>w%X\$دvV\"-R%WD@ʀVoE@yh1\"tЙO/![`:x}@]b @5U(KyS>8D͸yw=|T,'LY\\L͌d.@ђ9<`9EZCײ\\h=qR`GGWX{5-LRJ\$JP+7XulӘh̵YPgzuiwyLycY7yF<v\r57dOgkYq8p	\n*'9\"`w[GHDy_]ciR˖ow9	{]Oݍ8C67:IvS:_U71zڵyy͹M0ͬc0z?z7}W'5_eƸzml\nCX_(Ý{@}X`SgBլDuñ!k~YOvK\0crr(^`n;y7z+{W:\$M\"I%omŠ	,PK9ʅg\n޸a~x%~WؽRٌ݋Xx%zSzթX?y#}L);!yߕsو:xz+UԺ|1uHO'cϩ{c<g/V:퉠Ɋ<\\3e\0ZTxZq\nl_I_Zy,ۙ]9ۚ͠,회k:;}-E\0S~2\\	UͺTV3oE|E CmϠI=\0НzkGٹ\0ّ91	y=5ۛ<Й]GЙScՇ!\rDR]P'pLtǚH+`Ӿ=e9ڇQ{9_b\$5lUzynz`xbkM	3 Z\rq])ֽ{#cWI\r8\r3䩽aSI'^a~eD稟>o2 NސP>cΞ^GY͞~x^Rg\\\$+ՍPkY*4~,MݶW-hhG_Iԉv-?ive>T\"\$[Ը+,)Kuq?KW\rkL%}tԻ~0|Pk՟T=?hEn=Es~xJHKVuk?X?7B)ciD\rא>D',ʟ>v@X+\rr@\rUXׯӀ1P>U,3G>>tѥ}\"=D}<T%9iʫo1e]hi&]|*l1D\r)XZRYl\"E/8ײ*ByK45Nrz\\pӽ9YzJHS>/4C&sCI;Z,ۆb3\rϖ{|vD\nٟNpÁ^Ay0az<ԜMPS0ڠjew=Ooz4>h1L%RS	}u82𦴮9oncM<uƶ0\rp~A\njQ3z(;3Ea]eUl40,uffH0݆\$1CAfi嬇>XcʂT\"6pHgDH?\"pl&K/?`2lm*TBK\"ϋɠ\$P\"oeVk<oIr:=(x2*Ȁ@=hCEF6u+,ZYir^lPx,g*ȖQE)1ihJ\"IFlY|TfV}Ueo	5Q?)\0cMFʼڑjllPm4\r*`⨸LMiqbV)QWR^a.>g	ox\n\0P`@`\$4鏍rZ#H&ncv)lF	 NcoXF9 g\"9'4t^!<	#0#hG|\nBx\0PT06\0TD~#<Ԑ@)Hb1I[hGj7_!0	CX@\0\n1@Z@\"ǎ8N\0jH\0E#ۊi:i#hDs#!TL\$\$)B׎v)-?hcP	 Oto\$pօB7#~D#-0dbDH	RlJ?\"`\nA?\0T,(RMp\$\":ISRzt\$'I>쓜'QM262PR	\\cxF&69^	pN)OHj:Q~y\0GyzFcĹ)s*<mQ\n(228zT#~[ G?-1.P;\\&5֍\0mTQn)p\$\\vZrK(c\nYws/gK]nbe.KPp:KC{6arؘl1)/04KUS@x˜QvT̄c.ʚ: 0ķL1چT0bhZL]AqVNL\nr0V#\0Ta2``2,\r-imMhSITxC,L.IOt	7_TrgIKxq8gIqMcDŦA3	 r`\\ULӜ'A9[8PQ0821 rBK`P%Tq	CF_hQu<C\n@<y,&Cv0%PO\"x*綔2&X)=p.\0{(N'y.2\$>a&)@\0Ov#X\nNz,xbiꁦ=iZyRg3MVs\n\nq\0?AhA;`;m(KAz\r!O\0EBJPBޡXO\0@Q4V0kuXtYK٫h=n{@f=6d)}* 95FB\0N'\0ѵЦ`)P˔o#ڀF>#BjQ1r*)/Rl	qXzA|Q9)H	҃@=*JD+p`+d\nE؀g(\0P,̤IXtmk64۔\r.K+ߤmIp&t=:OKQM\0	@O]<MzJLS@UrwJ1ڧ\n\$)ɨ	@aH]Bj.\0U \0'Ǵ\0B\0+TWRY4	 T9O\nsS9`N>>&MFԊ'4 \nj@*T1pf*9Li@5@/QRTvUeHjFUcY@Vzg槍[iNUT%\"R\nRhZXJ56EkUje1YF7?e#oJVnW\rV@QY>3ۀ*!L\0Lj\0I)\nLd1P!Z)]Z!8u̥ob (TB&CV|/%p)`ȅ\\ȮHb\nLSPGf󇶹JsԊAZLR`<׌55]Lw*:Ҹ@l`'fqEJ7Hގ/\nm\n܏o\0Q`9.qѬFV-!\n-3X5U]2\0\r!Ŋd)Ʊ\rXlb,n4qdK1d!wLofrW-Cvm\0p	צ*ɖx==yd[ V0(e+;:7͑	\"b,u\0{\n)F<\$T'RV`2\\VJ8P+`ɋ;Wd4FJJdRΦ4KL԰d矵富l|5.L\"U~`NmUmQTzN7U:\0v[J\0(S'*[k>T8=ANWpԊtoLYsX숲,0\0\nqVLulsn\0] /iا1 c<Ku֝zfTŇm\$+[1hXB`7c.kv067j؉5v2]FDdKueexvQ5B[2\"eE#^Yotli7jt][qM	dc}ȭhƁ%̷PQ_pۨqkj޻\\ei	D8*д1@+\n7B2@x4&\"W<\nme7mKD;G;Cf봿	d9+Z@w].Xw }n_uQTcԋxA5(T-X *f\0\"n*<W3po,p+s2\"\"މPMrQ +A82rpFp@}	uf7L|×-m?j>SpEz@>`?\0\ncx.!a꾯aZ+ʫ%MXw0zDĊhXUJlM#|S`Jck~EM^(eю.yP;+ᕕ@ۈ)Gbjōqh +%zp=0\nmIƀ+\nS|Βc@ƠpR޸H6	\0w_\"8r>aw\n:	\"\\qJLwO<|cV\0x݆@|*Wk6pOpLm[FTA\nC R9]vDF9w%F}<h#\0N~6'ȦJUV8v\0F\nR;.N3\rs/ -zxp[<F].:'ѠFG*q6G1Gܚ3]l@dÜJ;Ș\0007,Vc\r#weP\nqAZ^VzR't|kqqk>LߑR9g&fE\0R<d/wSeE7cQ*ec2eHk2c00¶o;2!Ijp?Y93[(`e(Hw3\"J=*W<큝a32@s27 <Y[&y˶^37g6 L|ǬqSsݓ>#rQ4Rh4Iסbg694@w.E3;/q]1WX7qΜ3%OYs}~f&Y1Αq]A\"|+~-2(,mcp6s<(6e4@[mӽU,=9y ^<2Hx e#cXIW|%+i,*3Q\$K\0=x2נ԰P7#ȳ0VXSB@l.%\rܥHҧu޼Z7p޲@2=]jnϴYQZCƎQAg8d^1<\\ gQ[~PRyH_ZVۆHƾ2U\rAQwK:\r\rtqgB.%G*c+Fb&-Gqb\0\n)1\n( r0Vx\0(MZ6X-'f2P^ōE,&bu°C8@ͧl8ڐ\rD-;kENӶ\r{-Wa]lz&vՊ{HZQmM{c&@[4tc!y0:|䶡EOtTr6e\"x|}ee>cdn\"2CvR`:k>X֠V&\"Jعs7qOY\"&ŞD:VL[޺Y؝Bm =y[\rcv]SZ&X3vQg{=`k-\nEpJ٭Do~;9\\S'p4kG|Z[v/Ë`Ujh(W\\@9;\\)xXC\0_\rCO~ʹDpK<2hv8&@ൔqL<UuFn*\\#B\\`*=\rV=Be`8\":X83|h=Nr|iW9\n3b0JL3B	)\\s*a?r3\nrH,uzV@4=#|aȔ}7\0i&%Ql!S>L׆[X!>=m_v\0D@xE\0۾A 3jDFnkw渣\0WZ~L&L+D#\0>@>v;p6\$+?CQ<RC!ɀM0y\$!r/d覫1Wz{:B5ctq۶蟾ju7N\rݢiN2Ȯw]J8A@tu44@}.+&/G[#\\FV'zQ5{c]I%{uyo^)lIfoPGI_9V}[)h@Oqx\0.żyݐw{|asTE.wO޾6-p8^v#V\r7N+>K̾k@WX\\d{Y\\Oevh?m7tm80lON}c>|ZVNꅷέcìv@WRIkt}:@dV :W]h[ח͹cr\n)!tiI+&̑\"|Cox(pfuNVR\n\0x槎9873ǣʀV!ȇB2l\rG6Y+(u5AE?wv9\\llwXxDM>㼂FH?3)Έ	}+[or:w?Ȯ)\0'DNH鸘/Sþ@<3x# yND.?2m,p\0O&?h>\r\\	w,=hG'E#H_߷ʤܡjz\\%pKέ&i|Zk}]5!5T{](7Or/>.&0c>>Z.9\0>+@)T _O5!t4pk\"忞x]Zt\0<@c?/}N4ApC<NWZ\05ь)^HN}oP\\p6O.#o!T!\$K*nPqr'\0VNEhF#xM}~GsPE*#A̄(F/!gMogɩ(yb~|3a@'ޤƟk3y'z<,,\${jvļ)\nq\0zA=	[٠=)sMm\0X?\"\"\0=VpJqkދ뽶ox.c6.cmö<d!7B\\ޓh2瓨\r<BHE&+.P	,)0==2-#'=3x1Xf󺌤3°@\$菩wJ3@_<\092!,9r3 ]R̫A%#\\2'?vbB\nL/!@s%DA&\$WE	zH`+CPP%_,3\0s@ ۛ!>`s64)3BքX@Bha{8 	gA\r=}P\"lA@TAAz?\0@͆/v[hys@	@ۃ2 @A(?\05bxxn&ƍ7Jky\$	4L#B@yEc\\Z7X9p<#9t!OtJ0M+YkLX:y.[@ئZ;#>o8H`MP#3\n8=݅`z{\nRwLe2(!	'	\0L)䜘'mokB c`jaҞ}P,-|Pf-(5I&|0C%~)F3,̡ԉJ8⁐\r\rX⳦*Lݛ@.D\$\$6/fمv\n*`s\\|>H1D-ggjyRp\n/Bt1&4;}1ݐ'..CGjCd0C2<>\"14C 	ɏ2C0(\r*0(RJ\n\0d(0;`;>ub\r)TǨIap(3\rB1CDC('aIJ@Rq|EDaB2Do2()Xjpyha%QA1CTJ'<APx-2@\$|JDNM)视JħTFc5c\rD<.C#G*3ć\r.#CN<[q83\rIpD\$QD}@3V0Bn'EP\0Q\rUQBnU%RQ0H0D;\$4O>gQC)RqS`0S5<B|OHŏ\r E_YMEDӨ%0`\0F#[\rp>hAxx59p=`7+Z,xB\")0x(bn?+],?&Sa@3^,	A%ACz'a&\\!`*c\$a8C1Zӌ`@\"dцn	F\0:~!a \0x(q˰r(iFLR\0lf	\rtlF5\0Cq.{,\0Olnm?ѽ|iFm1+X8|qn=!jF!15	4w&[QրODaeGotu04gB+F8\nQWl7)SQG\$qƱ[\0/ƻl}qѺG!k 7ƷAGGjQGL}q\"~QG\$nG{Hk	́qH tkQ ~G܃RI\rwB\$N4c0-\r7b{xȡ	\0Z	RF50\r2!FN\niaMGdqCf4{#y!TF#_:Ӑ25>C\\cWD\"FD(x7qÊ\rkx7#_Dfjp&Ɩ1]`)\0۲DH\n!\0`	*p\$8RI6	 (\0?x\n*Db4D,!Qᅜ:d`+2K a\0Md%><5&\"@\n\0H0%Ɋ3AR\$| <f> +PL5Ɲ&@\00ƻ'Kmok>H\"lj8K}#_ 2?|cB~X\ni6I\n܏= \"ɽ(ir&3OI R>,\0(vJ@LO҇z\rl)A2p+a )LmZL,(,B\$A\0!2D0Ir+zl8pAR&8̅ȼX?]^re%Z+Mc\$Ɋ|J+(һT[Q £_lE^ \01\0,+\n\0&00\nLƣ1hɒ;k\"n-\0;T::Z;cKa[R\r CI1u%ȕ%{)\r<K <%hrDK %\0(h譀4Ҫƨ[Q(?BW8, K,2@&\0R>rm>Hw#^2I\"mV1Cr(`\\̌:FeTHhT=@64/K,q\"&X+1ҝe[٠>q0(C\$1\\m:%j\0.\0002\00>.1@++\"2j@܅I23ٓ 1NL\r`\nȼj\$0H7jlҲ/U\"@;[; K2`&3`U҂׌T!{(c.`>>ˢ[%9+m!)H%\0J4Pɒ2dʯR33tHɇMJ&>ۈ\r*P`.H\0@ I+4hI5Xe6ԓ`Y5T@6MZAɤli: fϗx`('Nv^g 63;.e0d'`TԿ3/\nK7x#(),!7!7M\"4݈1\$y6%x7>N%8߀),lX6I8z@!,&\\HQBL\"\$+8\$+A8sNlӜvQܓ6\nA\n7f<c&̰n@7PhzNh2Hn5:o;:ĿS~0H6l%x9s>A%,t>\0005BQ%oND3'n3\$Pzm.m8 9DAA;8\rƀ<\09g.kd^ƂB	PdF`@ڬ?+TkF0Ճke02Ck)S/aU68Fkjm`'h[-=E˘Ȥֻ)2Xd.+փn\n¼\r65ۀ(ZR[/|2/c*̠Sa(d8(9m`*0a(&>ܹ@MtoF<_Fc4KDR4\r)09,R!BK&:0#\$+#ah\\H,9\0[30#\0O2j2'Ψʐ D+Bt-l	+9+ӑD3\0A3{[҆]:X82Ă%R-FSyX8	&-	`KZk5by͟&rqD저Ʉ6OMx 3C;;يX'U/>,<A>,g\$Rro\0Y c:T\0TcI5\$iM=gAW%G\09(\nM	MpW<Bfz%|٨?4Q?M6QC!v:5^79\"\0\r}G_4hTܭM	P2-m	^f )\nLn\0+Ь:*|AR\0'\rdj\0@t)d\nJ|@@pdPc4(!\$`f5ASMc%|ԞO-IٳMI١M*:tfҨ\"9R0+Ȯ`ɜ#ɯL	5P5tK O Y;SN\0@\\kL~D3oJDt3Lu\r\\!FTdeDF]I`4@0Htp2'HEk,D!ֆMBnM\$D\n4MA=bW.la,K88MQj݄/H\0a7TIM~e84OS?8NBÔSN0?TӜ)->:SN=!O0	H<8TO\"!T\0>T!O`u+-@4t<T\rP̑P=Du\0PK8SQD7ɹ'cX\rFK9Gl\nQTR9R\$Ԉ4 `\r.R`\\'0	RRO/D	P\nB6+310TT\nA0%Hɕ7g24 D[r5R%: 2jhGS\$gmQ\0AR TFYArB@wH@^\$jy/R\0'`l[	VI:7),Z''BŠ`#BX\\KLFBH.\rq?0`QIm\rx^tMkDvavTEѰpʔOLHaP4 Q̙ѫ ~I_Of46\n\0\0 XEBCfTPDC\0@bX	b0dD6k,40(oUbqY6di\nU<P(<]T\$?h\n`Ïz8HY\n:DD\0(b*\n`\\\$ \n` X	՟\08=\0`x <>\r7ʪEA1I+`:mchRPgYDCYdCQg'\r&hE:KD*\0vȑ\0M?H(¬bO(}Uc=YdUVJ=\rqJGY~6y#U[qBչ[i1oucY%pQ!Ex_]rQx]AH5,bpD]uc ^Uen\ncuWX#4lu@_q5}\\_5~_R%_\0006XrkdamX,w\r#`x(\"i<	!Ѷ:0\r<9\"`'aUT\$eDX_a,\0<XiagYa`3R\rvXB+\rTmXhiYanXOb(fV*axnXh0\0c@\0;شhP7bx=XaPڃc~	c56:X:3hedOX^<VLNUdIT0\0ODX\0\0mv7 iQbXiD\rvD!>ZCZXhy(RGTUYzbR4\$ՆjܻZ>dՔ6,K  )5YG/e,Z]ٮP%C\"6oG~-\r<+s·jYe@1YdM!E@r\0Z\\\0<Yg͟v{!&e1Yӈ:lYcAV5f՛rԸpY6GAhvEWYhZ5i0[VmGiIU7Hl\0[qٳi=9ZUf;ӥ\0Ŏ֐qfŤu٨kc Z,,VZSfhvjKC ~+-MZ[gLvV\$]j֮g=67.n7<r+t*X}bmZPvc}Zk5+q8D[j!Z8aiZm`Gs@m	ٵkaY&3+;aa#G0\nE[Oa|A!a[`VTA[r\nՎK{m9N\$ݸv߀6\0n冖۔iv٧g\r֔Z&}Y%dڃlYrM;.vZ=g[@!\rKQݽ6̍V\$o(j>paT\roXV]v[mmp6RFZ٭p\0\r\\)\0P\nȬր\\AqY6h`\\1q\r@C!\r0o\080P;@B\\:mVpxb+yq%W\\xm͏r\nL@:\\irpkMG\$l2m`Zk>iW!\\?%ʀܭjT}RܿqlvW(eBq&m)[h7r?K[Wxw\\Wq]\0XoI1p-8hMMYEP\\%o`	!m{ _v_YX%U\r>\r͛Vw[X䣄 v2UqxDH*uu@,m\$\\I`,6Edt0搏\\[vطl.vM]#Џ1mEWdX/v\n!ޖ`S\0[dbs݅v%w]vsftrG\0003#ڃ]g]^&xxW;hdCv 63v4x9M\"Ә7c䷘;yՕw\0y7فy5w	%imޔ閩ݤ=HB^z:a=ez,׮z90	x%ר^EzXxCW٩x-WZuj!jEX{e{tضV_{	\\|u^7oUi'{*HXy9!\0;Xu >Ur\${1dh>v#`/~U}{J-\rQ_!5-9cHhX@l21X܏>O\0\0,Pf\n`\\\"*G>\nW\0VbVj	]\ne\$d%\r_3r:Pjm\00	#*#8퀚\0ڎ\r`m)_\nZxH,71MP\0	g:\\?C@\"쥘+&>I\09i**DJe(x@xVd@zG`ʦf\r_̀@6كQ.\r`ۃ*΅\$G2X1\r`7ڵ`F\0\$L?v`*QWZ*MCZF\0,a5\0Q,x:`уVxC`2`#A0G\\A?!`@\n``h)`Հ7h?M4.TE\nx@0xr\n)\\`}X\"6	\0?=I_-\rO@na`Hj\rw\0M*x	(.\nvW໅6!0 \nN\n)*w\n؏CDx˅0@Zb:EZk^VZMU<CV?W`jF	I#\0ؕXⷁXT%*b\0x\"Ub\r࿉.Xe\0Vj\rV/xJJbػo,b8b}^(?J	2x\rbv@\0Ώ?Rj`>j*cAXjD_>6xkC\"=#j>kCˋT/K??Ң8Х%Y; %?pꀧ:a.-\nHSc]\0*Цf3\0)coxxyV>\0V *?щ?0\nI&4& 7]&AN'*ܙ?6Kd*Mx-c׍=dA?`ŏ@\n\r.?Aġ,)8X#\0 	\np#j>\0&еa>*6*Ʒ\"@ \0X=	y\0d\r\$dǎ> 3L\$c\n:cY8H>Ad]gx`œNdk]#L菻:6uG}t\nePdtzܨj *dZ5i\nߋ>XɅˈ99F?Ux,7GTH^9偪YUJye_[&W6\$!9AmW4=	WgbFXarᅂ*O+峇4y<eFAe^,XI>TeZ=ko6Q9]jX\ne?=eߒJyzd6J(A6쭑>y|e/c?9f#~ac9|7\0`	ʃe?~\0X%ޔZ9Gf%^Fc?v)%~9Nd0ՏkIW>e?9+Ǝ&%GMX/\n[aÅ6XYE&@jJ̈́7%⟘Fҏ	n~y*0jRe\ny%h*>SFWb\n ⍃J*e\n.->kHVhgJ8XdCh\n X	\0Ar7eV\rYd^2BPV{N1d\n\"'?Umny)g\0h>rی*¥Ys kY\$	>n➩JBJ?v|%g0V?WA\ngz-X``ȑk@\"f	R9xXL@*\00d'78h<%X/\$?n7CF6Zi\$nbhO(0Fj\0Ҡld6z`?*\nVR#2>IjcdHmesxH>DU倶*جfYa#Ù8Yh樒z7~v?8\0ރT%?&Auō.-\0\$i	ZCΎGL\0\0^J`yx\$chL-LW/9\$ ?FYg[/p#\\Pi&\neE \n>s##mG'GGA诏Ɗ\"S같>8+\0I5঩n)i.LNzLݧƞpR-^JJVh`Ҥ}FK)*if4bzf\n+\$F*&i-ÜZa2xh*[/`ۣᔤLi|\"#kb9JhN\n~8	?g˝F'ؖ7\nY*6K\n֭(6_rb*	IZYZꚪfvy1j#H!fbNCF*LnCc2AUdAXb_]b]h`	\06Rԍ2Kraz'<rkKvqz9Z\r^MB`ZAy,QrRksQ8ej(69ey.8CK/\0?kk?U8l?詉ʈ8/䫓\n\rsM-EZJe?fhXL7楘e\$\"*g]thXhZ\0r-VH8Ǡh,çv)dh`A>P>\$1	\n\$o7, Si9p:1 eb<ܡ8L j\\gT-fkPa@xT+eKұLIkR;0Ϙ\rSLȷK\rɀɬ]x*6ճM!%Q>[>l~nI7ϳ!ClE\0Ttd!UG{R\0ڷp*VV}҇\$Ʌ<2&څaA\0\nZsTl\0< ?d\n`+8ɮD㇀Zg*jf\"`]VhkUfrja>:{og;m1^\\#Ŋ+ V`mZmӷ){{m۩.6|{v_mY0S:98U)y& v,s,@\04-ɛ\"^Mn+-{59ʓK;&@ҳJt\rD>oV+\0Nn[*HD\\CP\"Q(%۪	)&	 /նfO\$ځW,Q, OP!ەb1̘φHAF*t\nMHsbAj)kMR1FDK:\r^ʔl12fItlYIc+)U%:S]%1g\$5%|_>#S#\$2Lk&4A&A	 !&LI`*ɣ+`,VM!}C\\xGe˾\$;0k(cHlۀٿtԺJ;36Q܉;v 3l1IE\r\$%	_@.PB\\8=u<P#ﵻ(?U\"6=D\"Ny]0\rQɎ=HD`c0,\0ݟ2T[0k}W3oӳ\r?v̐_T	%{=Ap/__pJ|*%\"?3o\r\0002/\0`>p9*}ǔ		ZHk[ˆ\\+Cp6\ri0|sJe-zN)-Y=9h68nQZ)^<T\0F8q\\GY\rJ@\r#bᅊLK7)6sqn6(Ht gAG(cgA`\nTu_\\˼u+#e`=.~⻭L8;sv^R\rɅ!XfN䪻=h6\0ȈO]-bB?S Tܲ!߅%anIr`%]ӹĘI@:gQʊ'186R]ؖ6Ox\$j.Qx|6/X=rtkRz;MplW*یE |AqO\n5<	#8pF30Pgm+]%,UUq8&,g,;o*h7gQ@47H1QGvMZ.;qqh3R̶@9(bB0帨C@%㞡Tp)IJa!*mU7t4GfLJ\rHMI9)hHO9^}H`ɳn9SgkW*WFW* \\2sǳ(sϱ7|Ʌ/=>i\$n=s	_<79st)yWG@Jt]!'A=_A/>@1Brз@t9Ѕ!W̨dP}aEm=ERO&51qT= `_Һ	WTU\"׽~(jN\"E#uVBMn>;ҶB]o|/cZq[tһZ҇2=3rƄ4,m!=_g3*5AO DQ,r#8*lfER7SAI!AJ<f2.NJ@BgU{A\$ԯT R)0s_v@\r|\0xJ`9\02[ٔu'PA&M{ 	<R]+wՖE?q}=`1ك\" 7^#]1F5sHmאF-9׿Ptg\\{m__}c1:\\׷XG^U!DaXv}= Nؒr׿aoOW0tCy'^k%-]=1\\!~!J:OOyWd5Ӹ\"U\n7R=Lu'WW&;t~S\0b0凁JY\0006m22G X@U(Zom .l-xnFU_\nmv\"lcp+x=5feR뢰vme)^-9BUbI6lq/Mj1K=Y[pp@o70iSVTva`8lh\nl<,+M}U7sWI_\$V\\;nܙyMqEq&q^=ՄKP=eܙ\n`	||{	kHv#2Zٞ7~8`=?luhaV	5z&U^nYX\$qRqMjw\rv!U#'Uva?q]ǀ\"1TeTGz\\f#1;ufNA6F7Wt-ce1Ogs|Q]+N}sޣZ]U^)7qo84c}Uxޢ6jOWoUT|mBǎ\r|Ex6'VxU\$t<} \r/I,l~,z><Kw^LsU(>a.d\rmhePyn>d\0003^<9)wmwIX7\\{&\0\r2C\0T<D'q2IMNo%)\"y&466-1U8,5B)mQhyS[K9'`xGrZ!MWm8yT\\ejqy,9=]NO3_qM\nrk{tw&y*f3qT57Ɵ3IUm/Eg)݂I64a@62K(߯{NMQG1=1]^;8h޲uۿTZ\"z4þ(y(y|&\n5:˫uObw?97R|,kk~[\r/K.7ecMFiu`U9?Mqotx]Kyw?}u'\0,	CBp=ϘM@d|Zqǹ<}P+|	\$w4Ġ43L\$bw_*KIz?~IzO+qkx{\n\rGw{LKU~IٱO`E%wR !_ʂu/KS,k}@u}1	x}M8\ruS|o4e(b%n\rZ|94t([R\n\0|dHMU|=nY2=|_W?q6W˗\"pG_\"Aӷx%4_q3GE4絪o^gH~L_6v2ݗ\0К6}>u ơFS٥䉀ϴv}1Kiv8LɤkK!X|E|{ΟlѲ 5U^WE;&xlúD\nvR\ry]9ϲ=Ǝ}!K_ڍwb<v~|Du}~oпt J>ٿcv14TПq#>x\"z\r=]Y|Wmx5l}+ͥ}\rwiqi7 0|{vwߓ~Aּa&XƂJ}%x_0twL4JS fCug\"}KO wxrt?J\0P+t!.;F'}%f?X]b>ʱ6Q[P3Hpg/߼a 53Ƀޠ{oh;t'ɟK{?=pGLҽ12e|`;bLIВ?wGl4M=}#4I7Dwݿv8\n!,X%6_\\PՔcu/߿Ytg(H Z/g{m(%+ӷh&ͦ#P%w	qôweFS2i`ڈ-`;L»WEt?\nJ,/1'uS<Jvz;g 	k`a7Yk5^;_\0005bX/^j<ΨL;VhgTI.\n6(hP]ruHɼhU	r \"|@>(@\"!0!`% Ra*Ϭ\0i\0v");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$o=get_temp_dir()."/adminer.version";@unlink($o);$q=file_open_lock($o);if($q)file_write_unlock($q,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Lc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$E=null){if(is_string($v)){$Rf=array_search($v,get_translations("en"));if($Rf!==false)$v=$Rf;}$sa=func_get_args();$sa[0]=Lang::$Th[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}function
lang_format($Sh,$E=null){if(is_array($Sh)){$Rf=($E==1?0:(LANG=='cs'||LANG=='sk'?($E&&$E<5?1:2):(LANG=='fr'?(!$E?0:1):(LANG=='pl'?($E%10>1&&$E%10<5&&$E/10%10!=1?1:2):(LANG=='sl'?($E%100==1?0:($E%100==2?1:($E%100==3||$E%100==4?2:3))):(LANG=='lt'?($E%10==1&&$E%100!=11?0:($E%10>1&&$E/10%10!=1?1:2)):(LANG=='lv'?($E%10==1&&$E%100!=11?0:($E?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($E%10==1&&$E%100!=11?0:($E%10>1&&$E%10<5&&$E/10%10!=1?1:2)):1))))))));$Sh=$Sh[$Rf];}$Sh=str_replace("'",'’',$Sh);$sa=func_get_args();array_shift($sa);$Uc=str_replace("%d","%s",$Sh);if($Uc!=$Sh)$sa[0]=format_number($E);return
vsprintf($Uc,$sa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ga=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$se,PREG_SET_ORDER);foreach($se
as$B)$ga[$B[1]]=(isset($B[3])?$B[3]:1);arsort($ga);foreach($ga
as$y=>$H){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ga[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$Th;}Lang::$Th=$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
196829103){Lang::$Th=array();$_SESSION["translations_version"]=LANG.
196829103;}if(!Lang::$Th){Lang::$Th=get_translations(LANG);$_SESSION["translations"]=Lang::$Th;}function
get_translations($ce){switch($ce){case"en":$e="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\rQ<ΰC\\~\n2NC(r40`(:Bag8i:&㙔yFY\r2 8Zӣ<'Ha2܌Ҟ0\nb豌n:ZΰUQŭwDmfpQqacqw7PX3F/ӗJ6g2qspfoE2& ڵx(\n戎:0c|9hO@;B	c\0x\r\nC@:tt\";~8_\0LC ^&ڳ#p̳͋^|8(ơ3KQ 9ӈ#c89;tM89+#ᠡ*,1,CC8cxؒ?B844S(:17N#\r&ӊrè/-}D3ׯk@c@#пV2'гXIl*8\0003ʭxx( 55ۘ9Ӭ\rvJ0B͡\r>Wuax 2ZB(.][!K[FEC\"<;ɴy|&k^E:]9N1_#rH1/(7(jEZL% @873:7<B@x3\rB:*\r{7(4hWOwHhd}R4`O	YT\n}hhĺ0Mqz:*1ng)0\rQK\\\r6QtaFq7+|}Xn.=**C,=f|܎jH\"8?Tk4j;G!\$5-&BSBieJY1(J`98t\0Q5p81\\i2;EDFXI!}73?(}~J~P4#``W?EߴgJBD\0yEj\nY16\":ύxȆ&B̩LJ 9z\rY<شJ^A>202Of4J0,>|ϬTZQE1u#G\$}\") eK\nK22dx\"Ho	oR<F4q!3(ZLCBkUهR:HY+e܋ !1&e\\86X%x;ț3Ɓ#WvTii<)E`@R%IFt`\nFprX̻uxcHv^Ј2*\n\nkA\0F\ny0oK39BpIم'|OHO	*\0BEUH@-Y`IJzOځ}O,kQIpo5DFxv\0UI6\\IR-E}ip3j\0AFj:l2oby L\nL\$bM00Dmū>jrĉ\"٢XUÚR5=83EjzntgD\0%m%mY>}&Y9'@SO2Ij,WkX)䅮tbWR=J!ԃ852а\\ʞSOoVK(PcM^>lzΐmBT!\$	_*G k\nn~R(c^V0(7V\"<%Ȼ{J&a\02flasHfy\$6L`np̟/ye}Y%](Y\\[KH؉jNRy!eZo/VvKLf_	yKAVE\$Jbɝ;+PIXLQ숶H̰k)웲vK{jɯU1B[Y&#WNJqmkq`9 \\%8Q_Q>B͋բӫ2\n^ݎ7;?)k\n  Rb0_\0Q9'V}Ao{ÈgB;%^d7s	t5wS\$\$=\";rUĉy/#/J-L'Wmx#87T:G*'ָ.5QS《NRnU)b;>d5KW(Lsg)|5銋]<\"Q-/2dT˽:8x{C{r߫C\$,?uXm\\Hܼ\$2g˗5<	c}\"'4..;cOƬdqvD2BMlhlH0Zd\"J&*f%h\roޫ*)20x~0B,-,;'vÄo	0NuP/b3<lp`7E=0\n!@=>0(ဎE:@\rRʰQ#nѥh2!n&7h.\"	qm\rOK NhLj\0\r0b0#:p.q\"'\nlDZ59\n~\$Hl͌o=#ieJdˮd@`<,/0(qִ\$k`VCfv^I솢c=cD%ULt]o%!\$nmރ\\2R6P!&6\$cH`F\"l0Yr8q40	YNP2e'r*`\$rV0z*\"`Č~,-\"&riN>:qư\"ʯBкfD\"-L`lC";break;case"ar":$e="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`ӄ\$F`!2\rl'E<>!!%9J*\rrSUTe#}J*d*V́il(nTIdu'c(oFe3Nbp2NSӳ:LZ&\\b\\uZuJ+ωBHdNl#d2ޯR\n)&<:\\%7%aSpl|0~(7\rm87(9\r~BK\\1 Y3ޱpA/*Qb&KkB,iTOJE#/\"l\"G2.# \07M0: 1C38CҎKz˭L9H4C(C@:t2tA#8^2x9ΣI|6-+3A#kt4px!~&mED`FhZYK!CWLDpU;([0Z	#P0CtƂ\"#a%Er\\DBQseC]6CZY(*E2K\"O6K6+	uRb\$wũUh:ZE)+4abV8[3id)lFKkV+k\$#`ch5 0i/	0(ZV.ek)!5_:Qi1l,Po?vh-,Xźc׬b;eƔֱږ6&l<ȯ\"V&d)@6=S:۳,	nCUթ@9R3\r#?H2vٽ}@\"7#KA0(wav7LUH柔{ۙRsis/,UR)>:\rS<[(0lJ%]B@j0n :\0f`6zÚx	]\\.lSv\n)0ef I|\\f`ZH@R((` I<7 dސiE=\nPD0.R*MJ7B@3*sI/b\\F)\"+\"R /Pr\\ 	e.Ӣv@8ryOq]@(%B1GD Ro9J=ԧHm6@^LMڹXe^d\")r> JB	64 ifrq#RiA>i6Xj3\"%RS3oō\$\$TjC@p\0A#tRa\$7D\"L5F\0ʸwӥٺý/'Ԡ7dBFtxF*fTF35.77\\\\A0:~yVC)?DtY\0FtF躱\$!)?m\"DXaȉ\$\nJRzL	4&)E)K&̸PI aϥ(k\r4Xkؕ)RS@oӑdut4\0P	L*bO0zL\n%#D ZFhGuw/bEqFIdHu.H\nvִtmLڂ--3`2\r2.Uo}Ma qёG\nx}\ne%T\0\0U\n @D0\"攆l{RA[xf\$;\0QǲyDX'zJ}v=T0 _:ji#Kⷿ@TZHfM\$b- ylldE\\kE3v*\" }g̞\\oO%iG	`\0ށiPmC|9eCX'jCvR0M}'Ć0z楆N\ne+#g+ֆPHVHچ#*6QH|:͌;~X]uS@lG`eQJI{Dja4n7*\rlQr,Pe-_LI>@lI^ݳ!zC	\0 `ҕ_K!0Vie\"-QK6Qc<B^;.gw	K\"X#~hOYf񛵽:ʤ2 ^&YfB]o.t?\"I.>Ui>{Xxd!,ޫs@w JN8^ĮQyF,(sD[!7	I~Y^.]AVfc2m0d{b܀FGM(gY*\"@'xpXGEPTF<А@%ŞHI\$plq<e-p~<WسÎC >A\n\$'~e	FXlbkD0RO:1\$,A_P;2!l]ODdaz(p%B\n,jzWXv!Ej%Gޏ꾑 B<M kq&Pld-%\r(ВtglB b#O*GO0418'n>VCP)l\\ {N(1ѢŦQDmQIEjz#<l*A0Т/Pl/d@0mlÎfn](@,|)\0?.eF%\"ErE[\rJ>BB4^.6XpY\"*BVXwz1w(bWRR-W}fF?()\"]+&,N*ÔXB\0]Z#;#mzo\0m#qx]Q|ұ\0\"S13	r,\r&\r2v/2R)0\"\\G)2#\$]JB>RV4\$Ԭm@[5D6iRa\n7e6y6i\$\08\\rtg0W,-l2#;*1<E|&*:0p_!:~l:1==9>f.Jxfs!1LNm#<N\0Go,%K3o{+cGRRx.dc%m4(˔-.R:%	ř'E¤hF\rV5Lax\0&M@\$stz\nZ=zPO)zeWB-PH %sКQ0|n`EðLNɚGj6\$\rE@O8-4=\"b,T/dϭkFc0^%FTCS0>ڵP\n6cD4e7IAdBnP!Um\")NcG\0/S	uOc	\$1\r&fW5h\n'+b̀\n@K1\$frjeZ&v:O:UJ14qm8\"LGCP(\rJV7tkg0d&HG,R[ 	\0t	@\n`";break;case"bg":$e="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9(g+8]*OqJ_\rGiTh~McN\\4P򂞴[1UkINq呺6}rZ״)\"Qr#Y]7O㬸2]f,D5(7'1|F'7QLs*ns0,{ ī(H4ʴ\0\np7\r7J3H۴Cf>ANԱln:zX Ċ>2*÷\n'hQM2\rH 2a@: 8E@1s /\00#1#H4\r; X90z\r8a^\\0˒JE8^2}9th^+aO\r7^0n+ʛ\$aP+o+O9xNrʩmۭEpM)ӱO\$EyzB9\rӢ\nNɗ+(`{JJjzMs(}4,ΔJH1 )8ۜԤnXAFٍ郰#/'͵0s*'%`E.IhgqQpiJ:4IA,4i9I9hЭh8tQ)龼~.Hnk	di>]\rnt)\"b0;i>:tH7Up,V[orEڷI5vg%}qv.JZZ9\$,hHhB\\GkްR(r׃́B Y7+a\0:sE#Z҃#_0	`!\0C;ʗ39؟ߪ(DBeV'5@9yW4|c7!}qId?.v`Iڰe=c2h@Plɏs.HcA.(5s0N)RD\n\$H#nGÌkA&|RJ0\0lPᓌȨFYrS&9tDzJ:2y\0sȁZHxTdYzT;\$\n3'f@aCɕ] @ Kiu/%xiH&TSjuO,UU*^ tWЯpgy(H0w+2ϸ[I%z%ŲJJĩ])<Fw9F@\\RaM)<T[\n`nӱZDN\"-ZWiG(8=YLwˈ34DF|;GL[%8&=ZB%П|X\n\0004bCf9T0u7x0T Pi`@Ԥ\rӨ0`paT2ٯrHAt4C`ѠЪf(6rH9*\n\n),/bE\r\r|1ΩbzA;V뺈M]2t[\rw9E>x)Oi o=fD2pS .ࡔBQɂpCh~AL}aѢyw!,\"fB.Z1\"8Q\rێ\"2Osh%h3B=ͤs\rCbC)ك.s #HSSY&GIJ5EdV-W;ؘțCdjG8USלRhQCEe MKO.T{'	ϱB-+䶇DdgY㻤bF#)\\iqϬ\rfS[!I/½VS	,EQ[8\"9<UXAW\$RC5`lo1-dR,4eěFl,ْ/R;ռ	>H2OM7gӼzGE*ݮA^A_&s{2~^p؝r!\"BClѬm_5Dd%AʓyJ;Pt`+:ӽ\$o	?ZMvha\rt+Q5˳0zQ\$jU\$#5xRA~!cBE(٪PY8\n\"r9UA1^`nf\0//3שP{eBLHyC	R]@(9\0T tJR)\$cr_^AdUq{w'UpOL_eݹQ)xzHNwGemga5(SͰ !B6.rp'C4\nM/A\\c,X9#8\0'i숋cv|;{+(D  \n`\0J\r\$N(LM\nMdڻN\0B&H~\nA\nd8` ta=Кêl\$(a!)<M	̆\"q%Pd,\r\"\rK0ykFOè3l#\nek<	:Q)g0 6'\"vGh|EȪF%͂I\0001h,n,(}\rL'&,\$fc(>z%pl2.QP1#J2)pl>&-*:cxҍ&&PG-nE~aeZ %;N\$mB)\nE<&0hBBH!4\$F\"cqx6B.н\")z	!N_1&g/#.o&/29&x\"L]-4d`ekdi6D \$^Aor.Am;I,+F|G'DĒNz+=7&@O0Mҁ`\rfho6zH^pҒ(4h2ir n&DQXchg-33ΔBί)')O5,0K7B#56v'()5y*3h\$\n9\rr[\"HҀϭ6)\\M2S10\rQ4	9\n5sw&|4?2:t1\r\r;\r>?@2\"cBޮlx(c{CDd3	gN4R7fcqՁKG'\$ēүGIB7l/3@Nۏ''e0(g\\bҐ\n-&:-(3nN'MT4rq<M'3}I̒x1ԇcrZqIqOS&	4j|U|ht92#PEQF[5y8\"4\"7u:gUP1mU&Uk@<oC hrI!p@xbpǴ\"mnAsQQ@Y_}RS4 sYSNR;O8ZnjO?(9]=ZU ¦hjc?U^U=Ż[u..\"<%/\riOU,V\$ʮ6 vc/nDol)(Ll1x%TwJ^qBM\"oes[7_T\"5\0P__+g%QUIM,>P\\_fTQmp[RkȨu:GKlTvk[UYqBfw aZmBq\r7q.>u%ޒ!Ct:2R?oS@q_&V;?6mr7WM6dv1e낊`bh>E/<,EcBrHb+'E.-~\nZ2k2lb{- j5+w@{n?nT)x\"i(hQYu}(]N^cq/Ȯj>]oG{`OҞNJZ<)̠o7\$O ~~]-`-(3	~TAFm[rC+0}a5Ոw,:F>'om'0S6sx'\$'oEHw&HNl\$hlr\\T,(ؼ1*^n\$o73sO0X]G¡G.(w`\$bp&A}#q['KV#oV3j2lL88-pTx{Fi:-f.M:49G\rDhXB-ĂUZH6KpuBb";break;case"bn":$e="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHW΢Jhj_\rmyioCZNr,N%Dn৮еU8O2nŭr`(:NS7]|􆇵82ɼ 4NQ 8'cIg2Oy2#:\rK:#:E3nm ;KB+M	Ь#G.S9h6ԫmTd\nQD\rIlj'@Ep{LDЦ\r#pΝ2*b+\nDNtɨÄ+H*[;\09CxCJ:v]rl:ҺDX4R	&.S)B*&Q.3Δ<R;(-z# .\07/h: AY1#3\r\0#LY94C(C@:t5AC8^2xqܣK0|6Od3PCl4px! <W5F+mL,'Zu]+u!5CTD0U&/+ܮ5D.{g=ez\"}4L4n\r	JE\0P0Cu&Nӵ\nB\"yr6gl\n\n9:QS:o<G6CYN*k_B%0e;#`2꫎NIٕn>\r\$ؠtԦíYjiFR*L{4d@{Sv3Hp>F.<H/1#pL^)Fωݤ:U\rUI&2DPZNeHB'FB=r3ԄJ>\nlgJ+ڒ{F<*1>NC(&>NDC\"}\r V!!;^YA-;EBa˴:VʵSdA<:#s\r`e#P`D@FtKnZLd9x2q~eYK,FHUdP\r5B4\$j\\Z\$*8ISz/ yO;d=3`ذ\"\$Jyb<\0(Z!Ԃ\0:]k:)C8a=P(`SΕR;W3lSMfLgCҞOSi%@g]RȰWQ]x5_&zÓ!ь0PDK.ăNqbCw!)LF<Hͣ\$LEu*mLHRI	iQ\"O8r]tx/%轗`~P:|ÂHm6@\"ݍ[Fؒ	qWj;+nixZbrXڣ*\\19X,xA\r16ՍmA3VU:D~xպh=0@}\r.R{L~2C.v\n (KH)*)^(y(,>J<V>b#!u~tYS|ϩe #Y7|&̪%85\r_S{=K eA:ũ1 (%t\nDm[ۢ{o|!O8 aL)c|w]7̄^O3unvbAɥ5rs6\\+1<ݚte!(ck6MhJQ]k(PU\"R.I'#ct :=\n	\$<eI2[a SC\03(GƩ1tqs?}\"RTU:9@'0FI[hC)5F̫i(h2MFwF}hitFɩ}?ӽ~!\0	赂0T1j֡[zih\nq\0^\\@6gU<HljZXeBtY3>SErR#'OFCu\nvd'|{>dT_jp~nYcǣRdvH6yb&DV-Kj{iTY7^L\$ùhU:mS1d<QKUS̞ӣN;q5.\"FUcR'Mv(E'#e뽷ȳ~*G?N9N\0\n/l\nF4fJYw-f[Ӿ=;		b\na`&oĢdʉ@\rcu˚ \0`\rJƬmC'HEdA\\v2vP\"o(JiHdN\",Z.D:+\"|:\$/@;@@\rb\ne@,\ngPN;H<|~N-A*3IDbꐙ\"to5C>'FrgNHncpNiZ&|(bV \n 	\0@\$\r%MRY ¤tpm쇙(86om@^vEimCI皢.rq9^wG*&wqEǺ(۪ Ѣp1OqJa{/HJ8L{L7mvMLl0( CBӧEbFѴUqS#&RD<qhCR*QQ#Beqђ?.c.eż\n!6*Ov82d+o\"M\$\npR=JdB\"tI,D(⼑5-ÈFܿz0,izD͢/hLn*/lGj {ш-mAlE2'Ffm\0/CT/zh\$p	+M+ΐ5SRkX) \nD^&nkj\"0jnϷ	Jx8Ã\\R`:0p;&S8M&=:i(O8sg:=Lk4V7:QCU%<\n;@P XS,TOG/B1Bh>Đo1L%.A#%PN0c%R23F3<m=]EqjouڔN}OH4so3#?/EI1ITJsJwjD4g8Ƚ>/-r_L̄:se=<Ne2.*8;>6,/S2 Q9|R./i=)FDTMuuAQQaO1F	hu	;NV5Vq4a+PUk6ҍ	5r3>J3iXH@U=CnD,jhkMSZe`B6DF/jNV4h(g%M[t\$y_WIbEUp˥ED<'4UWpھ,ސR	)&.OUX]/ZMNplTf\n@.&yc\rW>?*;t\0rX8PVd5X6y&wM̆PV*EfmgU5)OBi\0_Da6Uf4>TWVRtV_ֵ44!4i3vmh2z'SN@(oXnpSshR?+',Q.꤄BTiu/O֡\0Og6UTU1[Nri;jt1l֓m6mq)BXi6ArCnGYGc_MWj7otgdfWXds,	w)wuyWiOBzTfV確@\n`\n[L\$q]|=#ZTO?{|w|˯1ZA~j6ƗP`f7jts1/-x6]NufX/U\"uuu?5\rfq1֑u\rh6ھc18˳cJwCktckumUmOD/)[WM{Db3OO^p\r	T	C% qmQ|QqnI?*	7&Sz@%XOҫian8LS%877:nVlyFR5Q7a{\rVנ|KpZXu@[\nf\nZ	0tK-UC#e@gq8CicٷG-3:\rSPD	s`o&5w'iBǚ8Qtpnj@Td6FP 2/\"ҳz9ߦ ń\0A\rKt'\"юTdE_\">!C8cx@&XuרK1>\",3é78j8J:਒=#|\r৅jT_Vgэ8mhFDN\"6آyY</\$Pq[n>2Y탧Ch\"Ѕ\n:\rE@YیwDTPUYbh#/K&:bﴭN(z;6g\rW扫@\r0@VnIpں 	\0t	@\n`";break;case"bs":$e="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4* A\"PCIrGn7+,lbdѶ.e)zCy\n,΢AJ -e3Nw|d\r]ŧ3cXݣw1@ay2Go7X搳\$eiMpVtbM Uk{Cn59.m23O9ɰ֍,`&%iJ0\rL\nhԜq,##IST\"( 8)c#i'MKdGpӐ9R42C0z\r8a^(\\0.c8^ㄟ(C ^(ڹ̹x7^046T>&)|쎃58R84Cxӌ}QT;O̪Rи0\n\0đMy_X\r^R!`61 8AL`ܿA/&h>[KZѭJ߈(0dvY	F.P:\rq^58ɂφ!\"S5;#,/\rwB\rl-x84rW40&.C[|nC +I_LBEW8L	OG:b\"S)C|9Z[hZB0RFY\r4[|\0ڍGrSDxWhCQ	93,g \nqΎjh\0@np=G2 Н\n\0]}\n0	k.\"87/PK2`3ɢ	|E\rm7(f:\0x2p9ʔ0<?a(aJ@He=\$\".5ij/?P1PwQV3e-ԾSe4rp2DZ<nle*(Uy 0B)9E9RKI\0M9I Q0\\RKy0&\$șDPLCfiְtsn憆kO'bI.d='IRl@\$:!d{OI\r_b!&#g\\#Ϥd_CAa\0d\r%TN08Gt7#	\r!\0%C\0Rh9*)܄,Hc><3JiJG!՛DhdoXS,2\"Ibd)ViSln'8͘c3;,c#AE8) [4WC04Ԑ0eՏP! E%SLJM%DRNc	\$<|\rN\$CGa\0!	O?DYa;HxS\nԙXq|e<:qK\n;@;ن\\\nm(\r`'US-I#ɡ\"0 sҒ&?8̹j,H ܩI{2Q`'@BD!P\"\0Phɣ2t̒dDB)W4@-Ժ`ʂ\$ARȶWZ!<82XvD)'aˡ>`㬣pmB<mlhfM\"HnlPyn◬FK-9bdF⤳\rf\0#f)\rľbU٫ALR'3s:hC`QQ<zC~V(@%.A=2)7rc3BK=	dΕ9ncLvxq*&KhA*s&#	5m4vU;{71jJ`SXƇ`\0,C<JBKm|z!mRQDUyHٴSQ^T퉔C!2ct Aa VޭYhuF9\0`3h%)\0\nXrc	pYVF**#0Fh@HƺWbk@HU⹄4(M}w㐫y+T&<[~/˸1n\$eg9keP!ƒˏ]'3~7+>:T^YyB& zb\0;Rr)<B<f2w	;^\0x#.nd,he^D\"0qOqt73)xGiY'		aM=fۓ`m_)|_N]JjXqzarWK/̽\rp|!; >@\0tC\"Bg(p<\0w\0oԊx;#6o1ZP'\rV,.BLRD2^CLzjȀB.plĐcf1rol%4`H:cndy\nb1\nnc\nk|\rvO)r\rx#\"l吊N.b:%YD6ac\" He\nl\"s%1.liMJcR8eRgLbM	PLJ(CLe-z%-BoШ1H\r><pg	jTQo;ﴆ\nnlBQFbCpFb`&q1@f#)(\$Q%Q &CD2žOLfFT3<1o#.Þ17\"A'_.S\rE4cTRe2W&\\-`2e<z!\\-|89	:1\08(:5c)B2*M m\"RE*%+-1{O(.82Gѵ%Hצ]/MBQ܆([ChѰA1ErA1.29ҟW\n'P5N#3V\\46T'BfPE6FBWac~XeiPjn6{9)dz{n9#sS h~=%\0#'\0r\"ϊ4pk\"0\nZR<b@N޻B?K??l;=eL3ko@U\r`.)̔=s!m3n#3c+\0-ُx\r)1TTDD-jXVg&^M\nŬ@]!|·;:0yB\0cTHOű+ETItK0О@lIGKEP=fiv3qdP0\0ddQ	&bsL<F400dztOf*!e\"b~-2L.B3)`,lǉ01EJD\"M9r\"/|BR8";break;case"ca":$e="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(TPfS9?Qi3M`(Q4D9pEΦ\r\$0ֳX~`6#+yedya;D*i+p4(8\$\"M<kXXēYNT^y=E\n)joM|*u4r9]3MPi^2.ڡ:H!0cpȈP %i\n\$H4bfELT&P2%136j6H#:\"-4ȍd(9N420z\r8a^h\\G)\\{9xDj/C2=x!0(n	P	`Nc:-̍2ǣ5:L7JLc0R	+ @1*`v-/\rڽB8AP{A(h=A\$1Ԉ:B\\nx3,\\~;/!(ȬGȱtV!L00`صz86\r}'ώ#Hrt	ZƢd\"Ԗt*j QU|0p@)\"b12T=W5TL1I,MS\"*֭{=+>[]zx(5͂B심ąkC.7l\"@S>tAQ@2 FH04]qc}\r/]F.o2\$ۢR\$kKFh(6p[\"8kq 6S`SH#3Df&#l7),\"\\]:7,M(0-W@e\0r3&\"E T0ȡ(b2 F9%C	K\r04ʙJkM7v\r>4:HI9`Ɯ\0҄ã.FFj3}(UHy!ia;HeC .K~D̚RlM8bݡU2jN(zt.DI(!B#hR4\$׏am0RD-q	-D,7J\"!!6XA3E[boҥn8&r0#DHY*Q`хE(B\n (\$\0((M|p>ZMy	B\ruȹz{8;琇g%4ܸkRC'c\r&UD#0(߭!C\naH#O('b|<sk)jŠ	WbD~	A.&b \\l:b@ɥ\nx!Y\0njPl>uAɲ0T \"I2\0)NUlDT̬TsѤ\"*#E&r#o\"I,1~I㪦\0#I1njÑ\$h<-,!Vdp \n@\"Y&[*&|K5gtHyD>WF+ga4la#\\2cSHxg92f4=I*19~ilmڐ徭&!<w	cMaH,\0]J,]bE1]:uaݩ>c/(Nje`zM3,}_msk'\$£~R=/t B Ts\"be-'SfR̫Jh+E~r5;l>[b5;FE	g.58ё_6dB\r6V\0[jG^r|1\nRmӁXG)0nbata\"-nx	~(t\",A]M qAa\"G/bl>GR~il}y\0\nYІUcr%\".(d~%@\\\\z=J|>Fuj	Nv܋58^_@\$VfMy>G.+II<?!݀2*EaL'ĔPվ[/J@-qI>Y\nNp 7[=u䔸䍜u.>l7/oS&ZPt?:0őw27\0s-Jf<5	SE`JrqJy\\,fΙ\"Řґk)>(+\\gV^Zgnf_Iղ]=]Sg<\\1KhpYt_q]}цGoB\n\rVܙuYb#0/xd6Ân锟Hb8ˢP°fp4p-F2אF\\`B,4\nZ.plb=f⪲*(EPDeMnJC9	2/^-0Bp	fp\0N.CC@Ȇf2BZKbP\0=|h0LІ*HGhpp,\rbFC^҆K\n/\nZ	fHlWkp)oL2cH\r4	xoOhSЧhpkWMji>N@JbKt\0xaQd1D~yQ&~1fFjjz5,l9͖Ң:_ #1[PocN(ILFz\r&\"%\"\rr&/7#?\"')%#llN?Q\nq&%&wf\rQm'& #(\n\nMG4\\\nm&\nҨ.Ҵ(0@j\"IJG!\0\"2DEY\r]\"./2p\r.\n08H\"kS`jDDkϡ\nF@Zb&mL \npu1Tnll4S\rnHss	H!n-eB2-#f\nn==XC֤̟41R# «efd6PF|7#=h;1%hBj<oo`h0fV7.<\rhG@	0|HAyB0 >ҥ@.1p6#|(C52@>0=R\"k<tty->a%*T0e+L:deEo̠S-	nYEDE\ndl/g;c\"2\"3]\r;3z9mCAoB@.\\@م\\Rj	\0@	t\n`";break;case"cs":$e="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8d:VH+TتX\nbc7eHa1M̈dNA^/J{HLlPDܮZe2bclu:Do\rbʻP.7Dn[6j1F7761T7r{āE3iǓ^0b穦p@c4{4T9&㓞5p	(B#Z-((!H#z9¤0h˴6#t!#\"(s.VC@5[f!\02A\0\rX.2D49Ax^;p0\\x99c@2`Ɖ#2@i`x!D+2ۏ! P74>:(C[^Bx6szmE3Mӭf\rcռ(Kp5Ѣ9UL\$0C\\u_Cx:.o :(\nH%jf:EDA)5<B`#p9ŊzSId\rzQLX:\\r`BEC!CX2i!#G6	;\"\"?A_rP9.wu=īT\\&GDYX@U2:-GN41H=J?3\r)0«@S6X<m:5ٛk@PDoB\r{J3h\\2t*Ea0cp4qq!A\\_A\\򜏸	փӴ!b[]BbYѰ^67:4)rQ29V8jup00̜I2E0#gEjroЈ5H湄QEm46 yںF`	c&?Cߟ!ϥ\0H́	?,\r?B~DFX|Ϣ;\"\\CdEΐ.eI\"d@C~BC[@RzQIK*t_L)/К`d\rT:A'!8Ez#\"y\0RrdDnR|z0Α(O	c(\$IJIC\$adEi4%XKIq/&\0\"24^TPnA:v	5̷ǎBGI\0<<Cȉ\$D'H\r75d\nDYJF>Kv H b>C\\IgXF\rCEmd,5D^KuVnA,rc+ѕQ78\$\0 gn\n\n8)dkARd\r!؇PJו\$#*\nKb3D\"ONJN^M^Y9+\rǑ9}e(MΞr@RL\"kX= 3A%0@RҵSL*~M	a!\"A63 %~<T	{!6fu[+Bw;NI\"WAzc,AĚN`  \r|'a[*i\nosxBO\naQ ;P[QZ*z(nEɹS#ii]ZWnc	3~GmcґR.FgPm\r@`LM'm'\nD\$_\$A4we-dՓD򭋻HҚD.H!ؠVd*Py'cr\\\nR\nDc	b\\!]ӳM1}6l\0HSAP\$bl*>H9K\ruHMfe&\na\n{gB(t[z͡<d{~읕U:\\baYr4zAԺS%5G((FQo'+ \$4\$e[Fa/9'd1K	Ϝ\"ŖъR2H\$õ\"dZF2ZFu\"\r@(!^L87@+N\"ӎjPL9h=KC95J9N ;3\n!uh@r30Rs!)'6ݠ\rY[!`]\nP 0S8XC9ȿTyVX=ePX}o@ֲ`T<^\$6r\"weU)?%Y\\Ya3B;dJ7@Jv+Wi	;\")N\"<~A.t\\əX\n@nGZD=?j#w wGljO5|r*سw>S0#}qmIm(*}g\0eThC{\"h4ᔏ*\na!@B'p`?R-@D\r\"z\$=ÉH7C6h(nS%^77Mh&&V47 5JT1`opF&p&jirE(΅;8ţKK(:<z:T\\7V^gߥ \\ms\nE4H')d,@'\\:!Pတ_\\*	\$EG*YlvBb`Ь,I,\rEq>q5	\nJl\"NqB7	g@,b=\r-	D<U貐@-r5w	|&1QcJ	̂.OBlC+/7e1L6ì>ÈGSMnqޑnX&g@ ާx* \"\n%OioZ%Z'Xp\"^2.rdoH:F*~̩jrH^¡)1!ޒ<e	iHɲBYKbaqMS) nj@)p*`IC1Į,72x.2\"\rxp#i-#ZdYtnc2\"إ<A.Lq,L3)35	\ng@\0@9i'\r3',UR+SL`L\n.5s\$/#'5.\\@EVEq;,s7-\"E83sCSHSUDDg-RᳰQ6\rFi/+-⳼@rx+x\n+;Q*#J0AS<=s<@B\r\n5!3vS'T2'B\\=&1aa'>46:mZHUCb#DGCD3\$s\" oF^%9<246#qKHF\$α'I(\"#WIo=yFޅ(\rV;tcL\n'dR\\#p'.`)O!\$\\fLN\npQJ%qJJ\0ؚCcO4[J2XmO/?H\rF!6D	Ro&U:R\n/E,8ZtB?@ҏ[\0c5/~GD8O/\"<\$@+`%!\$5nbq\"\n&4IQ+,h[ѠvXV]i]u5<sU<fjp}^an&Qd&9CAP#P'u,ҍu,ZY &)\"&x1d@z2\"_b:U2\0\"`C,u\\2%\\B}gc]LzBl,_#afc?^vdEB1g SM|";break;case"da":$e="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9gC9GCyo9Lq\n\$	)36Me#)76遹NXZQ6DL7+dtD 0\\AΗk6G2ٶCy@f0as܁[1Z7bm8rGS8(n5z߯4k1Nnvv{i7ŭ@QB)&8c(&74H# ڶ) 2ahܴ\$@ӿH4\rD09XЙD43x%Ȭ&1@|l9^'Aڴ!kcp92I07x#b\n66#\n*:;cX:@QC4X4@3Vp6(P+#ܶ(J224;OXމ P<+6e*n\0V0d7ƙV,8264C:qM8B2=\r3;0\n:R@k+6:bB-1uTcH3C&2\rţcӔZfc&\"`Z5T-?QExh{\$	cxc\nMl\06U>j,F?袁I@%.ɴ	<3Z7ˢΌ˪2lLz/;(B-P<%CrA3h؜8L\ns\n4!-,,Y(X3\n}y!Q cr9sR0ɲTR|d2S8\n\r`ب42ho+mv1J,GbHR #IT'B)ʰ3\r}44Ū8tk\\sDA7/2h11\$l~C)dp/_sJ|ITRXwII䤕sn6%PNd\"L4dh\rg%昋%Z<D<nn9/aK3hZT)ǌⳭKϻ\"Qy%al~g`i-GFȱ4UĚC%@@P2jNA:0pDL\\#mhԆ2L\r,258Cf2F¨g+\n`)=ktF\"C4hxCppFHh\r!44rԑ#Lꔳ0 g4A) K!(0 -Pl5pDI3ᘙ}LtA Y@\$@˘/r]Yӱ2+1cI12k6.pRp£F 7*(gh /qڽDE	䔊1\$Ɂ2E4(.|+X7ځ\"dTZB	`Ϩ4hPp\$1.])t=NXT.VlMO	*\0BEdL\"PlU.pc7>&U[J4A8[\rGw3PQ51좓bpCL<ӍU\r&0hoDa~Ьd:&=3Q:mUKə6\$DmЗ8!2(mDO)(T^/k*}\na=*t	[%l;с#A/*hxEOY/C\0	RvQļ5{_lMl1ɑP5\n+&\\p\0R-̺_4+D&PA H>[ dF1+UrAa R \rr+OC(j3u1˜hpDb1JT*sT[d9!\"(0Ch		z6l5՚iK+ر.w**лv޴,jAdrh:܂?ZΨo9y2\$\$9X DeR~W;k\\K6d@Fh-m{(ШK5K/fB8ꑰDxnnB1HK ^O/2trU;eFQ%IWڕ8\0[bESԩ&~'Λ>||q&_icZ2\$mZ.@^A:]oL=qʷN-XJn]<XtFfk͞uL9Wq=ޭ,hz&QC-}w枯 .5OȬ2-{[B+uZ.C|h\r.Gcɤ,zX&D23Eb9\0f&L\rfɯL\$N\n\"pϯ`O0k^.FbP+f9W-,4ϫF}\n0|G\n#C	\n6\0%OBh	\r/lp\"~44ìBkШPîDbOfl\0ˏC\".Z(.f~ z\$蠂Y4ΰ-L\r`\"dB7\0DOO?\nccz#qQ~%G\r(8ifF\\'cMZ\$2EGTPidH)Q	ePbJb@\"Mz\r'\rd\rV\re\rp..\n	?%0#mr-v)Bgnzܲf19&+T&jJ\07Wc~&Zs0	N(Rr8/\n2oC:):9&b\"!O*(6x/ :Q.+/6aQ001K/KvL2K'#d5P6v J:bL.E?6eUϞ\nJB\\\0Cd3:-0\0l\"yL/l&D r0Q3T0\n&-+qi%LȀ@-j!CO";break;case"de":$e="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9& >9M(e)V\n%⡄e6[`rbQfa\$Wn9ԇCіIg/* )jFQ`M94x 0·Y]rgxLSڸ@wŎBx(6nBh:KC%-|iz9#A:W7/X7=p@##kx䣢pk0\n\\;.,(:0o9S/X&\r:CC6p3(,8!x:H́#@7AQ @*Mhx0.\0C@:t!c8^A,xDj6#pC҉!^0c?/H:C+)@,0NRU.'ˎh\n<672a*!(a\",	Z-U#7ðt8ΎHẖ阩h7(Z(:n(+{&˄\nD\"@PTZ3:eZIn`RK%\r͵U6U߷{ \rz;S8'%t\rV0z(hj%K ߋc14\0JUBY\nn*UW.>0%hJ1J>@SRՁBH8F\"dI1]L!WТk9\07<ȌcZ:u pØ}ɽ<2G,oG)mU4\rz|\"Ng\r'\0007=8-4Ɯݍc-:>ԇ4;&(C#M)u4K7cdz#6Hoհ	]C87!Xp-\nu\\LQ3fHh?! &48Oq\rJG\"4'(q`;z@ӀC,eT6	>`#8РMaOn#䁉(F@tC*cL4ڛӊ=N;'DIOsI\rmBgS2\$_0#AֱfqB@o\"IranI./&\0И\"fM	6&j;P^LYiI6[ktt1P:\0^hxD:\"pÓE!8ZH\"2dNP	@2=.ÁpnE?DlKGuV[,7vLD)ҳ0`B4L#@w<VuJ✔`ŀiAD\$hIVկei4T.&hLL	\$?Ȇ\r~teX\$(rT,4\rzFHW\0UJG\"Đ!0\0T\r\nU	'#(BOJTld'ĨAꞓIUc;VΜ2,ɱGHD3p4I?ڲ/6*-9A	M'>}9\$\n<)@Z1e7jbHzvtrrN@b6_{w&\$w)iCbgSՂ@\0-!ײfyd4@*C\\w;I/Ǔ9E@`dll^\"\0\r`.A:\0BEd\"NθAA+<d>	 \"JKpQJ0m1	)1VYŏ&I!Hwyf(~xfr\ru\r%A0EOΐk	у_AiP-M}}A5:6Nnil'Wl  t>䎩bY1bOlIt3CDYMSQi*ZARq)эHRw	\0Pecfdq,\r}'&[  !O@T.\"nGNc	\rMf:OpʁD`އjc@=d\0BHq!ySnDmv!Oފɖ@/*!\\+YUCߢ\\}C艑f4rgI,ٳiN،qSORR @֪ڜIV~{F~О~bcjDduO!|~V{ߛaΉC~nfL߁/pmn&\r\$#'%QE߉йq!ou9H#?֞\nF:z\n7Uļ:	%gV͍rb)o\n}\"IcϽgjB΃0WG\0n(nK̓0e[HegC̰Lր]^-#\"<dfom-QMluF1H	c`Ex\rH\"#Md Z\\eY1ɬ[CcE#Ir=	\r-.yNo\nP4C=\0JZn\$`aP?5/b'o\n\0\rd\$\0006\"YPuI@k\0QZ0_zV,lB\rF4\"y'y~1`Z*,cZ'D.@#pz9LL\\MIjBŨo1f!Q\r0\r/MBfLFTob	\rM2!poGpiNSO!.&33 r?梒:悀U%23cH=@6v#4Ky]\"}!M2jj)#R#1R`\rm%d-\nc_S*`13:rZ\0gG\nG rPdD<Nr1n@F\r2\$2/*MB2Un&5!p1d\r\$b\$,⃧\"2 :s2-'1@*\$[(~[(\$;22sPSaN\$DGJ\nje6`Yʜ0( 9,m9e9(	gbɄJ/;qE4Yo82S@sy#\n:-@eNp\np4\\10nڗ/RŅ:)o)'L0*#B8b-ml\0ŴCz\n60wn	?<\$\"!*Z-Ǿ{r\rO	*(@PSCd3(̣J^!!J+sYK@@LkJl%4j40Q~I!Ř|t=0VE7.'\rv'd5(~Y(-O_Bm > Oxm23\"VBm5\$\\	Ҧ\rԼ\"Rݏjc,iLbFk(ZtkgY	N\"4\$!cH>&ywX0JJK\".4h";break;case"el":$e="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqck[)>Hj!uq*?#BWe<\$]b^2n>z< TM5'Q+^rJU)qs+4,er5-3J7g?g+1]_CFx|-UtLꢻ)9n?O+;)IjtP#0\nQ!s'\n|W+IHsH<?5RP9~%3ٞG(-4COT\np7\r7K9FgRPCZJ=P4L@fq4AtD\\9u;*%^(̦gbE-IR\$ h7K\07A, 8b0cZ98@0C0C2:\rx[9\04C(C@:t5-O.\0p_ivK |6EN3Lm4px!bٜ΢-Jf& %;O>%c(%0[6푥YCǕ@cO>cX6&)Ȳ80Cuz @1#:V3&U9Lr_:2_(Zӹ;¸vxӒ9(۔0(נ1qMBL.LJںt_4ժ9[JNGHq</j!d37fqAJJR\$DjV;foH@)\"b\rNB} l\rGRe/.Vghg?Y˓y0?3Wk2D\0l7gPH%6CHgq8maM\"܋别=Dd@AbN=#@@CsV+i-ZjKm09i66Hg(ƫ<_&45D>L	p7Fxҫ\\>xCw-%kS>B\\cH hB\$S1)a(:F\$2w\$yH&M\0006@A9(JOML)VvsPjK6QbP(҈J4PyF{Q-yaw]iՅ\\|#JSD\"kLrQ-4K2Kn >}3N)+')JtYM޷y\\SQkd`\nVU9ATʠ9-HdU+h-ż\\ˡuuػKzWC^T<],]ɂBD'JIIuv^P#{a=,!.EzL&Lw\$\$l\n\\tLׂ^9XT&F,E8bo%D'eȱ>HG~B!DM\$/;)'0<X\n>G2@#̝cn3CFH=՞&LkG6*	Y!6Ʀ]2 -a\\o0l\r0bȌװ5NuQ!<ȴJD,(A|*,\"r.|tugf\\f=!&8TJH\n\0@R΄>s	;+PXh  ehhfޑ E8Kяb\0sZJFCppYEiPԃh\r!4C>\00Y24'8SC\naH#(qY2IG>2<H\nL.qJ]^31CH\$J<E+BZAT~݃wydV#uqOg_6P~\"JRZ0%!GGϑjK?\\lXqs\"61Dd\0¦w51b{#-v\rV(6	rFWvʊLͮZPdM	IW\$yR{	:beD\01iG'J:	5{hf\rp6:7kŷ\"S{N!Hbq !Ih%Qh gU&\\4.}wSf?'N9)zMqH'+u?92tQx_>і6^~*|ɢrgJ'w%\n'7b\r&5)>+*4O3RYCߝzpp(c&vKPpL(*bbkc#H\$W>gǊ4Ħμ hMg0x\$ml9+hoGdHO#8`\rʀ\r꿈@^YfйGgd\r8gpdyD>òtŐJk;gDI6\$oX@3aF&OZO>&OoHbܧC\"hk` [Y\rx8LN>o#XlQ7&q/v\nizd@)w`#c\"#gih) !M%nHr\$@\n 	\0@ KU~[^\rbehV̺koCOk ^\0k,\\(k㖀EDIBOn#\"ϠIR,Z悎Q%ܫbbL]!D!!bB\"ip .lBzH(+ \n:kZB:Ck,W(RE!J#\"p98\"(-C)\$\"*DlXeDl\\`P#\":oR>08֍¶!b|G'2*O#\$g/ዸ-cMn\$<-t-I23Y Cy,28+*̳..@\$>o2\$(1kƅ#hb\"BNNGt3t,n\$3,0\"sb~67IM^hĉFHů?<ri&H)\"ak>'=9#&oذFg4S589(g:@@dMd8&8SC|-C~ &\rYp)*I5'\0:Tr\n/H(+:4hp\"H'Ϡǐ:p~0CTNGlG0\"X@p<M4ozϤqAu?J+]ER#\$1?P4FMC!<NiD\nAP3R(R̛Se-i_ ҽPk%%B%\"\rZSSR++]T\"I\"gM%O`uQb'P3A%AW^DbD.Q0!TY,oUuB'DOWK%,Fܕ2>B8I\r7-1P'/^'*4-c9c<mf_K|,l.p-+Π\$m^A3o3u,3/2XO4Y\nUďǔFD1X0bMPby/\nd{ABC5Yn\nD=iuh\\[H5PVfhNQ*Q>rYNQm0Qg]Kp\nR5#KRpsm	\\\\L6~pooilWVԸщq讑F)+Csl0b0b,'Nyo,zN\$kRoS6mldQ}aiuCwqkgUkp6D	x0Qq4j(Qy	GԹH֏0Cpr\$ƺpo\nVr,#{(6H;!^ϊ*\nlq֧UTz ȗE\\PiJ~-*Q\$j8+d|SY6j:QiF,KdSn8Oy[H=qßʕGH=rNT\$ўgL5Efnͅoxn%Aw|62i x6hv=\$7nGfuO+/StjJq1MrZ9},<cq\"46.2R;QUk%rT=0w#)TTs+b?tr=F=`\r#KVMoWw>K>m2ua#fD,BVPk\0wq \np&I&Ν@H)@-U;O@s9'LRjKb*HWBf|hRnJCNI;o[XPN()K#kz:<\$(D(陏WJ>Gj-Y!,&0E{AvQrI'#\$\"d߃5V\0HIp,7f6lvfi9%2B3r(GtbR9MT]ZW'TY,d\"nu=ILH)J8ݭZB-FvqbtE|Ӧb\"9BJwSFxG}&zuܙ&TR,1KvG&; dَI;e\$,=:y\$RCg;\"!vGC.um-T(Hu:Hfk1Qh0_Y\$	sv@ĺj<<qMd]k\$smEImm`¸";break;case"es":$e="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AL%\0/LS~\n7M:8(r4FdJx#&̆1*rL+Z	oX˕.ifS {4gCcpt:\r'*O{0dd}ɎE!(o7-[NNn2\\AjH}C2f5Hl\\S9㈧+/js1\r3OG\0007x@c(:,C4ލ. Pp@B`޹\rΛzL4ÌH6Ps<cz51H752qTC`@5C3:x1gAr3^8/ØxD´lb\$9x\$b9/Ch?/L,ڲë^C°L,#+䞃*r),T<2# //<Ms׈P\"B҆os\$¶M&-Gh@:\$6@:)qB? P28:S˥SH#Hoa1L̇Y4eR\$>\rg\"cҦDB3\"<@,La@U?70R!&M,nMTt?#2RSTiꁥL#AH(4=[	#lvi-J2s/\\!nSDj<1\"88,C`@i<Bs\nC	'3\\ϡhG,(}	urnb0ʏ50зâ͉ĵun!=V2ɆV÷\$ͳlֲA7mIr+\n\"m-ۡkRƉ5h7]rGxPAk6MRLP	#\n0B2[3brRQ<DK)m.úeLQ4{DhV }\nQkro̅2f)IlBqR\"DDCUD %&ز\0PoPa+bLBR/	k\$2N<MʐȀNCPa Cs3ch2'\$F4s~By(10kQGаǰH9RB\$1DGc1ICVxqDk\$3Z%\rP\0\":-8\0POI:+rZYs_ՑNk42gzFHК!*?!D k	#	8\"[I9\$蔣cQ3\\פkHܡ+\$7R\\7b^z\"VU!c\$iˆ\rhuI&PIR~gWQ1j%=*sACs'4z8)8-bˠBph֧QHO\naQ\$rk-ly1p@ uDUmrRJBXb9Q=Lǹg̬^L-#9;O\0 Rh2dÔ> [޴Gs3)6 0nIA)dxR\nWpcEX kЁ\"pr%ܲ#CdA<8/AX	1YB,\\2qIOKCȁJ\n['\$maSTOCFa&NrI)6ScJ\$C@(V[ͱar~a/Y̾pN̬&t't~I:?\n[3fxYcٔ1\nK{[;Q1ۇL#AӵECNdCFgξڤ8G,&\"\\L6Ũ4\$bL^,+Tŭ=FjTB,P)uo\$9X6FRZ70hrPKaA>j#QjT\"##nOv'Wt~LoWw|*\nwДjj%-wٵ*ݼpm7\nE@\\Ou!	Op9DwaQ[ɦǠZATgiNQHeID\$1h(w inQ@WLGD NHrXsGMI%? 2pMr;\\z!Y![z\r{a\\KJSLUUW#@WnDQ4xeraZy_|\"72E/:=^Ky͝Tt]<!4TqeԳ;i1s߸iWi|.^9\0Hҟ4fA\\5d\\a6H^ a1jrŉni\n5Bf\"* IR1 ێ^*r..0.~@ߣ.P@~EGwzBFp`5h0\nPf\"i.X@8.А;*z&c@!&2\\/O0E̘	L#pӃ[PT!At0}K,g\r˒ԈԹddbQYƐzG.%1,zͬS/@/]1M#1Xd\\8f:ET-E#l\0f/\$ʩoH1ّ[oahb8_;hѾ\\)Q%toI\0mRU\"1MT%	#\"=g\rp\$JsMc\"C\"Q^S;\"2?E\$I\$jBh+0|lBB\r2]`޶Wl|/.ҕrr^3@\$Q+\"4jG6\$Nl\",Z3\0C d0ɢ@^%c,p~#n!zU*<?1Tͮ\np\$ny3\"g2|!\\,,Lr5v/@/#C\nݍxCZi\nQB0DDd;8C<%at^bd:EX,=фdefeV<B&&cLAÐ̃0f?(oX/=ǢGCF3~f=ؚ~[;\0\$f@\rtD,Vڔ\$c(@HH\n\"=p\$\$|`?f,1\0HzV1LF0_DP\rG0(GTp\r\nc2M.f\n~zpDx5j*\0";break;case"et":$e="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(aLA0d2ࣤ4iF<b&l&+\r\nBQ(ԉDa'89\rfupNI9du'hѸ&S<@@tϝNhgP9NI9;|)@jjC,@m\"ٳq|F=ZqF̶`*y㹸@e9Rr4e1DyP90/9\0*\rȲ(/:>#\0P7#BS;\n\$>\075H#ƈ%@5(ƈڰ9P|4C(C@:t㼼\"-C8^2x##I|J!03-Ch:\r#x|țBK'8j+|ܦZ-j2h\"J͒\$p+Ð2B(J?*(]\nh\rk70k.^!2B=C0d^&@;B\$0>00cۂ`Ң@P|Mj5ųH'qB90ʕψ5i\\6\r:c\"`Z(:ú7QŌ'r\n9|sKT?T.'VSUІ\n% QJ\$*^Դjjخo !Y&'n;&3Os#@PI<9sͲ<`|'(0{foSߣsAo(֍Zè۝%yN諫\n\$09mψ!-֐2ٯ4\03j4722c;<]hG5ڼ&j?@3w5`;8\n)P\rG☈`\rdܓN+&3`@Q9I01XX3)E)TR]K\$u:iEm>'{fXڣ;4ܣ-/He\$ܢbSiw4RJY,%`)2CN	ɴãt׆j3_Nȼ8FV=10~fȣH::;p\$PHԅI9rC1\$Ccɖ}\0cɡ>@I)C(E켐H<Yj5\nm=p@@Pc\nA;@)&ഀњS9EV\re('lҔI|LѺv=ƾ!!bJܳ0qbVԍ2zmCzOE04F^<c\ry42T~y/|8CtԒ^c_(\$0eRk3Rqȼ3 \\!1	Uk4(ji=QB\\D=HȻBdǩ.8L\"V2j7h3\0I#@`6Bvm,2A\nAcX̲Br3UeS\0\0U\n @@D0\"刱	\"UF\nb}U\nIJ;:0N\r!̎09\$JSl/{)@>mȀVQ\$EMRy]kY<P>KS۴N<-J2'(\r}'taZlMn7'f\rb[KB Uxԅpt.)<Cm/\06V\r7H]M[]h\neF80J\$,DCPe\0cXTeV(cT%i_[jHl1ȔsӁ3	\\<3P䨴RjI\"%D,{z+@@ՁH2yPWeYilӀ\"`STHFSaRN\n@@@ L8=jpFF3KͷE̶|+b֎息a!Y2!\rg1k5EJB1s29:KngR/>A܂P/\"-5|BAD 5Ågٿ[ZӘ4vL/jbGs^fMw#9s'3V*LB%vÕÅ`G	ē`WZ.7B{/*By~~\\Z^<ϾcȮc(7o\r4~AMu\\c!`fQq	/O.)=f\0R5a=4Τs\\YS,\"	׋nbH]vdRkO?P\0'\"UUF!bjP.كl4,:I:Ethl\"Lfhpjذ}o/8dZwXJ8>	 .ﺊOGx[ĖioI:Ne0I\$}o,Э\$t4Eoк=aOH	0-\rZ\"B>XúP4<T\0S	J/P&:SC7pb59_	RȚqYQLT@\$\$q)axJq~p.g	ixѫz' Pڭ\n\n!jt	'BCK&R8CQ\"@ĉqQ\0E, RMg qUBi\r},TЉ j:(=#2k\"\r%i.EO%:3\"&\\J	&G'r.bNğ!'BZ԰,*d2)_cYl-i)	Nc%#)rmzgѾZk8 0x@!@rf	\rN,\0+~ٲ\n@h.2	Wh,0H0SE3/^\rŘ.*\$hY4bVe\$fg9N҂@j `\$Pw'E^. ZF*;N(X/Tʥ!Hi0D	\r \$\rlR0*ӄ1BrK8#jjÉ\"N4G\r;c	`J!û	VQN#N]\0L1	Tʰ0HVqBRk,!TG\0ސtV[F/<sr3C9'GN\"6&kFj/E2ކ`C0\"9xOo\nc \"CnvB\nP^@&	\"Ō-\0OƢ#kBHY-Ak/DPk@#Z,>k_<4oOb@`-cZB1f>Z¸.\0	\0t	@\n`";break;case"fa":$e="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6Ѷmkvᶹ![vM@2ka>\nl+2H#0\n]SPU!uxd)cZ\"%zB1C2o\r*u\\o1g{-PsW㤵>--#JK<֋TsFT/\nS0&>l`Q\r{US!\\8(7\rcp;\09Cx䬌T*(2r\"&\"_)k\n2E{3	# \07A 8T0c9c8@00C2:\rx%9P4C(C@:t1yC8^2|9P^&AKX\r7^0J~MT<6.hHSRs\$jP;9]i0QX%zZ\n7J((J2<nTv	?62KV-LZ\\\n\\I,BBy]uEq_X\nc.[]%L0,U*\\Ldȑ2XlaN5-Q\r\r¶)kO:;l@_94/(\nb\"@n|W&3RUZ5_7UzY%hcLVl%m7*UyPTgw^E,8llʫ*V\"X/I@67R3:gCOT	0983\r#?82c!=}^\"\r#6K\r{!w<DNuI[.U\0˖clN41{nYÐ60ZIHR!K3<K2FR\$SJ1EE5&ylHrYB1!\\dQt}P)a^(pHAEn@U\$!#H:^ƸVT\r\0\$%.J ܁`cy2#rN<'PQ}B%z?x!MDҚ=ĥo6Ổ^.&Β+.!5^,M\"!-V\\p{r!H<@TU{87SyOi?rP%㼐_+ G]mZ?B,ѳ#͜?,3\$?f9+[H8ڔdHO,&)%ę]\r!6\0ė2@LXa&gl\rڥ\\wT4Ct|!rRc	VfD<'GU|S*{ (\"Lmʒ&\n	)f\r%ߕ)%7Ee\r9=L)\$\$:{I546:Kq)D̓68&4ʙHrZ4N.X0\\eaL)jD	ڷʲW+VnR eD<O+(&`a!˲?\$Fr6%D<D	\$<\$}oHl7-D_q\"dbsGe:\$ōHIlIEeXJ72K^?z۳țN3\\]l_f*<~KDh[M)м#JjROZJy=2M ؈f	w#M8\0('@BD!P\"L(Lq7YJeCw¼K&>f86L<vUB'nS\nz%:R(ޫc i3U:b\$/hpIW@ra͐ߔ\\n_sV\rdCR8E!([ER\"nHa%Tmi`lS}2 1rO&Q̥.Qn%le\$XmF?G\rb:I)0EY<*#Ԩm>Fቼפ/@w!_Sb7Hq-.z13\n@ea4╒A(;ɗB|7q\nq3ä#Bv7Ni.:T!\$āJAJuд_V4\n\$)ZASLCV7U\0>VlcmWIХOj[Qʘk5)gƍ9.l=/f.eB/^Y]-9Y9,PS,}& {\"Sim%H8`/ox\\jjA^^\$C.N0P.R4pÀeof݆^p.dD)83\ng힥PrBFf0GN&\$4r0xnB T3n4.J|pk>iLN6'AfGT]-.In-(3\0km\$֧23oՆn\rm#4k)2NC!o)tVL*&/~m+m\\1\"Bpe]Q\$(y-0glp@.l)<waR|G¤UQd~\"*;?bF{\$ʢ3iϰC8- l/5	`lΥ<f0;Pq'j+u\r1Qr7 Fr\nz\raUE(![9VD\n+d?A	)+L \"2?%?qe\nm.U'vC#&Ǥ>(f'2Bp#:C'\n¢.phKK( .w+\$Bj2,h,~y2\0ء*;,N8JC;\n/Gp7/&c'.4R#!s\r/fzZ. ce'%3r_7r@^Lۢ<m8)2't:f%MxԱ.13\rS\nCaW	Dl'\0s|7GX\$610(33ő;S;C^CU4f.!ʮ@kܱ?;	3i,\nZ	LNi7SlFC&]/X>Yrx4>g<Ϥz6<nA0QtC{=EE(隶	πzMΨ2h(<&ϞsG#\0001B8ChC,DBV^ZnIRT8TTl0c\$GK_\n@p*ԣMT3EM.1K-7\nLV&lP8dѠ:q:bF5gL'B3F1L\02Q:A^ㆂңfΆoJj워O-znT2ϥKIl+pFh0\rO	T(.s%1h:|Xڵvoy#2l{\\ׯ\nF*";break;case"fi":$e="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 |=NFt<\rL5 *>k:+dnbQéj0IYa\r';eHmjIIN_}\"F=\0k2f۩4Ʃ&ånap0i݈*mMqza͸C^m6>㞄;n7F,px(Ea\\\"F\n%:iPn:lنhVÑʆ\$Ck(#\nF=%#2crH4H9σ4:BB>&9-p0\r2@29&\rLP'xɀ6,(09\r@!@2D4&x5jx3^c9xDb6=^0H@s@݌S!r50h^ر9ptQc*n#^;Ms]P-L87+q[0Z5[-æ`H*k)XQ2#=Zp78/xD#\r23Z>	Ӿ):挮\nXp2֩Jӥ(u2S6Z/doS\nb;,B86EJ0ĈIeLf,K	('9[\nqX!>*%Nf@ᡒ@K;45˔\0HΖ|(a_iK,֖c]ImowUz\$\"pU-˛4J\r&GIE|I{R;2َ\\P(0jq&BK@lH4nǥ\"!{ESU7E~jE	rzHY<{m~Y. \\LS&y\rK4dŚ؋\r1a\"s3W\0F0[EiޔwCK{d49cޔT7ؔl/&ęfM	6&sNn\"P!4C\\FKRԻH)	/O=Rm	w0HL ZКGqsRDz1.&ƙS:iMa6HSvXPSbN7I)\rH[Udr5Z`gG	y\r i\r7!5F>L^G3.)i\nC&M\\ڵD>?JK #,*M<G+\0-nh7FҩAC2,j!O38CO\"ԊDwIi\r8''mJ:və50\n)M.i2.䓕eV25Q\$~-':D&!TCdʦd6\".N)F1o\0F(:G^\0L-JCh\${RQ2`ػEDb5Ҁ\\Z;*sJBQy҇zr9h'J̾BuJ%0%ZDO\naP)T 	0ɐ*C	=\r彫)i1;)YϢ4p}KN P(`a9gHګ%@\"9Omfrzso+8PT,@.XA@@\n@^X>U`( jw^5GTRTÕ1S,1 d.iL42Ύu5((QrjJg9!4<@PVGU<w_98&\\8:sй0Cxvr>%Z}e96IYx /siA>1(L.fhU101tg%94]Øh_47tcU\r)P* &1؀Vl	tLlsHU24^j4A\0cA<b.TsuXx%3ݏgALAJNmdty\"^'n!P 0	L2&Q9\"<\\YXO:v~WFD4WlCN5vNaeJ__3<sf\\/4ǥ\"CMNFmd*JU}tz봤CNbk[#%A	+4 w}䏼ܧ	lru kb\$We~Szm29IA[ņ?|Z5L{5PD/j|uK5.ZzH9=Lc0~ǲɥnu2'00*W4'3^mP(d}IL/\0͉0A/K5BȊ:lþ,,\$+NV\n^\0:.o͌EY-3FZ*P츫JL@c/0WgQ`4KX\rAģvWXߏ	BJpty\n*\n:ﾥ0ڋ(M\rBlzAHZuBzÇcl/`8bX咈\"U&NGn&ذ*\"C|v-TH=Xb^٦`*pҭpM\rnT.?Uoܶf֑\0B]r)3oym#,6\$d( 8.O?D%Bꫨ?	c#P4%1ѭ\r{z؀]ޟ|#!\"Xxn!']CnD\$E  h@VE!\"S\$RH\rL.rXۭ\$\$ՠ% P-ܭplڹ-\r P62!Ҝ1'G+/\0ur5ҔnZ*02c]-ԝ_-R!1	\$ 	7m<8?!ʟO<;y1EX#g'^2\r.xg\$t?DHWLF`\rV6̃+CgükqMq@p!gN/r\nP:o\"H&&fm!T>0y.8B^u־,8̂5\\f1k?M&2xk\$&>/eӈl4D-b6Q06D<'	\"*uQTOr_E?EN/	ΦN\n#&&WtT ɢnH:(i`EB*6Ƞ6IJCz-KI0H̾gcO=CEf#|%`JQ`ЩGVC&L㯞0\\";break;case"fr":$e="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AL4T`-;T&8̦(2DQ4E&zdA:Φ脦\$&̆fn9',vnG3RtBpv262S'I\$6N\r@ 5T#VMKxrrB@c7iXȃ%:{=_SL\n|Tns\r<36΄3P\"Ln7; <P܁B26(:ħV֎c(!5L2;#s\$4ҍO/v-Z20lT j 8!( 501ɰ:\0tcØh@N420z\r\r9Ax^;Ёp&,3_,c,2`\"cp̋% |/pTƕJ#CbN0#o1,[0h\0׬b2	ʃP6;H>â\"Sj(\r0:6q7H(7T*#UuTWF\\A:L6A/}B40[XC,qG##;8㲂#>3Ǐ2Z4\\s|J@#dv6qP(:(/)sZ|*l8VWeVh)\"b.r>u_[|m:89x#FsSU񠡜֙P3ƈ>gۡveEBE8ݬM{;Rt93#IS\$]t]aA)8UyO\"ޖ2faC(\n G\0004&\\ KB;%2JrD4Jl6\"jA5<\$!0<aPsZ\$&MSPy5'x߆RMds\$ Fp	\"h1d!VQ4HV.FT4(Z_ +M!\$\\FS!Ѝ'hS}@5\nJ1G7VR>ǄT%sD8Jy-0#t&*0:2 '!d@!IԌ2PC(<ZmòTZl Ck(<f12إt	b2\"WQI{Đ!hR*)Rt<@l9Kxur2L277&ȦY9->ZSs]F]@yhY \n (%\$Eh\0#JRXs!!JIἁK酙W(J̑|3fѱz=%U	Uh̒X8 pT	jojAhi5g\nq3f'qn-UMZ9) \n&P+M2YYiJԢ:DaIr^EmﰄDL2UһHp֩(JHliM<#O3`8Set``9E:qs2~ ¡(&h\0R;[>Xbe\$ť5wY(;\$y\0N:P4&TjpfanQd	`ENhT-\r.ɳg?˕Z('@BD!P\"<(LXxm\0ŤE100EA\$ !О\$81.\n`\nyL\rq}c%2nD\"tcEW``;@sO_3Q,TLy!WStDC?feuI)f#.@Sg-t3>+3]8lHAy֢RSjx\01(% ǆVA_:SaG\0Llc+K=1f\n)C)LCS!ԾPσ,+X+k%BdzE\0Jxo)c*S78ERUydcAyvJrkUy|_z\r}6ׁ5deu֥F\ntaPuYIa셌\"Sf|uMT!\$B |4wo\$5\0\n\\3Eʷ#3F9ʰ)%;V+cgs眬s+C=vϼvMr2n17pBH灐]tx~<\\1`'=&I{p7p͝\nWv<9J73-N\$8ǻ3]ЮC|PO)&a2uoiD\$haTˣ?k\$Z,.Ϋ&\$f\$\0%ocP)	=\rk.:K\$Ƹ*So\"Xʈb#1KL`nY\\\"I0iM\"bn6n.Zڌ@.vcv\n,f\n{	#05R{E:%S@bi\$;pФfP\"oUpVf\$nPE|2Q5=J!ndJ158	\n6P0`)\"o;n \r~l\$NQ*хL&aPQO&(jPoaS(;b~nìEx/\rEƘ#r%NbZ`ʐ4tD\r8]ܟˎ:[4`sP2~cp-Bf2b!P3%Me)K\0q%q:|'@V%p(2NnsmR(ma2]('#(rv(R>%ή:\0H}`\0\0dl#F.S0hY!(%I}/3(2FVNSTMEX\$\\+_jN{'~J2vC}fX\rh5)V&5f6SPk573úe\$\\\"ro/\03\r9)ӨS1s::2Ky:5αҶO%:o&c*MF&:SC>3;	qAR3\0,&ZV-*M=Knv4lK&-4461̅&%-6(Z0-*[;4=x)op֛\rV;U 3>#Cm1\$s'E]|lJ\"#j\nZ>&d\nC}/B1~sB!dDuF;2pr\$eem\\1_˚D\n@OPAu:XT6gnsSR瀆},%\n0gb263>tz\0lJtVqng&d\\cV-)Xis\"GX5wY\$JNh<\$gq&#'V Ve^XMDhǬq~,x\r:*D?c\$1x,Ìh-ޯ\rdBLvun;ʥlQ0ړ`\"\0,a<D`g1/uΦU0ʨ";break;case"gl":$e="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9k38!uF#N\n73Sue7[ƃfb7eS%\n6\n\$s-]BNFS z;bsX|670·[VpL>&PG1\n9llhE]PӒq^k0&uQT*uC&&9J\nfɖZ\niROk:/:  ).臁PX2LxƟ42(08: FF98@\n7]\n43c0z\r8a^\\0Ŏ~/#8^&9ɮ(^)aڼp̼|1+^0(;9	{7\rKtS4B7 =B.\n (CʴtC#x:*\r(u6Cd!2pVj+L\rO\"1v`Hޙ*L\n˪P45107QfB͌\$0![c),	+\0ǧF(&ej	Bj*V\r4rӋ<#*=\"03e90(T@+#M8P)\nѐƓ#=6zjHz~P*J\n\$5pC-H޽ 2w)a\0mƒͶc<Qa4-*)M3Х#!\"}\n;I/).P\"@3bLc\nH<32oX gBefANDkD2hZ!tW\\֩>ۖ횛T!5[sOK_:\"q(~0?Dd߹)J׺:\"JddcCi[g\"ZO҃\"% @*VK	i.%\$/?)5^QK~Dz(iJ~[_\n^p3TGeg%BBTPjyaӝuc\nT:䢔ҪWK)m.eEɠ9&̒Niո&ӟ#vLSq#B%AZ(bJL@jqv\r%(l(RahTv1d34A+\$d0Jf\r%Yb}ߋ,'a\nB*ӅA\$H\n7ydAK&RCy\"qH\"\"`I\\mdL3(Fh]0\n 0Κ	*+F6BJ#3dTA܈O!\$h\$3DtЀ\rS\0C\naH#@:V(ii7RZ٠{}~gqƳI1&d;4K5VcbY}'fV;p3:yߟ8W7k P	L*6863gr;(MZU+Ti @r-bge|*!%@~+4T\0AW(F\n72I#L9 2 vF.!0xg(\"~AB&Q<JC\nT R<'\0 A\nTxR\nX'ЈB`Ewfq~\"ĵ(f	3dE:R.\0ܜDlLzt/g\"Zcjl6g\$Qi\\c3e XLi!n2`ͤ	2;C:ZJ'ЃTn=+6u+ Rg)k0h@6ͳ\n/5Nϋ/nQPu	z\n. U1Z\"-puhâx>CjmS#Ny!X\rMQ;Q)/A>RuܾCV'!0.o+H{?z&X6\r,=2(NS6D#'ƢIyd\"ި\nBkdpRT	\0bFߨoFu*0Z\\S0Ax WߠnH5GC#!:gֆ0{\rf	{PILV	QMzF@ӥ2PyPOlۯΥاVD֮z5s׺F#qsyvÜ:S9xm#T;]%#\\1:<xqEJA/H(Hx.]i9Md̶U ԓUBnr\\}dF;\n]\"߿ʧ%{웶FY&.vcN.@[-J|LB.Oxҋ`bB\niҞ6\0Q>'v(51vVEXe \rFƦ4olmP¨Yފjo00j^%DD~p\n-꺄\$\"N4/G쎮d&1o	(e4iBC)ؽIf{)ԼM/@Bp8!Ġ'	xmιB~*d̃ZJ_P,g\$\r你TNͅ&\r^1v9E0<#Po+q\nQ,#\"/WI	\nPDoB82f^\\m&f\\CpD)Q4ޭM!\"5F_Ql|m7/#>_ms%RO#1ZleT3ߨnIT@>C'l\$.(\$\\+R\"iߒ!@r+,.\0<\$\rLnG-%?ŕH+R8\n-P/eA27[P	&\$`Ғ @\\UMW^>\r'4.2Z\"3JPn1zD.#D\"|4ĀbNO}pPA`ƥƞĦb=&h1Ų)Ζ'bdk7SL{,\np*\r;o!BZ*\"/PQ8@८88d\nfs?'&j<t`<X03l8 l<o'NCe2L#MDA`eCE(7Em[[D4U\0	f	(bcGCk?X7Ga#pgGL\0lehBΌfd\$FeBnޠ']BO1yGlo\$@B2\0CJ1Nb:I)5	d id\n@;܃U<+FpX`*";break;case"he":$e="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r;*bJu<UBk0i]?F'1eTk&G~_&0EAd4U¤MBi~ŕ\"U hn2\\+][vGbҥE(ŷMƳqnNG#y]ο񯸫_A_0il[*Js8r,)#cք@h⚚36K h7<A\07@ 8,B0c:98@0C0C2:\rxl9(`4C(C@:t㼴0.(p_!r\$I|6.3<ld4px!:9\n\$C6#F+\$rAH2l:k2	9R\n7E(J2,5=ҊY\"hI\"N,	**;0*.zLN\$)%%]:u`%JjZn*H0푮ܡ2(![O\"U4i,Τ+ )\"e\raL%OB@Kj< Ԝ8FY<O\"Ȳ^WI+֗/U6\"'^h92T&O003Ø|!#03C.'/ 9ƃdq<ݼp2œ?㦽;3u<ܢG%T\nJ[̲=h^rIrFO?#6+RJhWvu޸a<`B?mYi:%!{GP\"!n-V/.LIt)J\\K0\$ƙAzo<&`D\"ub|\rQ*1&QNsAIrJ\$W3d@YR%%ԞRUJe-ydLÆs%f%BFȉ8Z*\r/3xaaQD0rN\\֑Ca鐦vPyQD`rB8E1<` H8\$heU38wê)Ea:ǐ;sGH#p\$ i42&XCc14hl e\0\0('Ɨrrp07\"r\r!;P \n&nHy\"wq]4	\$GĜ0i	%0n 4`w\r1ҔzG1S%(UW9E\r{AXCj3D6Z.U`>4an&((iЅEZz\"Nܒ<a-l0YH5%QQP#L_?\0¥\"\"DPTQa©d\$gjV\\x&Id%A[`,	)1_=4͝4h\rRXԕ׵FT,NfV%\$`IU3N<:n\\an)\"MHIQ8:\"XEC?OUݟ	`qPS)2+UiReWy]KYj1Fzl\"N2Wŉ``\nj\\N'-f&ۙ[+Y:	\0AM\n#䕰K*Qsu'2\rhQM:``oK 8\$b0\nrl2z GeR\nDG	:rEdw/51Ibrѱ:Ck \r&\$q=C.a9єm[ISBpL0:m\"Qc,Ք.qC	(JdD/LU`\rW&bR5Tȉ\$j@󕃬RJ)\"'LQٲqKZO_S6H)=BkTQ9.[^VQk@{s'#4lݑ\nRݐzA6FWQQc@^Pv,:Gi _NKs.+)Cܔ\rQ#xn%n\rEwbrOݰZQ%E\$vG\\8iayq-8(47\\hXqd쓔+>5lJiÏ3hain]!.-v+2k]̣|	˦ fٟf_uEFޚt%51u%J*b\\YrHM~Օ!`yx8E\\s-m	e`	y=\$%g͊Ӭ?>l*Ĵo,E~0R>Qyw˰X%Q쮷tR\$W.wFToZPP Ѧ3\$N+:\"8Y<?lWnJ:\$]n#|1oDbS@\$.vY0#:1ТC\n.0aoVW'f# \rgFL4d<p	0\rƌD&\rQv%V(.Я-\nL॓o.+=AD#/q\r!pL>0T[.æЏ~&-\$:\$*|%\n6<ϋz\rbEQq+	^إ#IvHdCtH	j*(-(hnR~Z@e秕1BX^W>U\rQ֢@tJ!H4\nȈ<1/&.%P!L)\0L04w]4P[ΐOp(N\"Y<%2%r(h!)B2KxTf2,665E\\:*AL4쎗^ou2b_FnⰫ\"Pg\"]f˸ѐ!.\"(qJ0Z%+~â\r<@G1X&jR5";break;case"hu":$e="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n!OGC| L5\nLL<n1c*))`k56Lԁ:'Td2ɼ 4NZ9@p9NƓfKNC\r:&hD7, *msw&kLxtl<7cVAgb=U\n*GNTT<;16B5x73Ð7Jx:H2(cVƈRf	H0|\"PlC8:\0P6 =6mot8A1l(\$qz῍`4-4׿`@\$Bv3:x7tA`x,cI|6b3Akz4px!T*#6\"P:C֎10I\nYÛ.=SUM\rH@*::N:6%TN5PS\\V28>\rOe\$Hm%cE[跈(0@;#`2B[dì10֕:v3è>\nON9\r5I\"v7.w޼[73P)e\rެPX~c7SB,ZZ2#;E*jDr	VlkM)VT,\n{*HS.Bmz!	88\n\rfHBbbH\"R\"E]{\"Ya5`{0PI(9AZG#H] th4wׇjP8m|Aⵝ7Ithn\"4p[5ox;K6+x2b#lkJҭ`3ɚJ2+EP7hHI!%eR{zyNFx(6uA@s&\0@͡LE)IMT@r)-`KS^oY#jeL5ӊs!;'ȳ^*5@袢885\"R	\rO:%(mNj2FN1)=4\r\$2侘b\nfM	6&K7p9J!'B 'JARR\rrSO5p4XHN)3D14cE,9C\"Cfm :x	L̛XwL qqyPCsI52PX@f{P`&@@Pqw0+dD;PR&*LCl\\s&\0̔\\P!;D	#AἩL\"(	\$i\$fT0n[\$:ta;ye8KGIEM'2 !0zQ8`l5):JeKɉ32<B	'E:>Fjx@\n	\$<dz\rjA\$pRvXs'(n8ALP~pSܶRf-֓BO\naRB̸9'.]\0I5sR)ԴnrI\0Ӊ-_`@Z&:PY:KE[ ֿZ,xYhff4ct0Z8pj╋ zZA1&\nC23d>(&/]EI)1٪vջhxU7&1^NƉr>&ʆB11xd1B͉12kXoZ.=b	^C8^ά1	V'\rWV&v+1K0\"\\{E@\n	Nbf`)܇FeFVk\";aU{,lqJolM=bvc\re!I8\nŊ%2٘260l3JIAIw|hY-ن!Xčg*ЂAa YJm͑RY*M6{2YbQeV/&\r!bYJyIfRśaZ/rW=NM\08Nlspjya缧O+oE#KPG7r:s}!@9`:9Zp\$Ly*|`ʉV`=?ba(PXw-R5q` u^3\0Ӳ4`!Fq^Pt2(*ֻd:AV05\rSぎL`U{-'y\"ViWXW)J\$U>^1'#rDx~\$*B(ΆU\"\$#Z\"e,#C\"TzÒ0&~-@RbqK0D,\r,:̌#R *֠F\\j#l;JZ	-f[%Zv\rjhEGVLOokj8't00o\0000Mr\"R;\$\r.?-^\$j|.n0x\r.00YcKlp\$OHP-\0;cbjipyHo]eTQd6@KIRhEm>t>TI`BHyq\r#X0%QAڑZüdObQ܌^RT:IM\0,\nqGK	q,n\n1i!s !#!#r\nU)`@122Top8B;iM&q<djޤ\"fa\"R6ƣ،aBFS)k@;);&)ο9\$l9BEbm5\nR2!hm.R`(-7.KF(B>J-&G'O1e#q2gp2n2\0Rs)2G,Kf2</E='15C'.(mCR\0c\r#\\X)o#eL,U&4YE; ʹ/W9^:bd:蓜S;s3	n@4#X]<֓q>h?V/?e8\rVPI\0`J\r ̂Ĩ%@OJ@\nZ`=KHV@pT&TY^qV \"B(\"\$f\$BHǸ;#Bm枡C 0~\\c<Q2K2/'j %@P}4NCC7\0]îUD>o:I䏍TψO\0\rJ\r<<\r<fl3IrOQOQ&\"е'2/R&RbΥ,^(:\0m/&<Qf'\$b<TSAB\rfJiNZ	Z0|vJddb`Hpl7T,C&s)#9\05EVߵ٦KPqQR¢ǆ&J-a\\BƆ4\r.b)\r80\"|8lt\r";break;case"id":$e="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n 2T~\n5f*@l4цa\$E8S4'	ldu'c(oFe3htƝ\ry/s4aUU/l'Q!7nS>S/W95&n/x\n\$NX)\n3 Щx(6ǝӑ9\r0\n(DSw0/2Zz=Ә&@ȣj^ ښ`182 0cJ&s>\$h4L<6Ȥ`@-@2D49Ax^;ȁru\\z&Ü]~\r34^0\r(F	J:x#OT;z. P7N#J6P\nP	cx7bR&Tp=	)oO0:S}8\"G6\"6+4\r\0PҰ3Ō!`Ss\n辷,IxΣZ\nNY345\0002.#4)\"`1@NbړMs49c,~>lXɲ_	-SA\\!b(6B \0.!J9'\rN9#2\$Yk 4'bkB\"2@h2\r\0ܽ,\nz9Č^(Jp;S[B 3T	kf-02РUpBNƍ0̴I)xb/x7Sr\"4;ս7N#rjz aJK׉:D*1IY.x0t 9FC҄B11{2#rX&\"Y,}>ϧi-Ke]V*E	DÒl@\\ѫGH\$FyI\$Ĝse\"m%fCS=\$RUa 战tj	b>^J%4g~jL\r/9!R-@ғ^*]CDQ\$H8CJmAs6hpQJ9@P+HhLA?%ƢDCrIo͙8eeR,:5\"XIlRE h)\$4C:!zDq\"@c#H<3ShcV}߆NS\nA>F9Xi2a5U.aԄ.SPu\r'\"1QqfMI:-\08CY7j(\$0aɊ|EHÊ= 3YRB1v?? a3-Un\0T\\Ȟ+RI8 	iq(dFNOTȎRbYG e74gΩrtNT_2H@eKpF\nBD-`ԔHcPʴxxNT(@(\n \"Pk@\n	lU1\\,hhR?--6f>h&˯-XtNUɢ1ܙbbbfXb- ?̶&yX(\n\n/CΥ#\\P\":|Oa(JmYaxJd{G@[Ԋ2**P,\r:\\KER&T2r\rىTw15XZ}}OӒ9D!\0ǁ7! 3R։<ǪXAHUc\rczl7R.vT\n!A@Wqf:D0\n7JfjDơ̙k+:0Ykd~)%/z]P9\\&t|dno&:P	M<PAN'r(ͤK覈c2TQuY2hqy	yN::',<\r\nAPh/B<v>XP\"ck?ycPuWèi\$J\rBMg/z͠:o}~Cxߛwy\"l]\$+|aЈygi?+@xpVߪy''=O#\$QN[lpXMfX͛w7ZiO/cj4K??SDǙg8EǅrM̶qR9?3#o\rYV;vR䔵T@87(IND 0jS} `IT30ysȋMbRೃ֓^HGjޫǒ|\$FpǮ`q']ߛѾ/avU;?\"O}F<W'ur0&yx	/\nn0cT8A/-.joE\0/`0n\$Ot\"(X2K`Ne*XȉV<?H>F0B;:>\"X#0TPSgr%/Wg0j!poCA`W\"PTT/N\r0zŰQ08A\\QFQ #	;pm=\rp\n\0LvǣX(k9nx?`?Xm/^-˂NLd\rV!bȨtWBs ? uDP\$@Ͱhj`\npk1cx\$L0p[7\$LnR4l	mv^ZDڢ;CC\$\"ԧ@p\"QVMR\$Ft9'4G!CF=W),ox,f\rqx#-߯\$! ( oq!AMb߯OO5\nNɘ᠚}`C&n \\H%+dCK\"v/Lmev\nR 6V..V]rr5=2cA\"tnXザnb1l4T`";break;case"it":$e="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AE8QoS|@o&dN&(fLM7\r1xX(-2dF}(uG&s4M\"vZgZ-(J.WCa[;fʒ 1Ņƭg<	 gJerKDSd׳&ZQT\"H&9:k|jlʷ;`{yP (0i (svIx	zԏ3eP2\r[:#88-\rH1l2\" p9`@%#CH3:x#1\rAr3 _I|8\r&t\r2ЙA(|\n3zQz%\0000k3ROH6k%,@+kf',\"b t @1*hN\n\rb:BUm,7յ{&rI[`O°\"!0m%f\njЍ2-pJL`Z 4el\n7csL	/I®2@4TV\r-䵩Ո7(P0kDPt\\\0UE!o-m\$1mQJP>2	#l@9.N9(˃s!N\"3ji@6#n0M\$9#[<#5\$Ĵ!ka|9:L\"8˚0%:TN1mN֔!tjEM9𓽏b87KfO}n<Zh7+V&.M10쀲%PAUAcf\\CT\0H˗:uk_[?vg-}+nvO\"֟S4FԌ02+̂\$L\n5%p0(& GO*G%%y4:NeMIG0`°9v%荩@Iт2?lFJ002B\\R;!\$DT(% ~\ra-3PFTl9BbB\$}w\\f\n@8\n17RDpCFqu1Дb>SoD ;Gl\rV;n\r\"A)Д)@aB(.iPH\n\0FA?\$f]8Anz-H6Vc2#%_r=0ƽJ Ҟ&ONR(DYaLmGҲ`8\$Բs(b.yB	\n5@RӆLe-f`IO ɐl%IH_O!?jU'DO̔pFT9`̍@f%rܒy(ȉ.xS\nB̚'p(SBTԝSٓm@HzT}	!\n,a(itC	!R])GUI̊9I7M5CnMlS`('@BD!P\"K,(Lphʪr.6wSsBb_	2e-\$ANL9[椵PZ0RCh{\$\$J:\ne42f6\\ف!K\nEk&)hl2QHaLdC\rml_Q9<18svH\0VP*_<#HCAeY&7*Y8`Ƃlz\$lyDDbOvQ>T7D9/.?)+Hb9S|1\n܃r\nɏ8 Y>\$>LJa\nP 09	)S9e),dtAYQR@!i*O(cA\0O	hPR#4E@U'n:,f)<eId ÿ'?6d:י66;ryY1A]ޤ.{YmED>l5\"'Mn̜NSI{U\$G-{V@:WGXHn0o)pӡ=EN3\"\r(SՍo/`q]\\kYQDtB}J!2gvV]!̰pn> ~k{m%0dC!f*\"ZU.l/6^YЎ깞8C)ae賧s4_Ipݝ1kMK]vSlrw^s4/)]u|YC5rYe9A0L\\nl}M)_`G'&rϚmz\0B%pO\$&n0xvܔnO/Z@\rH\0RM\r6l̫ UcfNRV/ _NdLg\nŌϐnXpHo\"\"B|h4[B*`kwˎnj/lCOBP_BRŰp̼J\r+'Y\0+<3 ցBfSʠyF.\rBÖ3V4;.pxpvg-,pq1@s0V!,7uhxp	f_\n%\$/Hwѯb0\"mSѬ0^>+SǾ\"-`\"ܓbgT(Vmx(cꀩ%=iZ\$2J9`:⃒\r,qNHoC</.\np^w\"Vgvԍ8Fl͖Zl0h	ڕB@0fs5o\";(\"R.1P\\\"2(ڭc6KEX\0V\"1CTϼ`,bʗR   .,-).rK,Φ(-RM007d2ORbec6^FBAs30/^d䩅h3N-nJC&:pk,g`\r&F!ꀂ`\$KF0\nrg /&ҷ6>Ӟ\rUh`M\n	WLCڒePZ #";break;case"ja":$e="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp99UB[Hi[x9+AFCw@~UM^_PPU! F^!UМR<I'2mhK,/P[PtRW^XEvu:kL[&|	W~G*)Am4TO;%~sC\\10G\$%ReK8myCd~\\A\\t0C lrkHI^ŐdKC9,B8A8IYpD\"R@2\rH2JAq\\@A0B\\\$%qG_Z@c,@x0@2D49Ax^;Ӂp,KR\\7C8^2x0cRxDARY`|sj^SgI\0)YR\$fDڶyg|%\nsmdrDEgAZS\"*DBD<EfAL[MRrv\0QTr@1\0\$DsRDeB{^In)[W\$\"^K/+*[\$E!9i+Se\nb`dۄ.ӯ`ǳtv}~̚pOoV6=c;X;_o9|S:<V\"VA@\n,WuBb&y_O)S.c\"ɲbA / c)\rZ9֥A[\$%53R&s2(\$;y\0@_^1Re㲤8\"_{%qA!e1J9.8\r\$Vbss-#3( عN	6\"Hb6@a)B.Dsl9+oB%2*C;u\"f,Y@f< PbxB	x!9EcCl)30@BL=!(wJ\\E+!TBS(@Qc`JJ\$r9ؘ(J-F\"ԪS*mN쨕\"U\02CibNKX0]r5N	А.䴍Ʒ\"V\0Q3FS^Mɉ24m8&LLD9)(RYL)8RuRCtUU*fAr.BA|\"K mS:|\r2VN^{HKIl ĺ\"d\0#،\"g`d\$8PH0lP\r%)\$\"ЊTap_~SH\n	֧W/ G`0\nP@\"EBNe':_XQ<߮4n(|M:M4\"Lxw(=\n5ə(!t9;\"1>bOgMQ'g`Mf <4 {#NPC\naH#PS%qC\\&4\\uJ\n`LO!F\rƮS^yDhA(ZS3PǂC91˵٫\n\r7\\9E\0eG#L3#Jk,a@'0BQqCvJ)6r~ y4FJ![oN<jI)UdSelب&KF\n@sQISRI=G/\"AP+㛙xRH%HkQNZ\0L'@BD!P\" E	J/vKP-#!ډɇÞ|y_䙉kNnF<nBf52׉ž~cݜa&D!dyƍHcvr#RLgaN\\V00/BN^!!2	Y\nvkޥ^+(4ChA[XE+Y~䍐ibmP9L+G@%eb#|/A1\rΈ5\rw-R\"`EIU+\n!^ܜE9[m]nq\$%ވ\"jF1=Agtu#˱,By%`]>\\x.\"3]_mQb.\"n0BHy7!#SUPfA!\n/܂L}'N5 mR*ɕRﵟʵ'>zO<`u@[q~WnB*W>җhE1@vn̛',Hg|JLHxP6k~\nL|E-˯&r,6\\ZfoboL\\A~.PH0(lv!p|3C83ź[H\"C1	ex7À8Pp	v@4EiBŨ1>䯏箌7E[O\r=8ΐb\"԰HGv6c	/b/fGFrlbFS218o	n8?Nl޾m<[PF\"\neMG͜װ\rnbbJξ,b-o%bD-pZ1A\"ザ16\"ŝBҿ1PL\r!	m1nŚ1ʬ Gۥ!#^N؊z0_\naB_p2/P#Gd|hlh*°\$2Rx:2/Pb`07-<vc΄!.a MY2 !+J:һ!ѵ,,r\" *\$(mj}./&׊lr/aXt3\0.I]F*G/+.32!423rDw5m/A]0Hiq6b6\0\\QVkf\"a-K9Ṇ/2,퓩3GE/9*.NQ_Ӽl.*c=!Ԉ_<sBsw-B^&Jr/,`59<a o3A;	X\r\0M4\$J\\i\">aq9F-n_/\0sbMnhF0+o`FeCTeF087/\0nfб\rc6P\nZ2LL{(46W4 6Z<hv<sp:	;bt\nO43	Gual̮vaT#nT\$!~47TRa~>c!,A6b^&40j <jPG2)7b\najWmvMWesYX>aRp\rB\$!-q\$JFfeQ\nIDn0#\$ڛFRv%*>Hg\0GZ[\rm;^\rVV:a(']F͵FAX5OXF_YOpzN[Q*F Fj6P";break;case"ka":$e="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fIɥ	'\"1UdJ	.eiJ\"|:\r]GR1tYg0<SWµK{!feMs'Im&K=e\"r'Q+˿}-<^}nnZ,:K<թ;SV\"zq=o۳*#\0LDζS:-JsL,ӭ)[xbdER>B!Ȼ1	%iR.\nr4Ol=B*\"kJNS6/|6.4+rń6#p90'N,-7TSt\"\\̛!\0x0@2D49Ax^;p?4\\7C8^2x0c\\xD=^04#){K,jO/CCd0ǐ3.[;'\r1C%w4ȼp+o	#/\"+r&Ze46%q5LQ'lL-ß*I7\$n[KS*Gΐ3)MJՒm\rAPVCr_-^Jl3 NRry5./*k壾jNŵK znKJQM(锨i{*\$Pڄ4Y\r7)^1&P{o.z'VAS}oW*m{w7z_4ܸQ髸wt=7<S!l<dc\$0>Sw%mBhâ+!Q@p 0\$0 CZOpf\r!X\$s\ngnVqb\nҝ.WVs5W:h24t\0ppƈ| ϻM\$*:Sdrj,F[9 ݐWɵxҿpbgX^u\")*<VY+H:\$ES9H03M+b)EeF#^|U89,\\Zi#-Ne\${4\"3CFaZ~P\n	BJdcd-RtD6>Rɘȝ	9SQUNUZUY˵lҼ`Y2}nF]cI0}d`Yj~FaL-|d۳2c)^-5#*Yf̒)0٢m3A'\$1Du#3.t<FMQ*ELRU;%i/Wj2W9ηo@̊\\+0}C-\rg.ՖSXtNIwM%+N,JM̔;ua(\\gp{-?X}UeO\"+.˘))R\$k&22QI~:JP`kyĜU)O\n]]\$VVɤ8a\$R?Ǆ\nM2`Ԧ'P8 f*D\\ZhdH!6RyZDY܋n*z1\$z.46搷kGd,&JHi{Ǳ&Y\\pVI\nLtqh!0mIBeSoҮ>Y&5V.Fb[(bisJ|]_#n2^*Iƴ(U	Ix:c\n;]&˄M7AtAJiIP	L*Uˣ;fqTle:x'96f֣A4+3\$n[dJ̀YGVdT°v&\$zD*%Ye[P1%d߱7ӕ;G&KON`qbrvĒy;d޼	\\M\\*vùζ2OkB.5	C3oEfzJI!Ѧ~ˍkKK䜵ԛtl\\4}pyʡ:@\$ku!Z-U̩#bWƬ1Uκ/?B\$цGѻl8VRVzɶ:	YV\$`u0ƨ\0h\rmJ&`K,sPeV_[72by76q@2Inj,ܲl\$\rM6knõ@(c\rd!9A\0cD>&7\rSI=fc6zbM|+H_)q3(ZÑ }r(]\rW( @ 	b|0ll7B1HHyNL5dK\0`^-6ȯ\0|hE\"~&@:2x\n)>dhm ͿFŋf̋2f\$p,d,c@\"7t[X\\ܘ(>pF=B.ć VbNح.g \rZNPPPg\"ؐl&MFtjH0Fߑ&rn\rv&'\"Jd)=^kso\"t^v~{<gj&Jn[0,ʮ0xMgxK'npSj1ђМEtۈRz8hz+legcu@dC6Oqho-Y\nKmq\0ڋ>'\"0\0FBʒbO-B/ĈFD.?x4fn\r Ng*c.(=C.*o&q-\"2\\/Υ%q&/C*Q-nLhV784*PR~eN+Ra'1)\$\"DD(Ҟ.~pY\$\"i-R4)LrvBnV*\$(\n,aMO),fv\"e\r36ms:#3>rJ:+2#3؇0-hQB2ctR-\$Sُ2f5.7QX^Sbό&Z^M9v=ɂ,'o2'=A5^4dl(sdM,t%F/vv&/d/'2#:HwB(S[=swMAQR.QC9\r14U3\\o1 Moэ	pv	~'*8J:,4(#0NGI̙DE=+gmfR7KK24WQmMMbN%KTFK-Pm\r&cb\reBX\0@@W@\r&5 U&U-S\0ST5\$\r)T& U\0/v\ro{tS|G%T046[X7DqXupEXMLBaE1@Q:,54JdK\0\$CPe^ULH&A`:ı#4+O,4xC4\\dSE]PиHNG4\\ra4_^r#c&О\ng~\n@:h\rWlPgL\"&4Ec6Bu\r+\n\0p4#'\$cYiAGȦH6	xp\\bfN[ocƪ85A0N9affd6?aOm4Xxjpr4OIpb68DsK\$R;1z[/~&0wѦoVhvL1;S5t!XH{w?h&tMh-DjvF7@3ml䂼>oEF*e9W;er3B%\$8'6R\"V7L&Vl/oæ{:.|o!Krw1Yj~o&w,B)E\rj=<N wi\rP`@ҧ6.1r,b>l8yN\"hԮLH";break;case"ko":$e="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4)؋R;RȘVN:J\n\\ZKRSȈb2̛H:kBuY\r֯h!a/\"]dێri؆&XQ]n:[##i.-(Y\nRO)igC#cYNw	NL-\0S0&>yZP',l<VR\np7\r7IY7D!`uj*FR#D*1D#\0*Q ؔ2Bol0D	-iC[\r[dv	Zv(r# \07A\0:!2#0o2:#9\04@:́\0=c 2\0y:3:xO.B0p_CtMI|63Bl4px!%\nGQJ^ !@vdꚳ널RR\\\0Pi\".fZ'I@.EǶO!grW26VeQRb.R\\6\0PJ2<fZ7r9.Z!Q\$B*σ@:#³IL1:=%&0d;#`2V]A؏9\"kA+TT\"JeX?!+sec7J`'R.+X#df'<1#s(!TΑnjb`3PrAYND]We\r|/on0Ęv[گk\\ d!o7{}9`[fD)@6GT:P^:A_)_9z3\r#?2{1>~V\"\r#>Є7|Aw(:U3z9yW,˃؋*jTDB:&\\%5PɃftôJ#	9)U\"\"&\n\n7A\0u\rɝ7'\0A\0l\r5(!0¿P0R|A,N-FԙrUCi\ri\\1'YKaHdK<)&TSjuOuB\"JTU@Gv}lBZX^@	xUA*<HxZ'ߣU90JG)\$SJqO*Eh.TʡU?'\nVA\$6UHt{h(%WA[&V,d\rEHbTaðA FHJKԶXJ hO@CcbIo٠f):[2-?'>0a\01)YK!ej\$)A@\$5Ih('҈AH;ȘrPba\n*gս`>N\0Oeᕀ&bLҀD:BR4JH>T虔:o-@`\"Q\n*VCh!K\nEhx!V*\$C\naH#	N{ɺn\\QuC-	:ȠC]t&DЛ`F:XAy!{ࠇnu:QZyJI*\r/F*|\rb%\$Y[uAa'/[=S%a@'0y;BP+\rpjM#*I v\nBkGPB;MN#esmM[ɰF\nCh[0\"\$Lq8ľ2萿tVâlLc>AL-9M4n)<T& ˍ̂8:Yu2cj\riS{T_\$Aa8fc3\\pՖe7xa--&tGi饔%ZnOQ9t7\$\0H^`(D+7a Vaw` Om,ö)zJ	HI>C\r薒l F_Te6݁2D#_;;N.i(&EU3*a6u\$TtRT\0C\0>A;\\Nf{|D}R3pCByl򋅷cgЇ>[A\rI'{Y7p0<D\$vJk`-9v(@mo3\"o5bޓ\"`PA\nP 0/\r\r)'ڶJk_,:֝Aa-Lvx^	-OOR]kGDNZ (ۛ(\"A<͖K=?4e%݉fEc4JtK{DE>;^\$G11CY~)|D0.T҅ K\rim^&#f`^aӌnO]p\"YpVw!#h >4/~Cf6iB5n22\$G#cdE^LoGdEL4&,B=\$w/bCr		Жp 0I<fx`e@څlΐx'*fL;L\r\"\n\"b=a|3o6-Ԑn\r\\ԫeF6j!ipz`Cp̠#GC1(._űNfX1qkqc1Ap&\"\"jlf6%ÆѬ@CC*I*D Hё\")BiV\\ZtXfχ\$1N/%QSQNgQA ŐmpBAn\\Q\rqB5qsr2!N \"\"<3B&RJod /\"4cjn.i,%#5'M 2'9b6fL'8EfL;O*r:b\r\$DvOkRKЎbg,2LJ-fR/\rr-2֣&LK/n˖1`\r pTsR!3\$.nj=3.*4\$NaB`N@DU1e2\\c3+29)؝S6ˑ\"\" 	@'6sÄ#c9QnfNJ#H*Jl.3q YC X3)09BAf ;o\"t3S%m:6E0;p+`\0kذeTOw\r ̅\0%`xİ\nZ֌NOjo dF 22sn5TL,>he:\0TtrBh\n#]H!XSh-RȮBo^p!KJ2\\ G)\"\$g\0h&KayEX6oKȴd6.[\\.BPaEE=)O0v\nLH.\r\$2q^p6Q\"uRvG[Nfv/]O(5r5ؿB\"@8_d>cVkVFm&w=eW-OO_\"RK-6&65!\\RBa\\k+A00fO4.3R/l";break;case"lt":$e="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 rT&*4AFi7IgPf\"^ 6MHC	1Պ\0NE\r:Y7DQ@n,h(:C@t4L4:I'S9P춛hb&NqQ}H؈PVuof,k49`\$gYnfQ.JbfM(n5rGJt,ϲ`\nд**\n):&)|7(=\n*D5\0('M쓄`4ĎF# ڴ>`ϲю #ϤN09û422C`@JC3:x7mAr3^rԸI|63,\"*7^0:<C[2C)B	JUN/@;##S8Kh6pS-b7-:\n3`Mc,͕b(C`ຠ-p,(*ЄH1*0:ZJ:U'J4J5qނ#;3ȱ\$39B4\"I	-RF`5BbFbʐ݈΂*9.6\r[Zc7;4.f<:\rõ8h4?اP&ϴ\rv4<K{,ⳍX;60:\"<-m:-Z.en\"@T<@6A8hr#04u |!у2͋P|GpX9C(\r9Y@ү/ &e{n]y@#P-2t\" @̰3dqIJ\0T\r8huH 3/;KRtZ7\rˬ2\nHJTd&[M4!ĈGB>DNA5G/7`2i2tҚjo9n簴Ti}>CEi\"BciW\$p\"rrX(8b^4&؛rq<9'cΊ\$B⼝C&\nxH2CZ !/l5riعJc\0	0m	1`@2ҎC1t7ZHL˳dA/rǠ[rWHKPo'X\"eY!\r\0l\"\ri\0S\r^Å؋X)ܓ|IHwEEt&,8\r7PАѨP8.Rz16Y<YpGH9tE|\0FH\0@-\06EKx5@9#XU\"\$n\r|-w/&^|ɖ&\"K=Hi@7,SPj0q_bj9G15MQ	#m#`O\naRH-Nֵ^CYtǡ,Wg`j,ʌ0WNM-݀6])#i%\"F\"uU@4\$*P5 \0YI8\0V`e_дVDZK+\0/0kK\nߤPV\$i!W@YU|:dDFp9է98H\n%-6m[\0andJIicetoȭհiS{#+tB8sCa!BZ^;(2 r,Ni\0\$FAq{ϘPZ-4[PyJN\0/-a2S+fwHz_A\\e{0zr/s\nN1riQy7tΫ*At6ƽ<֕ؤ(	,@eT'F+tVm1qm<܁d\"ϺѪQ_o3\\\nlD8d(-ƜFL\n!!P*@Hؤ~U	ol4D_,b1:Yw1p=ܼٛ#Éj^nu9!W4ގC:IF2UCnM&k:RH[mLp\nY}׻n;7`}wa;\rnXeivtJq\"]abpFi-vYn/pa:p)C )#i\\Hhi\rN!\ruK)E\n65=0J3	)cbaMKjXԙ-'JVr#O윌!L(X,d¬Mf+ڍ\$MÉdPn#p+@;ÃBJ;<e:7LB%b؀0*5#N\r%vL\rj0@dQ-n\"n,O^	.E\0	km\nm\nLʌ	qpnx0P0EI\r^쮕ھB\r\r̕P+XP\n!/[7許)r316o.+'ҝ~@ԣT[	`,83&G\r&f\\f&'ie(^-j\$/J7C@#'c<Q4R[\n ̝M>l\n-~U8-Jɾmo|;n!C\\? cﮖ! .D\$E,C KdE9L%#dJp:lbF÷'R0?{/'a)223L\reH;`T\nd|-m2jBz>%;+2,d\"E-\nr--.27k+\n޲0MDQa0d\"'os0qO2.	-r@etj	\r4Bbs-z\\dr\r\r+/&RlrT#\0Yr*e(6qS(τ\"ӌ+nw8c>Cs9e%&*\0]s7QPp\"<Π2Rk:\r2Q6Bl&s),JP>\npx|#ڨ4B=æsC4A\"\n[rq`@@&2\"z8P ,/n8bk!C3#ضt98TRX8ĘB\0\nNA \rf} EB\0000 @f)4/E\nb\"MbH\\P!^l\n~G(@).AVR\nr?\0w#~U bEU5Pp_\$D6fD]џ`2t%	O|mz`@RoMRVie-'YN{`j`N<aDTā\nC̭[,d<R`->,R 2IX2pz";break;case"lv":$e="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(#Y9\"F3It9GCF\"67C8'ab:ǥ%#)DdHobٸuN21	i@ S0Mө_ni2|9q#{o5Mat5_6̆Q32b)V\"\rH/h+2y5 9\r`0c\n@P8B1\$&pjڒ1#+1#cܗ5[TO+ Xp90z\r8a^\\01/C8^2xَc2\rh3/I6H^0H=!(EaB*bh9.L3c`Ҩ#ºBj8T,s BP'):dBmTd\$.\0M{_#aWŋzd\nL	cx2BIģ?;\rre7Vp5Û2H䧕q;Dv2ȕ9C\\ģ<3JQo;5 ZC?>u6bib<.հ0z:7u[f=)∘\"Cҕ\nL;EKS҈0}Om_z'L# hp#hV*e{eT޽BU\$3|N[њYAPL7c|4hriH1D/AԌ_[2&|6,9C&x4CZgO\rkBd\rVHȌ#֏B\0V]!B!b.-Z>9!2@&p[Lf\"ጡ+dw`%p%ܿtL\03Q 4B(IŇP?`ؓy*%	8Yg4bHJ|+2j*9L	nA̔`e1%A\0AK(9\$t\$\\@jOJ)M*ts\$9&\$ɊXi6`@4׈G		4G:=hF@lQ.%=Rq\$\"FBջ&@\$䠔VK	i.@Sev7;ʛ>m\r.yiЃ%@GɺC>sDI9#\\ϙi6L7G(6j,3Sj%PyIAQQȦ,34{\"Kbk%Ħ \n (u>M3~zEI!20S/b=6'ݾ`l1{;*j1F0^cId!D\$\"Iq\r!2,eHh\\q\r)e\$F\0T0Փ+E9aL)cp/\$Ո9m#x Ga	\r(Ċ\n	3OD,@#Y\$\rbТ\$fPVljh'fw#|\\EGSvwzdd0؀\rv2'ljZ@(N#\$ÈxV<gu Oq':_gf)21 \nl>HI%\$+h%3bp-R)/*Dqg˫(}\\=l5(#|Âu2uCB\$*]P'*<CbWPL(ɔrC膄6\$@%1GuC3SQ^۴֋EfAU2l) AB\$Wi]-Ķ-zPvF}-6,4Q[\r-nm(wΤ]|#{q\rpʖb=(si1ViG\$\$ѵF6fFl26b-,8dJ\"[:mFɑ|/x~#d!xCI\r؆={@,޸Wq@*A\"D2yGKzFUM3FJ Ƃ`{o\$f&BT\n!w|Nbl@([wX`,3J|AfϬ|:¡\"Ϥxب\"O8A7𤋮Ht<vm'6VGN}.rnsŭ\"gk+2k9WrRAxQE{`1*{FQRlT9\"T-GR2V:qBQ'!k|\n HY0TUՄPa(\0:̌;8\"2 ɽQ>I.X?\"{9863FPT;mL|l\0oT.\r\0`p,R\nb%=C\"%p,fHC@%8J\\,u0:\" ]]htB8\"B@eRTBІl+L`emm܂`ۢde 2#ښd0k	fRB1ޥ2Glj\rzY6x,v0#l\rL}FJL1 Pm\rQVgmX!!1/\rnì>\"ࠐ07cjM@EJ%%0G#*P\"HC\".%^\\D\nP0\nvÌ=}HTnp.inJP6a~J\n\nq\rpE.fΆE,Tl匄\"xQri r}p>\$L 04\nd@J0e9\$g8:>3Q#e6#^*#Rio ƪ\0_:k-(&}RlSr(U#nf28D\"@PM\rfH\$Q0\02S+\0)g{I-R-dlv% .H\0'8J\n\"Aj1bq'jq61!*N!0ƏZr2AŸBs\0щ4\$)1!4BSNp*gE*JDD\\1%})-|O8I9bf% >\"#\rXn7('2RjNG'\"^0m@E7@{\0V,&l؂ݢ%ğ`@\nZ\"&WCPn2҅|P)B0.sBpCCLN\\>#(TI3ECh('OG\0C3=% /CeLT'!14R'2REYc10.)%\rL+M,bNXd=7>Ö`I&?SB9=`\n lRĲ >mD &,tړJG\0J1BO6uK*5H\$=UgL\rt:-~e]D|bldjH";break;case"ms":$e="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7ADt@p0Qs7VaT4\"TLS5ki9k-@e6Q@k2()6ɝ/fBk4S%A4Jr[gNMC	œofs6!e9NyCdy`#h(<H>Tk7rf\0w*33Pi؄;IXΚmr::`ޖ+	BA6.\\77NP8=P1q*H&tc(@;#7rc2\0x3:x-@7:s3^r,I|6R3=\nx#\"Ҷ{	l:#[D9/.Btjx.\$C:B95Ib\n\0<MISU,7蔙1{8VmTL&Hk #x'OhA!43>-'\"!r^%cZ⛤ɁUBBq`6X9K|uꞵ9<\rئ(S~I#p/TkN<!I'0DSA!f,lĒ}EcMJ {%uݦ<33aL'j!}5:2\"16GZ#X;>mz <9rH68=}5.C:)8\"ݜkp2ns\r*qt0̶0˾E*:0S%iRCYp!ZJHe̲rJUE3=?S:T:Bˬ6I!#XpB9I=6\0!XA&*̶;˿4|e\r2KJlM2BM%2<dY.Hi@hA=#vO N\\bNJ	I*%d^|9&D۫wi2`ZS-F8eA YG\$VKEtӹGr30c uF3R&aGFcxg\nN\\7d&EMP	@@\n	)%\"+ZcI;)E1>y,p	+NC4*(Ҥg[F89t&s%vn	\r4`Ch\r!\0ΔޤGA0 \"2) 0L\rټ\0JЄxGO#eg6'ydœnQRfq%ewR_)'s(:~FBQ.dK'zn/ll\"'Fu͊I@\"@'0BCzRPD:6(9ڶ'.aUex\"<ꌰF\nrIiC	u2Dd7Fa5`NH\n	8PT*@-X+6|mٜFRPROHI,9H\0gBʙd^H\"ڃQ\$>y'ɐuBj4SD&{N\\bEfkVV+JIAXE~o&Zba&d_B\n^ȨiR+{-)Z@PJRJK-A3|N\"'R@\ri84~\$K7tM[,f.A*,JR D1:V)ߗ=\rv\0=0c^\r'ǘCX\nd\"k]\rٶPn>>\0	AI aYUQ@<CU˔e,r2\n,x80@RTStXvH	I*Wh)uJR\"qĊbzAD9kIGi\"3f.r RY!D3sK\r-n`hيgH4n8fґ	b\\5pAuz0sI1SBYGd6@ƍm00F\"|q*%txoI?OmaeOɠTaGd;lwrA=r:J_\$>u:&V\$dI>13Jvn#q?owYݛr*<~L/%WSO<Ercl:5#`l*D]52=FB%`IR\"bUy2fTw;Z8aI9;%rxs9Am~/:%,J^~\\\n:Β~\"RFΆ8k\0f箮r|2\0\rrj#%\0O}\0&06B`>v4@ :ܡ\nqy\nDO2DR-p&PTBɂLX]pP.p5W#\09[lЧL&)ElX#,\rBtΞ`'*DILl{ܕ:͑%I\nEyf:ܱ7B>(m!+!z<0-,(Bn8rcB8Uk,K\0(	i\0000EVG)`HG\$:*Rd(GH~\"\n\rVbo5Bv2͒,\"#8edmx\"̡\0\np#-xPd@v!օs\r8KKވQ3+YNbbpYl{#^-Ey\"\$IQN-K\"u\0b4dozh'0ȣ\\牊tPpz\r3bND4ҁ&j66R%JxzRtf^BZх%rM脀ƃKE?ҙ)ú>/R\"t1j;-&j 'Koq;Q86t\0\r:\00*l8;byJG#~fpt";break;case"nl":$e="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7AEs->8 4YFSY?,pQi3MS`(ebF˔I;ۍ`0߰\n*͍\nmm0K`-Z&.O8Qh6w5m9[Mֿ5!uYqoEkqȕ5u4.T@f7NR\$YbSh(8c\$=h9{+-C O j9b5 ns?\r ڽ-c6c^3:\\(cWh X\n90z4crx+NAr3^ٶ|\"J(}\rE+94\r |FːƍI[ ?+)û\\L!xH\"r:J5;EN/NJC4TBXޏ8PLCJܝ̽\r&V#coX/\rd4ˠG## b 4]?܌b|0PKv?˵\0Ȉ#2?\\\"8\\9,b؊(΍BEas0XĹ x)\"dT8ߌ9МtRÖ)C+@;P29Bӕ(؎f0B&P6ȈƊ9^Zf!C]Ң	^	\$R`E&3냘}]8ENs|(kC\n6n=8ÛER(w&7z<)e\n%\rPP?p02da=\r*өr6P4qP0`N*>JsKwC&)8'S\"/i[-/9xz7ԾPA\rsStp8>21h4F(T\rX54GJ\"Tq'\$\$ГrP'M*p`j\\K0& U	i*BtifNaGcjS	C@+CN}bPٗ\$\$-ATRzQY,%(nL.=¨Ě[SC#̨kh:{9h,\0=RP?܉^M4(a e5R*߃R%E3!ũ0s~7It2HcB\"@-7 p\\3)H\0P	AFGR∓\r@\n\n()\$p9>.I	-Ky,D!	PN̥bJA,IjIB+\"lӑA&D3,ښ\"Mcv aL)b\\rp QDj{˱+8=>IA*r8Æ	I\"SwBᰡYW\$T,}%@ĶKHb*-nL^5&0L	7GPTØN=7c	-!VĔ\"r98\"K!lp'[2V#ĂOT@844pM_H\0P])x&\0\"a!IT 8PT@-V*ͣa9FɸND++3{֝,'Ai.QE,K!P\r8\nk\"m8C	CPR`ىk A}S\nLl.5TL2QN}E]ۄc2!RRb/?4%{G9a2,W 	&'I:\$4CQ\"I2cOXD%)shUaنP02-!L)φ0r!xxci!ŅU<cr4`C#p ᙲ\nE8xBH:'N	vU\\-q*\rZh/ UYHq\n:9gz&\"GUUKMhƓae\"L^V>RLu[vdMm{~~ڇ}?)cKɳ\"5\"Lx(R\$&G-f5e8HIHPʐ	6_q1Y7'FA~=0J\nQ'.U1\"PAETHDUW}^Y5 ̸Qa\"\r6gj!V뢃	\\2J)p\r1OFl4ouPb9nrWJ̖:u@NAX	s7Gl䴇 KoL}q0:s;V+p{rMΌz{Z{P|&N?@w+c8esv!fZ娆k\rw06)`\r\\C#%	,8,&/BDdm	VF-kf !\0Y歫09ϾBl0B&4׃\"VEh:2%lƿpQziQi\rJNmHY	E#I	J\nX/\$>hNIH%Vdd\rTtІϩ,OBtк\\̰pj2%\rʓ	cgƾ@b n2f2cpqBgF6l̇`hUBǜ&4nP\0@C\n\np1qQy/|18%141TW0sʞS \$\rULE%B@N1\$g-UД`\">{Qv:!-͘Dn<p\"U<n\"`(r*݀Pj=&.jh5	X1C.	ni\"@\np\"8K\"9\$Fh(iz)f,!*!RǌͬgdV`1\$Cb \r`NERP5RLY6e_(bLpRIB&Gxͨ*2+5?cVb#(\"`ve\$&b.n#\n\"=122|8c4Ҡ:\n.0s;aT]*e#A2;\0% nDEn`PW,[&92z,e?7\"6mViB\r<\\װf	 4\"f(iPm/ofW)>`)^E4C*Գ{\"04'P##B\$`";break;case"no":$e="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8!	\r࣡\n7&sIlMzb'ґkfY\\2qNF%DL7;g+0Y'qH16:]40gۈHr:Mqt醡B傽JG\n!n7S:S<3-cp(3Ðǌ-ĉӘ-蠜2HP獎b# ڶ# 2oC9#\$K@0*:\rx\0;# XЙD4%cx)d6Ar3_cv\rJK\$\rpx!:+&B:526Cb'.+\n7-:\n\0<MAQT7­x*#%jغ cz5u&ǌ0:x췎L6P\$#TccYC8I4K<6IDPHb2h}^\"kƁBC&2\rf\rIɰBu7M8HyG5h\\AX9cPBz.yNV0\"meY`QK#hxe{!O0	\"'\"3;/BL^#:,!(B|4kn2nJ^(\r9rK[:\$\n7MQt\n7J2(KiS7\"8ʳ0PpZ\rhИ-ȳk3`Sk^7*DTX3Y*pJTv2R7ϵ\$<c:*\rG6#ZC2q!|8Ƨ2(A#2TrPJIQ+!Ĳnx'@uц&{8Z@n`y\n;N nT'6ST%%8I&úUCP-\$p=3^3mƥ@cMy}pL\ra99!otaИN vsbPȨC|i8IJ!q+eBC3 &^[rF淈Xc84bBGj(ƓT\\\n/ƴqP	@7M	\n\0N]d^rk\$@zKxDPI~{<kSB%H!4|4Ma8#z\n5\r1fNyx@ܛ(!0Xo^3Tt#22FL)J)\$\$Lة\"2Ma?&Q& (0f\\HyvP\"PU\n8O8i&~0y ƅIOJD+#5іrL .b0g5ٓlKɉ3\n<vIkP×fua1x5\"Q`6\$H	QH#@HcBhԉN)iZCe@Rsl'@BD!P\"\\(LU%JrlИ\0V-Vw\$F\"X6B.!H#27B(QF,ڃ.I9L3E!bOHfw]Fwٝo{SRvbsdRvuapʏAEpZ#\nF0KhhO]>ܵiAF0#^aa̠4r-r~+aeB`T;!0Zb6i.djC+\0f!AY31)j9{K[AɫwPW}D5dݣB;i9j\rڢWg^م@@ EYO\"&8ik[M \$ěNr1aS*v`BYoa(3FZCF2\nU{;lM6F]H.Uorq61PI	`^\r۰~t%bP=܂*E9(\\D\\JI`6b0!\\2*Kl0xm2T!Wh9mҢy0\$ᙀ`	A!Ks{]膺_vFp=ϋIe#gэK!cpa`򒸠)4`SAp,giRO-i(W\0HUjV;rHN^[Ҩb#\n_Lɧ0}Gei]s&f.Gu۾wR~\"|~hiiK_7}i>l&[G'_t,9W1W|)(5 V HhPG@&-ٰu*HoO\$]cY\"&cFu(b(fL#i\$dXN&8O@kQp9x:|(V*|\nOt̂nҫfG*SE\nl~;@ǩ\rJ/:BOPE#%z=lbA&]ÞyPƿ#.|0\"I.VX1J\0.sqW@#YZ-)\nCUΛ	OCApU`*? WC'0#	/wfA 	~:ਯ@T6Tv dX)*U Ж	eZjjfC\0!oϴ\rXe\rV\rf\n!(.8|>\0(@j\npui<ȮS;#N\$fsm#Pz'2hk\$ER(0e8΁+B%Q&#\\5dD6Ʈq:P0In,E%!oNdnE\0bVra0C\nwV00l1&ί134\"P2F\nX^U'/\\¿BaJ#ɬ[,f\0C7D..a\"i3Fl\nfT!0-˪ˢGr3\nD0H2pOK;%V,0 ޥ-K\n\"AÈ-";break;case"pl":$e="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AD35/8Nxp:L =M0Q\nkm!y:M@!aݤhr20gy&*u8Blp*@do3Qxe5^of!hp[73qiy7pB\rHL>\ry\r+ry;¡\\b@t0.\"D)HR#\rt)D9;\03o(0h޺{ڌcC6\r;9.C0N@c(5Cȹ\r\nAҘ:D\"	B(D!`@%C3:x-V4ţ\\7C8^`;̃ ^'bmB7\"V\r!^05(>-b9[C* ۮC+:@#G;J	x1x	KK*0A(C[W\rw[\$;BX6j\\\nbmeVe;S!t  Vߌoz̫ޤ䞘p\r6փBP:[H(@38=Q@3\r̌C1`ҹ\"/N0*ں7,n%xE0ţ:3tD\"t&0)\"`7%jMO=9<)j<9¨ÒnFŒ{\rԂ3#7Y.am6\$B*QcNYZ<!=^3\0ڴd=\$1éDnD@\$\nm4T`Շ2;CH+>6@Ę>d-\ru\0[_⎾:~	L=X5YrS-ySB8hZ\r[6xfAC\$FHuHT:!fB;I\$\$gl=5n	&H\nH0V2JSPZD\n1wP0.\nl/0M!A/\rVp'CAj\"H\r\rS;Z+ؖH\"E1zV\rEH\0KI=(4[2z:&\$șA%4ń#8eD\0za\\W%4+b*GD3uH̚AGTJa-%\ncL6nC98:\\yZf	<VqsO5~)-҂nK\"#\":\naIɓdJ3\n (Bp%;*KENoHQ`KxU	c\"kl gHD\"BhȠΡĴ.<碫՘\n/\"I^zR(7:G	sE*[\rCdyGA?(s?pBxzŎtE,xSOhen2 Dֈm.nTHRtC0u8y/ĊUE)>`V[H§'\rY\0FN*5O'RyNl6.۹BUu.XFIY(m:p2E&ICw쏩#MAsxsR^-`~hk!fѓZOu<@^<bqIpRm;'hHHc!lWz]!<fV7;ʧB%@H}35gM3`m\$-dT	K:da\\Wt8%vlk;#2 [V8@Iʑ.@Tc&FuXQrF#yR3=/Q3ȋ2.w3=1%mۂ?HTʣ(\"(\")zpk114QOhY\"8*Өsou(F`H(WS6ރ{u88x\n&^&رAC3kq'oP)\"~2B	mDZk\r )dCLR\02!@`S*lߝvVP@#6uKnPa5\$95RތpR7˩ϕXyG[P8kT(+\"_c_g\rPhA^40\"y=(~}fâ[ѢPVBT!\$IFú=* ʼnEJ[JmW0&ɐfjDW܍#ogxB\$xN]2xC^J#-|9qf=9h0Ə=LP^.24Og#pf{ˡ%Z\0|7G! 50lwUp\$HyY\$:kH\"@jСo-aUF!UQb%cRw(Ƞ'`>a2͖_e7f#0xP6)zGx\"̧\n/4&t\"MlXroC!dDT.\\\"JQ%d>Xs-\"A9Ā\$RB_r%KPpIV`%Дڰ	ĐoFLʢ^TK݀I@%]jt#eB~,]ȫ~h͗Ì̊]\niKJnS\nOPXŐYClQQVB-HP0dF{1SOCNJ=pc\rMGnO\rRxoO\" M]sZ/ .2J0q%ѯqen<0`ҫiN>L! QM~6H\$2N(L4CBk\"Tt %#~-_Bb#`(#fT+#ㅎ\"LsRFP9&\$@%dL)yrYBN#θT\r}9 8ѣ!QSNǒ\ncE,2ߒ%\"Pq.rX.z(Ib3,\r 00}0K\\.L2#م><#`<z8f@bP\04Jg@\$X--,y823\0@n0kOC:;:t&BxYDP\nS47Ѝ	ΤS+NPnV9.Z;.^6Q1hyqW8(<@!?r't:q0%4+x@d(/A~\$D,ED!#HB9,Vrd~R03T^04T#XԛJJ2h3tpxwRJ6CzՑ/fX1Q`n:\"+&e!*ɴ8z;\"nc'LrCeBDbbt\nZHdGZp,^WT!,]F\$o1Nq\nѓ\\oCA\$b!&Ufs1aUphhlLv8Q-Nk#w:NRӀܴYp\\)Q<-+R;p!V+މ?^]66j_ h6}^ғ_a79?U4-R6ǀ7F\0悐,v0RPjy]Sf-g%*\rF} \\Ol{f`bw4t[iʊ-_tM*@NZ5&Fk6^%6%j@AkV=n@C9Z";break;case"pt":$e="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTe6\"P=Gࣱi7#In0 Ը:a:LQc	RM7\r2tI7k&i#-ڟMQHٳ:e9al])#cs+Î,qX̸q9W|=:IE==\n\"&|q'o<qTk7N90{f(@!04\n6\n)rτsԴo2PC%AC9&Ҵ(\$>0B647\rH6zαk*\",PcpA!\043\$(;c XD49Ax^;́tM\r0\\z2ʨ9xDɻ8.2方`x!S5@2 1\n|T62:TŤNJ6ƌC94O0\nL0فB:7<(J25a\0P7\r(}9踊!\$5\"ͤ5+ 1j2ل2&npƸ(0d~٣,=Hlpg:kdNN1p\rt6\rj'ψ\rc֨%Ib\\Gm\\8*`cb.Mrƍ֚Z7'!\0(SC;ub=BTOUTm89ψUF.D<4bK#l(8g \"@S86ub6|0P?r#F2erخR\"3\rmѯ#Iuu\$(%IB!,iU(˃2\n8_N+D#03T┊4H*\r\\<p:ȭ3_!022#8]*Nd2\nT{/@9>3nrH̔L}͊#%\$#dYv%JdLɡ5&9@	;^NKCpy	|XL\n[H@{7\\xZVf	״)L4ڛsI;2Ԛ~P\r8s]]IDě'2P\\4.RM\"L1R§NL?-*DpifR!+A(&t=(}Qd3H9\ru%(\"P	A 7nlAAA\$`z\"pn4kst]1*dBv&g۾HcCdn	M<t#3I9+\"2O7R}\nJ\0E#MHp5%;RNABlXYnKnO@ԠVM,)Ek_ؒ@ɣA!#&nb(3r?\"4og* ((QD8)`@S@* Z@Ziig청U5ց\\9ŵ'<gO^j2IEա4H9,a*L\\	sPd\0YFU4KG ͛CxNT(@-ȹA\"t2IG-f+,PXP#QGJYq	a5cYRnWEE߄tobหRonQgD~|ϺIKP6-KLS,	`ŧতj\rW^Yc/KjbLȩ=\nY( U>N:Ac2aAL4MJ.<C`anPYtV\r &:Vk ͐`2yT=;RC(wael߆hdFBnH W w.:9RV| v*QѦ˞!\$aiZ.`-[j)~ZB&m٢7ŇbMTE\"5KO`C@BHX#׳W_xpns\"^Y_&,`^T3Vb\rgi}!d3V|``I..sעI(^)aA^jb\rДhEhq\"_ăT\\o3\nA9} د>qby)ndp8w йKNH9qꅟ-c,a<wY8QB[pz{UHvs1:3:gW[3c`e,ǉLȵ\rσR![B]1NmxL糈LZjϺød+˧K͗&7	,篻M6/%ڤ8:2x9\"d;n}{H/Yu㋘ 'I#nZ=?ʴhm2 *2J#'j,J3b2Bo[e, H¯dimFeLNj6> %',2Nbn@v4J0_cPbj^rpE?.)44;Z]@&d[D@n/L}ԤRYp\"],2RJMKuɩT/l&#TP 1tÐYVxUf=o]qP#Nލ]o5E,M]U;CPx#PW\r1FBflYHB)\"!L@8bm\"+S%1*ӆ)OQ(`1[/AevdpoĂvcJ#\$<@c'\"_Prd,!\0 <\rf֢Gע=h#T92C\"}C\$⾨ccE#/\\&'qM'tvq% 0\$=\rʖX\"\"iaX62Grf0RX/O1ŌJ5P?*f<%< j\r&, ϩ\rPb<0(Pq0j`Z1)EFN[P\"߰8ԗ\"|!HFL6\"Ri~cGc':B/(#RͫBPDJޓ1IĮfhat_Bl`̜>Wa+E_)N\0PS*Fc;\\EBT6-I!\r茞Po=bY&Έ|Q >G!k\$i=D\rc\nu%*[=#0\n1OC^'\r\rd:d3<b\n K@ij/61k0\$%j;2pe.1Y`6l,.P0J.j\nf";break;case"pt-br":$e="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rQXcach>#Qz4Fi7MjblLQc	NE2PcI>41e!',΢A+O_cfkNC\rZhbL[I9OvqŸnD,\\(ǵGM7k]3c/_4Iț`&U7094Ó-#i4\nhZLk2B\nnɉz'XP2(r|&`: 9FƷ/@@0\rƎc2\0y \r\rC@:tCQj|/8^ㄙ'C ^(j;p̾%j|⽃6	6\$:PثC6!41H4*'\rp(B\n\0<MaYV!`J]QD({o!ȳr9\rD6P\$I1OX0@W,P{&#WNaV4t(4(ɤLE;	2lp(7rR ߴ6\"cYbc (SOɈ4|Bay>6;!/\"\0V\0\r#b\"HP<l#SYCj8@60έJ?d\0#A\$^OK(2A03Si#C8̵ˠո \$ԨUV.cB8b5.5-Z:060\n̥z^!jGm3]!r#8[\$@\n&VMj-N*5nyGȭ3\$2#L%d^L	;DXPiMas\"xޞ\"*a̡Q \\䔏=AkB?en1RNLjIdE8+VfC(dTR]K1X0jM5ӫbG\"t%ő7pAZ(nH^Mz:15\$Mh;\$VE\\sqX<{ouT,%Gu!Gc0gKyBAԕo6@\$jM+Ls!@bNpc:!dMlrI\$˙)\n0ؘJ\$Rx817(SpI1\r&phn-?Y˛\n8FO3PL:*Ixl!(yDuwI2&T@(Hl?c\0PtP.wJ< a#!\0ۚ&ރ1-JKBG7wxS\n2W\n|7! u.D|ı\\G4H7IK%!YΗ,j*+.?鄡!f3	l.80T`68wQ>U\$9Ti攖UZAW#('@BD!P\"l(L,TsTq:0i<l~EFEx0ř3&1RuJ%GɭB:iC%)FxiGv(EVj؂\nvV#PS<ٝ\nNCT.1-9Y\"*s((詿 \\Ҽ\r{Rb\nxw+xeQ%`C4PI!3%IptQcePbx4<Ιن@zdlLݼ\0C'ukA,[Pc\rdz*Qi|։Exi0FOB):\re(GcEAP*/ԅ\$l\0eIJnh!\rXR\\bR<e\$UcZAp	;gvno7{m8Ner3xGw=ĝ[YZ*{?xPۮN>uf[+hiQ^8Ȇwϴy0!GTS	RTpgxJָH5ʣmak%/Dfr0F'OM42-oL<7)Ӧso(OϿxEzL;\$>hd6jȌa&ۦ4K5F]u?(S\"yY@UTY==]̚e\\ꗯwӰU8OVJhD?eoX+q\0j\"Z>0O%C&\nMl0\"\0rn\rL04>PD..5 /dj0Z(gmonZ:jF\"<[&X@J\$0#)h!aZ0C	#9'2Po*d3)jRjp/E2)gbWͣ9od20'k\nƚSQ4/O\n%ZHJ18pQ:\\ew1r[\"e@&vT!NmOAx6B|9;L0xB<{ȭh,&d^*l\njtJZo?kPcX#\$`bzRR6p-M%\"[\"!\$̒\$h^-&\0ӭ?O%\"%qmq&\rMqy	\$2TDlP4fD\rZ%%nZ?&d?*A/	\r\0qc4V-B#lSZ\r0>-fQ\rV0dC0onbc\"p_.nc#,RG/#\rV\0`\rO o2@Za\"O6o'*\nZ\\\")-.0rO 8!\"\$.2^B<Hj 21 l(O0y\rX?3B=ΞHki>]oV\$C-=kBbDdatRhl߂odcn\$[.X)T7ھ+r6o.9X@Al-Q-g4FT-#\r(B\$j&:AFebHOjΥj\$^b4S`IhaX&b#4#y3EN'%%GKE̯t4U:@/R*.5D|";break;case"ro":$e="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9Φ㡕4\r&sQFsyo9Z&\rن7Fh&2lAH:LFSaVE2lH(n9Lf;̄+,o^NƜ :nN,h2YYYN)Xy3XAK׬eNZ>A#\ry۳qLYN[Q2lBz2B5x#k(ڰ	L6	2\r,+9B\r!03@93`3i0cpʲ3\nr!\07J#9k΄LS\$0!\0\r\rK`@#CC3:x;uAr3^8L32\rLf:\r.x!6@#(<ḥO%UV\r5sɍ\rbA.J+ct @7(ٶ} PΊHm\r#p̅\rRd:/ȆF-F҈(0j@쾎 NZ.vŲ hHì2^8õoVCl?Λ_k(׸\",p&6\$ʠܰ\"`@8#dn[5k|Zc@ʙOg;Ίzvƍk*p 7._l#l9<o:(вm@&C34[ƇL\rUK)\\Ecr8<} |`ۖrArRVh+=KM)Wґ]ۢ3QZ8c`P2ܶZ\rxء3הt+2?\n{q!cqFaf{2/;'dS9 ; 1xXT6)咐 G쐦c9LM\050\$ڛӊsN;~P!2ډ%']I\r\$(0ZHPL&dÙZ#ɁX&Yi\0\\!k9'D@O!fҌIQA7eW0tuuVpa\rj<#pU)\"  X#b,!lD%O<To	!\$!C4o	>X`R8ͨ@k\r%gv܇xsmfb7Ye2nI!8\n\n\\KS&\ri7h\rg8WbO1	g*;!u8֐C騐\"b5؏'h9BL	QḆ\niȵI`04f(8dw\nOz^8uy\$2jBۡX&ꓴ&#JE׌#hj/@ɲHAgPBq9'bqr\ner'FCQ1\n<)I<q*tY`3-\$5l#A!2\"P/ujl7*x)-5֦zݗ})6RZ#A*\\ ~IpfגNJ}[MΗ:%[m`Fjzo)ݕȠJRO0@,tbCg:IW5\\r`&+?\":,yJ->VHi@f	=-a7VTQұZAo%ZQW@N͗HP	 0^yY/*(K,(w.ZJae!4\$B]pѴM:e*ʬ>hWzڶZ:Ç.XKla47=3QGJ(ClA5\\cvqu<.\${Az_S1֓ҁ04 gJH\"QC&ym1+@y`\neI7Nl%yAa!AFn8nu&Mlx>Ax :2U8XFJca3-^+jǉ BjK-<Vʓ\$|=72M`5%kW.hbwLqtFIl(_cQA`=utG0/WR{I2R3uFĘ]XRSF?8>i+< ak?Gbp@A#%)ܐL\\!y⎽Q0C-X#ÌÆXY*3V&&l9w~`=b}\$ED+m)\nA\$<uzI>E9`tc3Ϗw:ﺔ\\yvGKA}3`\\k.EoƩO\$YEDED3:ď2%\\BbӍ,fȩLWCL\\ WNŬDrNDoljĮ/ȝW\\pNHEpM F*: ).MUJ,4P_Vp\"*``jM<R#\\_0\$F)s0R-\rIBrk\r[oGP)LB\r \rʁ#N;1p\\n5F:ðxҠ\$( [̱W8;MM\nT[:ѥdV*-\rK#f4p-j#QqCV\$dvf`j2Fi\"\r)#'4F)\"pPZOn\"!@nS89\rYFcmTQPT?	EOS	ܯ&k@U4\"['	\\\\(\$6-`/%`ֆFȦ*x2j/*S6&*\n@H ]m-r&.14q&.-CEDo @ޢ./d?I\n\"j\$q293S(\0%`Kr[\$#:\np3DZ,B袊@0?DE(A\"l|70 t:%\"5uP%o.4-7:Gq\nP5EmW2cpÏ2b\$Dr%bZh\0rGd\nZv\">YE\004T,!\" dpjlʊ<4c=\"[r욱3iP8\"f@AW,Av%lY#tJDBF\n&>\rVF\n1E|\nr:F,}e9{tTJJp%JEyJ2QA2x6m+ԧ͒mq-/%`./{PAZ%RkP,b\">,%[^C&D\n5:@	O%f:'RE`/:-Dc:TJ	g<}&'J@tȋc\rk>b!#+R-h@	\0t	@\n`";break;case"ru":$e="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4%Gf\nb֬{R\r%m5!s,kPtv_hn]#Pօ'[\$!&chK'FAIE\$e6jllѬ2\"\\횩mKV7ťs6PhNCh@zP<l:\n,c;jA0p9m#)Đ~ZĎc(1^Ӕ07Ϛ8ŪGHE y4̢L(h:𪈎=:(dzO\"\$\n\"=Pr\\1=(0oB|Gx h7f4mlq\nE~MKVPMẕoP<\r3:xg\r3Mӡp9x79c2\rTF*+~%H2~\\x-|%H&0O3T(k3:FQ\"ʡcDQ4#QðC!d)T\"9>kB~#5A(W.	0gKwJV S_ؠ3l>m:ҟd]Auy=+kD8<hѡ-8fg#7ϕ6*ݶ#8R\$Iz{{>e\r#f4zOdvXD	84\$RJ9MK̤ڷ:Xwι̗=oª?mɣ`P(k6BHBEi@9Kc{U?\\˶8v;	ChdtG\0PjB{\\|\$ٍH	1ATN)C4g\n	ϕtyYe~EzW:e&Arɒ_+윫B{u%W-\n-4*?ysϤ8\"]tDS¾]`)\09	-9\$uxViJMIҐ8\r9\$u>_JBm+9DWQ	d\nzE_\"\n|k6ދ%9iHl>Q,hI.)WFWHV×TKs._Az*LEÂ)B&\rh,D9.mMñ+ڜ%r)p'Tk`O	1Yř\r	9g30V\0`\$eeA+w!fcRn4͔juXBV+>d)L)8J\"ȠI3GN4)pI}*2Xd,ҨUk o\r:ԹWDBPHZ|U?w3f&EBz{WPc!CfCA;(=p\n1R:VX%e՞֊ӨYl-Ct[aη-A24钏/+ԑ#i҉L^}B~/Py6KEGO.2Qy&c('YG/J#di,w^w8M4Bk\02H;p\$-LԥQZ:f&ejU5.Z*kIb+ PRZ&)cF2?y,aˡOw%Є^If)2KDD6o>vY %dN)l#25E,+W--wXHFZ2t'ٴK#\\ﻲf3Q:I RS\nA<QhiPFbDdZHs\$5q^k%v@L&ixQS},JJ,29\\S-D)#dPAQVHHu=Or~PbKB&Ok+9\"H \n<)Gh@)]UaXO(P\"hG]1'\n/~G,8rY[J2NOU=TV[oB^{0T\nu\\;	YiN4J~Z%@)cb\rvdc\rC2ҋtDR(7i/˚?yDy\nx<S|ţG5Ttun|0mf-6P\\5>b>\\IYNП҇&D7Q_iD!A#~|n-)vL9\$lLrwL=IQjc*`޲	\n (iՇ;%)roQ]E4iFJ<8>C4-Gdb\0\"t\0H辿*'2O}\0#*\$Jڤǲ`XKv\r\0tND>kIʂPbnF`-&cN7y#D7B a^ǅ:fn{&6&o|'~OmFlG%o\\lΨLLjd^'b-&-.NN-̂дc^\"\"l45)4^d K,zaqHiA+mh8PH(TlҨNdN\n 	eM	>LjLp\$.h{rg`^0FF.`qqs>:-ֈBB*Bƪ椑efܦT(a>.fhspKPMƎô*h~EBϋ\"s#\0P24\0&CCڛR]\"B|=M%(.Z*W\rb)'RqDbK(Rk(S(	Gnw\$1 #\"#\$%~\"rA,(.r)\"=ң~qfmU.δL͜I+/-q/HU0ebnJK&-Fn0341NsEIa\0E,͐9a#1VR2GI69dbid7vHE8Svkp	HۉrJB\\dh9#/9M:1\"oG9~z?i=ВzoMzbDpPv9R,35bo*k O(p=nm[=	g6,pMx#1!+枌T>2ǅ	`\r\r\n5C\$4g%h7:\rGHG;&`t\nOkG.9ج0T};;u*t:R|*	K1Jb@ey'szeSMƛa#NMg'R\")#WKDduIOsM\"Oܕa#%I	Qg(\r\rNk.ȆN\"p/W\"λTCTURTu^&uJPU4\0@ּd,23~䤛RF(mfU2]ՌUH\n\"5#kYvuGWUb VDW[k/&P^}w=SQ+9n]=U}QAh\"l[J*l7-e[cZ+:RSfpVueucuChahOdnK;6iJf06VvtI@Xj.X*\rl\"f.LK(&ڍ\nD5POPsGb`GRhVoopiԟj`V!Jvqo-\rKp6s&\$-IV)TxdGHcvHpTv-rrn&ir\$WdUא+L.Wuih-~3oyBot(Y|#5i6)JͮzۗOw~qu6~Wzi~wUwV\"5a7Sz0=\"21R v h,QymjJSXNOXV{	*Msd=jVXE烔ngSi=wGNSSQ845!'NH؜s>q}i8\rVSd}]G?0˜̺֋#00RI^5g+\r!@\n8;[PnѾI	h:((M-.bؐ\nM9v@gqM!6Y7rPa\r{xd#m)5=6|8XeNlʔJ/(:I\nxb+\$o:X6\$q&ADSiVc,5t6`.:`=4Q\"+54	v\nT4FO~a# 'a7DGho.;#\0\$uiDLSi+(d9v8+>EWH^N(4¨IDDj4rKGWNC!x7Z:Tw`6w<yp;YLг&b&4uzt6txa\"<.dBjP\r@Z:sA\nsNtp5ժu9KuqTl#*";break;case"sk":$e="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8yj)AB&sLR\nbM&}a1f̄k01QZ0_bԷ  _0qN:Q\rA n4%b	a6OR5#7\n\n*8	!\"Fo;GA#v8.D8ܞ1*͗ə\n-L6la+y5O&(3:=.ϐ@1¤*T09&(\r -\nn	(B -x\rbP9p*B\rEQB9-H jȉ(\nh#\ra)#҈1@4CXXr82D49Ax^;́r\"\\x59c21C.2϶8x!B+#IB\r<!\n6)\$4&OTmNȫ0xJ2:6c6Mc7.:2q}*	c}P7D\$*l2Ӽf:Rv:A\07c<2%ɂ+cpMҔZ107\rm/oX_/5*rȵ(Ct\r7ȉj@Џ\rḬOl\r2VnVl\"(9[]K\"`2oa'DlZտXZҚ{,Z{t'ҍ'MH\"_\"(?[VXj\"@PJblꌸ0w9\rg:H2!p̹F(Ψ֥Cص:zoݎK+Bɶ/ځF!\$=q\r4:K=BʏcwKĸ-2XQZm36(B'LV96'.XXug@_7G!-tTK@\nb[\0UQFAPB 7L\n섐B1 T8mpD.	GQIH!x!a|8 W^Ʌ1TΚSZmM9'D#DaԨ}Ú7!בh0.\rE%\"RMr<0aF󽘦Й4RbIh)],C(X.r0&\$șBjM7#ÒuaBnP*\r`ʔBQـ'*Yr2J#q>H:Z׸n.RUS_,zCS'+X.+{2.!ZA%p^c-r@ԏ	y]⇧+^J:	#HQ2+\$\$ɐ@fj`LO8 NHCyI2`d,=i/e>{W:pʤRD\"R#lfIšJt\0AZsytɈ aL)i1)f%E&΍d\$!mHPbPJY9/UPAhBQ\\e!@^ɹ+c\"IrM\"LccN28hBQ-B5\0\\)&\r\0¢45yl/A{oo`eC\rh̝{*E:ހV]p6A?rjx74*0T\n\$8~O%* =\0kr\rd܄[2Bѥ,>\\Mb}RF|,E	R1W!f^<!|uO\"^!E'\$6+[0o&7@ĉI\n\"JuD(4hj#L%j	]xg.V1<=OJ@\$b[K >TZFA<1C\r6ByHē݄:1N_`O|T?#y@L\rN]&\nmؘ6I3&ŕhdBaੳU\n^lt<.r↠J35)ǎ\rq]U/s/\"3EZ|	|<633&)\n-M/Jɕ*\nPҼn!`g9@BH!9FQ=c\"KRK(efdHkYb2N	;B/%Fd3QbVLu6iGP2ϟ1/nbۨL,%|xo8<Aiop|\rBRӚ5t*E<Gk+8Ii.%su|b?NLT?}li,ds!Җ];v_*UpB |)&5`\\{/B,ڈ[\0d\$v1#S:բx\r.@]\r\$c2?KÈ:~ret!,ϲfl%5^ފ0y'h8J͘7DP\$-\nm	OE\ni0~=i@pмdd7!NIh,]5x(\nBc`Ud]ޮyR	`ebѢ^j0Rfju\rľvFЕ\np\rJ0%[&1UjK\nH;Pv(nB;B_\$цON|,TfѠ.ѧoq'giϺ,n*lz@BCn2Ix2\n!# '>\rVH!&8L|IE>BxxVV]KbVX>\\̬Z̲*,d-n)\"f/I\$)LgC!R\$2lfCc&Z[\rߥшy-\")-ѩ\"}\"G-鍤:qWca/0Κ'.cx4mc2k,7C[[ #};D(Iu-\"@~_\$OR0%6701JQs#_Cg>leU8JmpA96䳧7V:gNw&>\\S s%4QӅ=3S y3,V`.ni-T\0H-pt,m:Ne@%/34fBG{/De@SB>\\ι4DD.\"@n\r<2_PvoC\0@6+VYKԏ6RId</#4\rԐԧH\\\$ #xcE|@'\$\n4%Jpz2&=Hɼ&\$	 D\rV=@\rcPwcV+rt-H@woD2BRK':ni(j.\nZZI%/*/FRJOMUOQT5qVO&()T\"\"ܔaBCJ#eIB:1Q6Z,`Exܿ25>3>0,()6,c\\zE0f=\$ޓhv0qq-]\0^W|\nI\r\r%Na7T.6(f\r= Ò0G-1]+;%\rV)jVv'(m̟d|Ct{pW\rd\"L-c@&\"V\rjvZ&P``\0b2G\"&L2eb-EX4\nl\rE:\r|{b\ny@";break;case"sl":$e="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n)Ǆep(0#Upz7PI6AC	laCH(H;_Iуdi1ȋ&aCl2̧1p@u8FGCA9t1f\$E3A}kB|<6?&Ʒ_7K08ʱDы*PIFSԼU8Bҩi;L#/Wq+0ȥV.h6P͢@P PʥL\n	\0pԈ2L# ڷhͲI?)1l	[D#;C+q;c X[Z2D49Ax^;so\r\\x7uC ^'a926cH7x\$Nʫc{DACz#)l<#;02+L\0ٵ'\r(2C(\n\r:\n\0ĒMQUU\r]TcR/Y2#`2`P4\0P7k<Ov#`0C 	o\nLB\$0bgo\r;=k:-\0C :	B5#`+Z/	,H7ۀP4k7(\ro7x630k7&-c\"n2H1UT=%EB\n<f9yK;\r=j:hkK\\\"4h#e 3*:ZMp8i2sx̶.#j6D3XA-9qX\r\\9F)A}\r#dsj )7-gfw5ű3r	\$FV̓pQ(@-ܬ~:^X3-Tʃ<aJE̂WW \n{M\\C2|ҵA11\"tjOJ)M%ddM70}Tձ@NSAs bz?<%;^\$A5 ;GH8	 C!%\$ĜRCP5+\$ӓKnY.&@Hmad\"\r\"z3 0hLry)l:>t~IXz%h&vE\rᝆ-d]7hQ/\0*yȦ@\r44v@5B{C\rOjLc.D\\4!V%	@v\nHyB@܆DCqDh.fTyfp\"ZxwSQM\$+	&)9p9L\n;P-PgI&vJ٧.5-2@rBS\nA&(M!1r @vB[\rf62JII;p!NK<&H[Д\n U!:0c7*I5H`q]M3`l9!#)95R|00(! Zy!S.(i%_]FSA9kޒ,&~-nUQm&	+R^R,g9\"L#܇U>c<X\rI7VY<p@^KnRaϱF,BiŤñ24o+ҏ8Fey|YwY6]<\\^	26F	n3 J@ŜZaijiݛvЕg%aԭC(䢻Q-\nͫ\nǬ?Ҫ.r\nAB`0;A<9e\0bWMa50Vo1i Pf\$@95 aaP(C,SF~CiHK0!;T\$\$Slٳ-X5SXCs(f+mP>y<7(3w)Οb.y+6dzXn&nDleB.H#&6IoCǴ{<<}T\n!ARj wU\r0iHB%e\n_Ux/)vJ6i^[@m ˵6r}تqU@+2{l29~\r(%pfmSRMܛvmѸE.ܛE`KlCU;D]C~t}mߛRdn\$<#m8~;tk81%ϲ3_xPo'HA0\rŁp-T.h/[9<#\n>z׺tDIB=\0p~HMuz}aDH&pr\"s&RB-\$^-r{(|΃0;> 5D\r#r胊1%'*A\"zG\$`H}_4\"LҜgߺS'~\nc1iv簂9_}wwIݩ\\^S~2DU9s=Jk%>\"L	,k\nˬEbńXo%\r*H\$b* ,,irx+@Jb\nd[ϽOᦰTOfJ%N	b\\dTd\\#~\rnH2M\rb0	pvg	\nOy\nЎB?E&E0+;\njS	R7nPKu\r\$jJPJn\0!#?<#னnR(%B/]6@ҖBW䖣j(02h=dvH0\$\nΫLBVlԭ~X*RKq*PNIF&k\$&?OQϺ'L̏xl'1f=C >0[XX\0ic&Q%*\0fOH&0MΡб/	K\$\$O 1 fxz%Bt\$Ղ1&^Q;yZ/\\LXX18.\n^DWȘ1b*\n\"(lr)쒪l#Ҫ@\\:f>xOKce\0Ѣ_Q-.b'r;h\">cY/%<\r_/2`/d-RM\$&&x 'VXvslb7ڒ7Ι8#6h, \$PMT̀7Q\"j\$3Sod|̄/hʥČ=M<%E2\rVp\$`od`s\r\0j\nZ\r/J/&\rC1x<Kn/\rT`D\"XIA\"!zD\"@RmPo2C+T%; !	sb@:!\$L~!^à:%x6LwJTM>Tq\rtBJھT.NRHNfF`eO,]D5\0005\$@1#*	^.Cl,XiQeOi2q\r,%`lb%wTjl9\0K\"\r\nN8Q l+>/.a\n,+\n6\$͋N#%`u!OӼ *#þTcSB4'H3Z ";break;case"sr":$e="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9WhtuO`J\re;ьF\rgKB`X42]nG<^PdeCRFtɼ 4NQ 8'cIg2N9d08CAt0ոD1%Co-'3Do8eAZA)@{b0*;p&\0\r#p΃4\rY] s(>X7\rn07(9\r,\rt1\n+Nĩ(.5z'QƎ\rB/iRtڬо1D=O\"IB6±@2\r7#8F1n\n\09/97Ecj2\0yC3:xU8Ѩp^8R2\r\nѨ#x|2\rGA,*7#4%L;]\"J1{+0r%t6蕾hMh&	3\\+#B (ȈoR*Bc~;EL%ĥ~hDPH0wbfٚL!FD:0Z8B?rBG\0 }1OÜ]&.?S&2DB(1'2HJ=7\$S٣3Tr^9FptԥHS`#BBRKB2C`T=\"o:/yK:hwM\ruRmmJCǓ^^B4ԯ}xZn/=xAcu&ߴC}] 0rԫ\0:s7_à20`!0s`!C;`s%A5F!Geh7(5َ-/e,x5l\noP\$4rdѯ\$C7OBbq+bx%,yX<\0CPA\0:jd:(C8aa\0N(`PJ)ZEKEIb(̠а M)HdNJl)@\"U\nV*8CV:B@U\"d!h(VhC\r!S>K,6M/\$dF{&%sR]TdiNJeB*U*;^.VJ[BYʿ	!8ڭCH0skXi8#(B\n؜mnDtaI16\$,%ućZJ]!\$AOe` G)+A8a}=F)o(GçLH a1ΚZ\$0qM\n[_92\",]1yє\nH\ny%n\n\n)#Ւ.J.|9o&hy9g4Vt:Gy;pý+dR\$Q:J9 Xa8H'8t1:;u@1f՞03h%F	Cw͢|_#\$n<(E,A'DQ͓Hy\$׾4J ԖR#F)бBI1L2J*A;IOA\0fFMOtlc2Ept/#(#РT--]L\0.XAAR2Ȼ1VI)ut|MTև+ĉet!&XGNx42Iq7hޫ5:\0)3cP*W08i'4G\r/&Y<([ǨP*P@\n&Kȉtf!`i`@(LwOR7CI5VKY@X^v1 wqpƸ\n_@6TKiu콙tN]\n29g3P@+Մճ-n3kq~4O&1eh?%Sxo<ݫ;THuLͨgwywL{c@I0O-DD z	k\\kkY%Q(~rV0ihfw,PQ>8iMI\0e9>vR	WXjYuT2P\n~E`eqۙ}֑lDeRHP 0)g;M~UrhL!PC!5PķuZS0/YvU8D0' A3[cƑIZf\\.#`oS8Q{p*FA;0qsOi7eҘNa^f`|\"6`!plwcZ!B\"ʑ#\"\0@S&p0-?wʤpJ0&H{jN(0EL&ǫAaPY_I\0\$@)s_PxP~+2\"v؋pkAj%Fk	P;p	{P\r9	p\rL|7	Ph~05BZnLQ@F  z*)b(x0^\"(?w18,0@)cGpp\"n~V(4*XGik|16p%('}\rlōrl\rF.B瑠?qj0NĲ\$^1\$(>fJKn׎߮\\AC>e7.6+n\"Qފ (,U\"\$}pr'|r\r'!cCB­QA+	R6`F#%!%J^mN\$c^Rj%RqrpE,}\"5BcfZE؁\rZ @cRcZ.\nRC-R0|Q=1./R<^2A0-\$0#+am2<p	Le\n0IESm272lH-P34#05'!_3̻43c\nN_sH1(Mђ29F/[92Q2)c:_'#So<ml[(t&3=.xN24l|>qbf}&Z!e2pFLHش>&pa+Ҧ,S5S7(B@x)bȯH#\$3شVtяC?B2)ؓ^Ra9Q+&A2>]iG:K%l7#\$Ol:'W;`2&4#wJKQ<rI/Jv*KPm͑Ie74H.jJDT ѐn#oJG2j5;3.3>R+Cs2sqP51\"{cpͭL`\\F1ǌKSjN&+KMB#JM3_&r3~cd8EjNrx/gX:JwY&XoiXդBYh\$ozQS\\]4GT]@U/<w\$>bu^n)\$_]\"\r)tGMFKUd:V#^5%KH-q^</R~(T`'6fVЎlm;fK0zApjqggWh׶o>s9\"\0lN\0p`ǽiCg7S6I*M6 U3m8H\rVHGbT&)/-(+@\nv`\nZFB6TOpw6@Q7#pQszBSRK\"gT`\r̚,=2CbL˱tD.3Wxd0}\nk)˩%#-箬Gz7GTG9vTZ͹TlOD(}8N\0@\".)pއ[!v6uKl\r}l27-#l]E#g9}t1@x!t1>+gw(oۤ<.oE\$EtBCa%J%oQר͡u,Tפc#FZ/waAB@OeW\$NyRf#Ŏny_~#ox6N	x3BuF&}XmrQ''5)Ѐ9C)-]yP+kj7Vc";break;case"sv":$e="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7AL4\$8uOMfSt7ASI a6&<b2\$)9Hd7#qu]D(ND0(r4\$U0!1n%(Ɖ:]xId3O\r3Dpt9tQN!ݾr#-+/5&d~hI<Ldy<ѳ7BbT9\"4+;B6#rJd726`&l 8L*9\\Dc`@4RBC \\D44Cx'ȬA/{j9cJ\0|&*q\n&x|550H+\r#l:C:¸򭐔\".\"p/Ë&<@M2Sh\n%k#R\rl/Ko)HcR1r)H9,T%դ{YG,9\r@P:5W8.L\0)O\nT7#/=!9N<f3\n:!igQ\n\"&Z\n<zK#髼QT`R>mcFJA#9䐤\"3I#8	#hr\"(M>L0\r~@Ue9\nP:\018\rȠ3dܓ35\$C=2@){Xَ0Ίtfء	Hf3db͐'kPktFK)ϛ.&O+C!\"\rm#JCd,\rkt3dB9Y@6o<ŃǃJ\\5kXLXÓ['lhHw/uKg}\"p6GnSN)@7,wKRX]D8 B<uϨTj4\$% R*GI)-&`2TY,^RMIB[Iqi\$C:@3#A`CuB GP#+H)&\$䠔<#I],2\$Ra`LL8E\\ScioeW.!F|B!!d\0n[\$~TXs4\rGјf4ͬ~E^.ܿ[sXADcLPpbk8[\n (vZszB\n\n\0)'	'<h,'\"L3a<KsDMR\$	8O-Θ	deeϼEDJ38j\"2LS>FXKk2<!RHD70F`@Xi94b)&%\"&2\nGM4H\\G~U@ĩ:	KE>	H2լ՗r *S3R\n\$#q^պ䐩'\n<)@ZZ˪#D5l!.\0mSCw\r'iy+29#\$YّMs\na8Pq93Hj>Œe)%z~o|AVdCX\$@@BP*PBpGN T!'\\5\0*']\$Aֻd  %z̧❋̵:dg=EeUPF@whnh՗6X!HQH\npYmOYk\n4XL3ܽCBl,5Ø	\r4GJTfܙar\0k[Ra_Po1^6RR@S08Ĕ9޸iE<Y²;J0C!\"U\"2i.*<;э'^@PCeN3\$w;'ǾdV3OJsd\n\"(YBɜб]PE>G6Q\0Oޠ<WD 0k^dҕ:y!bU0Ex ,.c {y;*>jS{3nxg!Gw\\Tb>IڻSwْxpgr\$nˏ햳8K'F\$~SB6PIg`%gv}y%FG/.)=*sЉC-q<q\rdk)Y^Ǆ^NQG\0٩l	!uvְ}_02\0m,`Ȳ\$-jr.@-^9j~<0[K-\\wv4;u/ESU+ۗ8{p)gu~cMwpbж=#od{E/EZn7KۙswN*B_\"}׾h߼9gZDs]^4_=wUflB/FFv\$!2I\\B(VxCJ0ضTr,FB&o.-F/L9-D0HT/\r/QhМrb	PBlP	5\0\neBL\0E@]`/YK:rB	\r`а0p\0/b8ŠZDnÀ/62:+_c?igM\"nF8#\$\$2N.OKObm.\"G'L34< Ӡ	/nӍJ`иQB'F-MLY@rPׅb1@u4!.\r/!/E#!	2CD!Hq9dY\rL<3\"p4b%~S-8S |rR2=`=?b\$\rV\rg\\k&gCR!(Pਤ@p\rh\"\r+Jh#4\nR)Qg\0@8@\\<t.X<J))\\+('2%fLE\"rnh#\$A&u8%2	Q3U.o6ba1\nfb0sR!Ú}X0rĠcX_>=\0(cXz#c҇r\\˰.\\:J5^&*;>kSh\\PfxL8vD&Q-\nFR";break;case"ta":$e="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8U_\\dj?&JGFMSIXrJ΢_'JuC^ʽp i4=xS/Q*Adu'c(oFe3NbNd0;CAt0l,WKɨNCR,H\0k7S*RޢjMY`,#esrʢ\rBB4;2)(|\nD@\0P7\rn7(9\r	:D P)#6cVZ+j	(1;ꮵlت2:M¨1Pd8j-jRMYj/4WE͒tFn<H>1<?쪶KWUdBgJWu0 l1 ;x\$g#r 6K4x@;/j<7;̣ X90z\r8a^\\tL8^2xu]K`|6̮3Lk4px!w͔Ok\\ާnsAk6)NU5\$±[6t_2])-Ϊsm#*\\6hyʹK8\\w]1Jve]V\"9\r\nv~W6hpJ6Wyʇ{6WydFiӈu#뵸lDV\"w,l\\qg ~֪}:x0˦Ľb~ٲgè1\0܂Ur~`P =3\rqILv7owP/1\0,ѲNq\npT)tRIe~+Z\0l=@CrA\n!08\nk۞{((e&wR:w-6\\\\R;h.86p[+Wm\rhWD؝3ζ( q(\rfT&\"58;wc\nY5I /yjȢٟG)FF\0ȷ\\[##\\\\@{1&=Vƈ` \r9/\0ŗtn&ydl/,f\r!]YYHDCL7M&ܱ=wHH⁉m5xњy0N9?ht<iAf҆:G\reZ5FWEBbn7@0\nx!co6,svfU	D*ǃpyH9U33@|Ni\nO(`o%Uꔃfp(Vq&Mm% *zrke\"SllEN^}/X附d,PY>fzgӕRوf+d<\nh՜]A1+l`+\$<|kvJ/5_vl[L)0͓bHPh`t~.g{ea\rligN/M3vpգ*frXܛ9W\"ՆT*\n}l\ruj\$dGv*GahSP`Dk&A\r^'A+RQ8(sHZU\r4\0((KEc#\nl{̎+D:*d<c\\\nAi0o̭q9-˿;a79&4zsa\\M3ƃppϨc\reAq݃2F%EnGMZ\\W8G!'Af-`=Di,EZҵvM5CVpF1x]r1~6zulskVeĶ/FZܼ_GŪXTZy퐲ZMosh@Y!r/y=k8ij maW-.)\\G.n>Y9CO\naQ6tA%D{{iqL,\nэ(aeLɁs/ú1P}0rRJ槙`)0A2[*d@CLzUg;Ò6ItEAK+9	8PT+т\0B`ENEɣj)@ĳ|;#mqgh?H!'{Q~2\\grY&1+eS[?*x:1CHq3܌3\0(,ELy\n{.'NfVm\0-ϞBP\$h\r&0hĆQM@Ȑ}*	X&n~\09)<BFmBImJjk\$`&\n=E1mNk\n\ne?	t`	'DCI>l쀼'JP:lg-8^`R\$67v\r4H GFOz)BC	Txzlh\rK|np#nHTo\0\n/bJ	 ܯ%:4	,IBz/IhȖl2̌͠&` ^Q\riQ	.q7b_'XUD~nLl08trdVǔD\$cPfdC/y!W%r\"pM0uDmp,ņ\n 	\0@\r%Yz>KG´/.F̷'pbPp2j\$pq0v)c+\rJ00~nߍ],Fh\0@ &O/\rm1\$+1kY,!0R%jѨl/-gH(@2A\\EbHK3  (s2+`6s053VʳA4r1:O/nӛXP]2;r5s6%BBI4\$8y	`zL%se/<6f+jP95}9']7\$\r\nEAE.SRy@&+Ddv\rhGI\$TB4T`Sx\$h1o,0F`\"`PcoegE-sG\"I''Jo^T+\"sx#wM<\$DkJZR3R摤C:t&mPjl4N%N1ROR)3CSSLB7SIT1pMQtl#:33US'EDw9t>}B`gn2rGoAz~x.ڒk@	JL#0. Ej&F6}\\.Ox.uZcZdG/4tFqМ\$G7].-ȢKщ@\nN\rE!#\0T{;Xii-:~7VU<aW2_/9=_-Vԇeu\rd=;VG(%JVs;Q5Y`Ãg9\rwfMTe5ogU,z)2OMӸBIwg8Cq4]D2?rjkjGDP66N\0~VPCCmCmSs(AnHn*'A(jsWu\\S 7-\0Votet5.G4rs=<өglNOjV\n\n=^0VPiRuq6Zv\$zlR,q	LDW_vIU7rIן}3(15x4W7Hi}~\n)HEYb \n\0}L(L	~+s-;8sw!wuxlAos&GmrmGRt}StwUA`?֣DwSF@؈j8hhpWjUC}ϿMq։VR\$;s׫BUcob厘Wsg3+v+`uW6-#wBۑ1!q\nY\nɔYXϒCzC#(T\$	Px6-QwkÏV^UufM{\\e/kYۖXhjثkwNxqWy%9&Yzٵ`znќmCgr0UyCvI	Mc:'h.uBXq;%LL\0[K*,f[A㵤6q*:RMEQGUu5eŋ L~q́9qux@w{YPytXC7c_HYOڋzkVIhRY_/5JFH#8lX7z:'SY\nr<nEѠ:@\\,&I%GLq^J1\"f0G9?=J,GZ&7m(mi4:H鶾u6IeWECQd0\$d PdB8ȶGjӷpe,RhOU.grUCQϕ5&VŽ.bB\rV Ӥy[xt\\ܖIhYP`\np)V{N!9N*\n18]G5q0Q|Xl.k:C;ruj)\"FwMCmsJ1.SU|(L{w||w{8m&_-@u{Jy'g\rjJQ80^?\rKZUi}zFi5AfxG򨪝AUEsC#y{}uɯɄ4Ox҈Gx9(ȸ`;CZN\rI>Q_THZwEVz\$_y\$G]ChqK#BUX\0H|Cւsadi[@xDp`JxwP	Xl)r%vh\\3g0xUؽΞJ\nq{8{g[9ggs1^NUr\0P <csA}}=U5d嵓\0=D`	\0t	@\n`";break;case"th":$e="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=UW	8{#+&\\K#[[=-O5,%&ݶ\\&TJ}'[AC\\k%'TLWȽg+!'MbC ɼ 4NQ 8'cI3@:>2#:\rL:#-ڀ EM˘a9~NsL^\\.-R\\\"CCEÚΩMR:()E<)CH3srR7!pbLB5ø7P²Zjr4\"@Li\n947R>Q͍.#).R#u On*g(=|(utwXϰ/<*e+# -N\07/:8O1p-\0gA09=sc2\0yq3:x\rfO3p^8^2\r-#x|:RJ3dgS:&\rarN:اPU	DJ5R|.豒!(6KBFRH\r0iLsI,\n7\\#B\n<>ej\$z;A.)pՏ\\L1	qGF4&R\$n[uS@\"_c6Z6.+zCcQI4mՓ;ԠM0\\2R#RѪ{(nmԲr{[J\ry[(ourG9VLْ`\n6 4\"c!WHSQ|)A/GM\$6i&]4@YjT=dՒt,5\r0+#'^#\"Sqf[	Tp*K\"t)<\r.=Mu\\hH{va	ߚHmj/v6um9C(eD?0|0f\r!AYKRdDϡt	:A&er< ܷ0sBtdt\n>l3@((cW%]%SYSz'2deN9ܸԣ6,(y/&KdoBo>7@exu[x3;p@xgKAz@=g2nM@@puA@9Q3s}h/ŤC>OM	ʨɢ	z9bC\"^}/`!S6{>SFJā>-rxO Tg2ĻEѲd㓌3IWM;ˈQ!?C<	J(׊N8r_~+%sbRWK\nHm6%E]P	zZigh̩FYdԢ . S0 ]A#lÕ-0jgݰ\nR@w9J#KClnt\$/7#}WW娝H\n\0@SV8o؏rE&\$u֟Oen`9I4ڹ;(̡13%PgM-w:Û[M>]7Pak\\} {GcTyer5b03v;Hcn S{c\\o|u҅ XMT3p9)\rE/Ry\n	,&bXNՖ)C\\:IHyᒜ-%uA	}{\0fNᶘUcހ1f\0+TE⋧[rzU\"AfN(n&	f\"H↱ڥT?H/4gC)WlI=I9j\0]prlPS6mɋSaO0T>l+kLEhq^}rɬP*^{ E	5ߣ}B\0tj_!ԍ.#4sNlдDoeYoO\\[B)W>wʇSg{)/>4vѓ@cl3θgҢ<b w?&Տ2v1Ⴛr:FDRizX;N	BL8{D\$50\0M,4Q4xg`u\\-]>	e46U2?ӥtjUik)串ND7	aLT?xb \rJ؜n5⢀\$,QB\"(lhvkH\"g\$? fΌffhhU(lF݇Pf\nsޫd|)d&b>\0\rfeA,\n\0'89Bx%pEtC@c\0dj\"\"JGTOjz\$FhέP%U\rst4GC2oj^os\$TsdT@耨 	\0@\r%m+XAKJlǌg^0Dƚd;~ 0Keh2FHʶ;j.fĠEtc\$屆Q</O\"ʻ\"yނѵ=	oi )*de0x\$?~4O7\0*kiP&R\rvl(Ȥ\n4WE꠮T ,t:()Dr6ī2Fr2^6:C:IWC4Hg\r:CpIrrrrr\nOkhhdjC0d\"&B~+\n~n\"(DD6|v~&q<\$)IEª	qO01/I+R9?-1.ʹ-2t2N\"*(1m%=*P;RN ~'\"+y#.'rS}s3ΰK7zG*60}+k(v5\$@iΝSVs9wڕXd`<RG^Pa*4pO;-?#(p4S2Q6@Ǵ!<\n/ӻh\\/5t)SJ90Б&;'ʿјn;4\0003Bp0QFO@t#.[	.`Pr&tRQw<7EYF-	tώK2tgTN9C;!ЗjrpԬX\$dv.)n<S޴?&g4j~:C2Fum=p`JM4HIM\r<FFP0sOT|4JPMQJSN#_M}P,WJDNirnj	IK>iYJ8~4-՝LIZ4BS7ZKaXƥ{2BZtL/K'[532w@']#j]fT;t=^sKq\\M1_Uk̚~F,&:p(\"'Padphg'M/cki.\nEYթ]@fJ%fKu6YqgJk#][vqCU`@@`fM`hN+3UAj)j)[V? k.:G*+6Rfr\$.Zop>ˠb%7Kg6o\0wjПpqp wp@h]4s@Y{^춂qs't5i6iu@ֱYa\rlwO\rRHD_5\r!%!sSev}wYk+~s[zwKlzzL7t\\4a9x\nbKPքGoyD:ryZbtw'q\$cpfwP-,,Bl{W3kէH#=lHڠm\r7sPC;2dV'`\nplքi}_-mɤ[Ri4/;@ր3#ú)H:  oFL7TSdy&U,M AV؄=uL%V&:\$B\0KF\0%<v@ǡ|PprrUPR֍t\rlpσVZnlzIՊ=5Sa:9SfI3\n@@C>w&N`\nYp.薈S+T*;;6:m-PL\"<{-+t/>>n9me#]9.GcSny\nŶ\r|IDaegkrςTx/X50o\$s8:P+k:9~qg짋?tFSFscYVx'Ձ@@?Dx)]x#T3H4Bp	\0t	@\n`";break;case"tr":$e="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9b(Bi=R*|4&`(a1\rɮ|^ZɮK0fK\n!Lx7̦ȭ 4k|\"tit3-z7eLlDa63ڜI7FӺAE=FqH7PuMn7Q#j8S4ΑnYu{4>_(x P4k+@:&2+h7@080l\r8@z0mh4@ޣ!c`94C(C@:t㼤0B|uǣI|6MjB3#Cl4!^0+4#0E[=HL6\n8ʤ+(-b\\)\nU%J0`@5,'9A(Ȗ0#UUP%듶*/@kŋA*Bx7ԛ. PcT\nPSB35b4[&9V\rN1A\niw#퉃J.	8!R:X,*ܱkŸsp\nbOى3@7s\rMPbȵ9m)fAj:C\0eR˙b*<642<@׊ ɢ:v.Yٞe!QhH#\"#Em?n9N3n4˺4'i5\"4\rG\\x<=cro=SҨ툋\0`4-`c=d\rPa&6>hw	]g[m{Su7]?&gzX}V\"8M@8H[5|#-\n9egޜԣϠ9/ MBD53I4xF`XkW&舑3DDH!%\$ĜwJYp/%.5I	%ܠMp,(^\0ޑjrR@\r:bN[!!X\0\\h ,3\$SHHj#@\r؜V,NWi#RzQJiVr^P!B%1?nܑ\n\rџ3GF[\r\"\0@]q^3b&kPXuI\"M0䩲&ELOAp*ܴC/D@P9UIrB\0('`%\nD(dU(cĿb'<S=7!eIE̠|E)I,\"ojCD,9\$f	5MA8d 1.Q,5O&HiʇNFrl@2aNhWs_l4TVYe\02&DDoA2='L@\$<!>\nȢ0N1Dk:ZRIwy/\\(\ra+e{eCS\"Np[\"VEe֝pRm-etIȱ6JJ^BIVM=%kN#.B?&+q(@RD7,P*YrF}gҘ0@{,eq(Lߐ~J0jxp2VȭhPó45rc9*đ	~pN9Ad:rrbLjp(s;w5+AaSA'-p2l\\m|`@)^J@\$U(j0xAӂH\rlM7I\$٭[C/+PM!IS=,Y2ػųŌ\$_ށy\0ҩ`:,CE\$0DIKa`ADC}n\r-J&D*hsud{`.I&1.7߂\"R^ yw9A5EnpYnF=	I'Eb#Wi9}%?Y]`F꨾P 0p#ؖ9BB1KA\\UX/)7Ň\\kwRi^0XC<I>O!Ofyz;nNɫMM\\czZTypL!u#re-.2ӭnOθ}ݣ͟X}1TεX4u׽<!Wɓa=Î(b L/rOǉu*eg\\Dh1y-AUQN9A[3|<&\"ti#zdA[(Mt;;ͦ?W!#YJ4,ڭ!GXn%:%OQgW\0lrd\n\rD,\"؂\"W\"v\rNĠ)&>Bch^eL̤&3\0\"m8O(knEOw\rхtGpd).`L\0dZ70.pEꎀ(pX'ͫ\r-μ0\rozHiJ~\rclTVbrȅC \"&MH\0H㣞iX;,|~#\"08ܼ\r\r*̊.Mf\\5%j8-\rtQp/Mm\r{OPs1U\r011{R}gkq`281^r'DMP7̍Pp*1in~\\C!\$=zO,2\\Px!71v/i,\r4@ʉ<@98ۀHH*2[\$d\$N\$MR_&v,^qqmRi1)ePPQ;qWѢn	+r,dXr*\0?gF;NL\"Ŧ0Hq\ncVf*}`?UN4\\/Ы.άNO3#^!,6\$C^\$\0ve/Ű\0Z8L]Up)i1>3k>צʂL\r5ag\\̩\\R8/,\$*V\"Q;dU;Ex\"r\n&|y!lc!yρ0#Om#Ȗgj.A\rF92ӱC-b*Plp,r#~qv\rF.:ȋh@H60F?&CHPH1\0ކLzsY Roz55\0{\0/p!\0O~7Ktjgj1>|HC-rV<?ޠ\"cRuЁ\nC+dZ-4z";break;case"uk":$e="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9\$&;dH5}Q\$C˩ZB	D8(iyA~Gt(ygY1~Қ(BdׯKmJI\r.(VV1>#\$:-r%CǴ)/tp^\r>[73'6SP5dZ{h>/Ѡz0)28?v(P|\"oKB\"i{* 5ϲ:㹉вPPD#h\"#N!J#\"JB#䎾H14ǹ͋X5:OJZ4#LzJFhh\\Ȏ;w\r?p h7h\n2h#54_#\rؽSPżzLȋv\r3:xa\rEѡp9x79c2Fnh+%L:ʹj{|&iԪ|Ɵ0k\nӄXTAs8'W7qdM%\rJB16-/\"3v%P NS=ePWJ8N}j_hr,hH'24JAS F!;\$Z3\$ڲ	 ^Vsp/\$Nh:\$ôNd@Cm, WlOLyהIkzZʲ,2P/JbAİfO'\"v9MIW!2@LGḽ,Wtb&n析zK˫'qdQ#*5x~!\nD&B\"ڗ_gqrDINxr!*.}#a*#IU%Y]*\"'W+Dat)dJhsb%М9Grl'AYdQR2!!R%0\n\$8FzF \"`AvX\\ H07oM:IIpIAƣ\00/x`tM풘HGf/i:bL`U:9Xw\n.#	Q-\$;t;ج6DFJ*~Y!KlK8MPH)SU[+ّ#RKS#-S/d=ف0kM<M͚ҒSM)5#Fh*l4?-#kU2>y9EGB-вcwڔrrM2-D_+\"IQRLBQXBqƕYUnUڽWauZY9h@t\r5l,`Q!7t]l\$Rz[+檝!P^,i	ӮE0O	*va!5-'+ElҼWa,EJJY=gÝKZjNB~!ITzJ73༐!6L@8p	bR!uTCXˮz:IO^}(\"\$]KYIj_PTQ#ª)6IGwuHHŐc\n (ر~\\' Sk	֘#]ԥޘu8+}I3q&nHtTsV\rRgǄ_3<''[t'Q\\K,~U6)[)d8U\na2(wFơ;+tRBS\nA&***D\\N\0u7l,3(_LC#W~fvwa\nᬬ1A\$Z2gru!+ݵ?hr!~q*%JVE,S.ɚ_]oZXb@'0:Sn)6Lj#luV7S![/\0ht*\"%yq/B%!څ&GRdBJ#@K4	WIfO/A4JY+\$nDj/kkvA<{q0F0 CsѡƁzGD60l^PM#{DhM*44e+cR8YDAZ(kid(g.H}m%y5䝸SaATEI%%^ y\"~4ұ22|]es-X|\n\nLA(@uVoLo6ZFQ+F}nxI9qu4',qgF\rC༳A&K̘5o0V0\r\0\\_ot8B84@Gڦq'aƂu,|!Mbb:`DHgRM)JC/b0P2N2TBDr1d0]BFGJ(|},(gc伷+Ƒo,+\0kDBF͂9\nRb`x&}*~D:D@\n 	4׋bÌ\$\$2FGx\nz^^ڜEafuHd\$+C벙CNǊ	,:7:@^'b;fR1j;oQu*gq<ױgǆFeTg,־4@SvlT%_i1\"/K!	yoqgaQ\0ǯ uNuq*vr0\$fA>LpvlCwVHHܡb^NT1Xr<(1d#b>:짼IE\\'\"%\"PHwDbjK<@U*C'dCB	xxтԡ=û.Z(C;!.*/Rޮs=0) <.]0h30/F6n3f&x\rmlGNA,(o@0¿*x!7En6U585#\$0+w'2\rCi08n@\r\r,vF84LI<oD.by-;)NԊSQ??3;0/>|3S.6)jH\$#X1I+\r`hVrA2s4@smDE*	 h_@1FFTCF;FG0df{/w -H1s?NgH+?rqK+qKq#K]2TL4LqKLML3-1pkye'hO=&DҪʲO#On\rc&P73j3km\\\$8&ԱMN,Q0buBP5\"А4`(aMSMa{K!uTNNC0,w0ԧKNH/HT3]e比Nz].w|KS&]0`Kb1B~\0r_DbBĄItP`u15J<1NNYsduI4[KC5a*vbr)[dT`uGgghR?e&}!@HT1\nT'I05_\rHS#e2	\"l)k^Jփ`llwE	Et3ol]	e10W&*UnUnpadN#W'qh2H)rq\0jdb)-ԭt01Y]C7Tjhy7]]nt\\56;j4vp9,.(gGFr֫*mff.9z6/Rw({\rIqgfz@Fk/achWPd|a04E|ti]֌&kJHJ\ny83ȑ@t8LD=5SSZBy0+&*]OD;\$\0T\r\r\nqu1z8EOF1w	/@{|')VkP_)z~+oW3H/gyD75d\$ED~(v⟎TjoRDK]E}'`A#0F/\rن:\"(DFf'2uOT\\0Ԭ/Wk\\3{ZI_\0XQi,Il1[4I@' (#KR0Ɨ7p!<RVf/0OP9-S=J&RÏC/`1Pѥ.AAx6c	OkqbUF2Ҽme+\\f0IAd磆\$l1Ep3C8tQ\r`p+1qR]2̦4";break;case"uz":$e="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8'3Ac4MsI@k7#**''3`(;M6,q&ƙ}ģ+77:B:\rW.3b\r4q/|\0(a8ۍ :`*{VvN-o)dgxiw7MX('b%Iyawu:D5+*Fς\rH\n޺:6C=.p ޑ#;Ȟ\r(@8BcR>c7Ì))W3Ê,Ak`;/12\r!`@5 3t#Q\n2#8^2|h9c\"2|-89<q5x#u\r77B=&KO#TBZ,¾cC<IRN2/(RPTU\",`6l:<84>UuxɁA*#aG*\nӁTpUr\n#7h9[WQR:Cv3C*d:\$C\n#J7IڌO{ێPZ52}J\"βc@ʈ\r<{N,IhH3(F.#)\"b(:)8c{ҸNCGqDV,|g5Yj#LiD}D(&bHڗ՗p\";Ff:WREI0ZD;]C\r4\r;3|9sAPiM83A2W,|RHɬHc+w,hb[n758yb2iJX#J\\@P:Zb\r2\"<[Rv%)\rd8(h3&v{j/jpq#D̂bV)D-܀_{///YZ]\0Du\nE8u+ؕ@zO!,u&by5d30`ad1мT5,%b\$ΚSZmy=_H7@9	\"Kr:*pa^	JD 攡!Hpp9ѫ؆,G\0U8Ȝ\"ᤈчPOIZ&RaLi+\$RlMa:&EsT\$ WYct8XI)D0&DзɅu\0eEcLGt@H߬mC\n	<&&_\nDH	i,VeMH*f\$ZLi`(_.|\nMhe,t£R\nQs#9\\ݚRB\r\\\$\"NJIY@2:}W'gt>Ҁ>2[j=`9% fIR\"sURNnSRȘ) H(+PR%\n\\T\"hȀ~`3' 	/l6L5&	5JZIJOAi&xʇ		q+A@'08ZI|\rq3/,u25\n[cyyiς`W\0jc8gD؄P@20\n Dh)HDdȳUz`N,,\rY!8#~=pHR'`5:BHPɱWL	͟gXdE5F>,Y	<8/zSj9- %KH4c\nG>C8mR?iY5ׅLzO!3PiYa!Do,\$@NPD'tmCld59П\0aMҚSNh\n	\nH7%Lϔj, 0ƿe]xE	Jjˢ	:ܐZ\ryT0+Yjf_&(d'x*k\$;\\z(geMø,%\"TNNAA9O\0002Kb_9Fq<Ѝi[{yL;dɐ&ZKμe\0cóy_^SD\\acTd] Otx\\PqѲ^O'C\\!dˌe\0Nm	u=}@\rsN~iyKW.@l7I(	u1G_B=wˉB\$xx\"ΎMSέ Da.u!vFyR%s[X2fEAQ?J).[B8FUhq,/j&߫w_PzxUs~P(}Ia	[-KS]MJ2ܣȄ=lVT7wZ\r.\$o`ޠ`dU̡Mp[d.?  LQ:>2oLI5#\0Aᏹ&ƴc*a\0k\"z\"py+갎H-\r\r=	Pse%).D<7X#-#CHi	Z%r	JPYs\"bBc\$5%C̐(Xo\"P\rmر3o?͒bY]PcSLS.M`4oQp\rd.,#bUpuHNd1%E>Pooǃ0\$N4ƀ7Pߐ\n\r\n1^ɍ !Qd;\r`Q.1 pc1D\0Z-E\r\r	3 u\$\$d\nKMFRU\$r2'j@!&m'.;>x%Q)Ű\r&P2%WP#FJf.2-\rҌYr!8,#Zf\"#d.\r7B'8eO.Yf10Ҳ\nI+|C\\&{b*; (\"n ZbJRNrnnQ8|.Gr]/f/t^jH2#qc(<4~\"Povf3'^24>84\$I܇jrS%O_ƒ\0ӯ<#aB&\r&3jx^ϼCnoof#dư#GҬc>OA}pA\r4Q|`t1*eC3=̒Hk`Vnb'\"vm-xttl0Q>yms\$;CbGC%0Ex=c'GrSGl\$LiBcf	=B%\"RVcChxk\0`e;e|";break;case"vi":$e="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn8QE\r Y\$Eyt9D0Q(Vh<&b-[no\n(U`+~daH8iD\\Pnpu<4k{C3	2Rum]/tUږ[]7;qqwN(a;m{\rB\n'ٻ_2[aTk7)o9HI=&će;)ZR \\Z:\n\n(TP>22AytV\0P<g066(A4#p kCx9c|(9B1c& :#9\04x*9j4C(C@:t2,8^2|9^'AL\r7^02O[,6F;p\$V*(RKA],#Ra|/Kzú P0Ct\"<(P9 Pޮ\r6]\$JFr1\"crL!Rx^Q\"OC6B6(UBeRQŢ\rn~/e,(1MaM]EV<hTс2.;FJ		퀗d(Sjscof؟b&CX\r40g\"\"m>՗7%CoV]k\rIvաPFUBT1)\\Ca[nޝh93<H=BCaRH|ɎנH0/`I`2-T<AgE;st/r\nL9c@@&q&[hAe5;0fV2wE\n+e(1jA	܋\n\\\r3YC٣6fzh	8!Zs@eC	!D\0¤Y Ð vil\$Dto4DxOI?(0wQ\n*,ԈdTR)p}r!o8\0PA6HZL\$a:F\$WsmВB2hd:tP*\rBuϬnJ9H(ʤBSÞ(I,\r9'e`-QzB>&Aʣ\$\r2`60i\r&P}bmX0eRWK!ޏBg!ĝ2yX^\r}hai#vKU-nEзB@\$NɌd@J	TP1@pA콐:jTz)0Y|Y=CI9S8&ڛӈrZ?埅&BC\0:E\0iI#ho%3H]\n22ɢR:\$\0QvAbQG&-Nfɉ^Z4@tĄ\n}˽GU.bE+)\$!\$\"MIAkɧIhP3s\\+7J>u7zXE@'0\nN7bnR5Έ\$]DY2XK\"ܖؔPilaXLGRJ[жF~PDn\"'R@9C=#Fkd\nRj!\"/a8Dj#\$Q G'gXXHK0ĝ3Bh5rrȣRC%\\s \\f{O,v\"%f\\>vro婿Ɂ{5q-aL(#G][OBQ<4dnbz\rAlntu3\n<DK]Xg\$DUx3\"sQ480A\\y]pԾ}RTPb!6<DM8 =3~ ޳ЯۙĐ3u˔C(cy<CX\n+h_f(C\"n^ i~A^LhU.I{xV%V&\n\rȈCYC	h\$n\"QJalLX[;V6[!;; dĖ2R\"IN(kd<]۹)𢡄E/'VL^U!\$0쯳E&hpЄ5LW^㓄ґ]KBYX|.H98XaJ^枃,X(P@yC^iAeܠ_{uBb' VnɩEL]\0qBBD7Xtr&ņS{@-8~CE?n=|T͢faFM @\$8,c#-*E\0C ^)^n(>6'@~BB^\"b-fB]fD*EM¡Í\0#\0C5jm,ǎa|IA2Ȇ4;ր.&p-D,l\0qNoo,\$ P\$N\r52.1h0<pĭG\0-o\0l60B P1\0R\"Zii։\"nL\" N0P!ЉLuO&UD:BJJ/p`g\0\\XQ1K\n/%K\\'X1HN,6kPwÑjY.cgSr(!N7,8\$v\\	 \" :xNsetCMdѡ\r0%)\$D\n1F&DB0.Zqo!\\(,*9T\\\0\$Ɯ =P<)*@*f+\0+R+B&IRKZnk..+a(r࢔}er0R;z~D|H`\r\":AUܮ`Gg3#c2:g1;梐mE>n#cNrV0%b5Di:bLcsH:0Z'Osꥭq\"B	TbМ&e)2kb.հj\"#HD.)\0\nqOа:UW\n\$mxW c\nkz@R.6EvIb%:2Y;#fUEX],>VLH#d+ZlFk\rn.tHK#0F/j1(A8mc-i1.&.6qCI'ѼۆDHd?ICP7jH<f+D\n	k\$k094*ޙnNRlrd+@	js#pI5e\nT!.-b#49?NK4IL^E8H\r>eJ2O<3D~wN&\r!k]T@";break;case"zh":$e="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4usUUt w:t\nrU:.:PǑ.\r7d^%u)cxU`Fjrs'PnA̛ZEf]EvitUλSծ{Pg5	EPN1	V\nW]\n!zsΟRRY8r{}CrzP(+e&%^)F'<6#p9%0JzLWI.W1ˉ8Dg4Ĝ2F@4C(C@:t㼜03\rx3(9I|1B:LΝ\$<x!tIE1ģ|s^Ińs6)6_Q`re9iLr\$PKR8rXDseDS>nsև-lQE)DON\$xqHr<eJCM\$ZHAv]\"h^9zW#s\0]Y̢|9aI5BL!XErB\r	Dm)\"eHnv.I4O6T\\C^YՁ7NSٖKge-SGAM\0,*r>m40ZSa\0:cA:Cp@09#y:pa703.:3G>p!K?%qDA-IX[\rUe*<OĹm`5YVIdU]nDaaA}#`9*LE^C<APbBX<V.,38C\$vSXI\$t⅕adQ?	AZkBA`QbõCx\0A2\$IV#~REH%%Ԟ_TJa-t\r-2e`,\" tbKGHN\"\"[v.DML-œs\0[s4H!() \"\$2HII1'tUJe-Psim2W\\.PK3f%I;sp9ȅ0K/,1ABAy%B,VA\$kHgر>M#	PiDX.0Ř_oE\"iRH\n(Dg09D|CxB\"'pOa)U%!*|f,#a*!*QK*Q@ #>YTĺ^C蘜\"^-P\"LOԤ0 00 \"mB6\"2E<b9Dk#[&~ٚ\$V9pO4Ŕ'8p2(8cIE]Õ#X(I*V8jRO\naQ#r)0\0L=qpA,GH^+͏ѹԲfI<\"\"\",!a=%洋ڱρF-&wHaH%\nrxNT(@-A\"l@Z2~<Jr)1\0K3z`'q(\"d:&QȓX3%5Na>^\\@siۙafAorlD0B&hhI%p/1\n+hDciڍ&g<W\n+OIDypL\rD2gC!0ƐcHh\rвLY^:Rg?\$8d4(srB@	X(;/#g\na20׏A!<ٛbDߡmY6.\"L_Mc;agm%[!}ou5%A|1WHFMk Aa s(^I!2H/K2;epFgҎF\"2d	t,G,(ȉ[,l\"\\v*am׶\na80\"}b#PmqVᐉ1btRaUe~}A\\2.fO'L	´΄[QQj\"(5)hDG.\$M/Et 9g6JC]3\\/^1es<^ShyUR#s-\0.e++%rCȁj-ny?9JDF(ei#hKD@J;,ucκ2VlKA:~(\"˯ކzn+H}|.gc6azP1H~im0D~gd*g~g@%9B+{kCz/-߁\$F^oaXy(PPhRJa!*fV9R!:EOQppXݐ)Nԩ\"Eg-Ю̿ wOhRojM6'Β-1e;B2p0Q<9NfJ\$,vQ:=^f\\ءag\"24nO(M.Qz~!N_!riݰ1q\n\n86϶Xl͠G\0\0@\0ƦlƳ\r0'|CpLl~0L&kJFϰaNq(0&>P\$nq0Ю(tM8vd,*D>	̀Ѐ_\$-t#>^2v&zJ{UM/bGZg~\rvr 3vIf*C\nZhfۯ\\px!X[#ߧ]	&a!(4!^cl:+j/ѩ\0^z[0{&za%l\\h]\"<\$#PnN/%AXIm)1Z!x(	(bfe4/v0\$B2^n+a+-KgEGVݏFh V\n`چ*l#G'eˌ\$#()9{(\nS)2˭29L?6Þ.Г{.`/=!";break;case"zh-tw":$e="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/TuʮM9Rz?Tא9>SNeI̜Dhw2Y2PcмW*=s7B9J\"XQ2M/J2@\"WrTD{utspS\\=\0Vp\"R )ЪOHΔT\\ӊ:}JF+JV*rEYYg9jXtdrL)^C+c@ZLhJ\\<AB6#p9% J4yhG)*G-N*M\r\nF@4C(C@:t1|cx3(9PI|t(B1֯B|\$	psd<%	^sHˋWGe*QP\$mO2eNѬRM1ZS @1#aJVJ\$O.Ivt>A\0BҶU	JѶSJF`Q}\"^6Cfvs}sGP▨d1T	\\vZ\0P2@t\0S#N#+6A})\"`AZs\$K.NkyT̙6X;tVimOh4b\\?1a˰=T^t=p9h9Ҍ*7\0000C<P\\oC|!p4ć\\YS/yQ1KHDEtķXI\nsB3\$p.RLY&Y<\$Nr8iec#|P:K6teMz2D;,>]\"`Xĩ.ҡ}G&Ԟtjit9D@\"@:D8Ö^\"R+ldB	+YZ#djBl@6E(4[K}04BjMG\"Cir)a`, t%8\"\\J\na9'\09ET\"9M[DE(.cbpOZXKIq/&\"f5nqy<'\"ԃ\"U:,hLJ+cj.H\"0Q\nRȭ@Frf!9ÖAD9ۻ a\$T}ra'Ź3`읣EGhZQH\nkWf]K'Q^6H\rlR`9J4<P>rDDDt\nfLهwbRdHx2GXZG0=B# !݊CR&,ԠV`@R:֛쏁64xkI	XWl#\$\$<+ Q8 	2-u%)x(JAa<'Ш:DL=S8rEU<@9äK~\"G4N\"xS\nDLIdΆ4Z	s.b耨40T\n:Ҳ[4	Ȃ`AԶ52`% B4Z1@(I	8PT*\0B`EK\rb҆\$h\$dxGtod]2EҫQ1PJ(+\n|O!tB5V[r0\0`ۂ͝5ChPH!P\"T\0yͲMwtBX\"DAwMcZ#߼S}\"ej8Ey1&kđP\\c'P(eWA6PΌC\na*xt!\$T%JQısJS*lh[`w/EZP^ik9А!\n	kpHt@@ea<4( zYaN.,Ak\"&EMaxU!x,`.:[6OI=`!P 09|x\n]`x?UUrx W\ni4<%4X>/|BEII|20U\"4/2*wB1J\0-F7'䨈[JJ=\"q)	1+G(r\r>1J*\nq_Q\\DeC@]}1kDy?U.w\$F@\$ iscCb\"ΪtqNH,A1j`U[U`¸qepchȹWF˱_e_\$T\\T\nϛ#zn|kk#ч*7_>ҫgdRd,{[煰ߍ?+q~0;LG(n2/\0N(0B˞+sX-(BACԁP5IRF#n2IJhIY/*ԬdRj6\n6/ӣ!(ҩ~IfpV(rMU\rZo<\\4R4XNBTeJ6Ifp002İѰȹa\rA]ʹ_mphې0#~<i:,\"L%7cw\":[L^aHp*]i\$j%q\\^k#ynYB'b\rd\rdNEv\0@\0GMgQpgFqyѭ,p1Mu5HZ\rͅRAJ6QqqY\rom.gx°Mۯͩ|Zr !\r\"#	 !R̂4L\":iJ+8?HRAFb:!k&%Cbo\$..3!z{::è^6%zI2\"	R0\nZiF¢XJ!b%\$!e\n(RÖZi~9Cفj!,\$D'Rs ֊:0gt/4bdR-/F3N#lrv@\$eM7OdiXPEEN,,_b<ӯs8o%k:2!p.a*Z` \r3\"ӀADޯD	.453V#lG@<g'c&k<)p,!)\0";break;}$Th=array();foreach(explode("\n",lzw_decompress($e))as$X)$Th[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Th;}abstract
class
SqlDb{static$Kd;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($P,$V,$G);abstract
function
quote($ih);abstract
function
select_db($Cb);abstract
function
query($I,$ai=false);function
multi_query($I){return$this->multi=$this->query($I);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($Zb,$V,$G,array$lf=array()){$lf[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$lf[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($Zb,$V,$G,$lf);}catch(\Exception$vc){return$vc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($ih){return$this->pdo->quote($ih);}function
query($I,$ai=false){$J=$this->pdo->query($I);$this->error="";if(!$J){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($J);return$J;}function
store_result($J=null){if(!$J){$J=$this->multi;if(!$J)return
false;}if($J->columnCount()){$J->num_rows=$J->rowCount();return$J;}$this->affected_rows=$J->rowCount();return
true;}function
next_result(){$J=$this->multi;if(!is_object($J))return
false;$J->_offset=0;return@$J->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(\PDO::FETCH_NUM);}function
fetch_field(){$L=(object)$this->getColumnMeta($this->_offset++);$U=$L->pdo_type;$L->type=($U==\PDO::PARAM_INT?0:15);$L->charsetnr=($U==\PDO::PARAM_LOB||(isset($L->flags)&&in_array("blob",(array)$L->flags))?63:0);return$L;}function
seek($Ye){for($t=0;$t<$Ye;$t++)$this->fetch();}}}function
add_driver($u,$D){SqlDriver::$Vb[$u]=$D;}function
get_driver($u){return
SqlDriver::$Vb[$u];}abstract
class
SqlDriver{static$Kd;static$Vb=array();static$Cc=array();static$Ud;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($P,$V,$G){$f=new
Db;return($f->attach($P,$V,$G)?:$f);}function
__construct(Db$f){$this->conn=$f;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$m){}function
unconvertFunction(array$m){}function
select($R,array$O,array$Z,array$s,array$nf=array(),$z=1,$F=0,$Zf=false){$Pd=(count($s)<count($O));$I=adminer()->selectQueryBuild($O,$Z,$s,$nf,$z,$F);if(!$I)$I="SELECT".limit(($_GET["page"]!="last"&&$z&&$s&&$Pd&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$O)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($s&&$Pd?"\nGROUP BY ".implode(", ",$s):"").($nf?"\nORDER BY ".implode(", ",$nf):""),$z,($F?$z*$F:0),"\n");$eh=microtime(true);$K=$this->conn->query($I);if($Zf)echo
adminer()->selectQuery($I,$eh,!$K);return$K;}function
delete($R,$hg,$z=0){$I="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$I,$hg):" $I$hg"));}function
update($R,array$Q,$hg,$z=0,$Mg="\n"){$qi=array();foreach($Q
as$y=>$X)$qi[]="$y = $X";$I=table($R)." SET$Mg".implode(",$Mg",$qi);return
queries("UPDATE".($z?limit1($R,$I,$hg,$Mg):" $I$hg"));}function
insert($R,array$Q){return
queries("INSERT INTO ".table($R).($Q?" (".implode(", ",array_keys($Q)).")\nVALUES (".implode(", ",$Q).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$M,array$Yf){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($I,$Fh){}function
convertSearch($v,array$X,array$m){return$v;}function
convertOperator($if){return$if;}function
value($X,array$m){return(method_exists($this->conn,'value')?$this->conn->value($X,$m):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($N){return
q($N);}function
warnings(){}function
tableHelp($D,$Sd=false){}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$K=array();foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$L){$L["null"]=($L["nullable"]=="YES");$K[$L["tab"]][]=$L;}return$K;}}class
Adminer{static$Kd;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.2.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($P){return
h($P);}function
database(){return
DB;}function
databases($Pc=true){return
get_databases($Pc);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(array$wb){return$wb;}function
head($_b=null){return
true;}function
css(){$K=array();foreach(array("","-dark")as$Ie){$o="adminer$Ie.css";if(file_exists($o))$K[]="$o?v=".crc32(file_get_contents($o));}return$K;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(22).'<td>',input_hidden("auth[driver]","server")."MySQL / MariaDB"),adminer()->loginFormField('server','<tr><th>'.lang(23).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(24).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'),adminer()->loginFormField('password','<tr><th>'.lang(25).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(26).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(27)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(28))."\n";}function
loginFormField($D,$od,$Y){return$od.$Y."\n";}function
login($ne,$G){if($G=="")return
lang(29,target_blank());return
true;}function
tableName(array$qh){return
h($qh["Name"]);}function
fieldName(array$m,$nf=0){$U=$m["full_type"];$hb=$m["comment"];return'<span title="'.h($U.($hb!=""?($U?": ":"").$hb:'')).'">'.h($m["field"]).'</span>';}function
selectLinks(array$qh,$Q=""){echo'<p class="links">';$me=array("select"=>lang(30));if(support("table")||support("indexes"))$me["table"]=lang(31);$Sd=false;if(support("table")){$Sd=is_view($qh);if($Sd)$me["view"]=lang(32);else$me["create"]=lang(33);}if($Q!==null)$me["edit"]=lang(34);$D=$qh["Name"];foreach($me
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($D).($y=="edit"?$Q:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($D,$Sd)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$ph){return
array();}function
backwardKeysPrint(array$Ba,array$L){}function
selectQuery($I,$eh,$Fc=false){$K="</p>\n";if(!$Fc&&($yi=driver()->warnings())){$u="warnings";$K=", <a href='#$u'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$K<div id='$u' class='hidden'>\n$yi</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$I))."</code> <span class='time'>(".format_time($eh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($I)."'>".lang(10)."</a>":"").$K;}function
sqlCommandQuery($I){return
shorten_utf8(trim($I),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$M,array$Sc){return$M;}function
selectLink($X,array$m){}function
selectVal($X,$_,array$m,$xf){$K=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$m["type"])&&!preg_match("~var~",$m["type"])?"<code>$X</code>":(preg_match('~json~',$m["type"])?"<code class='jush-js'>$X</code>":$X)));if(preg_match('~blob|bytea|raw|file~',$m["type"])&&!is_utf8($X))$K="<i>".lang(36,strlen($xf))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$K</a>":$K);}function
editVal($X,array$m){return$X;}function
config(){return
array();}function
tableStructurePrint(array$n,$qh=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(37)."<td>".lang(38).(support("comment")?"<td>".lang(39):"")."</thead>\n";$jh=driver()->structuredTypes();foreach($n
as$m){echo"<tr><th>".h($m["field"]);$U=h($m["full_type"]);$db=h($m["collation"]);echo"<td><span title='$db'>".(in_array($U,(array)$jh[lang(40)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($db&&isset($qh["Collation"])&&$db!=$qh["Collation"]?" $db":""))."</span>",($m["null"]?" <i>NULL</i>":""),($m["auto_increment"]?" <i>".lang(41)."</i>":"");$k=h($m["default"]);echo(isset($m["default"])?" <span title='".lang(42)."'>[<b>".($m["generated"]?"<code class='jush-".JUSH."'>$k</code>":$k)."</b>]</span>":""),(support("comment")?"<td>".h($m["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x){echo"<table>\n";foreach($x
as$D=>$w){ksort($w["columns"]);$Zf=array();foreach($w["columns"]as$y=>$X)$Zf[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($D)."'><th>$w[type]<td>".implode(", ",$Zf)."\n";}echo"</table>\n";}function
selectColumnsPrint(array$O,array$d){print_fieldset("select",lang(43),$O);$t=0;$O[""]=array();foreach($O
as$y=>$X){$X=idx($_GET["columns"],$y,array());$c=select_input(" name='columns[$t][col]'",$d,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(44)=>driver()->functions,lang(45)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($c)":$c)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$d,array$x){print_fieldset("search",lang(46),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Pa="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(47).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Pa),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Pa }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$nf,array$d,array$x){print_fieldset("sort",lang(48),$nf);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$d,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(49))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$d,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(49))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(50)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Dh){if($Dh!==null)echo"<fieldset><legend>".lang(51)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Dh)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(52)."</legend><div>","<input type='submit' value='".lang(43)."'>"," <span id='noindex' title='".lang(53)."'></span>","<script".nonce().">\n","const indexColumns = ";$d=array();foreach($x
as$w){$zb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$zb)$d[$zb]=1;}$d[""]=1;foreach($d
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$hc,array$d){}function
selectColumnsProcess(array$d,array$x){$O=array();$s=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$O[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$s[]=$O[$y];}}return
array($O,$s);}function
selectSearchProcess(array$n,array$x){$K=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$K[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$Wf="";$kb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Ad=process_length($X["val"]);$kb
.=" ".($Ad!=""?$Ad:"(NULL)");}elseif($X["op"]=="SQL")$kb=" $X[val]";elseif($X["op"]=="LIKE %%")$kb=" LIKE ".adminer()->processInput(idx($n,$X["col"],array()),"%$X[val]%");elseif($X["op"]=="ILIKE %%")$kb=" ILIKE ".adminer()->processInput($n[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Wf="$X[op](".q($X["val"]).", ";$kb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$kb
.=" ".adminer()->processInput($n[$X["col"]],$X["val"]);if($X["col"]!="")$K[]=$Wf.driver()->convertSearch(idf_escape($X["col"]),$X,$n[$X["col"]]).$kb;else{$eb=array();foreach($n
as$D=>$m){if(isset($m["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$m["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$m["type"]))&&(!preg_match('~date|timestamp~',$m["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$eb[]=$Wf.driver()->convertSearch(idf_escape($D),$X,$m).$kb;}$K[]=($eb?"(".implode(" OR ",$eb).")":"1 = 0");}}}return$K;}function
selectOrderProcess(array$n,array$x){$K=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$K[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$K;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$Sc){return
false;}function
selectQueryBuild(array$O,array$Z,array$s,array$nf,$z,$F){return"";}function
messageQuery($I,$Eh,$Fc=false){restart_session();$qd=&get_session("queries");if(!idx($qd,$_GET["db"]))$qd[$_GET["db"]]=array();if(strlen($I)>1e6)$I=preg_replace('~[\x80-\xFF]+$~','',substr($I,0,1e6))."\n…";$qd[$_GET["db"]][]=array($I,time(),$Eh);$bh="sql-".count($qd[$_GET["db"]]);$K="<a href='#$bh' class='toggle'>".lang(54)."</a>\n";if(!$Fc&&($yi=driver()->warnings())){$u="warnings-".count($qd[$_GET["db"]]);$K="<a href='#$u' class='toggle'>".lang(35)."</a>, $K<div id='$u' class='hidden'>\n$yi</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $K<div id='$bh' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($I,1000)."</code></pre>".($Eh?" <span class='time'>($Eh)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($qd[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$n,$L,$hi){}function
editFunctions(array$m){$K=($m["null"]?"NULL/":"");$hi=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$Zc){if(!$y||(!isset($_GET["call"])&&$hi)){foreach($Zc
as$Kf=>$X){if(!$Kf||preg_match("~$Kf~",$m["type"]))$K
.="/$X";}}if($y&&$Zc&&!preg_match('~set|blob|bytea|raw|file|bool~',$m["type"]))$K
.="/SQL";}if($m["auto_increment"]&&!$hi)$K=lang(41);return
explode("/",$K);}function
editInput($R,array$m,$wa,$Y){if($m["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$wa value='-1' checked><i>".lang(8)."</i></label> ":"").($m["null"]?"<label><input type='radio'$wa value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$wa,$m,$Y,$Y===0?0:null);return"";}function
editHint($R,array$m,$Y){return"";}function
processInput(array$m,$Y,$r=""){if($r=="SQL")return$Y;$D=$m["field"];$K=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$K="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$K=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$K=idf_escape($D)." $r $K";elseif(preg_match('~^[+-] interval$~',$r))$K=idf_escape($D)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$K);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$K="$r(".idf_escape($D).", $K)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$K="$r($K)";return
unconvert_field($m,$K);}function
dumpOutput(){$K=array('text'=>lang(55),'file'=>lang(56));if(function_exists('gzencode'))$K['gz']='gzip';return$K;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($R,$kh,$Sd=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($kh)dump_csv(array_keys(fields($R)));}else{if($Sd==2){$n=array();foreach(fields($R)as$D=>$m)$n[]=idf_escape($D)." $m[full_type]";$h="CREATE TABLE ".table($R)." (".implode(", ",$n).")";}else$h=create_sql($R,$_POST["auto_increment"],$kh);set_utf8mb4($h);if($kh&&$h){if($kh=="DROP+CREATE"||$Sd==1)echo"DROP ".($Sd==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($Sd==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($R,$kh,$I){if($kh){$ue=(JUSH=="sqlite"?0:1048576);$n=array();$yd=false;if($_POST["format"]=="sql"){if($kh=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$n=fields($R);if(JUSH=="mssql"){foreach($n
as$m){if($m["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$yd=true;break;}}}}$J=connection()->query($I,1);if($J){$Id="";$La="";$Wd=array();$ad=array();$mh="";$Ic=($R!=''?'fetch_assoc':'fetch_row');$sb=0;while($L=$J->$Ic()){if(!$Wd){$qi=array();foreach($L
as$X){$m=$J->fetch_field();if(idx($n[$m->name],'generated')){$ad[$m->name]=true;continue;}$Wd[]=$m->name;$y=idf_escape($m->name);$qi[]="$y = VALUES($y)";}$mh=($kh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$qi):"").";\n";}if($_POST["format"]!="sql"){if($kh=="table"){dump_csv($Wd);$kh="INSERT";}dump_csv($L);}else{if(!$Id)$Id="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$Wd)).") VALUES";foreach($L
as$y=>$X){if($ad[$y]){unset($L[$y]);continue;}$m=$n[$y];$L[$y]=($X!==null?unconvert_field($m,preg_match(number_type(),$m["type"])&&!preg_match('~\[~',$m["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$N=($ue?"\n":" ")."(".implode(",\t",$L).")";if(!$La)$La=$Id.$N;elseif(JUSH=='mssql'?$sb%1000!=0:strlen($La)+4+strlen($N)+strlen($mh)<$ue)$La
.=",$N";else{echo$La.$mh;$La=$Id.$N;}}$sb++;}if($La)echo$La.$mh;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($yd)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($xd){return
friendly_url($xd!=""?$xd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($xd,$Ke=false){$zf=$_POST["output"];$Ac=(preg_match('~sql~',$_POST["format"])?"sql":($Ke?"tar":"csv"));header("Content-Type: ".($zf=="gz"?"application/x-gzip":($Ac=="tar"?"application/x-tar":($Ac=="sql"||$zf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($zf=="gz"){ob_start(function($ih){return
gzencode($ih);},1e6);}return$Ac;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(57)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(58):lang(59))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(60)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(61)."</a>\n":"");return
true;}function
navigation($He){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Se=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Se)<0?h($Se):"")."</a>","</span></h1>\n";switch_lang();if($He=="auth"){$zf="";foreach((array)$_SESSION["pwds"]as$si=>$Og){foreach($Og
as$P=>$oi){$D=h(get_setting("vendor-$si-$P")?:get_driver($si));foreach($oi
as$V=>$G){if($G!==null){$Fb=$_SESSION["db"][$si][$P][$V];foreach(($Fb?array_keys($Fb):array(""))as$j)$zf
.="<li><a href='".h(auth_url($si,$P,$V,$j))."'>($D) ".h($V.($P!=""?"@".adminer()->serverName($P):"").($j!=""?" - $j":""))."</a>\n";}}}}if($zf)echo"<ul id='logins'>\n$zf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$He&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($He);$ha=array();if(DB==""||!$He){if(support("sql")){$ha[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(54)."</a>";$ha[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(62)."</a>";}$ha[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(63)."</a>";}$Bd=$_GET["ns"]!==""&&!$He&&DB!="";if($Bd)$ha[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(64)."</a>";echo($ha?"<p class='links'>\n".implode("\n",$ha)."\n":"");if($Bd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.2.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$me=array();foreach($T
as$R=>$U)$me[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.": [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$me).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$vh=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$n){foreach($n
as$m)$vh[$R][]=$m["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($vh)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($He){$i=adminer()->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Db=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(26)."'>".lang(65).": ".($i?html_select("db",array(""=>"")+$i,DB).$Db:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($i?" class='hidden'":"").">\n";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$fh){$D=adminer()->tableName($fh);if($D!="")echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(30)."'>".lang(66)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($fh)?"view":"structure"))." title='".lang(31)."'>$D</a>":"<span>$D</span>")."\n";}echo"</ul>\n";}}class
Plugins{private
static$ra=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Pf){if($Pf===null){$Pf=array();$Fa="adminer-plugins";if(is_dir($Fa)){foreach(glob("$Fa/*.php")as$o)$Cd=include_once"./$o";}$pd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Fa.php")){$Cd=include_once"./$Fa.php";if(is_array($Cd)){foreach($Cd
as$Of)$Pf[get_class($Of)]=$Of;}else$this->error
.=lang(67,"<b>$Fa.php</b>",$pd)."<br>";}foreach(get_declared_classes()as$Ya){if(!$Pf[$Ya]&&preg_match('~^Adminer\w~i',$Ya)){$qg=new
\ReflectionClass($Ya);$mb=$qg->getConstructor();if($mb&&$mb->getNumberOfRequiredParameters())$this->error
.=lang(68,$pd,"<b>$Ya</b>","<b>$Fa.php</b>")."<br>";else$Pf[$Ya]=new$Ya;}}}$this->plugins=$Pf;$ia=new
Adminer;$Pf[]=$ia;$qg=new
\ReflectionObject($ia);foreach($qg->getMethods()as$Fe){foreach($Pf
as$Of){$D=$Fe->getName();if(method_exists($Of,$D))$this->hooks[$D][]=$Of;}}}function
__call($D,array$Cf){$sa=array();foreach($Cf
as$y=>$X)$sa[]=&$Cf[$y];$K=null;foreach($this->hooks[$D]as$Of){$Y=call_user_func_array(array($Of,$D),$sa);if($Y!==null){if(!self::$ra[$D])return$Y;$K=$Y+(array)$K;}}return$K;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$E=null){$sa=func_get_args();$sa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$sa);}}Adminer::$Kd=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$Vb=array("server"=>"MySQL / MariaDB")+SqlDriver::$Vb;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$Kd;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($P,$V,$G){mysqli_report(MYSQLI_REPORT_OFF);list($td,$Qf)=explode(":",$P,2);$dh=adminer()->connectSsl();if($dh)$this->ssl_set($dh['key'],$dh['cert'],$dh['ca'],'','');$K=@$this->real_connect(($P!=""?$td:ini_get("mysqli.default_host")),($P.$V!=""?$V:ini_get("mysqli.default_user")),($P.$V.$G!=""?$G:ini_get("mysqli.default_pw")),null,(is_numeric($Qf)?intval($Qf):ini_get("mysqli.default_port")),(is_numeric($Qf)?$Qf:null),($dh?($dh['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return($K?'':$this->error);}function
set_charset($Ra){if(parent::set_charset($Ra))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ra");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($ih){return"'".$this->escape_string($ih)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($P,$V,$G){if(ini_bool("mysql.allow_local_infile"))return
lang(69,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($P!=""?$P:ini_get("mysql.default_host")),("$P$V"!=""?$V:ini_get("mysql.default_user")),("$P$V$G"!=""?$G:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Ra){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ra,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Ra");}function
quote($ih){return"'".mysql_real_escape_string($ih,$this->link)."'";}function
select_db($Cb){return
mysql_select_db($Cb,$this->link);}function
query($I,$ai=false){$J=@($ai?mysql_unbuffered_query($I,$this->link):mysql_query($I,$this->link));$this->error="";if(!$J){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($J===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($J);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($J){$this->result=$J;$this->num_rows=mysql_num_rows($J);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$K=mysql_fetch_field($this->result,$this->offset++);$K->orgtable=$K->table;$K->charsetnr=($K->blob?63:0);return$K;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($P,$V,$G){$lf=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$dh=adminer()->connectSsl();if($dh){if($dh['key'])$lf[\PDO::MYSQL_ATTR_SSL_KEY]=$dh['key'];if($dh['cert'])$lf[\PDO::MYSQL_ATTR_SSL_CERT]=$dh['cert'];if($dh['ca'])$lf[\PDO::MYSQL_ATTR_SSL_CA]=$dh['ca'];if(isset($dh['verify']))$lf[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$dh['verify'];}return$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$P)),$V,$G,$lf);}function
set_charset($Ra){return$this->query("SET NAMES $Ra");}function
select_db($Cb){return$this->query("USE ".idf_escape($Cb));}function
query($I,$ai=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$ai);return
parent::query($I,$ai);}}}class
Driver
extends
SqlDriver{static$Cc=array("MySQLi","MySQL","PDO_MySQL");static$Ud="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($P,$V,$G){$f=parent::connect($P,$V,$G);if(is_string($f)){if(function_exists('iconv')&&!is_utf8($f)&&strlen($N=iconv("windows-1250","utf-8",$f))>strlen($f))$f=$N;return$f;}$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");$f->flavor=(preg_match('~MariaDB~',$f->server_info)?'maria':'mysql');add_driver(DRIVER,($f->flavor=='maria'?"MariaDB":"MySQL"));return$f;}function
__construct(Db$f){parent::__construct($f);$this->types=array(lang(70)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(71)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(72)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(73)=>array("enum"=>65535,"set"=>64),lang(74)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(75)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$f))$this->types[lang(72)]["json"]=4294967295;if(min_version('',10.7,$f)){$this->types[lang(72)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$f)){$this->types[lang(70)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.7,10.2,$f))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$m){return(preg_match("~binary~",$m["type"])?"<code class='jush-sql'>UNHEX</code>":($m["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$m["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$Q){return($Q?parent::insert($R,$Q):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$M,array$Yf){$d=array_keys(reset($M));$Wf="INSERT INTO ".table($R)." (".implode(", ",$d).") VALUES\n";$qi=array();foreach($d
as$y)$qi[$y]="$y = VALUES($y)";$mh="\nON DUPLICATE KEY UPDATE ".implode(", ",$qi);$qi=array();$je=0;foreach($M
as$Q){$Y="(".implode(", ",$Q).")";if($qi&&(strlen($Wf)+$je+strlen($Y)+strlen($mh)>1e6)){if(!queries($Wf.implode(",\n",$qi).$mh))return
false;$qi=array();$je=0;}$qi[]=$Y;$je+=strlen($Y)+2;}return
queries($Wf.implode(",\n",$qi).$mh);}function
slowQuery($I,$Fh){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Fh FOR $I";elseif(preg_match('~^(SELECT\b)(.+)~is',$I,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($Fh*1000).") */ $B[2]";}}function
convertSearch($v,array$X,array$m){return(preg_match('~char|text|enum|set~',$m["type"])&&!preg_match("~^utf8~",$m["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$J=$this->conn->query("SHOW WARNINGS");if($J&&$J->num_rows){ob_start();print_select_result($J);return
ob_get_clean();}}function
tableHelp($D,$Sd=false){$pe=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($pe?"$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($pe?"mysql$D-table/":"system-schema.html");}function
hasCStyleEscapes(){static$Ma;if($Ma===null){$ch=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Ma=(strpos($ch,'NO_BACKSLASH_ESCAPES')===false);}return$Ma;}function
engines(){$K=array();foreach(get_rows("SHOW ENGINES")as$L){if(preg_match("~YES|DEFAULT~",$L["Support"]))$K[]=$L["Engine"];}return$K;}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($Pc){$K=get_session("dbs");if($K===null){$I="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$K=($Pc?slow_query($I):get_vals($I));restart_session();set_session("dbs",$K);stop_session();}return$K;}function
limit($I,$Z,$z,$Ye=0,$Mg=" "){return" $I$Z".($z?$Mg."LIMIT $z".($Ye?" OFFSET $Ye":""):"");}function
limit1($R,$I,$Z,$Mg="\n"){return
limit($I,$Z,1,0,$Mg);}function
db_collation($j,array$b){$K=null;$h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$B))$K=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$B))$K=$b[$B[1]][-1];return$K;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$i){$K=array();foreach($i
as$j)$K[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$K;}function
table_status($D="",$Gc=false){$K=array();foreach(get_rows($Gc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$L){if($L["Engine"]=="InnoDB")$L["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$L["Comment"]);if(!isset($L["Engine"]))$L["Comment"]="";if($D!="")$L["Name"]=$D;$K[$L["Name"]]=$L;}return$K;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$pe=(connection()->flavor=='maria');$K=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$L){$m=$L["COLUMN_NAME"];$U=$L["COLUMN_TYPE"];$bd=$L["GENERATION_EXPRESSION"];$Dc=$L["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Dc,$ad);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$re);$k=$L["COLUMN_DEFAULT"];if($k!=""){$Rd=preg_match('~text|json~',$re[1]);if(!$pe&&$Rd)$k=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($k));if($pe||$Rd){$k=($k=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($B){return
stripslashes(str_replace("''","'",$B[1]));},$k));}if(!$pe&&preg_match('~binary~',$re[1])&&preg_match('~^0x(\w*)$~',$k,$B))$k=pack("H*",$B[1]);}$K[$m]=array("field"=>$m,"full_type"=>$U,"type"=>$re[1],"length"=>$re[2],"unsigned"=>ltrim($re[3].$re[4]),"default"=>($ad?($pe?$bd:stripslashes($bd)):$k),"null"=>($L["IS_NULLABLE"]=="YES"),"auto_increment"=>($Dc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Dc,$B)?$B[1]:""),"collation"=>$L["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$L[PRIVILEGES],where,order")),"comment"=>$L["COLUMN_COMMENT"],"primary"=>($L["COLUMN_KEY"]=="PRI"),"generated"=>($ad[1]=="PERSISTENT"?"STORED":$ad[1]),);}return$K;}function
indexes($R,$g=null){$K=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$g)as$L){$D=$L["Key_name"];$K[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($L["Index_type"]=="FULLTEXT"?"FULLTEXT":($L["Non_unique"]?($L["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$K[$D]["columns"][]=$L["Column_name"];$K[$D]["lengths"][]=($L["Index_type"]=="SPATIAL"?null:$L["Sub_part"]);$K[$D]["descs"][]=null;}return$K;}function
foreign_keys($R){static$Kf='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$K=array();$tb=get_val("SHOW CREATE TABLE ".table($R),1);if($tb){preg_match_all("~CONSTRAINT ($Kf) FOREIGN KEY ?\\(((?:$Kf,? ?)+)\\) REFERENCES ($Kf)(?:\\.($Kf))? \\(((?:$Kf,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$tb,$se,PREG_SET_ORDER);foreach($se
as$B){preg_match_all("~$Kf~",$B[2],$Xg);preg_match_all("~$Kf~",$B[5],$zh);$K[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('Adminer\idf_unescape',$Xg[0]),"target"=>array_map('Adminer\idf_unescape',$zh[0]),"on_delete"=>($B[6]?:"RESTRICT"),"on_update"=>($B[7]?:"RESTRICT"),);}}return$K;}function
view($D){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$K=array();foreach(get_rows("SHOW COLLATION")as$L){if($L["Default"])$K[$L["Charset"]][-1]=$L["Collation"];else$K[$L["Charset"]][]=$L["Collation"];}ksort($K);foreach($K
as$y=>$X)sort($K[$y]);return$K;}function
information_schema($j){return($j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($j,$db){return
queries("CREATE DATABASE ".idf_escape($j).($db?" COLLATE ".q($db):""));}function
drop_databases(array$i){$K=apply_queries("DROP DATABASE",$i,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$K;}function
rename_database($D,$db){$K=false;if(create_database($D,$db)){$T=array();$vi=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$vi[]=$R;else$T[]=$R;}$K=(!$T&&!$vi)||move_tables($T,$vi,$D);drop_databases($K?array(DB):array());}return$K;}function
auto_increment(){$za=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$za="";break;}if($w["type"]=="PRIMARY")$za=" UNIQUE";}}return" AUTO_INCREMENT$za";}function
alter_table($R,$D,array$n,array$Rc,$hb,$kc,$db,$ya,$Gf){$qa=array();foreach($n
as$m){if($m[1]){$k=$m[1][3];if(preg_match('~ GENERATED~',$k)){$m[1][3]=(connection()->flavor=='maria'?"":$m[1][2]);$m[1][2]=$k;}$qa[]=($R!=""?($m[0]!=""?"CHANGE ".idf_escape($m[0]):"ADD"):" ")." ".implode($m[1]).($R!=""?$m[2]:"");}else$qa[]="DROP ".idf_escape($m[0]);}$qa=array_merge($qa,$Rc);$fh=($hb!==null?" COMMENT=".q($hb):"").($kc?" ENGINE=".q($kc):"").($db?" COLLATE ".q($db):"").($ya!=""?" AUTO_INCREMENT=$ya":"");if($R=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$qa)."\n)$fh$Gf");if($R!=$D)$qa[]="RENAME TO ".table($D);if($fh)$qa[]=ltrim($fh);return($qa||$Gf?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$qa).$Gf):true);}function
alter_indexes($R,$qa){$Qa=array();foreach($qa
as$X)$Qa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Qa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$vi){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$vi)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$vi,$zh){$tg=array();foreach($T
as$R)$tg[]=table($R)." TO ".idf_escape($zh).".".table($R);if(!$tg||queries("RENAME TABLE ".implode(", ",$tg))){$Kb=array();foreach($vi
as$R)$Kb[table($R)]=view($R);connection()->select_db($zh);$j=idf_escape(DB);foreach($Kb
as$D=>$ui){if(!queries("CREATE VIEW $D AS ".str_replace(" $j."," ",$ui["select"]))||!queries("DROP VIEW $j.$D"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$vi,$zh){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$D=($zh==DB?table("copy_$R"):idf_escape($zh).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($R))||!queries("INSERT INTO $D SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$L){$Uh=$L["Trigger"];if(!queries("CREATE TRIGGER ".($zh==DB?idf_escape("copy_$Uh"):idf_escape($zh).".".idf_escape($Uh))." $L[Timing] $L[Event] ON $D FOR EACH ROW\n$L[Statement];"))return
false;}}foreach($vi
as$R){$D=($zh==DB?table("copy_$R"):idf_escape($zh).".".table($R));$ui=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $ui[select]"))return
false;}return
true;}function
trigger($D,$R){if($D=="")return
array();$M=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($M);}function
triggers($R){$K=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$L)$K[$L["Trigger"]]=array($L["Timing"],$L["Event"]);return$K;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$U){$oa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Yg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$mc=driver()->enumLength;$Yh="((".implode("|",array_merge(array_keys(driver()->types()),$oa)).")\\b(?:\\s*\\(((?:[^'\")]|$mc)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Kf="$Yg*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Yh";$h=get_val("SHOW CREATE $U ".idf_escape($D),2);preg_match("~\\(((?:$Kf\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Yh\\s+":"")."(.*)~is",$h,$B);$n=array();preg_match_all("~$Kf\\s*,?~is",$B[1],$se,PREG_SET_ORDER);foreach($se
as$Bf)$n[]=array("field"=>str_replace("``","`",$Bf[2]).$Bf[3],"type"=>strtolower($Bf[5]),"length"=>preg_replace_callback("~$mc~s",'Adminer\normalize_enum',$Bf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Bf[8] $Bf[7]"))),"null"=>true,"full_type"=>$Bf[4],"inout"=>strtoupper($Bf[1]),"collation"=>strtolower($Bf[9]),);return
array("fields"=>$n,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($D)),)+($U!="FUNCTION"?array("definition"=>$B[11]):array("returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($D,array$L){return
idf_escape($D);}function
last_id($J){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$f,$I){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$I);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$ya,$kh){$K=get_val("SHOW CREATE TABLE ".table($R),1);if(!$ya)$K=preg_replace('~ AUTO_INCREMENT=\d+~','',$K);return$K;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Cb){return"USE ".idf_escape($Cb);}function
trigger_sql($R){$K="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$L)$K
.="\nCREATE TRIGGER ".idf_escape($L["Trigger"])." $L[Timing] $L[Event] ON ".table($L["Table"])." FOR EACH ROW\n$L[Statement];;\n";return$K;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$m){if(preg_match("~binary~",$m["type"]))return"HEX(".idf_escape($m["field"]).")";if($m["type"]=="bit")return"BIN(".idf_escape($m["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($m["field"]).")";}function
unconvert_field(array$m,$K){if(preg_match("~binary~",$m["type"]))$K="UNHEX($K)";if($m["type"]=="bit")$K="CONVERT(b$K, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"])){$Wf=(min_version(8)?"ST_":"");$K=$Wf."GeomFromText($K, $Wf"."SRID($m[field]))";}return$K;}function
support($Hc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning")).(min_version('8.0.16','10.2.1')?"":"|check")."~",$Hc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Dg,$g=null){return
true;}}define('Adminer\JUSH',Driver::$Ud);define('Adminer\SERVER',$_GET[DRIVER]);define('Adminer\DB',$_GET["db"]);define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Hh,$l="",$Ka=array(),$Ih=""){page_headers();if(is_ajax()&&$l){page_messages($l);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Jh=$Hh.($Ih!=""?": $Ih":"");$Kh=strip_tags($Jh.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(76),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Kh,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.2.0"),'">
';$xb=adminer()->css();$md=false;$kd=false;foreach($xb
as$o){if(strpos($o,"adminer.css")!==false)$md=true;if(strpos($o,"adminer-dark.css")!==false)$kd=true;}$_b=($md?($kd?null:false):($kd?:null));$_e=" media='(prefers-color-scheme: dark)'";if($_b!==false)echo"<link rel='stylesheet'".($_b?"":$_e)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.2.0")."'>\n";echo"<meta name='color-scheme' content='".($_b===null?"light dark":($_b?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.2.0");if(adminer()->head($_b))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.2.0")."'>\n";foreach($xb
as$X)echo"<link rel='stylesheet'".(preg_match('~-dark\.~',$X)&&!$_b?$_e:"")." href='".h($X)."'>\n";echo"\n<body class='".lang(76)." nojs'>\n";$o=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($o)&&filemtime($o)+86400>time()){$ti=unserialize(file_get_contents($o));$fg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($ti["version"],base64_decode($ti["signature"]),$fg)==1)$_COOKIE["adminer_version"]=$ti["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(77))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Ka!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$P=adminer()->serverName(SERVER);$P=($P!=""?$P:lang(23));if($Ka===false)echo"$P\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$P</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ka)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Ka)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Ka
as$y=>$X){$Mb=(is_array($X)?$X[1]:h($X));if($Mb!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$Mb</a> » ";}}echo"$Hh\n";}}echo"<h2>$Jh</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($l);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$wb){$nd=array();foreach($wb
as$y=>$X)$nd[]="$y $X";header("Content-Security-Policy: ".implode("; ",$nd));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Ue;if(!$Ue)$Ue=base64_encode(rand_string());return$Ue;}function
page_messages($l){$ii=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Ee=idx($_SESSION["messages"],$ii);if($Ee){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Ee)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$ii]);}if($l)echo"<div class='error'>$l</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($He=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($He);echo"</div>\n";if($He!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(78),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Me){while($Me>=2147483648)$Me-=4294967296;while($Me<=-2147483649)$Me+=4294967296;return(int)$Me;}function
long2str(array$W,$xi){$N='';foreach($W
as$X)$N
.=pack('V',$X);if($xi)return
substr($N,0,end($W));return$N;}function
str2long($N,$xi){$W=array_values(unpack('V*',str_pad($N,4*ceil(strlen($N)/4),"\0")));if($xi)$W[]=strlen($N);return$W;}function
xxtea_mx($Di,$Ci,$nh,$Vd){return
int32((($Di>>5&0x7FFFFFF)^$Ci<<2)+(($Ci>>3&0x1FFFFFFF)^$Di<<4))^int32(($nh^$Ci)+($Vd^$Di));}function
encrypt_string($hh,$y){if($hh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($hh,true);$Me=count($W)-1;$Di=$W[$Me];$Ci=$W[0];$H=floor(6+52/($Me+1));$nh=0;while($H-->0){$nh=int32($nh+0x9E3779B9);$bc=$nh>>2&3;for($_f=0;$_f<$Me;$_f++){$Ci=$W[$_f+1];$Le=xxtea_mx($Di,$Ci,$nh,$y[$_f&3^$bc]);$Di=int32($W[$_f]+$Le);$W[$_f]=$Di;}$Ci=$W[0];$Le=xxtea_mx($Di,$Ci,$nh,$y[$_f&3^$bc]);$Di=int32($W[$Me]+$Le);$W[$Me]=$Di;}return
long2str($W,false);}function
decrypt_string($hh,$y){if($hh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($hh,false);$Me=count($W)-1;$Di=$W[$Me];$Ci=$W[0];$H=floor(6+52/($Me+1));$nh=int32($H*0x9E3779B9);while($nh){$bc=$nh>>2&3;for($_f=$Me;$_f>0;$_f--){$Di=$W[$_f-1];$Le=xxtea_mx($Di,$Ci,$nh,$y[$_f&3^$bc]);$Ci=int32($W[$_f]-$Le);$W[$_f]=$Ci;}$Di=$W[$Me];$Le=xxtea_mx($Di,$Ci,$nh,$y[$_f&3^$bc]);$Ci=int32($W[0]-$Le);$W[0]=$Ci;$nh=int32($nh-0x9E3779B9);}return
long2str($W,true);}$Mf=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Mf[$y]=$X;}}function
add_invalid_login(){$Da=get_temp_dir()."/adminer.invalid";foreach(glob("$Da*")?:array($Da)as$o){$q=file_open_lock($o);if($q)break;}if(!$q)$q=file_open_lock("$Da-".rand_string());if(!$q)return;$Nd=unserialize(stream_get_contents($q));$Eh=time();if($Nd){foreach($Nd
as$Od=>$X){if($X[0]<$Eh)unset($Nd[$Od]);}}$Md=&$Nd[adminer()->bruteForceKey()];if(!$Md)$Md=array($Eh+30*60,0);$Md[1]++;file_write_unlock($q,serialize($Nd));}function
check_invalid_login(array&$Mf){$Nd=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$o){$q=file_open_lock($o);if($q){$Nd=unserialize(stream_get_contents($q));file_unlock($q);break;}}$Md=idx($Nd,adminer()->bruteForceKey(),array());$Te=($Md[1]>29?$Md[0]-time():0);if($Te>0)auth_error(lang(79,ceil($Te/60)),$Mf);}$xa=$_POST["auth"];if($xa){session_regenerate_id();$si=$xa["driver"];$P=$xa["server"];$V=$xa["username"];$G=(string)$xa["password"];$j=$xa["db"];set_password($si,$P,$V,$G);$_SESSION["db"][$si][$P][$V][$j]=true;if($xa["permanent"]){$y=implode("-",array_map('base64_encode',array($si,$P,$V,$j)));$ag=adminer()->permanentLogin(true);$Mf[$y]="$y:".base64_encode($ag?encrypt_string($G,$ag):"");cookie("adminer_permanent",implode(" ",$Mf));}if(count($_POST)==1||DRIVER!=$si||SERVER!=$P||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($si,$P,$V,$j));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Mf);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(80).' '.lang(81));}elseif($Mf&&!$_SESSION["pwds"]){session_regenerate_id();$ag=adminer()->permanentLogin();foreach($Mf
as$y=>$X){list(,$Xa)=explode(":",$X);list($si,$P,$V,$j)=array_map('base64_decode',explode("-",$y));set_password($si,$P,$V,decrypt_string(base64_decode($Xa),$ag));$_SESSION["db"][$si][$P][$V][$j]=true;}}function
unset_permanent(array&$Mf){foreach($Mf
as$y=>$X){list($si,$P,$V,$j)=array_map('base64_decode',explode("-",$y));if($si==DRIVER&&$P==SERVER&&$V==$_GET["username"]&&$j==DB)unset($Mf[$y]);}cookie("adminer_permanent",implode(" ",$Mf));}function
auth_error($l,array&$Mf){$Pg=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Pg]||$_GET[$Pg])&&!$_SESSION["token"])$l=lang(82);else{restart_session();add_invalid_login();$G=get_password();if($G!==null){if($G===false)$l
.=($l?'<br>':'').lang(83,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Mf);}}if(!$_COOKIE[$Pg]&&$_GET[$Pg]&&ini_bool("session.use_only_cookies"))$l=lang(84);$Cf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$Cf["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(27),$l,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(85)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Mf);page_header(lang(86),lang(87,implode(", ",Driver::$Cc)),false);page_footer("auth");exit;}$f='';if(isset($_GET["username"])&&is_string(get_password())){list($td,$Qf)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Qf,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(88),$Mf);check_invalid_login($Mf);$vb=adminer()->credentials();$f=Driver::connect($vb[0],$vb[1],$vb[2]);if(is_object($f)){Db::$Kd=$f;Driver::$Kd=new
Driver($f);if($f->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$ne=null;if(!is_object($f)||($ne=adminer()->login($_GET["username"],get_password()))!==true){$l=(is_string($f)?nl_br(h($f)):(is_string($ne)?$ne:lang(89))).(preg_match('~^ | $~',get_password())?'<br>'.lang(90):'');auth_error($l,$Mf);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(78),lang(91));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($xa&&$_POST["token"])$_POST["token"]=get_token();$l='';if($_POST){if(!verify_token()){$Fd="max_input_vars";$ye=ini_get($Fd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$ye||$X<$ye)){$Fd=$y;$ye=$X;}}}$l=(!$_POST["token"]&&$ye?lang(92,"'$Fd'"):lang(91).' '.lang(93));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$l=lang(94,"'post_max_size'");if(isset($_GET["sql"]))$l
.=' '.lang(95);}function
print_select_result($J,$g=null,array$rf=array(),$z=0){$me=array();$x=array();$d=array();$Ia=array();$Zh=array();$K=array();for($t=0;(!$z||$t<$z)&&($L=$J->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($Td=0;$Td<count($L);$Td++){$m=$J->fetch_field();$D=$m->name;$qf=(isset($m->orgtable)?$m->orgtable:"");$pf=(isset($m->orgname)?$m->orgname:$D);if($rf&&JUSH=="sql")$me[$Td]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($qf!=""){if(isset($m->table))$K[$m->table]=$qf;if(!isset($x[$qf])){$x[$qf]=array();foreach(indexes($qf,$g)as$w){if($w["type"]=="PRIMARY"){$x[$qf]=array_flip($w["columns"]);break;}}$d[$qf]=$x[$qf];}if(isset($d[$qf][$pf])){unset($d[$qf][$pf]);$x[$qf][$pf]=$Td;$me[$Td]=$qf;}}if($m->charsetnr==63)$Ia[$Td]=true;$Zh[$Td]=$m->type;echo"<th".($qf!=""||$m->name!=$pf?" title='".h(($qf!=""?"$qf.":"").$pf)."'":"").">".h($D).($rf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($L
as$y=>$X){$_="";if(isset($me[$y])&&!$d[$me[$y]]){if($rf&&JUSH=="sql"){$R=$L[array_search("table=",$me)];$_=ME.$me[$y].urlencode($rf[$R]!=""?$rf[$R]:$R);}else{$_=ME."edit=".urlencode($me[$y]);foreach($x[$me[$y]]as$bb=>$Td)$_
.="&where".urlencode("[".bracket_escape($bb)."]")."=".urlencode($L[$Td]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ia[$y]&&!is_utf8($X))$X="<i>".lang(36,strlen($X))."</i>";else{$X=h($X);if($Zh[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($Zh[$y]<=9||$Zh[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$K;}function
referencable_primary($Kg){$K=array();foreach(table_status('',true)as$rh=>$R){if($rh!=$Kg&&fk_support($R)){foreach(fields($rh)as$m){if($m["primary"]){if($K[$rh]){unset($K[$rh]);break;}$K[$rh]=$m;}}}}return$K;}function
textarea($D,$Y,$M=10,$eb=80){echo"<textarea name='".h($D)."' rows='$M' cols='$eb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($wa,array$lf,$Y="",$gf="",$Nf=""){$yh=($lf?"select":"input");return"<$yh$wa".($lf?"><option value=''>$Nf".optionlist($lf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Nf'>").($gf?script("qsl('$yh').onchange = $gf;",""):"");}function
json_row($y,$X=null){static$Mc=true;if($Mc)echo"{";if($y!=""){echo($Mc?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Mc=false;}else{echo"\n}\n";$Mc=true;}}function
edit_type($y,array$m,array$b,array$Tc=array(),array$Ec=array()){$U=$m["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($Tc[$U])&&!in_array($U,$Ec))$Ec[]=$U;$jh=driver()->structuredTypes();if($Tc)$jh[lang(96)]=$Tc;echo
optionlist(array_merge($Ec,$jh),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($m["length"])."' size='3'".(!$m["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($b?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($m["collation"])."' placeholder='(".lang(97).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$m["unsigned"]).'</select>':''),(isset($m['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(98).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"CURRENT_TIMESTAMP":$m["on_update"])).'</select>':''),($Tc?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(99).")".optionlist(explode("|",driver()->onActions),$m["on_delete"])."</select> ":" ");}function
get_partitions_info($R){$Xc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$J=connection()->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $Xc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$K=array();list($K["partition_by"],$K["partition"],$K["partitions"])=$J->fetch_row();$Hf=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Xc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$K["partition_names"]=array_keys($Hf);$K["partition_values"]=array_values($Hf);return$K;}function
process_length($je){$oc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$oc(?:\\s*,\\s*$oc)*+\\s*\\)?\\s*\$~",$je)&&preg_match_all("~$oc~",$je,$se)?"(".implode(",",$se[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$je)));}function
process_type(array$m,$cb="COLLATE"){return" $m[type]".process_length($m["length"]).(preg_match(number_type(),$m["type"])&&in_array($m["unsigned"],driver()->unsigned)?" $m[unsigned]":"").(preg_match('~char|text|enum|set~',$m["type"])&&$m["collation"]?" $cb ".(JUSH=="mssql"?$m["collation"]:q($m["collation"])):"");}function
process_field(array$m,array$Xh){if($m["on_update"])$m["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$m["on_update"]);return
array(idf_escape(trim($m["field"])),process_type($Xh),($m["null"]?" NULL":" NOT NULL"),default_value($m),(preg_match('~timestamp|datetime~',$m["type"])&&$m["on_update"]?" ON UPDATE $m[on_update]":""),(support("comment")&&$m["comment"]!=""?" COMMENT ".q($m["comment"]):""),($m["auto_increment"]?auto_increment():null),);}function
default_value(array$m){$k=$m["default"];$ad=$m["generated"];return($k===null?"":(in_array($ad,driver()->generated)?(JUSH=="mssql"?" AS ($k)".($ad=="VIRTUAL"?"":" $ad")."":" GENERATED ALWAYS AS ($k) $ad"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$k)&&(preg_match('~char|binary|text|json|enum|set~',$m["type"])||preg_match('~^(?![a-z])~i',$k))?(JUSH=="sql"&&preg_match('~text|json~',$m["type"])?"(".q($k).")":q($k)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($k)":$k)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$n,array$b,$U="TABLE",array$Tc=array()){$n=array_values($n);$Hb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$ib=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(100):lang(101)),"<td id='label-type'>".lang(38)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(102),"<td>".lang(103);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(41)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),"<td id='label-default'$Hb>".lang(42),(support("comment")?"<td id='label-comment'$ib>".lang(39):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($n))."]","+",lang(104)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($n
as$t=>$m){$t++;$sf=$m[($_POST?"orig":"field")];$Sb=(isset($_POST["add"][$t-1])||(isset($m["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$sf=="");echo"<tr".($Sb?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$m["inout"]):"")."<th>";if($Sb)echo"<input name='fields[$t][field]' value='".h($m["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'>";echo
input_hidden("fields[$t][orig]",$sf);edit_type("fields[$t]",$m,$b,$Tc);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$m["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($m["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Hb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$m["generated"])." ":checkbox("fields[$t][generated]",1,$m["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($m["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$ib><input name='fields[$t][comment]' value='".h($m["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(104))." ".icon("up","up[$t]","↑",lang(105))." ".icon("down","down[$t]","↓",lang(106))." ":""),($sf==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(107)):"");}}function
process_fields(array&$n){$Ye=0;if($_POST["up"]){$de=0;foreach($n
as$y=>$m){if(key($_POST["up"])==$y){unset($n[$y]);array_splice($n,$de,0,array($m));break;}if(isset($m["field"]))$de=$Ye;$Ye++;}}elseif($_POST["down"]){$Vc=false;foreach($n
as$y=>$m){if(isset($m["field"])&&$Vc){unset($n[key($_POST["down"])]);array_splice($n,$Ye,0,array($Vc));break;}if(key($_POST["down"])==$y)$Vc=$m;$Ye++;}}elseif($_POST["add"]){$n=array_values($n);array_splice($n,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$B){$X=$B[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($cd,array$cg,$d,$ef){if(!$cg)return
true;if($cg==array("ALL PRIVILEGES","GRANT OPTION"))return($cd=="GRANT"?queries("$cd ALL PRIVILEGES$ef WITH GRANT OPTION"):queries("$cd ALL PRIVILEGES$ef")&&queries("$cd GRANT OPTION$ef"));return
queries("$cd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$d, ",$cg).$d).$ef);}function
drop_create($Wb,$h,$Xb,$Bh,$Yb,$A,$De,$Be,$Ce,$bf,$Qe){if($_POST["drop"])query_redirect($Wb,$A,$De);elseif($bf=="")query_redirect($h,$A,$Ce);elseif($bf!=$Qe){$ub=queries($h);queries_redirect($A,$Be,$ub&&queries($Wb));if($ub)queries($Xb);}else
queries_redirect($A,$Be,queries($Bh)&&queries($Yb)&&queries($Wb)&&queries($h));}function
create_trigger($ef,array$L){$Gh=" $L[Timing] $L[Event]".(preg_match('~ OF~',$L["Event"])?" $L[Of]":"");return"CREATE TRIGGER ".idf_escape($L["Trigger"]).(JUSH=="mssql"?$ef.$Gh:$Gh.$ef).rtrim(" $L[Type]\n$L[Statement]",";").";";}function
create_routine($_g,array$L){$Q=array();$n=(array)$L["fields"];ksort($n);foreach($n
as$m){if($m["field"]!="")$Q[]=(preg_match("~^(".driver()->inout.")\$~",$m["inout"])?"$m[inout] ":"").idf_escape($m["field"]).process_type($m,"CHARACTER SET");}$Jb=rtrim($L["definition"],";");return"CREATE $_g ".idf_escape(trim($L["name"]))." (".implode(", ",$Q).")".($_g=="FUNCTION"?" RETURNS".process_type($L["returns"],"CHARACTER SET"):"").($L["language"]?" LANGUAGE $L[language]":"").(JUSH=="pgsql"?" AS ".q($Jb):"\n$Jb;");}function
remove_definer($I){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$I);}function
format_foreign_key(array$p){$j=$p["db"];$Ve=$p["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$p["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($Ve!=""&&$Ve!=$_GET["ns"]?idf_escape($Ve).".":"").idf_escape($p["table"])." (".implode(", ",array_map('Adminer\idf_escape',$p["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$p["on_delete"])?" ON DELETE $p[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$p["on_update"])?" ON UPDATE $p[on_update]":"");}function
tar_file($o,$Lh){$K=pack("a100a8a8a8a12a12",$o,644,0,0,decoct($Lh->size),decoct(time()));$Wa=8*32;for($t=0;$t<strlen($K);$t++)$Wa+=ord($K[$t]);$K
.=sprintf("%06o",$Wa)."\0 ";echo$K,str_repeat("\0",512-strlen($K));$Lh->send();echo
str_repeat("\0",511-($Lh->size+511)%512);}function
ini_bytes($Fd){$X=ini_get($Fd);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$Jf,$Ch="<sup>?</sup>"){$Ng=connection()->server_info;$ti=preg_replace('~^(\d\.?\d).*~s','\1',$Ng);$ki=array('sql'=>"https://dev.mysql.com/doc/refman/$ti/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$ti)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Ng)."&id=",);if(connection()->flavor=='maria'){$ki['sql']="https://mariadb.com/kb/en/";$Jf['sql']=(isset($Jf['mariadb'])?$Jf['mariadb']:str_replace(".html","/",$Jf['sql']));}return($Jf[JUSH]?"<a href='".h($ki[JUSH].$Jf[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$ti":""))."'".target_blank().">$Ch</a>":"");}function
db_size($j){if(!connection()->select_db($j))return"?";$K=0;foreach(table_status()as$S)$K+=$S["Data_length"]+$S["Index_length"];return
format_number($K);}function
set_utf8mb4($h){static$Q=false;if(!$Q&&preg_match('~\butf8mb4~i',$h)){$Q=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(26).": ".h(DB),lang(108),true);}else{if($_POST["db"]&&!$l)queries_redirect(substr(ME,0,-1),lang(109),drop_databases($_POST["db"]));page_header(lang(110),$l,false);echo"<p class='links'>\n";foreach(array('database'=>lang(111),'privileges'=>lang(61),'processlist'=>lang(112),'variables'=>lang(113),'status'=>lang(114),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(115,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(116,"<b>".h(logged_user())."</b>")."\n";$i=adminer()->databases();if($i){$Eg=support("scheme");$b=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(26).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(117)."</a>":"")."<td>".lang(118)."<td>".lang(119)."<td>".lang(120)." - <a href='".h(ME)."dbsize=1'>".lang(121)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$T){$zg=h(ME)."db=".urlencode($j);$u=h("Db-".$j);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$zg' id='$u'>".h($j)."</a>";$db=h(db_collation($j,$b));echo"<td>".(support("database")?"<a href='$zg".($Eg?"&amp;ns=":"")."&amp;database=' title='".lang(57)."'>$db</a>":$db),"<td align='right'><a href='$zg&amp;schema=' id='tables-".h($j)."' title='".lang(60)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(122)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(123)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(isset(adminer()->plugins)&&is_array(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(124)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Of){$Nb=(method_exists($Of,'description')?$Of->description():"");if(!$Nb){$qg=new
\ReflectionObject($Of);if(preg_match('~^/[\s*]+(.+)~',$qg->getDocComment(),$B))$Nb=$B[1];}$Fg=(method_exists($Of,'screenshot')?$Of->screenshot():"");echo"<li><b>".get_class($Of)."</b>".h($Nb?": $Nb":"").($Fg?" (<a href='".h($Fg)."'".target_blank().">".lang(125)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($ob){$this->size+=strlen($ob);fwrite($this->handler,$ob);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$n=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$O=array(idf_escape($_GET["field"]));$J=driver()->select($a,$O,array(where($_GET,$n)),$O);$L=($J?$J->fetch_row():array());echo
driver()->value($L[0],$n[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$n=fields($a);if(!$n)$l=error()?:lang(9);$S=table_status1($a);$D=adminer()->tableName($S);page_header(($n&&is_view($S)?$S['Engine']=='materialized view'?lang(126):lang(127):lang(128)).": ".($D!=""?$D:h($a)),$l);$yg=array();foreach($n
as$y=>$m)$yg+=$m["privileges"];adminer()->selectLinks($S,(isset($yg["insert"])||!support("table")?"":null));$hb=$S["Comment"];if($hb!="")echo"<p class='nowrap'>".lang(39).": ".h($hb)."\n";if($n)adminer()->tableStructurePrint($n,$S);if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(129)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(130)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(96)."</h3>\n";$Tc=foreign_keys($a);if($Tc){echo"<table>\n","<thead><tr><th>".lang(131)."<td>".lang(132)."<td>".lang(99)."<td>".lang(98)."<td></thead>\n";foreach($Tc
as$D=>$p){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$p["source"]))."</i>";$_=($p["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($p["db"]),ME):($p["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($p["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($p["table"]))."'>".($p["db"]!=""&&$p["db"]!=DB?"<b>".h($p["db"])."</b>.":"").($p["ns"]!=""&&$p["ns"]!=$_GET["ns"]?"<b>".h($p["ns"])."</b>.":"").h($p["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$p["target"]))."</i>)","<td>".h($p["on_delete"]),"<td>".h($p["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.lang(133).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(134)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(135)."</h3>\n";$Ta=driver()->checkConstraints($a);if($Ta){echo"<table>\n";foreach($Ta
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(133)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(136)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(137)."</h3>\n";$Wh=triggers($a);if($Wh){echo"<table>\n";foreach($Wh
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(133)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(138)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(60),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$sh=array();$th=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$se,PREG_SET_ORDER);foreach($se
as$t=>$B){$sh[$B[1]]=array($B[2],$B[3]);$th[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$Oh=0;$Ea=-1;$Dg=array();$pg=array();$he=array();$pa=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Rf=0;$Dg[$R]["fields"]=array();foreach($pa[$R]as$m){$Rf+=1.25;$m["pos"]=$Rf;$Dg[$R]["fields"][$m["field"]]=$m;}$Dg[$R]["pos"]=($sh[$R]?:array($Oh,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$fe=$Ea;if(idx($sh[$R],1)||idx($sh[$X["table"]],1))$fe=min(idx($sh[$R],1,0),idx($sh[$X["table"]],1,0))-1;else$Ea-=.1;while($he[(string)$fe])$fe-=.0001;$Dg[$R]["references"][$X["table"]][(string)$fe]=array($X["source"],$X["target"]);$pg[$X["table"]][$R][(string)$fe]=$X["target"];$he[(string)$fe]=true;}}$Oh=max($Oh,$Dg[$R]["pos"][0]+2.5+$Rf);}echo'<div id="schema" style="height: ',$Oh,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$th)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$Oh,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Dg
as$D=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$m){$X='<span'.type_class($m["type"]).' title="'.h($m["type"].($m["length"]?"($m[length])":"").($m["null"]?" NULL":'')).'">'.h($m["field"]).'</span>';echo"<br>".($m["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$_h=>$rg){foreach($rg
as$fe=>$mg){$ge=$fe-idx($sh[$D],1);$t=0;foreach($mg[0]as$Xg)echo"\n<div class='references' title='".h($_h)."' id='refs$fe-".($t++)."' style='left: $ge"."em; top: ".$R["fields"][$Xg]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$ge)."em;'></div></div>";}}foreach((array)$pg[$D]as$_h=>$rg){foreach($rg
as$fe=>$d){$ge=$fe-idx($sh[$D],1);$t=0;foreach($d
as$zh)echo"\n<div class='references arrow' title='".h($_h)."' id='refd$fe-".($t++)."' style='left: $ge"."em; top: ".$R["fields"][$zh]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$ge)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Dg
as$D=>$R){foreach((array)$R["references"]as$_h=>$rg){foreach($rg
as$fe=>$mg){$Ge=$Oh;$we=-10;foreach($mg[0]as$y=>$Xg){$Sf=$R["pos"][0]+$R["fields"][$Xg]["pos"];$Tf=$Dg[$_h]["pos"][0]+$Dg[$_h]["fields"][$mg[1][$y]]["pos"];$Ge=min($Ge,$Sf,$Tf);$we=max($we,$Sf,$Tf);}echo"<div class='references' id='refl$fe' style='left: $fe"."em; top: $Ge"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($we-$Ge)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(139),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$l){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Ac=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$Qd=preg_match('~sql~',$_POST["format"]);if($Qd){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$kh=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){adminer()->dumpDatabase($j);if(connection()->select_db($j)){if($Qd&&preg_match('~CREATE~',$kh)&&($h=get_val("SHOW CREATE DATABASE ".idf_escape($j),1))){set_utf8mb4($h);if($kh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($j).";\n";echo"$h;\n";}if($Qd){if($kh)echo
use_sql($j).";\n\n";$yf="";if($_POST["types"]){foreach(types()as$u=>$U){$pc=type_values($u);if($pc)$yf
.=($kh!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($pc);\n\n";else$yf
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$L){$D=$L["ROUTINE_NAME"];$_g=$L["ROUTINE_TYPE"];$h=create_routine($_g,array("name"=>$D)+routine($L["SPECIFIC_NAME"],$_g));set_utf8mb4($h);$yf
.=($kh!='DROP+CREATE'?"DROP $_g IF EXISTS ".idf_escape($D).";;\n":"")."$h;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$L){$h=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($L["Name"]),3));set_utf8mb4($h);$yf
.=($kh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}echo($yf&&JUSH=='sql'?"DELIMITER ;;\n\n$yf"."DELIMITER ;\n\n":$yf);}if($_POST["table_style"]||$_POST["data_style"]){$vi=array();foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));$Ab=(DB==""||in_array($D,(array)$_POST["data"]));if($R||$Ab){$Lh=null;if($Ac=="tar"){$Lh=new
TmpFile;ob_start(array($Lh,'write'),1e5);}adminer()->dumpTable($D,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$vi[]=$D;elseif($Ab){$n=fields($D);adminer()->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($n,$n)." FROM ".table($D));}if($Qd&&$_POST["triggers"]&&$R&&($Wh=trigger_sql($D)))echo"\nDELIMITER ;;\n$Wh\nDELIMITER ;\n";if($Ac=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$D.csv",$Lh);}elseif($Qd)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$D=>$S){$R=(DB==""||in_array($D,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($D);}}foreach($vi
as$ui)adminer()->dumpTable($ui,$_POST["table_style"],1);if($Ac=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(63),$l,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Eb=array('','USE','DROP+CREATE','CREATE');$uh=array('','DROP+CREATE','CREATE');$Bb=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Bb[]='INSERT+UPDATE';$L=get_settings("adminer_export");if(!$L)$L=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($L["events"])){$L["routines"]=$L["events"]=($_GET["dump"]=="");$L["triggers"]=$L["table_style"];}echo"<tr><th>".lang(140)."<td>".html_radios("output",adminer()->dumpOutput(),$L["output"])."\n","<tr><th>".lang(141)."<td>".html_radios("format",adminer()->dumpFormat(),$L["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(26)."<td>".html_select('db_style',$Eb,$L["db_style"]).(support("type")?checkbox("types",1,$L["types"],lang(40)):"").(support("routine")?checkbox("routines",1,$L["routines"],lang(142)):"").(support("event")?checkbox("events",1,$L["events"],lang(143)):"")),"<tr><th>".lang(119)."<td>".html_select('table_style',$uh,$L["table_style"]).checkbox("auto_increment",1,$L["auto_increment"],lang(41)).(support("trigger")?checkbox("triggers",1,$L["triggers"],lang(137)):""),"<tr><th>".lang(144)."<td>".html_select('data_style',$Bb,$L["data_style"]),'</table>
<p><input type="submit" value="',lang(63),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Xf=array();if(DB!=""){$Ua=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Ua>".lang(119)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(144)."<input type='checkbox' id='check-data'$Ua></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$vi="";$wh=tables_list();foreach($wh
as$D=>$U){$Wf=preg_replace('~_.*~','',$D);$Ua=($a==""||$a==(substr($a,-1)=="%"?"$Wf%":$D));$Zf="<tr><td>".checkbox("tables[]",$D,$Ua,$D,"","block");if($U!==null&&!preg_match('~table~i',$U))$vi
.="$Zf\n";else
echo"$Zf<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$Ua)."</label>\n";$Xf[$Wf]++;}echo$vi;if($wh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(26)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=adminer()->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$Wf=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$Wf%",$j,"","block")."\n";$Xf[$Wf]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Mc=true;foreach($Xf
as$y=>$X){if($y!=""&&$X>1){echo($Mc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$Mc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(61));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(145)."</a>";$J=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$cd=$J;if(!$J)$J=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($cd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(24)."<th>".lang(23)."<th></thead>\n";while($L=$J->fetch_assoc())echo'<tr><td>'.h($L["User"])."<td>".h($L["Host"]).'<td><a href="'.h(ME.'user='.urlencode($L["User"]).'&host='.urlencode($L["Host"])).'">'.lang(10)."</a>\n";if(!$cd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$l&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();exit;}restart_session();$rd=&get_session("queries");$qd=&$rd[DB];if(!$l&&$_POST["clear"]){$qd=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(62):lang(54)),$l);if(!$l&&$_POST){$q=false;if(!isset($_GET["import"]))$I=$_POST["query"];elseif($_POST["webfile"]){$ah=adminer()->importServerPath();$q=@fopen((file_exists($ah)?$ah:"compress.zlib://$ah.gz"),"rb");$I=($q?fread($q,1e6):false);}else$I=get_file("sql_file",true,";");if(is_string($I)){if(function_exists('memory_get_usage')&&($Ae=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($Ae,strval(2*strlen($I)+memory_get_usage()+8e6)));if($I!=""&&strlen($I)<1e6){$H=$I.(preg_match("~;[ \t\r\n]*\$~",$I)?"":";");if(!$qd||first(end($qd))!=$H){restart_session();$qd[]=array($H,time());set_session("queries",$rd);stop_session();}}$Yg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Lb=";";$Ye=0;$jc=true;$g=connect();if($g&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$gb=0;$rc=array();$Df='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|--'.(JUSH=='sql'?' ':'').'|$'.(JUSH=="pgsql"?'|\$[^$]*\$':'');$Ph=microtime(true);$ja=get_settings("adminer_import");$ac=adminer()->dumpFormat();unset($ac["sql"]);while($I!=""){if(!$Ye&&preg_match("~^$Yg*+DELIMITER\\s+(\\S+)~i",$I,$B)){$Lb=preg_quote($B[1]);$I=substr($I,strlen($B[0]));}elseif(!$Ye&&JUSH=='pgsql'&&preg_match("~^($Yg*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$I,$B)){$Lb="\n\\\\\\.\r?\n";$Ye=strlen($B[0]);}else{preg_match("($Lb\\s*|$Df)",$I,$B,PREG_OFFSET_CAPTURE,$Ye);list($Vc,$Rf)=$B[0];if(!$Vc&&$q&&!feof($q))$I
.=fread($q,1e5);else{if(!$Vc&&rtrim($I)=="")break;$Ye=$Rf+strlen($Vc);if($Vc&&!preg_match("(^$Lb)",$Vc)){$Na=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Rf>0&&strtolower($I[$Rf-1])=="e"));$Kf=($Vc=='/*'?'\*/':($Vc=='['?']':(preg_match('~^-- |^#~',$Vc)?"\n":preg_quote($Vc).($Na?'|\\\\.':''))));while(preg_match("($Kf|\$)s",$I,$B,PREG_OFFSET_CAPTURE,$Ye)){$N=$B[0][0];if(!$N&&$q&&!feof($q))$I
.=fread($q,1e5);else{$Ye=$B[0][1]+strlen($N);if(!$N||$N[0]!="\\")break;}}}else{$jc=false;$H=substr($I,0,$Rf+($Lb[0]=="\n"?3:0));$gb++;$Zf="<pre id='sql-$gb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($H)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$Yg*+ATTACH\\b~i",$H,$B)){echo$Zf,"<p class='error'>".lang(146)."\n";$rc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$Zf;ob_flush();flush();}$eh=microtime(true);if(connection()->multi_query($H)&&$g&&preg_match("~^$Yg*+USE\\b~i",$H))$g->query($H);do{$J=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$Zf:""),"<p class='error'>".lang(147).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$rc[]=" <a href='#sql-$gb'>$gb</a>";if($_POST["error_stops"])break
2;}else{$Eh=" <span class='time'>(".format_time($eh).")</span>".(strlen($H)<1000?" <a href='".h(ME)."sql=".urlencode(trim($H))."'>".lang(10)."</a>":"");$la=connection()->affected_rows;$yi=($_POST["only_errors"]?"":driver()->warnings());$zi="warnings-$gb";if($yi)$Eh
.=", <a href='#$zi'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$zi');","");$zc=null;$rf=null;$_c="explain-$gb";if(is_object($J)){$z=$_POST["limit"];$rf=print_select_result($J,$g,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$We=$J->num_rows;echo"<p class='sql-footer'>".($We?($z&&$We>$z?lang(148,$z):"").lang(149,$We):""),$Eh;if($g&&preg_match("~^($Yg|\\()*+SELECT\\b~i",$H)&&($zc=explain($g,$H)))echo", <a href='#$_c'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$_c');","");$u="export-$gb";echo", <a href='#$u'>".lang(63)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$ja["output"])." ".html_select("format",$ac,$ja["format"]).input_hidden("query",$H)."<input type='submit' name='export' value='".lang(63)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$Yg*+(CREATE|DROP|ALTER)$Yg++(DATABASE|SCHEMA)\\b~i",$H)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(150,$la)."$Eh\n";}echo($yi?"<div id='$zi' class='hidden'>\n$yi</div>\n":"");if($zc){echo"<div id='$_c' class='hidden explain'>\n";print_select_result($zc,$g,$rf);echo"</div>\n";}}$eh=microtime(true);}while(connection()->next_result());}$I=substr($I,$Ye);$Ye=0;}}}}if($jc)echo"<p class='message'>".lang(151)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(152,$gb-count($rc))," <span class='time'>(".format_time($Ph).")</span>\n";elseif($rc&&$gb>1)echo"<p class='error'>".lang(147).": ".implode("",$rc)."\n";}else
echo"<p class='error'>".upload_error($I)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$xc="<input type='submit' value='".lang(153)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$H=$_GET["sql"];if($_POST)$H=$_POST["query"];elseif($_GET["history"]=="all")$H=$qd;elseif($_GET["history"]!="")$H=idx($qd[$_GET["history"]],0);echo"<p>";textarea("query",$H,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$xc\n",lang(154).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(155)."</legend><div>";$hd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$hd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$xc":lang(156)),"</div></fieldset>\n";$_d=adminer()->importServerPath();if($_d)echo"<fieldset><legend>".lang(157)."</legend><div>",lang(158,"<code>".h($_d)."$hd</code>"),' <input type="submit" name="webfile" value="'.lang(159).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(160))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(161))."\n",input_token();if(!isset($_GET["import"])&&$qd){print_fieldset("history",lang(162),$_GET["history"]!="");for($X=end($qd);$X;$X=prev($qd)){$y=key($qd);list($H,$Eh,$ec)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Eh)."'>".@date("H:i:s",$Eh)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$H)))),80,"</code>").($ec?" <span class='time'>($ec)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(163)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(164)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$n=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$n):""):where($_GET,$n));$hi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($n
as$D=>$m){if(!isset($m["privileges"][$hi?"update":"insert"])||adminer()->fieldName($m)==""||$m["generated"])unset($n[$D]);}if($_POST&&!$l&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($hi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$x=indexes($a);$ci=unique_array($_GET["where"],$x);$ig="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,lang(165),driver()->delete($a,$ig,$ci?0:1));else{$Q=array();foreach($n
as$D=>$m){$X=process_input($m);if($X!==false&&$X!==null)$Q[idf_escape($D)]=$X;}if($hi){if(!$Q)redirect($A);queries_redirect($A,lang(166),driver()->update($a,$Q,$ig,$ci?0:1));if(is_ajax()){page_headers();page_messages($l);exit;}}else{$J=driver()->insert($a,$Q);$ee=($J?last_id($J):0);queries_redirect($A,lang(167,($ee?" $ee":"")),$J);}}}$L=null;if($_POST["save"])$L=(array)$_POST["fields"];elseif($Z){$O=array();foreach($n
as$D=>$m){if(isset($m["privileges"]["select"])){$ua=($_POST["clone"]&&$m["auto_increment"]?"''":convert_field($m));$O[]=($ua?"$ua AS ":"").idf_escape($D);}}$L=array();if(!support("table"))$O=array("*");if($O){$J=driver()->select($a,$O,array($Z),$O,array(),(isset($_GET["select"])?2:1));if(!$J)$l=error();else{$L=$J->fetch_assoc();if(!$L)$L=false;}if(isset($_GET["select"])&&(!$L||$J->fetch_assoc()))$L=null;}}if(!support("table")&&!$n){if(!$Z){$J=driver()->select($a,array("*"),array(),array("*"));$L=($J?$J->fetch_assoc():false);if(!$L)$L=array(driver()->primary=>"");}if($L){foreach($L
as$y=>$X){if(!$Z)$L[$y]=null;$n[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$n,$L,$hi,$l);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Ef=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$Ef[$y]=$y;$og=referencable_primary($a);$Tc=array();foreach($og
as$rh=>$m)$Tc[str_replace("`","``",$rh)."`".str_replace("`","``",$m["field"])]=$rh;$uf=array();$S=array();if($a!=""){$uf=fields($a);$S=table_status1($a);if(count($S)<2)$l=lang(9);}$L=$_POST;$L["fields"]=(array)$L["fields"];if($L["auto_increment_col"])$L["fields"][$L["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($L["fields"])&&!$l){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(168),drop_tables(array($a)));else{$n=array();$pa=array();$li=false;$Rc=array();$tf=reset($uf);$na=" FIRST";foreach($L["fields"]as$y=>$m){$p=$Tc[$m["type"]];$Xh=($p!==null?$og[$p]:$m);if($m["field"]!=""){if(!$m["generated"])$m["default"]=null;$eg=process_field($m,$Xh);$pa[]=array($m["orig"],$eg,$na);if(!$tf||$eg!==process_field($tf,$tf)){$n[]=array($m["orig"],$eg,$na);if($m["orig"]!=""||$na)$li=true;}if($p!==null)$Rc[idf_escape($m["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Tc[$m["type"]],'source'=>array($m["field"]),'target'=>array($Xh["field"]),'on_delete'=>$m["on_delete"],));$na=" AFTER ".idf_escape($m["field"]);}elseif($m["orig"]!=""){$li=true;$n[]=array($m["orig"]);}if($m["orig"]!=""){$tf=next($uf);if(!$tf)$na="";}}$Gf="";if(support("partitioning")){if(isset($Ef[$L["partition_by"]])){$Cf=array();foreach($L
as$y=>$X){if(preg_match('~^partition~',$y))$Cf[$y]=$X;}foreach($Cf["partition_names"]as$y=>$D){if($D==""){unset($Cf["partition_names"][$y]);unset($Cf["partition_values"][$y]);}}if($Cf!=get_partitions_info($a)){$Hf=array();if($Cf["partition_by"]=='RANGE'||$Cf["partition_by"]=='LIST'){foreach($Cf["partition_names"]as$y=>$D){$Y=$Cf["partition_values"][$y];$Hf[]="\n  PARTITION ".idf_escape($D)." VALUES ".($Cf["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Gf
.="\nPARTITION BY $Cf[partition_by]($Cf[partition])";if($Hf)$Gf
.=" (".implode(",",$Hf)."\n)";elseif($Cf["partitions"])$Gf
.=" PARTITIONS ".(+$Cf["partitions"]);}}elseif(preg_match("~partitioned~",$S["Create_options"]))$Gf
.="\nREMOVE PARTITIONING";}$C=lang(169);if($a==""){cookie("adminer_engine",$L["Engine"]);$C=lang(170);}$D=trim($L["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$C,alter_table($a,$D,(JUSH=="sqlite"&&($li||$Rc)?$pa:$n),$Rc,($L["Comment"]!=$S["Comment"]?$L["Comment"]:null),($L["Engine"]&&$L["Engine"]!=$S["Engine"]?$L["Engine"]:""),($L["Collation"]&&$L["Collation"]!=$S["Collation"]?$L["Collation"]:""),($L["Auto_increment"]!=""?number($L["Auto_increment"]):""),$Gf));}}page_header(($a!=""?lang(33):lang(64)),$l,array("table"=>$a),h($a));if(!$_POST){$Zh=driver()->types();$L=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Zh["int"])?"int":(isset($Zh["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$L=$S;$L["name"]=$a;$L["fields"]=array();if(!$_GET["auto_increment"])$L["Auto_increment"]="";foreach($uf
as$m){$m["generated"]=$m["generated"]?:(isset($m["default"])?"DEFAULT":"");$L["fields"][]=$m;}if(support("partitioning")){$L+=get_partitions_info($a);$L["partition_names"][]="";$L["partition_values"][]="";}}}$b=collations();if(is_array(reset($b)))$b=call_user_func_array('array_merge',array_values($b));$lc=driver()->engines();foreach($lc
as$kc){if(!strcasecmp($kc,$L["Engine"])){$L["Engine"]=$kc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(171).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($L["name"])."' autocapitalize='off'>\n",($lc?html_select("Engine",array(""=>"(".lang(172).")")+$lc,$L["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($b)echo"<datalist id='collations'>".optionlist($b)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($L["Collation"])."' placeholder='(".lang(97).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($L["fields"],$b,"TABLE",$Tc);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(41).": <input type='number' name='Auto_increment' class='size' value='".h($L["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(173),"columnShow(this.checked, 5)","jsonly");$jb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$jb,lang(39),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$L["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($jb?"":" class='hidden'").">".h($L["Comment"])."</textarea>":'<input name="Comment" value="'.h($L["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($jb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$a));if(support("partitioning")){$Ff=preg_match('~RANGE|LIST~',$L["partition_by"]);print_fieldset("partition",lang(175),$L["partition_by"]);echo"<p>".html_select("partition_by",array(""=>"")+$Ef,$L["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($L["partition"])."'>)\n",lang(176).": <input type='number' name='partitions' class='size".($Ff||!$L["partition_by"]?" hidden":"")."' value='".h($L["partitions"])."'>\n","<table id='partition-table'".($Ff?"":" class='hidden'").">\n","<thead><tr><th>".lang(177)."<th>".lang(178)."</thead>\n";foreach($L["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($L["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($L["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Dd=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Dd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Dd[]="SPATIAL";$x=indexes($a);$Yf=array();if(JUSH=="mongo"){$Yf=$x["_id_"];unset($Dd[0]);unset($x["_id_"]);}$L=$_POST;if($L)save_settings(array("index_options"=>$L["options"]));if($_POST&&!$l&&!$_POST["add"]&&!$_POST["drop_col"]){$qa=array();foreach($L["indexes"]as$w){$D=$w["name"];if(in_array($w["type"],$Dd)){$d=array();$ke=array();$Ob=array();$Q=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$c){if($c!=""){$je=idx($w["lengths"],$y);$Mb=idx($w["descs"],$y);$Q[]=idf_escape($c).($je?"(".(+$je).")":"").($Mb?" DESC":"");$d[]=$c;$ke[]=($je?:null);$Ob[]=$Mb;}}$yc=$x[$D];if($yc){ksort($yc["columns"]);ksort($yc["lengths"]);ksort($yc["descs"]);if($w["type"]==$yc["type"]&&array_values($yc["columns"])===$d&&(!$yc["lengths"]||array_values($yc["lengths"])===$ke)&&array_values($yc["descs"])===$Ob){unset($x[$D]);continue;}}if($d)$qa[]=array($w["type"],$D,$Q);}}foreach($x
as$D=>$yc)$qa[]=array($yc["type"],$D,"DROP");if(!$qa)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(179),alter_indexes($a,$qa));}page_header(lang(129),$l,array("table"=>$a),h($a));$n=array_keys(fields($a));if($_POST["add"]){foreach($L["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$L["indexes"][$y]["columns"][]="";}$w=end($L["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$L["indexes"][]=array("columns"=>array(1=>""));}if(!$L){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$L["indexes"]=$x;}$ke=(JUSH=="sql"||JUSH=="mssql");$Sg=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(180),'<th><input type="submit" class="wayoff">',lang(181).($ke?"<span class='idxopts".($Sg?"":" hidden")."'> (".lang(182).")</span>":"");if($ke||support("descidx"))echo
checkbox("options",1,$Sg,lang(103),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(183),'<th><noscript>',icon("plus","add[0]","+",lang(104)),'</noscript>
</thead>
';if($Yf){echo"<tr><td>PRIMARY<td>";foreach($Yf["columns"]as$y=>$c)echo
select_input(" disabled",$n,$c),"<label><input disabled type='checkbox'>".lang(49)."</label> ";echo"<td><td>\n";}$Td=1;foreach($L["indexes"]as$w){if(!$_POST["drop_col"]||$Td!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$Td][type]",array(-1=>"")+$Dd,$w["type"],($Td==count($L["indexes"])?"indexesAddRow.call(this);":""),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$c){echo"<span>".select_input(" name='indexes[$Td][columns][$t]' title='".lang(37)."'",($n?array_combine($n,$n):$n),$c,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span class='idxopts".($Sg?"":" hidden")."'>",($ke?"<input type='number' name='indexes[$Td][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(102)."'>":""),(support("descidx")?checkbox("indexes[$Td][descs][$t]",1,idx($w["descs"],$y),lang(49)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$Td][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td>".icon("cross","drop_col[$Td]","x",lang(107)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$Td++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$L=$_POST;if($_POST&&!$l&&!$_POST["add"]){$D=trim($L["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(184),drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),lang(185),rename_database($D,$L["collation"]));}else{$i=explode("\n",str_replace("\r","",$D));$lh=true;$de="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$L["collation"]))$lh=false;$de=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($de),lang(186),$lh);}}else{if(!$L["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$L["collation"])?" COLLATE $L[collation]":""),substr(ME,0,-1),lang(187));}}page_header(DB!=""?lang(57):lang(111),$l,array(),h(DB));$b=collations();$D=DB;if($_POST)$D=$L["name"];elseif(DB!="")$L["collation"]=db_collation(DB,$b);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$cd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$cd,$B)&&$B[1]){$D=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($D,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" autofocus value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($b?html_select("collation",array(""=>"(".lang(97).")")+$b,$L["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(123)."'>".confirm(lang(174,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(104))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(188).": ".h($ca),$l);$_g=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Ad=array();$yf=array();foreach($_g["fields"]as$t=>$m){if(substr($m["inout"],-3)=="OUT")$yf[$t]="@".idf_escape($m["field"])." AS ".idf_escape($m["field"]);if(!$m["inout"]||substr($m["inout"],0,2)=="IN")$Ad[]=$t;}if(!$l&&$_POST){$Oa=array();foreach($_g["fields"]as$y=>$m){$X="";if(in_array($y,$Ad)){$X=process_input($m);if($X===false)$X="''";if(isset($yf[$y]))connection()->query("SET @".idf_escape($m["field"])." = $X");}$Oa[]=(isset($yf[$y])?"@".idf_escape($m["field"]):$X);}$I=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($ca)."(".implode(", ",$Oa).")";$eh=microtime(true);$J=connection()->multi_query($I);$la=connection()->affected_rows;echo
adminer()->selectQuery($I,$eh,!$J);if(!$J)echo"<p class='error'>".error()."\n";else{$g=connect();if($g)$g->select_db(DB);do{$J=connection()->store_result();if(is_object($J))print_select_result($J,$g);else
echo"<p class='message'>".lang(189,$la)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($yf)print_select_result(connection()->query("SELECT ".implode(", ",$yf)));}}echo'
<form action="" method="post">
';if($Ad){echo"<table class='layout'>\n";foreach($Ad
as$y){$m=$_g["fields"][$y];$D=$m["field"];echo"<tr><th>".adminer()->fieldName($m);$Y=idx($_POST["fields"],$D);if($Y!=""){if($m["type"]=="set")$Y=implode(",",$Y);}input($m,$Y,idx($_POST["function"],$D,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(188),'">
',input_token(),'</form>

<pre>
';function
pre_tr($N){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($N))));}$R='(\+--[-+]+\+\n)';$L='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$L$R?($L*)$R?~m",function($B){$Nc=pre_tr($B[2]);return"<table>\n".($B[1]?"<thead>$Nc</thead>\n":$Nc).pre_tr($B[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($_g['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$L=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$L["source"]=array_filter($L["source"],'strlen');ksort($L["source"]);$zh=array();foreach($L["source"]as$y=>$X)$zh[$y]=$L["target"][$y];$L["target"]=$zh;}if(JUSH=="sqlite")$J=recreate_table($a,$a,array(),array(),array(" $D"=>($L["drop"]?"":" ".format_foreign_key($L))));else{$qa="ALTER TABLE ".table($a);$J=($D==""||queries("$qa DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D)));if(!$L["drop"])$J=queries("$qa ADD".format_foreign_key($L));}queries_redirect(ME."table=".urlencode($a),($L["drop"]?lang(190):($D!=""?lang(191):lang(192))),$J);if(!$L["drop"])$l=lang(193);}page_header(lang(194),$l,array("table"=>$a),h($a));if($_POST){ksort($L["source"]);if($_POST["add"])$L["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$L["target"]=array();}elseif($D!=""){$Tc=foreign_keys($a);$L=$Tc[$D];$L["source"][]="";}else{$L["table"]=$a;$L["source"]=array("");}echo'
<form action="" method="post">
';$Xg=array_keys(fields($a));if($L["db"]!="")connection()->select_db($L["db"]);if($L["ns"]!=""){$vf=get_schema();set_schema($L["ns"]);}$ng=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$zh=array_keys(fields(in_array($L["table"],$ng)?$L["table"]:reset($ng)));$gf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(195).": ".html_select("table",$ng,$L["table"],$gf)."</label>\n";if(JUSH!="sqlite"){$Fb=array();foreach(adminer()->databases()as$j){if(!information_schema($j))$Fb[]=$j;}echo"<label>".lang(65).": ".html_select("db",$Fb,$L["db"]!=""?$L["db"]:$_GET["db"],$gf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(196),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(131),'<th id="label-target">',lang(132),'</thead>
';$Td=0;foreach($L["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$Xg,$X,($Td==count($L["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$zh,idx($L["target"],$y),"","label-target");$Td++;}echo'</table>
<p>
<label>',lang(99),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$L["on_delete"]),'</label>
<label>',lang(98),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$L["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(197),'"></noscript>
';if($D!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$L=$_POST;$wf="VIEW";if(JUSH=="pgsql"&&$a!=""){$fh=table_status1($a);$wf=strtoupper($fh["Engine"]);}if($_POST&&!$l){$D=trim($L["name"]);$ua=" AS\n$L[select]";$A=ME."table=".urlencode($D);$C=lang(198);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&JUSH!="sqlite"&&$U=="VIEW"&&$wf=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$ua,$A,$C);else{$Ah=$D."_adminer_".uniqid();drop_create("DROP $wf ".table($a),"CREATE $U ".table($D).$ua,"DROP $U ".table($D),"CREATE $U ".table($Ah).$ua,"DROP $U ".table($Ah),($_POST["drop"]?substr(ME,0,-1):$A),lang(199),$C,lang(200),$a,$D);}}if(!$_POST&&$a!=""){$L=view($a);$L["name"]=$a;$L["materialized"]=($wf!="VIEW");if(!$l)$l=error();}page_header(($a!=""?lang(32):lang(201)),$l,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(183),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$L["materialized"],lang(126)):""),'<p>';textarea("select",$L["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$Ld=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$gh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$L=$_POST;if($_POST&&!$l){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(202));elseif(in_array($L["INTERVAL_FIELD"],$Ld)&&isset($gh[$L["STATUS"]])){$Cg="\nON SCHEDULE ".($L["INTERVAL_VALUE"]?"EVERY ".q($L["INTERVAL_VALUE"])." $L[INTERVAL_FIELD]".($L["STARTS"]?" STARTS ".q($L["STARTS"]):"").($L["ENDS"]?" ENDS ".q($L["ENDS"]):""):"AT ".q($L["STARTS"]))." ON COMPLETION".($L["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(203):lang(204)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Cg.($aa!=$L["EVENT_NAME"]?"\nRENAME TO ".idf_escape($L["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($L["EVENT_NAME"]).$Cg)."\n".$gh[$L["STATUS"]]." COMMENT ".q($L["EVENT_COMMENT"]).rtrim(" DO\n$L[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(205).": ".h($aa):lang(206)),$l);if(!$L&&$aa!=""){$M=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$L=reset($M);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(183),'<td><input name="EVENT_NAME" value="',h($L["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(207),'<td><input name="STARTS" value="',h("$L[EXECUTE_AT]$L[STARTS]"),'">
<tr><th title="datetime">',lang(208),'<td><input name="ENDS" value="',h($L["ENDS"]),'">
<tr><th>',lang(209),'<td><input type="number" name="INTERVAL_VALUE" value="',h($L["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$Ld,$L["INTERVAL_FIELD"]),'<tr><th>',lang(114),'<td>',html_select("STATUS",$gh,$L["STATUS"]),'<tr><th>',lang(39),'<td><input name="EVENT_COMMENT" value="',h($L["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$L["ON_COMPLETION"]=="PRESERVE",lang(210)),'</table>
<p>';textarea("EVENT_DEFINITION",$L["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$_g=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$L=$_POST;$L["fields"]=(array)$L["fields"];if($_POST&&!process_fields($L["fields"])&&!$l){$sf=routine($_GET["procedure"],$_g);$Ah="$L[name]_adminer_".uniqid();foreach($L["fields"]as$y=>$m){if($m["field"]=="")unset($L["fields"][$y]);}drop_create("DROP $_g ".routine_id($ca,$sf),create_routine($_g,$L),"DROP $_g ".routine_id($L["name"],$L),create_routine($_g,array("name"=>$Ah)+$L),"DROP $_g ".routine_id($Ah,$L),substr(ME,0,-1),lang(211),lang(212),lang(213),$ca,$L["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(214):lang(215)).": ".h($ca):(isset($_GET["function"])?lang(216):lang(217))),$l);if(!$_POST){if($ca=="")$L["language"]="sql";else{$L=routine($_GET["procedure"],$_g);$L["name"]=$ca;}}$b=get_vals("SHOW CHARACTER SET");sort($b);$Ag=routine_languages();echo($b?"<datalist id='collations'>".optionlist($b)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(183),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',($Ag?"<label>".lang(19).": ".html_select("language",$Ag,$L["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($L["fields"],$b,$_g);if(isset($_GET["function"])){echo"<tr><td>".lang(218);edit_type("returns",$L["returns"],$b,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$L["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$D=$_GET["name"];$L=$_POST;if($L&&!$l){if(JUSH=="sqlite")$J=recreate_table($a,$a,array(),array(),array(),"",array(),"$D",($L["drop"]?"":$L["clause"]));else{$J=($D==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($D)));if(!$L["drop"])$J=queries("ALTER TABLE ".table($a)." ADD".($L["name"]!=""?" CONSTRAINT ".idf_escape($L["name"]):"")." CHECK ($L[clause])");}queries_redirect(ME."table=".urlencode($a),($L["drop"]?lang(219):($D!=""?lang(220):lang(221))),$J);}page_header(($D!=""?lang(222).": ".h($D):lang(136)),$l,array("table"=>$a));if(!$L){$Va=driver()->checkConstraints($a);$L=array("name"=>$D,"clause"=>$Va[$D]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(183).': <input name="name" value="'.h($L["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",),"?"),'<p>';textarea("clause",$L["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D="$_GET[name]";$Vh=trigger_options();$L=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$l&&in_array($_POST["Timing"],$Vh["Timing"])&&in_array($_POST["Event"],$Vh["Event"])&&in_array($_POST["Type"],$Vh["Type"])){$ef=" ON ".table($a);$Wb="DROP TRIGGER ".idf_escape($D).(JUSH=="pgsql"?$ef:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Wb,$A,lang(223));else{if($D!="")queries($Wb);queries_redirect($A,($D!=""?lang(224):lang(225)),queries(create_trigger($ef,$_POST)));if($D!="")queries(create_trigger($ef,$L+array("Type"=>reset($Vh["Type"]))));}}$L=$_POST;}page_header(($D!=""?lang(226).": ".h($D):lang(227)),$l,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(228),'<td>',html_select("Timing",$Vh["Timing"],$L["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(229),'<td>',html_select("Event",$Vh["Event"],$L["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Vh["Event"])?" <input name='Of' value='".h($L["Of"])."' class='hidden'>":""),'<tr><th>',lang(38),'<td>',html_select("Type",$Vh["Type"],$L["Type"]),'</table>
<p>',lang(183),': <input name="Trigger" value="',h($L["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$L["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($D!="")echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,$D));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ea=$_GET["user"];$cg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$L){foreach(explode(",",($L["Privilege"]=="Grant option"?"":$L["Context"]))as$pb)$cg[$pb][$L["Privilege"]]=$L["Comment"];}$cg["Server Admin"]+=$cg["File access on server"];$cg["Databases"]["Create routine"]=$cg["Procedures"]["Create routine"];unset($cg["Procedures"]["Create routine"]);$cg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$cg["Columns"][$X]=$cg["Tables"][$X];unset($cg["Server Admin"]["Usage"]);foreach($cg["Tables"]as$y=>$X)unset($cg["Databases"][$y]);$Pe=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Pe[$X]=(array)$Pe[$X]+idx($_POST["grants"],$y,array());}$dd=array();$cf="";if(isset($_GET["host"])&&($J=connection()->query("SHOW GRANTS FOR ".q($ea)."@".q($_GET["host"])))){while($L=$J->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$L[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$se,PREG_SET_ORDER)){foreach($se
as$X){if($X[1]!="USAGE")$dd["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$L[0]))$dd["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$L[0],$B))$cf=$B[1];}}if($_POST&&!$l){$df=(isset($_GET["host"])?q($ea)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $df",ME."privileges=",lang(230));else{$Re=q($_POST["user"])."@".q($_POST["host"]);$If=$_POST["pass"];if($If!=''&&!$_POST["hashed"]&&!min_version(8)){$If=get_val("SELECT PASSWORD(".q($If).")");$l=!$If;}$ub=false;if(!$l){if($df!=$Re){$ub=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Re IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($If));$l=!$ub;}elseif($If!=$cf)queries("SET PASSWORD FOR $Re = ".q($If));}if(!$l){$xg=array();foreach($Pe
as$Xe=>$cd){if(isset($_GET["grant"]))$cd=array_filter($cd);$cd=array_keys($cd);if(isset($_GET["grant"]))$xg=array_diff(array_keys(array_filter($Pe[$Xe],'strlen')),$cd);elseif($df==$Re){$af=array_keys((array)$dd[$Xe]);$xg=array_diff($af,$cd);$cd=array_diff($cd,$af);unset($dd[$Xe]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Xe,$B)&&(!grant("REVOKE",$xg,$B[2]," ON $B[1] FROM $Re")||!grant("GRANT",$cd,$B[2]," ON $B[1] TO $Re"))){$l=true;break;}}}if(!$l&&isset($_GET["host"])){if($df!=$Re)queries("DROP USER $df");elseif(!isset($_GET["grant"])){foreach($dd
as$Xe=>$xg){if(preg_match('~^(.+)(\(.*\))?$~U',$Xe,$B))grant("REVOKE",array_keys($xg),$B[2]," ON $B[1] FROM $Re");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(231):lang(232)),!$l);if($ub)connection()->query("DROP USER $Re");}}page_header((isset($_GET["host"])?lang(24).": ".h("$ea@$_GET[host]"):lang(145)),$l,array("privileges"=>array('',lang(61))));$L=$_POST;if($L)$dd=$Pe;else{$L=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$L["pass"]=$cf;if($cf!="")$L["hashed"]=true;$dd[(DB==""||$dd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(23),'<td><input name="host" data-maxlength="60" value="',h($L["host"]),'" autocapitalize="off">
<tr><th>',lang(24),'<td><input name="user" data-maxlength="80" value="',h($L["user"]),'" autocapitalize="off">
<tr><th>',lang(25),'<td><input name="pass" id="pass" value="',h($L["pass"]),'" autocomplete="new-password">
',($L["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$L["hashed"],lang(233),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(61).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($dd
as$Xe=>$cd){echo'<th>'.($Xe!="*.*"?"<input name='objects[$t]' value='".h($Xe)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(23),"Databases"=>lang(26),"Tables"=>lang(128),"Columns"=>lang(37),"Procedures"=>lang(234),)as$pb=>$Mb){foreach((array)$cg[$pb]as$bg=>$hb){echo"<tr><td".($Mb?">$Mb<td":" colspan='2'").' lang="en" title="'.h($hb).'">'.h($bg);$t=0;foreach($dd
as$Xe=>$cd){$D="'grants[$t][".h(strtoupper($bg))."]'";$Y=$cd[strtoupper($bg)];if($pb=="Server Admin"&&$Xe!=(isset($dd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".lang(235)."<option value='0'".($Y=="0"?" selected":"").">".lang(236)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($bg=="All privileges"?" id='grants-$t-all'>":">".($bg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(123),'">',confirm(lang(174,"$ea@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$l){$Yd=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$Yd++;}queries_redirect(ME."processlist=",lang(237,$Yd),$Yd||!$_POST["kill"]);}}page_header(lang(112),$l);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$L){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($L
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$L[JUSH=="sql"?"Id":"pid"],0):"");foreach($L
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$L["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($L["db"]!=""?"db=".urlencode($L["db"])."&":"")."sql=".urlencode($X)).'">'.lang(238).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(239,max_connections()),"<p><input type='submit' value='".lang(240)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$n=fields($a);$Tc=column_foreign_keys($a);$Ze=$S["Oid"];$ka=get_settings("adminer_import");$yg=array();$d=array();$Gg=array();$of=array();$Dh="";foreach($n
as$y=>$m){$D=adminer()->fieldName($m);$Ne=html_entity_decode(strip_tags($D),ENT_QUOTES);if(isset($m["privileges"]["select"])&&$D!=""){$d[$y]=$Ne;if(is_shortable($m))$Dh=adminer()->selectLengthProcess();}if(isset($m["privileges"]["where"])&&$D!="")$Gg[$y]=$Ne;if(isset($m["privileges"]["order"])&&$D!="")$of[$y]=$Ne;$yg+=$m["privileges"];}list($O,$s)=adminer()->selectColumnsProcess($d,$x);$O=array_unique($O);$s=array_unique($s);$Pd=count($s)<count($O);$Z=adminer()->selectSearchProcess($n,$x);$nf=adminer()->selectOrderProcess($n,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$di=>$L){$ua=convert_field($n[key($L)]);$O=array($ua?:idf_escape(key($L)));$Z[]=where_check($di,$n);$K=driver()->select($a,$O,$Z,$O);if($K)echo
first($K->fetch_row());}exit;}$Yf=$fi=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$Yf=array_flip($w["columns"]);$fi=($O?$Yf:array());foreach($fi
as$y=>$X){if(in_array(idf_escape($y),$O))unset($fi[$y]);}break;}}if($Ze&&!$Yf){$Yf=$fi=array($Ze=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Ze));}if($_POST&&!$l){$Ai=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Va=array();foreach($_POST["check"]as$Sa)$Va[]=where_check($Sa,$n);$Ai[]="((".implode(") OR (",$Va)."))";}$Ai=($Ai?"\nWHERE ".implode(" AND ",$Ai):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$Xc=($O?implode(", ",$O):"*").convert_fields($d,$n,$O)."\nFROM ".table($a);$fd=($s&&$Pd?"\nGROUP BY ".implode(", ",$s):"").($nf?"\nORDER BY ".implode(", ",$nf):"");$I="SELECT $Xc$Ai$fd";if(is_array($_POST["check"])&&!$Yf){$bi=array();foreach($_POST["check"]as$X)$bi[]="(SELECT".limit($Xc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n).$fd,1).")";$I=implode(" UNION ALL ",$bi);}adminer()->dumpData($a,"table",$I);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$Tc)){if($_POST["save"]||$_POST["delete"]){$J=true;$la=0;$Q=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$D=>$X){$X=process_input($n[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$Q[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$Q){$I=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($Q)).")\nSELECT ".implode(", ",$Q)."\nFROM ".table($a):"");if($_POST["all"]||($Yf&&is_array($_POST["check"]))||$Pd){$J=($_POST["delete"]?driver()->delete($a,$Ai):($_POST["clone"]?queries("INSERT $I$Ai".driver()->insertReturning($a)):driver()->update($a,$Q,$Ai)));$la=connection()->affected_rows;if(is_object($J))$la+=$J->num_rows;}else{foreach((array)$_POST["check"]as$X){$_i="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n);$J=($_POST["delete"]?driver()->delete($a,$_i,1):($_POST["clone"]?queries("INSERT".limit1($a,$I,$_i)):driver()->update($a,$Q,$_i,1)));if(!$J)break;$la+=connection()->affected_rows;}}}$C=lang(241,$la);if($_POST["clone"]&&$J&&$la==1){$ee=last_id($J);if($ee)$C=lang(167," $ee");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$C,$J);if(!$_POST["delete"]){$Uf=(array)$_POST["fields"];edit_form($a,array_intersect_key($n,$Uf),$Uf,!$_POST["clone"],$l);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$l=lang(242);else{$J=true;$la=0;foreach($_POST["val"]as$di=>$L){$Q=array();foreach($L
as$y=>$X){$y=bracket_escape($y,true);$Q[idf_escape($y)]=(preg_match('~char|text~',$n[$y]["type"])||$X!=""?adminer()->processInput($n[$y],$X):"NULL");}$J=driver()->update($a,$Q," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($di,$n),($Pd||$Yf?0:1)," ");if(!$J)break;$la+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(241,$la),$J);}}elseif(!is_string($Kc=get_file("csv_file",true)))$l=upload_error($Kc);elseif(!preg_match('~~u',$Kc))$l=lang(243);else{save_settings(array("output"=>$ka["output"],"format"=>$_POST["separator"]),"adminer_import");$J=true;$eb=array_keys($n);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$Kc,$se);$la=count($se[0]);driver()->begin();$Mg=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$M=array();foreach($se[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Mg]*)$Mg~",$X.$Mg,$te);if(!$y&&!array_diff($te[1],$eb)){$eb=$te[1];$la--;}else{$Q=array();foreach($te[1]as$t=>$bb)$Q[idf_escape($eb[$t])]=($bb==""&&$n[$eb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$bb)?str_replace('""','"',substr($bb,1,-1)):$bb));$M[]=$Q;}}$J=(!$M||driver()->insertUpdate($a,$M,$Yf));if($J)driver()->commit();queries_redirect(remove_from_uri("page"),lang(244,$la),$J);driver()->rollback();}}}$rh=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(43).": $rh",$l);$Q=null;if(isset($yg["insert"])||!support("table")){$Cf=array();foreach((array)$_GET["where"]as$X){if(isset($Tc[$X["col"]])&&count($Tc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$Cf["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$Q=$Cf?"&".http_build_query($Cf):"";}adminer()->selectLinks($S,$Q);if(!$d&&support("table"))echo"<p class='error'>".lang(245).($n?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($O,$d);adminer()->selectSearchPrint($Z,$Gg,$x);adminer()->selectOrderPrint($nf,$of,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Dh);adminer()->selectActionPrint($x);echo"</form>\n";$F=$_GET["page"];$Wc=null;if($F=="last"){$Wc=get_val(count_rows($a,$Z,$Pd,$s));$F=floor(max(0,intval($Wc)-1)/$z);}$Hg=$O;$ed=$s;if(!$Hg){$Hg[]="*";$qb=convert_fields($d,$n,$O);if($qb)$Hg[]=substr($qb,2);}foreach($O
as$y=>$X){$m=$n[idf_unescape($X)];if($m&&($ua=convert_field($m)))$Hg[$y]="$ua AS $X";}if(!$Pd&&$fi){foreach($fi
as$y=>$X){$Hg[]=idf_escape($y);if($ed)$ed[]=idf_escape($y);}}$J=driver()->select($a,$Hg,$Z,$ed,$nf,$z,$F,true);if(!$J)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$F)$J->seek($z*$F);$ic=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$M=array();while($L=$J->fetch_assoc()){if($F&&JUSH=="oracle")unset($L["RNUM"]);$M[]=$L;}if($_GET["page"]!="last"&&$z&&$s&&$Pd&&JUSH=="sql")$Wc=get_val(" SELECT FOUND_ROWS()");if(!$M)echo"<p class='message'>".lang(12)."\n";else{$Ca=adminer()->backwardKeys($a,$rh);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$s&&$O?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(246)."</a>");$Oe=array();$Zc=array();reset($O);$kg=1;foreach($M[0]as$y=>$X){if(!isset($fi[$y])){$X=idx($_GET["columns"],key($O))?:array();$m=$n[$O?($X?$X["col"]:current($O)):$y];$D=($m?adminer()->fieldName($m,$kg):($X["fun"]?"*":h($y)));if($D!=""){$kg++;$Oe[$y]=$D;$c=idf_escape($y);$ud=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$Mb="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$Yc=apply_sql_function($X["fun"],$D);$Wg=isset($m["privileges"]["order"])||$Yc;echo($Wg?'<a href="'.h($ud.($nf[0]==$c||$nf[0]==$y||(!$nf&&$Pd&&$s[0]==$c)?$Mb:'')).'">'."$Yc</a>":$Yc),"<span class='column hidden'>";if($Wg)echo"<a href='".h($ud.$Mb)."' title='".lang(49)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($m["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(46).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$Zc[$y]=$X["fun"];next($O);}}$ke=array();if($_GET["modify"]){foreach($M
as$L){foreach($L
as$y=>$X)$ke[$y]=max($ke[$y],min(40,strlen(utf8_decode($X))));}}echo($Ca?"<th>".lang(247):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($M,$Tc)as$Me=>$L){$ci=unique_array($M[$Me],$x);if(!$ci){$ci=array();foreach($M[$Me]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$ci[$y]=$X;}}$di="";foreach($ci
as$y=>$X){$m=(array)$n[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$m["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$m["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$di
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$s&&$O?"":"<td>".checkbox("check[]",substr($di,1),in_array(substr($di,1),(array)$_POST["check"])).($Pd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$di)."' class='edit'>".lang(248)."</a>"));foreach($L
as$y=>$X){if(isset($Oe[$y])){$m=(array)$n[$y];$X=driver()->value($X,$m);if($X!=""&&(!isset($ic[$y])||$ic[$y]!=""))$ic[$y]=(is_mail($X)?$Oe[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$m["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$di;if(!$_&&$X!==null){foreach((array)$Tc[$y]as$p){if(count($Tc[$y])==1||end($p["source"])==$y){$_="";foreach($p["source"]as$t=>$Xg)$_
.=where_link($t,$p["target"][$t],$M[$Me][$Xg]);$_=($p["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($p["db"]),ME):ME).'select='.urlencode($p["table"]).$_;if($p["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($p["ns"]),$_);if(count($p["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$ci))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($ci
as$Vd=>$W)$_
.=where_link($t++,$Vd,$W);}$vd=select_value($X,$_,$m,$Dh);$u=h("val[$di][".bracket_escape($y)."]");$Vf=idx(idx($_POST["val"],$di),bracket_escape($y));$dc=!is_array($L[$y])&&is_utf8($vd)&&$M[$Me][$y]==$L[$y]&&!$Zc[$y]&&!$m["generated"];$Ch=preg_match('~text|json|lob~',$m["type"]);echo"<td id='$u'".(preg_match(number_type(),$m["type"])&&($X===null||is_numeric(strip_tags($vd)))?" class='number'":"");if(($_GET["modify"]&&$dc&&$X!==null)||$Vf!==null){$id=h($Vf!==null?$Vf:$L[$y]);echo">".($Ch?"<textarea name='$u' cols='30' rows='".(substr_count($L[$y],"\n")+1)."'>$id</textarea>":"<input name='$u' value='$id' size='$ke[$y]'>");}else{$oe=strpos($vd,"<i>…</i>");echo" data-text='".($oe?2:($Ch?1:0))."'".($dc?"":" data-warning='".h(lang(249))."'").">$vd";}}}if($Ca)echo"<td>";adminer()->backwardKeysPrint($Ca,$M[$Me]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($M||$F){$wc=true;if($_GET["page"]!="last"){if(!$z||(count($M)<$z&&($M||!$F)))$Wc=($F?$F*$z:0)+count($M);elseif(JUSH!="sql"||!$Pd){$Wc=($Pd?false:found_rows($S,$Z));if(intval($Wc)<max(1e4,2*($F+1)*$z))$Wc=first(slow_query(count_rows($a,$Z,$Pd,$s)));else$wc=false;}}$Af=($z&&($Wc===false||$Wc>$z||$F));if($Af)echo(($Wc===false?count($M)+1:$Wc-$F*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($F+1)).'" class="loadmore">'.lang(250).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(251)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($Af){$ve=($Wc===false?$F+(count($M)>=$z?2:1):floor(($Wc-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(252)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(252)."', '".($F+1)."')); return false; };"),pagination(0,$F).($F>5?" …":"");for($t=max(1,$F-4);$t<min($ve,$F+5);$t++)echo
pagination($t,$F);if($ve>0)echo($F+5<$ve?" …":""),($wc&&$Wc!==false?pagination($ve,$F):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$ve'>".lang(253)."</a>");}else
echo"<legend>".lang(252)."</legend>",pagination(0,$F).($F>1?" …":""),($F?pagination($F,$F):""),($ve>$F?pagination($F+1,$F).($ve>$F+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(254)."</legend>";$Tb=($wc?"":"~ ").$Wc;$hf="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Tb' : checked); selectCount('selected2', this.checked || !checked ? '$Tb' : checked);";echo
checkbox("all",1,0,($Wc!==false?($wc?"":"~ ").lang(149,$Wc):""),$hf)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(246),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(242).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(122),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(238),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$Uc=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($Uc['sql']);break;}}if($Uc){print_fieldset("export",lang(63)." <span id='selected2'></span>");$zf=adminer()->dumpOutput();echo($zf?html_select("output",$zf,$ka["output"])." ":""),html_select("format",$Uc,$ka["format"])," <input type='submit' name='export' value='".lang(63)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($ic,'strlen'),$d);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<div>","<a href='#import'>".lang(62)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ka["format"])," <input type='submit' name='import' value='".lang(62)."'>","</span>","</div>";echo
input_token(),"</form>\n",(!$s&&$O?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$fh=isset($_GET["status"]);page_header($fh?lang(114):lang(113));$ri=($fh?show_status():show_variables());if(!$ri)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($ri
as$L){echo"<tr>";$y=array_shift($L);echo"<th><code class='jush-".JUSH.($fh?"status":"set")."'>".h($y)."</code>";foreach($L
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$oh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$S){json_row("Comment-$D",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$y)json_row("$y-$D",h($S[$y]));foreach($oh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$D",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($oh[$y]))$oh[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$D","?");}}}foreach($oh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$xh=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($xh&&!$l&&!$_POST["search"]){$J=true;$C="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$J=truncate_tables($_POST["tables"]);$C=lang(255);}elseif($_POST["move"]){$J=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C=lang(256);}elseif($_POST["copy"]){$J=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$C=lang(257);}elseif($_POST["drop"]){if($_POST["views"])$J=drop_views($_POST["views"]);if($J&&$_POST["tables"])$J=drop_tables($_POST["tables"]);$C=lang(258);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$L)$C
.="<b>".h($R)."</b>: ".h($L["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$J=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$C=lang(259);}elseif(!$_POST["tables"])$C=lang(9);elseif($J=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($L=$J->fetch_assoc())$C
.="<b>".h($L["Table"])."</b>: ".h($L["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$C,$J);}page_header(($_GET["ns"]==""?lang(26).": ".h(DB):lang(260).": ".h($_GET["ns"])),$l,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(261)."</h3>\n";$wh=tables_list();if(!$wh)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(262)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(46)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=driver()->convertOperator("LIKE %%");search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(128),'<td>'.lang(263).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(118).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(264).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(265).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(266).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(41).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(267).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(39).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$T=0;foreach($wh
as$D=>$U){$ui=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$D);echo'<tr><td>'.checkbox(($ui?"views[]":"tables[]"),$D,in_array("$D",$xh,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".lang(31)."' id='$u'>".h($D).'</a>':h($D));if($ui)echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($D).'" title="'.lang(32).'">'.(preg_match('~materialized~i',$U)?lang(126):lang(127)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.lang(30).'">?</a>';else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(33)),"Index_length"=>array("indexes",lang(130)),"Data_free"=>array("edit",lang(34)),"Auto_increment"=>array("auto_increment=1&create",lang(33)),"Rows"=>array("select",lang(30)),)as$y=>$_){$u=" id='$y-".h($D)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($D)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($D)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":""),"\n";}echo"<tr><td><th>".lang(239,count($wh)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$pi="<input type='submit' value='".lang(268)."'> ".on_help("'VACUUM'");$kf="<input type='submit' name='optimize' value='".lang(269)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(122)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$pi."<input type='submit' name='check' value='".lang(270)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$pi.$kf:(JUSH=="sql"?"<input type='submit' value='".lang(271)."'> ".on_help("'ANALYZE TABLE'").$kf."<input type='submit' name='check' value='".lang(270)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(272)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(273)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(123)."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?adminer()->schemas():adminer()->databases());if(count($i)!=1&&JUSH!="sqlite"){$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p><label>".lang(274).": ",($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(275)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(276)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(277)):""),"\n";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),input_token(),"</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(64)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(201)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(142)."</h3>\n";$Bg=routines();if($Bg){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(183).'<td>'.lang(38).'<td>'.lang(218)."<td></thead>\n";foreach($Bg
as$L){$D=($L["SPECIFIC_NAME"]==$L["ROUTINE_NAME"]?"":"&name=".urlencode($L["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($L["SPECIFIC_NAME"]).$D).'">'.h($L["ROUTINE_NAME"]).'</a>','<td>'.h($L["ROUTINE_TYPE"]),'<td>'.h($L["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($L["SPECIFIC_NAME"]).$D).'">'.lang(133)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(217).'</a>':'').'<a href="'.h(ME).'function=">'.lang(216)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(143)."</h3>\n";$M=get_rows("SHOW EVENTS");if($M){echo"<table>\n","<thead><tr><th>".lang(183)."<td>".lang(278)."<td>".lang(207)."<td>".lang(208)."<td></thead>\n";foreach($M
as$L)echo"<tr>","<th>".h($L["Name"]),"<td>".($L["Execute at"]?lang(279)."<td>".$L["Execute at"]:lang(209)." ".$L["Interval value"]." ".$L["Interval field"]."<td>$L[Starts]"),"<td>$L[Ends]",'<td><a href="'.h(ME).'event='.urlencode($L["Name"]).'">'.lang(133).'</a>';echo"</table>\n";$uc=get_val("SELECT @@event_scheduler");if($uc&&$uc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($uc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(206)."</a>\n";}if($wh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();