<?php
function adminer_object()
{
  include_once __DIR__ . '/plugins/plugin.php';

  foreach (glob(__DIR__ . '/plugins/*.php') as $filename) {
    include_once $filename;
  }

  $plugins = [
    new AdminerAutoLogin,
    new AdminerCodemirror,
    new AdminerDatabaseHide(array('information_schema', 'mysql', 'performance_schema', 'phpmyadmin', 'sys')),
  ];

  return new AdminerPlugin($plugins);
}

// Find Latest Adminer version
function findLatestAdminer() {
  $files = glob(__DIR__ . DIRECTORY_SEPARATOR . 'adminer-*.php');
  $adminerFiles = [];
  
  foreach ($files as $file) {
      if (preg_match('/adminer-(\d+\.\d+\.\d+)/', $file, $matches)) {
          $adminerFiles[] = [
              'file' => $file,
              'version' => $matches[1],
              'length' => strlen($file)
          ];
      }
  }
  
  if (empty($adminerFiles)) return null;

  usort($adminerFiles, function($a, $b) {
      $versionCompare = version_compare($b['version'], $a['version']);
      if ($versionCompare !== 0) return $versionCompare;
      return $b['length'] <=> $a['length'];
  });
  
  return basename($adminerFiles[0]['file']);
}

if (!count($_GET)) {
  $_POST['auth'] = [
    'server' => '127.0.0.1',
    'username' => 'root',
    'password' => '',
    'driver' => 'server',
    'db' => ''
  ];
}

include "./" . findLatestAdminer();
