<!doctype html>
<html>

<head>
    <!-- Xampp-Lite -->
    <!-- https://xampplite.sf.net -->

    <!-- Ref-01: https://css-tricks.com/snippets/php/display-styled-directory-contents/ -->
    <!-- Ref-02: https://css-tricks.com/data-uris/ -->

    <meta charset="UTF-8">
    <link rel="icon"
        href="data:image/x-icon;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAABDfAAAQ3wF0VV4wAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAABV1JREFUWIXFl3tsU3UUxz+/373tutJCyzYe614QMDzEwDKYxAgRhflkghoSIMGEYCAkKIhCiKLE8DAEiBEjiS/APwCJ4msQIREwmiAbD6MSmYSNlU1grBvrNtb27v78o9CuvXcbGiMnadLzO4/v95x7f+e0IrpmxFIBGwEv/6+ElWC1iK0Z0XoXwBMk5F0EB/DKuwgOgN6nhy+AKCxGON2olnpUbRXEOu19HS5EUQnCl4eKtqMunYaW+n9JwJONVr4OMWZG6nlHM+aRbZgn96Qcy9J5yEdeArcveagU6twRur5aC+1NtjAitmaEsgVfvB/hz+uRn3nsfcwjW+PgZa8ipyzq0VeFgnTteM6WhO07IGeu6xUcQE5djCgqQQy/v1dwADEwHznzTVub9RH4Asgx0xNqR/AcFz9+mUhjHVml5RTOewshNRACNfl5kMkUqsugZtcqmk4cwJkVYOSSHbgLxsYJjy3D9OVCS0NqIen4qqAYhEjowZ0rGdxazUh3BCr30HTiQLKywhJEYXFCv3bsU/RfvmC0X5IfayC4c2W3NghU/oS+O9ApM3F00wdHG/C44jzdDp0bobqETfNmJYmbBp3HPyLgiad06QJ581Jqbq0fmWl4lg7Emi6n6J6SmUlFc9C/+HFLFQChym8ZGLmScuYdNy0td9ASZ+mAqqnEaGtG9/jjDk+9gcofj2oOIsaWIYaMsiQxozdp+XozhbpIzTV5QeK70RaC2krQ+iDg0WLUf7mZwvkb4gdSQxTPRqT5RRrriDZfIRqqp/GHPQSMq9CNgMi7D23YxIR++fO3GSqNvjugCRCVe2jwB8h9YmlapZ1c/X4n147uJnr9MroUODXIdmtkZnYrTQiYcesFVIqGiu1opz9D81gvne0gUkBtSwyjYCJDpi/EM6IEoTuo3rYAvf4sOf00PE5p6cptkaVzUQ8to/XPSq4c/gA9eIoin8PW33YUC2CYz0Grx4mmSYQQ1Hy4nJzQr/j9DruQZOyEWcgn12K0t6BpkiFeJ15fzzH2oxiQZa8gp7wAwI0z33Fz9xKy3ZqdazxR/njkg4sQY2dYbObxHZiHt9jG2XZAls5NgAM0HXyHgjRwWTwbMfph8GQjBhaAJ7tHcnLqYmiux6zcewcE9AzEI8sTarj6Z/wt58GZHBkiexjy6fWgWcM7gucInTqEK6eArMmz42MbYPoKOHMAjEgfBIZNQnRbqc1HPyHXmTavpi2zB6/7neqN5Xg1g1ZD0VZzlqL56+Nd6OfHLCqBCz+lxFgmYdQ7NKkoRcbFH1Md/AHkuEdv2c3455a0njnEKB8UDnBwT5YT/bdvUnP3D1hIWwl0tCUVIfAPGppiFw8sRNzagLFwCKO9JWHzDilCl8nLNihveGru9jbSxULAqD0NKnkx9Gc3xX8baDqyeDZa6dyErf1CFW0XqhJ6v4mzkKVzweVFBO5Ff2ZTMrFSGLVJ30RB6dew01DE5ryLv/ixVE+zC2S3m6AUdVvngBAUrNhnSZwuoaoKnPtfxJW2LywdcOmC63tfI9JYl2qQqdewoWI77oZTZNZX0VDxXq/gkcY6ru973QJuSwBgqLjBHxvKCVUdTHkcEN9qNbtW0XFoCz6XxO+SdBzcTO3u1fGN112UIlRVwfmN5QS0VltyPU7CTkPF90H/XLwjS5AZbiLXg7RVnyQno4tcr56Y7QqoDxs0RXU8IyfhzM7D7GwnfKEKvfUvinwO2+p7JXBbwlGTtqiJqcCpCQZkSJyafbJol+JGxCTapZACPE6JN32GpEmff0y8d5Dktjg1QU4v+8JOJBD+RxH/rYSlEqy+SyTCSrHqbw9xyy0dDHQ9AAAAAElFTkSuQmCC">
    <title>Apache DocumentRoot Directory</title>

    <style>
        <?php
        include(__DIR__ . '/.style.css');
        ?>
    </style>
</head>

<body>
    <!--[if lte IE 11]>
    <div class="warning-ie8">
        <p>Your current browser version is outdated. Please switch to a recent browser for a better experience.</p>
    </div>
<![endif]-->

    <div id="container">
        <h1>Apache DocumentRoot</h1>

        <table class="sortable">
            <thead>
                <tr>
                    <th>Name</th>
                    <!-- <th>Size</th> -->
                    <th>&nbsp;</th>
                    <th>Type</th>
                    <th>Date Modified</th>
                </tr>
            </thead>
            <tbody><?php

            // Adds pretty filesizes
            function pretty_filesize($file)
            {
                $size = filesize($file);
                if ($size < 1024) {
                    $size = $size . " Bytes";
                } elseif (($size < 1048576) && ($size > 1023)) {
                    $size = round($size / 1024, 1) . " KB";
                } elseif (($size < 1073741824) && ($size > 1048575)) {
                    $size = round($size / 1048576, 1) . " MB";
                } else {
                    $size = round($size / 1073741824, 1) . " GB";
                }
                return $size;
            }

            // Checks to see if veiwing hidden files is enabled
            if ($_SERVER['QUERY_STRING'] == "hidden") {
                $hide = "";
                $ahref = "./";
                $atext = "Hide";
            } else {
                $hide = ".";
                $ahref = "./?hidden";
                $atext = "Show";
            }

            // Opens directory
            //  $myDirectory=opendir(".");
            $myDirectory = opendir($_SERVER["DOCUMENT_ROOT"]);
            echo "
    <form action='' method='post'>
    <div id='document-root-path-container'>
        <button id='document-root-path' name='rootDirectory'>" .
                strtolower(str_replace('/', '\\', $_SERVER['DOCUMENT_ROOT']))
                . "</button>
    </div>
    </form>
    ";
            // Open rootDirectory folder in explorer
            if (isset($_POST['rootDirectory'])) {
                $root_location = $_SERVER["DOCUMENT_ROOT"];
                exec("start \"\" \"{$root_location}\"");

            }

            // Gets each entry
            while ($entryName = readdir($myDirectory)) {
                if ($entryName != "index.php") {
                    $dirArray[] = $entryName;
                }

            }



            // Closes directory
            closedir($myDirectory);

            // Sorts files
            // sort($dirArray);
            
            usort($dirArray, function ($a, $b) {
                return filemtime($_SERVER["DOCUMENT_ROOT"] . "/" . $b) <=> filemtime($_SERVER["DOCUMENT_ROOT"] . "/" . $a);
            });


            // Counts elements in array
            $indexCount = count($dirArray);


            // Loops through the array of files
            for ($index = 0; $index < $indexCount; $index++) {

                // Decides if hidden files should be displayed, based on query above.
                if (substr("$dirArray[$index]", 0, 1) != $hide) {

                    // Resets Variables
                    $favicon = "";
                    $class = "file";

                    // Gets File Names
                    $name = $dirArray[$index];
                    $namehref = $dirArray[$index];

                    // Gets Date Modified
                    $modtime = date("d M Y ⌚ H:i", filemtime($dirArray[$index]));
                    $timekey = date("YmdHis", filemtime($dirArray[$index]));


                    // Separates directories, and performs operations on those directories
                    if (is_dir($dirArray[$index])) {
                        $extn = "&lt;Website&gt;";
                        // $extn="&lt;Directory&gt;";
                        // $size="&nbsp;";
                        $warning = "";
                        $sizekey = "0";
                        $class = "dir";

                        // Gets favicon.ico, and displays it, only if it exists.
                        if (file_exists("$namehref/favicon.ico")) {
                            $favicon = " style='background-image:url($namehref/favicon.ico);'";
                            $extn = "&lt;Website&gt;";
                        }

                        // Cleans up . and .. directories
                        if ($name == ".") {
                            $name = ". (Current Directory)";
                            $extn = "&lt;System Dir&gt;";
                            $favicon = " style='background-image:url($namehref/.favicon.ico);'";
                        }
                        if ($name == "..") {
                            $name = ".. (Parent Directory)";
                            $extn = "&lt;System Dir&gt;";
                        }
                    }

                    // File-only operations
                    else {
                        // Gets file extension
                        $extn = pathinfo($dirArray[$index], PATHINFO_EXTENSION);
                        $warning = "<img alt='Avertissement' title='Move this file to a Website (folder)'   src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAAfQAAAH0Bx0gPAAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHkSURBVDiNjZHBSxtBFMa/N7NZw5LNbOqyl+IcQiEheDL0mmOCq4wiJh5yUMxib72LJz3rqSKW/gsFS6v+HT2VBpYeNgd7q5dCTXd3ekjYNo1RPxiG+ea937w3j7TWmKVodbUEAPLy8sesGDbrYqBUkwghEcKBUs1ZcXRfBaHvz81x9iUnZRkAfkfRt7skrb24vr57UgV5Tq8BlJ1eAKcXAEB57D3ewo1SriY6yNfryC8tjVa9Dk10cKOU+yggTtNDEBPObi/znN0eQEzEaXr4ICBa92sg7BVaLeSkxMXHT3h/8QE5KVFotQDCXrTu12YCKOHHzLKMYreLJElwevYWZ+fvEMcxit0umGUZlPDjewGjUellu90GFw4457ALBRRtG4ZhgAsHdrsNQC//O9YRoNPh0OmJ4Xmw1VpGl3IBUi5kZ1utwfA8QKcn6HR4Boh+/QwALIrtHZBpZglbmxvY2tz426JpQmzvAMDiOAcs9P0i0+zIrFRhNRoTPyyEgBBiwrMaDZiVKphmR6HvF1me830N7ZWCAP/LdefhuvNTfikIoKG9POf7hoZumpUqQIRhvz8R+Gy8D29vJwlEMCtVDPtfmxStrJyD8GrqmSdIE96Q1hoDpV5SkkzX+oAI+P786urzH3hdi4a5j2LEAAAAAElFTkSuQmCC'>";
                        // Prettifies file type
                        switch ($extn) {
                            case "png":
                                $extn = "PNG Image";
                                break;
                            case "jpg":
                                $extn = "JPEG Image";
                                break;
                            case "jpeg":
                                $extn = "JPEG Image";
                                break;
                            case "svg":
                                $extn = "SVG Image";
                                break;
                            case "gif":
                                $extn = "GIF Image";
                                break;
                            case "ico":
                                $extn = "Windows Icon";
                                break;

                            case "txt":
                                $extn = "Text File";
                                break;
                            case "log":
                                $extn = "Log File";
                                break;
                            case "htm":
                                $extn = "HTML File";
                                break;
                            case "html":
                                $extn = "HTML File";
                                break;
                            case "xhtml":
                                $extn = "HTML File";
                                break;
                            case "shtml":
                                $extn = "HTML File";
                                break;
                            case "php":
                                $extn = "PHP Script";
                                break;
                            case "py":
                                $extn = "Python File";
                                break;
                            case "js":
                                $extn = "Javascript File";
                                break;
                            case "css":
                                $extn = "Stylesheet";
                                break;
                            case "sql":
                                $extn = "SQL File";
                                break;

                            case "pdf":
                                $extn = "PDF Document";
                                break;
                            case "xls":
                                $extn = "Spreadsheet";
                                break;
                            case "xlsx":
                                $extn = "Spreadsheet";
                                break;
                            case "ods":
                                $extn = "Spreadsheet";
                                break;
                            case "doc":
                                $extn = "Microsoft Word Document";
                                break;
                            case "docx":
                                $extn = "Microsoft Word Document";
                                break;

                            case "zip":
                                $extn = "ZIP Archive";
                                break;
                            case "htaccess":
                                $extn = "Apache Config File";
                                break;
                            case "exe":
                                $extn = "Windows Executable";
                                break;

                            default:
                                if ($extn != "") {
                                    $extn = strtoupper($extn) . " File";
                                } else {
                                    $extn = "Unknown";
                                }
                                break;
                        }

                        // Gets and cleans up file size
                        // $size=pretty_filesize($dirArray[$index]);
                        // $sizekey=filesize($dirArray[$index]);
                    }

                    // Output
                    if ($warning != "") {
                        $msg = warning_msg();
                        echo "
        <tr class='$class'>
            <td><a href='./$namehref'$favicon class='name'>$name</a></td>
            <td>
        <div class='warning' data-tooltip='{$msg}'><a href='./$namehref'$favicon class='name'>$warning</a></div>     
      </td>
            <td><a href='./$namehref'>$extn</a></td>
            <td sorttable_customkey='$timekey'><a href='./$namehref'>$modtime</a></td>
        </tr>";
                    } else {
                        echo "
        <tr class='$class'>
            <td><a href='./$namehref'$favicon class='name'>$name</a></td>
            <td><a href='./$namehref'$favicon class='name'>$warning</a></td>
            <td><a href='./$namehref'>$extn</a></td>
            <td sorttable_customkey='$timekey'><a href='./$namehref'>$modtime</a></td>
        </tr>";
                    }
                }
            }
            ?>

            </tbody>
        </table>

        <!-- <h2><?php echo ("<a href='$ahref'>$atext hidden files</a>"); ?></h2> -->
        <script>
            <?php
            include(__DIR__ . '/.sorttable.js');
            ?>
        </script>
    </div>
    <div id='xampp-lite-home'><a href='https://xampplite.sf.net/' target='_blank'
            title="Visit XAMPP-Lite Website"><span>https://</span>xampplite<span>.sf.net/</span></a></div>
<?php  
  $php_man = getenv('XAMPP_LITE_ROOT') . '/apps/php/phpmanual/langref.html';
  if (is_file($php_man)) {
?>
    <a href='/phpmanual/langref.html' target='_blank' title="PHP Language Reference">
        <figure id='phpmanual'><svg width="32" height="32" viewBox="0 0 32 32">
                <rect width="30.897" height="32" x="-32" y="-32" rx="1.545" ry="1.6" transform="matrix(0 -1 -1 0 0 0)"
                    style="opacity:.2;stroke-width:1.12297" />
                <rect style="fill:#465489;stroke-width:1.12297" width="30.897" height="32" x="-30.897" y="-32"
                    rx="1.545" ry="1.6" transform="matrix(0 -1 -1 0 0 0)" />
                <path
                    d="m14.592 11.941-1.352 6.941h1.43l.733-3.762c.486 0 .948-.016 1.408.004.452.02.623.239.547.683-.105.607-.228 1.211-.343 1.816l-.245 1.272c.468 0 .916.001 1.364-.006.037 0 .095-.058.106-.1.04-.155.064-.316.094-.474.172-.899.356-1.797.514-2.698.14-.795-.189-1.3-.966-1.465-.369-.079-.753-.089-1.131-.106-.374-.016-.75-.002-1.138-.002l.408-2.103h-1.429Zm-6.374 2.103c-.044 0-.089.006-.136.01-.428 2.201-.993 4.742-1.421 6.943h1.441c.109-.553.357-1.437.455-1.975.02-.104.06-.13.158-.129.473.002.947.013 1.419-.008.297-.013.598-.052.887-.123 1.083-.265 2.18-1.42 2.058-3.057-.063-.84-.538-1.359-1.358-1.559a3.43 3.43 0 0 0-.768-.098c-.912-.011-1.823-.004-2.735-.004zm11.873 0c-.034 0-.067.005-.108.01-.428 2.197-.994 4.742-1.422 6.946h1.44c.107-.549.356-1.434.454-1.971.02-.113.067-.137.17-.137.485.003.97.01 1.454-.006.64-.021 1.243-.166 1.758-.578.795-.636 1.162-1.474 1.153-2.476-.008-.853-.5-1.468-1.328-1.678a3.416 3.416 0 0 0-.785-.105c-.928-.012-1.857-.005-2.786-.005zM9.33 15.054c.544.032 1.082.032 1.609.104.461.064.657.33.637.797a3.679 3.679 0 0 1-.142.845c-.174.608-.605.945-1.224 1.009-.462.048-.93.042-1.428.062l.548-2.817zm11.9.002c.543.031 1.08.03 1.608.102.462.063.659.327.638.794a3.668 3.668 0 0 1-.152.878c-.178.59-.608.917-1.211.979-.462.048-.928.042-1.43.062l.547-2.816z"
                    style="opacity:.2;isolation:isolate;fill-rule:evenodd"
                    transform="matrix(1.14286 0 0 1.10345 -2.286 -6.62)" />
                <path style="isolation:isolate;fill:#fff;fill-rule:evenodd"
                    d="m14.592 10.941-1.352 6.941h1.43l.733-3.762c.486 0 .948-.016 1.408.004.452.02.623.239.547.683-.105.607-.228 1.211-.343 1.816l-.245 1.272c.468 0 .916.001 1.364-.006.037 0 .095-.058.106-.1.04-.155.064-.316.094-.474.172-.899.356-1.797.514-2.698.14-.795-.189-1.3-.966-1.465-.369-.079-.753-.089-1.131-.106-.374-.016-.75-.002-1.138-.002l.408-2.103h-1.429Zm-6.374 2.103c-.044 0-.089.006-.136.01-.428 2.201-.993 4.742-1.421 6.943h1.441c.109-.553.357-1.437.455-1.975.02-.104.06-.13.158-.129.473.002.947.013 1.419-.008.297-.013.598-.052.887-.123 1.083-.265 2.18-1.42 2.058-3.057-.063-.84-.538-1.359-1.358-1.559a3.43 3.43 0 0 0-.768-.098c-.912-.011-1.823-.004-2.735-.004zm11.873 0c-.034 0-.067.005-.108.01-.428 2.197-.994 4.742-1.422 6.946h1.44c.107-.549.356-1.434.454-1.971.02-.113.067-.137.17-.137.485.003.97.01 1.454-.006.64-.021 1.243-.166 1.758-.578.795-.636 1.162-1.474 1.153-2.476-.008-.853-.5-1.468-1.328-1.678a3.416 3.416 0 0 0-.785-.105c-.928-.012-1.857-.005-2.786-.005zM9.33 14.054c.544.032 1.082.032 1.609.104.461.064.657.33.637.797a3.679 3.679 0 0 1-.142.845c-.174.608-.605.945-1.224 1.009-.462.048-.93.042-1.428.062l.548-2.817zm11.9.002c.543.031 1.08.03 1.608.102.462.063.659.327.638.794a3.668 3.668 0 0 1-.152.878c-.178.59-.608.917-1.211.979-.462.048-.928.042-1.43.062l.547-2.816z"
                    transform="matrix(1.14286 0 0 1.10345 -2.286 -6.62)" />
                <path style="opacity:.1;fill:#fff;stroke-width:1.12297"
                    d="M1.6 0C.714 0 0 .69 0 1.545V2.65c0-.856.714-1.546 1.6-1.546h28.8c.886 0 1.6.69 1.6 1.546V1.545C32 .69 31.286 0 30.4 0Z" />
                <path
                    d="M442 124c0 1.104-.927 1.656-2 2 0 0-5.443 1.515-11 2.977V104l11-3a2 2 0 0 1 2 2zm-15 4.998c-5.462-1.468-11-2.998-11-2.998-1.136-.312-2-.896-2-2v-21a2 2 0 0 1 2-2l11 3zM440 99s-5.789 1.594-11.05 3c-.659.025-1.323 0-1.983 0-5.012-1.344-10.967-3-10.967-3a4 4 0 0 0-4 4v21c0 2.209 1.885 3.313 4 4 0 0 5.393 1.5 10.967 3h2.025c5.62-1.5 11.008-3 11.008-3 2.053-.531 4-1.791 4-4v-21a4 4 0 0 0-4-4z"
                    style="fill:#fff;stroke:#fdfdfd;stroke-width:1.20783;stroke-dasharray:none;stroke-opacity:1"
                    transform="matrix(.4199 0 0 .32963 -163.716 -15.47)" fill="#000" fill-rule="evenodd" />
            </svg>
        </figure>
    </a>
<?php } ?>
    <a href='/phpinfo' target='_blank' title="PHP Configuration">
        <figure id='phpinfo'><svg width="32" height="32" viewBox="0 0 32 32">
                <rect width="30.897" height="32" x="-32" y="-32" rx="1.545" ry="1.6" transform="matrix(0 -1 -1 0 0 0)"
                    style="opacity:.2;stroke-width:1.12297" />
                <rect style="fill:#465489;stroke-width:1.12297" width="30.897" height="32" x="-30.897" y="-32"
                    rx="1.545" ry="1.6" transform="matrix(0 -1 -1 0 0 0)" />
                <path
                    d="m14.592 11.941-1.352 6.941h1.43l.733-3.762c.486 0 .948-.016 1.408.004.452.02.623.239.547.683-.105.607-.228 1.211-.343 1.816l-.245 1.272c.468 0 .916.001 1.364-.006.037 0 .095-.058.106-.1.04-.155.064-.316.094-.474.172-.899.356-1.797.514-2.698.14-.795-.189-1.3-.966-1.465-.369-.079-.753-.089-1.131-.106-.374-.016-.75-.002-1.138-.002l.408-2.103h-1.429Zm-6.374 2.103c-.044 0-.089.006-.136.01-.428 2.201-.993 4.742-1.421 6.943h1.441c.109-.553.357-1.437.455-1.975.02-.104.06-.13.158-.129.473.002.947.013 1.419-.008.297-.013.598-.052.887-.123 1.083-.265 2.18-1.42 2.058-3.057-.063-.84-.538-1.359-1.358-1.559a3.43 3.43 0 0 0-.768-.098c-.912-.011-1.823-.004-2.735-.004zm11.873 0c-.034 0-.067.005-.108.01-.428 2.197-.994 4.742-1.422 6.946h1.44c.107-.549.356-1.434.454-1.971.02-.113.067-.137.17-.137.485.003.97.01 1.454-.006.64-.021 1.243-.166 1.758-.578.795-.636 1.162-1.474 1.153-2.476-.008-.853-.5-1.468-1.328-1.678a3.416 3.416 0 0 0-.785-.105c-.928-.012-1.857-.005-2.786-.005zM9.33 15.054c.544.032 1.082.032 1.609.104.461.064.657.33.637.797a3.679 3.679 0 0 1-.142.845c-.174.608-.605.945-1.224 1.009-.462.048-.93.042-1.428.062l.548-2.817zm11.9.002c.543.031 1.08.03 1.608.102.462.063.659.327.638.794a3.668 3.668 0 0 1-.152.878c-.178.59-.608.917-1.211.979-.462.048-.928.042-1.43.062l.547-2.816z"
                    style="opacity:.2;isolation:isolate;fill-rule:evenodd"
                    transform="matrix(1.14286 0 0 1.10345 -2.286 -6.62)" />
                <path style="isolation:isolate;fill:#fff;fill-rule:evenodd"
                    d="m14.592 10.941-1.352 6.941h1.43l.733-3.762c.486 0 .948-.016 1.408.004.452.02.623.239.547.683-.105.607-.228 1.211-.343 1.816l-.245 1.272c.468 0 .916.001 1.364-.006.037 0 .095-.058.106-.1.04-.155.064-.316.094-.474.172-.899.356-1.797.514-2.698.14-.795-.189-1.3-.966-1.465-.369-.079-.753-.089-1.131-.106-.374-.016-.75-.002-1.138-.002l.408-2.103h-1.429Zm-6.374 2.103c-.044 0-.089.006-.136.01-.428 2.201-.993 4.742-1.421 6.943h1.441c.109-.553.357-1.437.455-1.975.02-.104.06-.13.158-.129.473.002.947.013 1.419-.008.297-.013.598-.052.887-.123 1.083-.265 2.18-1.42 2.058-3.057-.063-.84-.538-1.359-1.358-1.559a3.43 3.43 0 0 0-.768-.098c-.912-.011-1.823-.004-2.735-.004zm11.873 0c-.034 0-.067.005-.108.01-.428 2.197-.994 4.742-1.422 6.946h1.44c.107-.549.356-1.434.454-1.971.02-.113.067-.137.17-.137.485.003.97.01 1.454-.006.64-.021 1.243-.166 1.758-.578.795-.636 1.162-1.474 1.153-2.476-.008-.853-.5-1.468-1.328-1.678a3.416 3.416 0 0 0-.785-.105c-.928-.012-1.857-.005-2.786-.005zM9.33 14.054c.544.032 1.082.032 1.609.104.461.064.657.33.637.797a3.679 3.679 0 0 1-.142.845c-.174.608-.605.945-1.224 1.009-.462.048-.93.042-1.428.062l.548-2.817zm11.9.002c.543.031 1.08.03 1.608.102.462.063.659.327.638.794a3.668 3.668 0 0 1-.152.878c-.178.59-.608.917-1.211.979-.462.048-.928.042-1.43.062l.547-2.816z"
                    transform="matrix(1.14286 0 0 1.10345 -2.286 -6.62)" />
                <path style="opacity:.1;fill:#fff;stroke-width:1.12297"
                    d="M1.6 0C.714 0 0 .69 0 1.545V2.65c0-.856.714-1.546 1.6-1.546h28.8c.886 0 1.6.69 1.6 1.546V1.545C32 .69 31.286 0 30.4 0Z" />
                <path
                    d="M1229.93 594.767c36.644 37.975 50.015 91.328 43.72 142.909-9.128 74.877-30.737 144.983-56.093 215.657-27.129 75.623-54.66 151.09-82.332 226.512-44.263 120.685-88.874 241.237-132.65 362.1-10.877 30.018-18.635 62.072-21.732 93.784-3.376 34.532 21.462 51.526 52.648 36.203 24.977-12.278 49.288-28.992 68.845-48.768 31.952-32.31 63.766-64.776 94.805-97.98 15.515-16.605 30.86-33.397 45.912-50.438 11.993-13.583 24.318-34.02 40.779-42.28 31.17-15.642 55.226 22.846 49.582 49.794-5.39 25.773-23.135 48.383-39.462 68.957l-1.123 1.416a1559.53 1559.53 0 0 0-4.43 5.6c-54.87 69.795-115.043 137.088-183.307 193.977-67.103 55.77-141.607 103.216-223.428 133.98-26.65 10.016-53.957 18.253-81.713 24.563-53.585 12.192-112.798 11.283-167.56 3.333-40.151-5.828-76.246-31.44-93.264-68.707-29.544-64.698-8.98-144.595 6.295-210.45 18.712-80.625 46.8-157.388 75.493-234.619l2.18-5.867 1.092-2.934 2.182-5.87 2.182-5.873c33.254-89.517 67.436-178.676 101.727-267.797 31.294-81.296 62.72-162.537 93.69-243.95 2.364-6.216 5.004-12.389 7.669-18.558l1-2.313c6.835-15.806 13.631-31.617 16.176-48.092 6.109-39.537-22.406-74.738-61.985-51.947-68.42 39.4-119.656 97.992-170.437 156.944l-6.175 7.17c-15.78 18.323-31.582 36.607-47.908 54.286-16.089 17.43-35.243 39.04-62.907 19.07-29.521-21.308-20.765-48.637-3.987-71.785 93.18-128.58 205.056-248.86 350.86-316.783 60.932-28.386 146.113-57.285 225.882-58.233 59.802-.707 116.561 14.29 157.774 56.99zm92.038-579.94c76.703 29.846 118.04 96.533 118.032 190.417-.01 169.189-182.758 284.908-335.53 212.455-78.956-37.446-117.358-126.202-98.219-227.002 26.494-139.598 183.78-227.203 315.717-175.87z"
                    fill-rule="evenodd" style="fill:#fff" transform="matrix(.0047 0 0 .00455 11.479 18.56)" />
            </svg>
        </figure>
    </a>
    <?php
    function warning_msg()
    {
        $msg = '⚠ This file should be moved into a website directory.';
        $user_pref_langs = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);

        foreach ($user_pref_langs as $idx => $lang) {
            $lang = substr($lang, 0, 2);
            if ($lang == 'fr') {
                $msg = '⚠ Ce fichier doit être déplacé dans un dossier (site web).';
                break;
            }
        }
        return $msg;
    }

    ?>
</body>

</html>