<?php
// Xampp-Lite
// https://xampplite.sf.net
/**************************************************************************\
    Original Authors and Contributors:
        http://nevstokes.com/blog/2009/06/23/a-better-phpinfo/
        http://www.page2pagepro.com/a-better-phpinfo/
\**************************************************************************/

$options = array(
  'CONFIGURATION',
  'ENVIRONMENT',
  'MODULES',
  'XDEBUG',
  'EXTENSIONS',
  'VARIABLES',
  'GENERAL',
  'CREDITS',
  'LICENSE',
  'ALL'
);
$display = (empty($_GET['display']) || !in_array(strtoupper($_GET['display']), $options)) ? 'ALL' : strtoupper($_GET['display']);

$navigation = array();

foreach ($options as $key => $value) {
  $navigation[] = ($value != $display) ? '<li><a href="' . $_SERVER['SCRIPT_NAME'] . '?display=' . $value . '">' . $value . '</a></li>' : '<li><a href="' . $_SERVER['SCRIPT_NAME'] . '?display=' . $value . '" class="active">' . $value . '</a></li>';
}

ob_start();

switch ($display) {
  case 'CONFIGURATION':
    phpinfo(INFO_CONFIGURATION);
    break;

  case 'ENVIRONMENT':
    phpinfo(INFO_ENVIRONMENT);
    break;

  case 'MODULES':
    phpinfo(INFO_MODULES);
    break;

  case 'XDEBUG':
    xdebug_info();
    break;

  case 'VARIABLES':
    phpinfo(INFO_VARIABLES);
    break;

  case 'GENERAL':
    phpinfo(INFO_GENERAL);
    break;

  case 'EXTENSIONS':
  case 'CREDITS':
    phpinfo(INFO_CREDITS);
    break;

  case 'LICENSE':
    phpinfo(INFO_LICENSE);
    break;

  case 'ALL':
  default:
    phpinfo();
    break;
}

$content = ob_get_clean();

if (($display) == 'EXTENSIONS') {
  $str = '<body><div class="center">';
  $content = substr($content, 0, strpos("$content$str", $str) + strlen($str));
  ob_start();
  echo '<h2>Enabled PHP Extensions</h2>' . PHP_EOL;
  echo '<table cellpadding="3">' . PHP_EOL;
  echo '<tr><td class="v">' . PHP_EOL;
  $exts = array();
  foreach (get_loaded_extensions() as $ext) {
    $exts[] = $ext;
  }
  echo implode(', ', $exts) . PHP_EOL;
  echo '</td></tr></table>' . PHP_EOL;
  echo '<h2>Function List by Extension</h2>' . PHP_EOL;
  echo '<table cellpadding="3">' . PHP_EOL;
  echo '<tr class="h"><th>Extension</th><th>Functions</th></tr>' . PHP_EOL;
  foreach ($exts as $ext) {
    echo '<tr><td class="e">' . $ext . '</td><td class="v">';
    $funcs = get_extension_funcs($ext);
    if (is_array($funcs)) {
      echo implode(', ', $funcs) . PHP_EOL;
    } else {
      echo 'No functions available' . PHP_EOL; // Handle the case where no functions are available
    }
    echo '</td></tr>' . PHP_EOL;
  }
  echo '</table>' . PHP_EOL;
  echo "</div>" . PHP_EOL;
  echo "</body>" . PHP_EOL . "</html>" . PHP_EOL;
  $content .= ob_get_contents();
  ob_end_clean();
}
$php_version = PHP_VERSION;
$head = <<<HEAD
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="ROBOTS" content="NOINDEX,NOFOLLOW,NOARCHIVE">
    <link rel="icon"
      href="data:image/x-icon;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAABDfAAAQ3wF0VV4wAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAABV1JREFUWIXFl3tsU3UUxz+/373tutJCyzYe614QMDzEwDKYxAgRhflkghoSIMGEYCAkKIhCiKLE8DAEiBEjiS/APwCJ4msQIREwmiAbD6MSmYSNlU1grBvrNtb27v78o9CuvXcbGiMnadLzO4/v95x7f+e0IrpmxFIBGwEv/6+ElWC1iK0Z0XoXwBMk5F0EB/DKuwgOgN6nhy+AKCxGON2olnpUbRXEOu19HS5EUQnCl4eKtqMunYaW+n9JwJONVr4OMWZG6nlHM+aRbZgn96Qcy9J5yEdeArcveagU6twRur5aC+1NtjAitmaEsgVfvB/hz+uRn3nsfcwjW+PgZa8ipyzq0VeFgnTteM6WhO07IGeu6xUcQE5djCgqQQy/v1dwADEwHznzTVub9RH4Asgx0xNqR/AcFz9+mUhjHVml5RTOewshNRACNfl5kMkUqsugZtcqmk4cwJkVYOSSHbgLxsYJjy3D9OVCS0NqIen4qqAYhEjowZ0rGdxazUh3BCr30HTiQLKywhJEYXFCv3bsU/RfvmC0X5IfayC4c2W3NghU/oS+O9ApM3F00wdHG/C44jzdDp0bobqETfNmJYmbBp3HPyLgiad06QJ581Jqbq0fmWl4lg7Emi6n6J6SmUlFc9C/+HFLFQChym8ZGLmScuYdNy0td9ASZ+mAqqnEaGtG9/jjDk+9gcofj2oOIsaWIYaMsiQxozdp+XozhbpIzTV5QeK70RaC2krQ+iDg0WLUf7mZwvkb4gdSQxTPRqT5RRrriDZfIRqqp/GHPQSMq9CNgMi7D23YxIR++fO3GSqNvjugCRCVe2jwB8h9YmlapZ1c/X4n147uJnr9MroUODXIdmtkZnYrTQiYcesFVIqGiu1opz9D81gvne0gUkBtSwyjYCJDpi/EM6IEoTuo3rYAvf4sOf00PE5p6cptkaVzUQ8to/XPSq4c/gA9eIoin8PW33YUC2CYz0Grx4mmSYQQ1Hy4nJzQr/j9DruQZOyEWcgn12K0t6BpkiFeJ15fzzH2oxiQZa8gp7wAwI0z33Fz9xKy3ZqdazxR/njkg4sQY2dYbObxHZiHt9jG2XZAls5NgAM0HXyHgjRwWTwbMfph8GQjBhaAJ7tHcnLqYmiux6zcewcE9AzEI8sTarj6Z/wt58GZHBkiexjy6fWgWcM7gucInTqEK6eArMmz42MbYPoKOHMAjEgfBIZNQnRbqc1HPyHXmTavpi2zB6/7neqN5Xg1g1ZD0VZzlqL56+Nd6OfHLCqBCz+lxFgmYdQ7NKkoRcbFH1Md/AHkuEdv2c3455a0njnEKB8UDnBwT5YT/bdvUnP3D1hIWwl0tCUVIfAPGppiFw8sRNzagLFwCKO9JWHzDilCl8nLNihveGru9jbSxULAqD0NKnkx9Gc3xX8baDqyeDZa6dyErf1CFW0XqhJ6v4mzkKVzweVFBO5Ff2ZTMrFSGLVJ30RB6dew01DE5ryLv/ixVE+zC2S3m6AUdVvngBAUrNhnSZwuoaoKnPtfxJW2LywdcOmC63tfI9JYl2qQqdewoWI77oZTZNZX0VDxXq/gkcY6ru973QJuSwBgqLjBHxvKCVUdTHkcEN9qNbtW0XFoCz6XxO+SdBzcTO3u1fGN112UIlRVwfmN5QS0VltyPU7CTkPF90H/XLwjS5AZbiLXg7RVnyQno4tcr56Y7QqoDxs0RXU8IyfhzM7D7GwnfKEKvfUvinwO2+p7JXBbwlGTtqiJqcCpCQZkSJyafbJol+JGxCTapZACPE6JN32GpEmff0y8d5Dktjg1QU4v+8JOJBD+RxH/rYSlEqy+SyTCSrHqbw9xyy0dDHQ9AAAAAElFTkSuQmCC">
    <title>PHP $php_version - phpinfo()</title>
    <link rel="stylesheet" href="style.css" />
</head>
HEAD;

$xampp_lite_link = <<<XAMPP_LITE
\n<div id='xampp-lite-home'>
     <a href='https://xampplite.sf.net/' target='_blank' title="Visit XAMPP-Lite Website">
        <span>https://</span>xampplite<span>.sf.net/</span>
     </a>
</div>

XAMPP_LITE;

$content = str_replace('<body>', '<body>' . PHP_EOL . '<nav>' . PHP_EOL . '<ul>' . implode(PHP_EOL, $navigation) . '</ul>' . PHP_EOL . '</nav>', $content);
$content = preg_replace('/<!DOCTYPE.*?<\/head>/s', $head, $content);
$content = str_replace('</body>', $xampp_lite_link . '</body>', $content);
echo $content;
