<?php

trait Commons {	//Fonctions communes
	public function plur($qte, $term = 's') {	//marque le pluriel selon la quantite
		return ($qte > 1 ? $term : '');
	}

	public function getPost($cle, $array = null) {	//Retourne la valeur $array ou $_POST si non vide
		if (!$array) $array = $_POST;
		if (!empty($array[$cle]))
			return $array[$cle];
	}

	public function getValue($cle, $array) {	//Retourne la valeur $array si non vide
		if (!$array) return;
		$array = (array) $array;
		if (isset($array[$cle])) {
			return $array[$cle];
		}
	}

	public function getValeur($texte, $tableau) {	//Remplace la clé par la valeur
		foreach($tableau as $cle => $valeur) {
			$texte = str_replace($cle, $valeur . " ", $texte);
		}
		return trim($texte);
	}
	
	public function getPostParam($cle) {	//Retourne la valeur $_POST ou $conf[Param] si non vide
		$retour = "";
		if ($this->getPost($cle))
			$retour = $_POST[$cle];
		elseif (!empty($this->conf->$cle))
			$retour = $this->conf->$cle;
		elseif (!empty($this->conf->simple->$cle))
			$retour = $this->conf->simple->$cle;
		if ($retour)
			return $retour;
	}

	public function getSelectOptions($array, $selecteur) {	//Affiche les options d'un select avec présélection (mot-clé de POST)
		$retour = "";
		if (gettype($array) == "object") {
			$array = get_object_vars($array);
		}
		foreach ($array as $code => $nom) {
			$select = "";
			if (count($array) == 1 OR !empty($_POST[$selecteur]) AND $_POST[$selecteur] == $code)
				$select = " selected";
			elseif (!empty($_POST[$selecteur]) AND is_array($_POST[$selecteur])) {
				foreach($_POST[$selecteur] as $code_select) 
					if ($code_select == $code)
						$select = " selected";
			}
			$retour .= '<option value="' . $code . '"' . $select . '>' . $nom . "</option>\r\n\t";
		}
		return $retour;
	}

	public function getSelectOptionsValue($array, $value) {	//Affiche les options d'un select avec présélection depuis valeur
		$retour = "";
		foreach ((array) $array as $code => $nom) {
			$select = "";
			if (count((array) $array) == 1 || ($value == $code)) {
				$select = " selected";
			}
			
			$retour .= '<option value="' . $code . '"' . $select . '>' . $nom . "</option>\r\n\t";
		}
		return $retour;
	}

	public function getNumeroFormCode(?string $code) {	//Renvoie le code du chant d'après le code simplifié
		if (!$code) return;
		$numero = null;
		if (preg_match('/^(jem)?(1\d{3}m?)$/i', $code, $chant)) {	//jem4		
			
			$numero = "jem" . $chant[2];

		} elseif (preg_match('/^(jemk|jem|atg)?(\d{1,3})(m?)$/i', $code, $chant)) {	//jem, jemk, atg
			
			$prefixe = (!empty($chant[1]) ? strtolower($chant[1]) : "jem");
			$numero = substr("00" . $chant[2], -3);
			$modif = $this->getValue('3', $chant) ?? "";
			$numero = $prefixe . $numero . strtolower($modif);

		} elseif (preg_match('/^af(\d{1,3})([abm]?)$/i', $code, $chant)) {	//af
			
			$numero = substr("00" . $chant[1], -3);
			$suffixe = (!empty($chant[2]) ? strtolower($chant[2]) : "");
			$numero = "af" . $numero . $suffixe;
		}
		return $numero;
	}

	public function getCodeM(string $code) {	//Renvoie le code de la version modifiée
		return rtrim(strtolower($code), 'm') . "m";
	}

	public function getJson($file) {	// Récupère le contenu d'un fichier json, dans le dossier json ou perso
		$json = $this->getFile($file, 'json');
		if (!$json) {
			$json = $this->getSavedFile($this->conf, 'chant', $file);
		}
		return $json;
	}

	public function getFile($file, $folder = 'json') {	// Récupère le contenu d'un fichier json
		$jsonInit = $this->getSimpleFile($file, $folder);
		if ($jsonInit) {
			$json = (new Json)->fromJson($jsonInit);
			if ($json) {
				$json->data->folder = $folder;
			}
			return $json;
		}
		return;
	}

	public function getSimpleFile($file, $folder = 'json') {	// Récupère le contenu d'un fichier
		$filePath = '../' . $folder . '/' . strtolower($file) . '.json';
		if (file_exists($filePath)) {
			$jsonInit = json_decode(file_get_contents($filePath));
			return $jsonInit;
		}
		return;
	}

	public function isFile($file, $folder = 'json') {	// Vérifie si le fichier json existe, dans le dossier json ou perso
		$fichier =  '/' . strtolower($file) . '.json';
		$filePath = '../' . $folder . $fichier;
		if ($folder == 'perso' || !file_exists($filePath)) {
			$filePath = '../perso' . $fichier;
			$folder = (file_exists($filePath) ? 'perso' : null);
		}
		return $folder;
	}

	private function getDir($type) {	//Chemin vers les fichiers
		$dir = '';
		if (in_array($type, ['chant', 'index'])) {
			$dir = '../perso/';
		}
		return $dir;
	}
	
	public function saveFile($conf, $type, $filename, $content) {
		switch($conf->save) {
			case 'files': file_put_contents($this->getDir($type) . $filename, $content);			
				break;
			case 'session': 
				if ($type == 'chant') {
					if (!isset($_SESSION['chant'])) $_SESSION['chant'] = [];
					$chants = $_SESSION['chant'];
					$chants[str_replace('.json', '', $filename)] = $content;
					$_SESSION['chant'] = $chants;
				} else if ($type == 'composition') {
					$_SESSION[$type] = json_encode($content);
				} else {
					$_SESSION[$type] = $content;
				}
				break;
			case 'cookies': {
				$cookie = $this->getCookie($type);
				if ($type == 'chant') {
					if ($cookie) $cookie = [];
					$cookie[str_replace('.json', '', $filename)] = $content;
					$this->saveCookie('chant', json_encode($cookie));
				} else if ($type == 'composition') {
					$this->saveCookie($type, json_encode($content));
				} else {
					$this->saveCookie($type, $content);
				}
				break;
			}
		}
		//print_r_pre([$type, $filename, $content, $_COOKIE, $conf->save], 'save');
	}

	public function getSavedFile($conf, $type, $name = '') {
		$content = null;
		$dir = $this->getDir($type);
		if ($name && file_exists($dir . $name)) {
			$content = file_get_contents($dir . $name);
		}
		switch($conf->save) {
			case 'session': $session = $this->getValue($type, $_SESSION);
				if ($session) {
					if ($type == 'chant') {
					$value = $this->getValue($name, $session);
					$content = $value ? (new Json)->fromJson(json_decode($this->getValue($name, $session))) : null;
					} else if ($type == 'composition') {
						$content = json_decode($session);
						if (!$content) {
							$content = file_get_contents('composition.txt');
						}
					} else {
						$content = $session;
					}
				}
			break;
			case 'cookies': $cookie = $this->getCookie($type);
				if ($cookie) {
					if ($type == 'chant') {
						$content = (new Json)->fromJson(json_decode($this->getValue($name, json_decode($cookie))));
					} else if ($type == 'composition') {
						$content = json_decode($cookie);
						if (!$content) {
							$content = file_get_contents('composition.txt');
						}
					} else {
						$content = $cookie;
					}
				}
			break;
			case 'files': if (!$content) {
				$content = $this->getFile($name, 'perso'); 
			}
			break;
		}
		//print_r_pre([$type, $name, $conf->save, $_COOKIE, $content], 'getSaved');
		return $content;
	}

	public function removeAccents($text, $isSearch = false) {
		$result = preg_replace(["/[àâä]/iu", "/[éèêë]/iu", "/[îï]/iu", "/[ôö]/iu", "/[ùû]/iu", "/[\":,!;]/", "/œ/iu"], ["a", "e", "i", "o", "u", "", "oe"], strtolower($text));
		if (!$isSearch) {
			$result = preg_replace(["/\-/", "/[\.?^]/", "/^\{.*?\}/", "/<\/p>/", "/\r?\n$/", "/ *$/"], [" ", "", "", "", "", ""], $result);
		}
		return $result;
	}

	function getCookie($name) {	//Récupération d'une cookie
		$result = null;
		if (isset($_COOKIE[$name])) {
			if (isset($_SESSION[$name])) {
				$result = $_SESSION[$name];
			} else {
				$explode = explode('|', $_COOKIE[$name]);
				$result = $explode[0];
				if (!isset($explode[1]) || (+$explode[1] < 2629800)) {	//< 1 mois
					if (!isset($_SESSION['saveCookies'])) {
						$_SESSION['saveCookies'] = [];
					}
					$_SESSION['saveCookies'][$name] = $result;
				}
			}
		}
		return $result;
	}

	function getCookieReset($name) {
		$result = null;
		if (isset($_COOKIE[$name])) {
			$explode = explode('|', $_COOKIE[$name]);
			$result = $explode[0];
		}
		return $result;
	}

	function saveCookie($name, $value) {
		$expiration = time() + 7776000;	//3 mois	
		setcookie($name, $value . "|" . $expiration, $expiration, "/", "", false, true);
		$_SESSION[$name] = $value;
	}
	
}

