<?php

class Editor {	//Editeur de chant
	use Commons;

	/** @var Json */
	public $json;

	public $code, $message, $messageImport, $messageImage, $default;

	public function fromJson(?Json $json = null) {	//Données remplies depuis un fichier json
		if (!$json) return;
		$this->json = $json;
	}

	public function getFormParam($cle, $folder = "edition") {	//Liste des paramètres de default->parametres
		global $default;
		$donnees = $default->$folder->$cle;
		$type = $this->getValue('type', $donnees);
		$required = $this->getValue('required', $donnees);
		return  'type="' . ($type ?? 'text') . '" ' . ($required ? 'required ' : '');
	}

	public function fromPost() {
		global $default;
		$json = new Json;
		foreach($default->edition as $cle => $value) {
			$json->{$value->json}->$cle = $this->getPost($cle);
		}
		for ($i=0; $i < count($this->getPost('text')); $i++) { 
			$text = $this->getPost('text')[$i];
			if ($text) {
				$lyric = new JsonLyric;
				foreach((array) $lyric as $cle => $value) {
					$lyric->$cle = $this->getPost($cle)[$i];
				}
				$json->text->lyrics[] = $lyric;
			}
		}
		$picture = $this->getPost('picture');
		$json->data->picture = $picture;
		$this->json = $json;
		return $json;
	}

	public function enregistre(Json $json) {	//Enregistrement le fichier d'édition
		global $conf;
		$message = "";
		$this->saveFile($conf, 'chant', strtolower($json->text->code). '.json', json_encode($json));
		$message = "Le fichier a été enregistré.";
		
		$this->add2Index($json);

		return $message;
	}

	private function add2Index(Json $json) {	//Ajouter dans l'index des chants ajoutés
		global $conf;
		$savedIndex = $this->getSavedFile($conf, 'index', 'index.json');
		$index = $savedIndex ? json_decode($savedIndex) : new stdClass;
		$newFile = new JsonIndex;
		$newFile->title = $json->text->title;
		$newFile->subtitle = $json->data->subtitle;
		$index->{$json->text->code} = $newFile;
		$arrayIndex = (array) $index;
		uasort($arrayIndex, function($a, $b) {
			return strcmp($a->title, $b->title);
		});
		$this->saveFile($conf, 'index', 'index.json', json_encode((object) $arrayIndex));
	}

	public function import() {	//Import d chant au format actuel (.json) ou ancien (.txt)
		if ($_FILES['import']['error'] === UPLOAD_ERR_OK) {
			try {
				set_error_handler(function($errno, $errstr, $errfile, $errline) {
					throw new ErrorException($errstr, $errno, 0, $errfile, $errline);
				});
				
				$fichier = $_FILES['import'];
				$splitFichier = explode('.', strtolower($fichier['name']));
				$chemin = '../prog/import.' . $splitFichier[1];
				move_uploaded_file($fichier['tmp_name'], $chemin);
				$chant = file_get_contents($chemin);
				unlink($chemin);
				$json = new Json;
				//print_r_pre($chant, $fichier['name']);

				if ($splitFichier[1] == 'json') {	//Fichier json
					$json = $json->fromJson(json_decode($chant));

				} else {	//Fichier txt, ancienne version
					//Titre
					preg_match('/<h1>(.*?)(<sub>(.*?)<\/sub>)?<\/h1>/is', $chant, $matchTitle);
					$json->text->title = trim($matchTitle[1]);
					if (isset($matchTitle[3])) {
						$json->data->subtitle = trim($matchTitle[3]);
					}
					
					//Compositeur
					preg_match('/<h2>(.*?)<\/h2>/is', $chant, $matchComposer);
					$json->text->composer = trim($matchComposer[1]);
		
					//Auteur
					preg_match('/<h4>.*?Texte de (.*?)\r?\n/is', $chant, $matchAuthor);
					$json->text->author = trim($matchAuthor[1]);
					
					//Copyright
					preg_match('/(©.*?)</i', $chant, $matchCopyright);
					if (isset($matchCopyright[1])) {
						$json->text->copyright = trim($matchCopyright[1]);
					}
		
					//Référence
					preg_match('/<h4>(.*?)<\/h4>/is', $chant, $matchReference);
					if (isset($matchReference[1])) {
						$split = preg_split("/\r?\n/", $matchReference[1]);
						if (isset($split[2]) && mb_substr($split[2], 0, 1) != "©") {
							$json->text->reference = trim($split[2]);
						}
					}
		
					//Copyright
					preg_match('/data-image="(\d{2})"/i', $chant, $matchImage);
					if (isset($matchImage[1])) {
						$json->data->picture = $matchImage[1];
					}
					
					preg_match_all('/<div class="(.*?)" data-nom="(.*?)">(.*?)<\/div>/is', $chant, $matchContenu);
					global $default;
					$parts = array_keys((array) $default->afficher->parties);
					foreach($matchContenu[3] as $i => $partContenu) {
						$type = "";
						for ($j=0; $j < count($parts) && !$type; $j++) { 
							if (strpos($matchContenu[2][$i], $parts[$j]) === 0) {
								$type = $parts[$j];
							}
						}
						preg_match('/\d+$/', $matchContenu[2][$i], $matchNum);
						if (isset($matchNum[0])) {
							$lyric['part'] = $matchNum[0];
						}
						$lyric = [
							"style" => $matchContenu[1][$i],
							"type" => $type,
							"part" => $this->getValue(0,  $matchNum),
							"text" => $partContenu
						];
						
						$json->text->lyrics[$i] = $lyric;
					}
					$json->text->code = strtoupper(explode('.', $fichier['name'])[0]);
				}
				
				//print_r_pre($json, 'json');
				$this->fromJson($json);

			} catch (Exception $e) {
				$this->messageImport = 'Contenu de fichier incorrect';
			}
		} else {
			$this->messageImport = 'Erreur de fichier';
		}
	}
}

