<?php

class JsonRef {	//Référence biblique
	use Commons;

	public $version, $livre, $livreNom, $chapitre_deb, $verset_deb, $chapitre_fin, $verset_fin, $check_fin, $code_livre, $livreJson, $liens = [];

	public function fromCode(?string $code) {	//Données depuis un code
		if (!$code) return;
		global $default;
		$livres_bible = array_merge(get_object_vars($default->bible->Livres_AT), get_object_vars($default->bible->Livres_NT));
		preg_match('/^(.*?):?(\d+)?(\.\d+)?(-\d+)?(-?\.?[\d+|f])?$/i', $code, $ref);
		if (array_key_exists(strtoupper($ref[1]), $livres_bible)) {
			$this->version = 'semeur';
			$this->livre = strtoupper($ref[1]);
		} elseif(strtolower($ref[1][0]) == "s" AND array_key_exists(strtoupper(substr($ref[1], 1)), $livres_bible)) {
			$this->version = 'segond';
			$this->livre = strtoupper(substr($ref[1], 1));
		}
		if (!empty($ref[2])) $this->chapitre_deb = $ref[2];
		if (!empty($ref[3])) $this->verset_deb = substr($ref[3], 1);
		if (isset($ref[5])) {
			if ($ref[4]) $this->chapitre_fin = substr($ref[4], 1);
			$this->verset_fin = substr($ref[5], 1);
		} else {
			if (isset($ref[4]) && !$ref[3]) $this->chapitre_fin = substr($ref[4], 1);
			if (isset($ref[4]) && $ref[3]) $this->verset_fin = substr($ref[4], 1);
		}			
		return $this;
	}

	public function fromPost() {	//Données depuis le formulaire
		foreach($_POST as $key => $value) {
			$this->$key = $value;
		}
		if (isset($_POST['check_fin'])) $this->verset_fin =  'f';
	}

	public function getLivre() {
		if ($this->livre && !$this->livreJson) {
			$this->code_livre = ($this->version == "segond" ? "s" : "") . strtolower($this->livre);
			$this->livreJson = $this->getSimpleFile(strtolower($this->livre), 'json/bible/' . $this->version);
			if ($this->livreJson) {
				$this->livreNom = $this->livreJson->name;
			}
		}
		return $this->livreJson;
	}

	public function getReference() {	//Référence longue
		$reference = (!$this->chapitre_deb ? "Livre entier" : "Chapitre " . $this->chapitre_deb . ($this->verset_deb ? " verset " . $this->verset_deb : "") . ($this->chapitre_fin ? " à chapitre " . $this->chapitre_fin : "") . ($this->verset_fin ? ($this->verset_fin == "f" ? " jusqu'à la fin" : ($this->chapitre_fin ? " verset " : " à ") . $this->verset_fin ) : ""));
		return $reference;
	}
	
	public function getRef() {	//Référence courte
		global $default;
		$livres_bible = array_merge(get_object_vars($default->bible->Livres_AT), get_object_vars($default->bible->Livres_NT));
		$reference = (isset($livres_bible[$this->livre]) ? $livres_bible[$this->livre] . ($this->chapitre_deb ? " : ch. " . $this->chapitre_deb . ($this->verset_deb ? " v. " . $this->verset_deb : "") . ($this->chapitre_fin ? " - ch. " . $this->chapitre_fin : "") . ($this->verset_fin ? ($this->verset_fin == "f" ? " -> fin" : " - " . $this->verset_fin ) : "") : "") : "Livre inconnu");
		return $reference;
	}

	public function getPassage() {	//Passage complet
		$passage = "";
		foreach((array) $this->livreJson->chapters as $ch => $texte) {
			if (!(!$this->chapitre_deb || (!$this->chapitre_fin && $ch == $this->chapitre_deb || $ch >= $this->chapitre_deb && $ch <= $this->chapitre_fin))) continue;
			$verset_fin_num = (!$this->chapitre_deb || $ch < $this->chapitre_fin || !$this->verset_deb || $this->verset_fin == "f" ? count((array) $texte) : ($this->verset_fin ?: $this->verset_deb));
			//Concaténation du texte
			for ($i = ($this->verset_deb && $ch == $this->chapitre_deb ? $this->verset_deb : 1); $i <= $verset_fin_num; $i++) {
				if ($i == 1) {
					$passage .= "</p>\n<a name=\"p" . ($ch - 1) . '" nom="' . $ch . '" class="sansTrait">&nbsp;</a><h2 class="chapitre">Chapitre ' . $ch . "</h2>\n";
					$this->liens[] = "Ch.$ch";
				}
				if (!isset($texte->$i)) continue;
				$verset = $texte->$i;
				$passage .= $this->getTexte($verset, $i);
			}
		}
		return $passage;
	}

	public function getTexte($jsonVerset, $ref, $isRecherche = false) {
		$passage = "";
		if (!$isRecherche) {
			if (isset($jsonVerset->title)) $passage .= '<h2>' . $jsonVerset->title . "</h2>\n";
			if (isset($jsonVerset->subtitle)) $passage .= '<h3>' . $jsonVerset->subtitle . "</h3>\n";
		}
		$versetTexte = $jsonVerset->text;
		//print_r_pre($jsonVerset);
		if (strpos($jsonVerset->text, '{p}') === 0) {
			$passage .= "</p>\n<p>";
			$versetTexte = substr($versetTexte, 3);
		}
		if (strpos($jsonVerset->text, '{pi}') === 0) {
			$passage .= "</p>\n<p class=\"retrait\">";
			$versetTexte = substr($versetTexte, 4);
		}
		if (strpos($jsonVerset->text, '<q>') === 0) {
			$passage .= "<q>";
			$versetTexte = substr($versetTexte, 3);
		}
		$versetTexte = preg_replace(['/\{p\}/', '/\{pi\}/'], ['</p><p>', '</p><p class="retrait">'], $versetTexte);
		//print_r_pre([$jsonVerset, $versetTexte]);
		$passage .= '<small>' . $ref . '</small>' . $versetTexte;
		return $passage;
	}

	public function getCode() {	//Code du passage
		return strtoupper($this->code_livre) . ($this->chapitre_deb ? ":" . $this->chapitre_deb . ($this->verset_deb ? "." . $this->verset_deb : "") . ($this->chapitre_fin || $this->verset_fin ? '-' : '') . $this->chapitre_fin . ($this->chapitre_fin && $this->verset_fin ? '.' : '') . $this->verset_fin : "");
	}
}

