<?php

class Manager {	//Gestion des pages

	use Commons;

	protected $page, $prev_titre, $default, $conf, $livres_bible, $recueils, $liste_recueils, $versions;
	
	public function __construct($default, $conf) {
		$this->default = $default;
		$this->conf = $conf;
		$this->page = new Page;
		$this->livres_bible = array_merge(get_object_vars($this->default->bible->Livres_AT), get_object_vars($this->default->bible->Livres_NT));
		//Liste des recueils de chant utilisés
		$this->recueils = get_object_vars($this->default->afficher->recueils);
		$recueils_utils = (!empty($this->conf->Recueil_Util) ? array_merge($this->conf->Recueils, $this->conf->Recueil_Util) : $this->conf->recueils);
		foreach($recueils_utils as $nom) {
			if (isset($this->recueils[$nom])) {
				$this->liste_recueils[$nom] = $this->recueils[$nom];
			}
		}
		$index = $this->getSimpleFile('index', 'perso');
		if ($index) {
			$this->liste_recueils['perso'] = "Chants ajoutés";
		}
		//Liste des versions bibliques
		foreach($this->conf->versions as $nom)
			$this->versions[$nom] = $this->default->afficher->versions->{$nom};
	}

	//Fonctions utilisées
	
	private $chant_edit;
	
	protected function getChecked($code, $selecteur) {	// Coche les checkbox avec présélection (mot-clé de POST)
		$param = $this->getPostParam($selecteur);
		if ($param)
			if (is_array($param) AND in_array($code, $param) OR $code == $param)
				return " checked ";
	}

	protected function getParam($param, $titre) {	// Affiche le paramètre complet prérempli
		$retour = "<div><h2>" . $titre . "</h2>\n";
		$i = 0;
		foreach($this->default->afficher->$param as $code => $nom){
			$type = $this->default->parametres->$param->type;
			$retour .= '<p><input id="choix_' . $param . '_' . $i . '" name="' . $param . ($type == 'checkbox' ? '[]' : '') . '" value="' . $code . '" ' . $this->getFormParam($param, 0) . $this->getChecked($code, $param) . '/><label for="choix_' . $param . '_' . $i . '" >' . $nom . '</label>' . "\n";
			$i++;
		}
		return $retour . "</div>\n";
	}

	public function getFormParam($cle, $id = 1, $folder = 'parametres') {	//Liste des paramètres de default->parametres
		if (isset($this->default->$folder->$cle)) {
			$donnees = $this->default->$folder->$cle;
			$retour = ($id ? ' id="' . $cle . '" ' : '');
			$param = array();
			foreach($donnees as $key => $value)
				$param[] = $key . '="' . $value . '"';
			$retour .= implode(" ", $param);
			return $retour;
		}
	}

	protected function ligneIndex($code, $infos, $indexList) {	//Retourne une ligne d'index transformée
		$textModif = in_array(strtolower($code) . "m", $indexList) ? '<span class="codeM" title="Chant modifié">M</span>' : '';
		return "<p class=\"res-index\"><span class=\"code\">" . $code ."</span>" . $textModif . $infos->title . (isset($infos->subtitle) ? '<sub>' . $infos->subtitle . "</sub>" : "") . "</p>\n";
	}

	protected function getCles($string_cles) {	//Retourne les mots-clés pour la recherche
		$cles = explode("\r\n", $string_cles);
		foreach($cles as $key => $mot) {
			$cles[$key] = preg_replace(array('/oe/', '/"/'), array('(oe|œ)', '(« | »)'), $mot);
		}
		return $cles;
	}
	
	protected function getLiens($pattern, $contenu) {	//Cherche les ancres du contenu
		preg_match_all($pattern, $contenu, $match, PREG_SET_ORDER);
		$liens = array();
		if (!empty($match))
			foreach($match as $valeurs)
				$liens[$valeurs[1]] = $valeurs[2];
		return ($liens ? $liens : " ");
	}
	
	protected function isLivre($code){	//Vérifie si on a un livre de la Bible et retourn le titre
		$trouve = false;
		if (preg_match('/^[a-z0-9:\-\.]+$/i', $code))
			foreach($this->livres_bible as $code_livre => $nom) {
				if (preg_match('/^' . preg_replace('/^s/i', 's?', $code) . '$/i', $code_livre)) $trouve = $nom;
			}
		return $trouve;
	}
		
	protected function getMotsCles() {	//Liste des mots-clés en ligne avec couleurs
		$array_cles = explode("\r\n", $_POST['mots-cles']);
		foreach($array_cles as $i => $cle)
			$array_cles[$i] = '<span class="mot-cle Coul_' . $i%5 . '">' . $cle . '</span>';
		return implode(', ' , $array_cles);
	}
		
	protected function getLivre($texte) {	//Formate un livre complet de la Bible
		$retour = preg_replace('/^(Bible:.*?\r\n)/s', '', $texte);
		$retour = preg_replace('/<!--(\d+)_0-->/', '<a name="ch$1" nom="' . (PREV ? 'Ch.' : '') . '$1">&nbsp;</a><h2 class="chapitre">Chapitre $1</h2>', $retour);
		return $retour;
	}
	
	protected function getElt($tag) {	//Renvoie le contenu du tag dans le chant
		$retour = "";
		if ($this->chant_edit->getElementsByTagName($tag)->length == 1) 
			$retour = $this->chant_edit->getElementsByTagName($tag)->item(0)->textContent;
		return trim($retour);
	}
	
	protected function getEcrans() {	//Renvoie les attributs des écrans
		$liste_parties = implode('|', array_keys((array) $this->default->afficher->parties));
		foreach(array('div', 'a', 'data', 'body') as $element) {
			foreach($this->chant_edit->getElementsByTagName($element) as $i => $item) {
				$j = $i + 1;
				if ($element == 'div' AND $item->textContent)
					$_POST['Ecran_' . $j] = $item->textContent;
				foreach($item->attributes as $cle => $attribut) {
					switch($cle) {
						case 'class' : $_POST['Style_' . $j] = $attribut->value; break;
						case 'nom' :
						case 'data-nom' : $nom = $attribut->value;
							if (preg_match('/^(' . $liste_parties . ')(.*)/i', $nom, $match)) {
								$_POST['Partie_' . $j] = trim($match[1]);
								$_POST['Numero_' . $j] = trim($match[2]);
							}
							break;
						case 'data-image' :
						case 'style' : $image = $attribut->value;
							if (preg_match('/background-image:url\(\.*\/fonds\/(.*)\)/i', $image, $match))
								$_POST['edit_image'] = $match[1];
							elseif (preg_match('/^\d{2}$/i', $image, $match)) 
								$_POST['edit_image'] = 'jem@fonds/image' . $match[0] . '.jpg';
							break;
					}
				}
			}
		}
	}
	
	public function renvoi() {	//Renvoi aux différentes pages
		if (!empty($_GET)) {
			if (isset($_GET['accueil'])) $this->accueil();
			elseif (isset($_GET['chant'])) $this->chant($_GET['chant']);
			elseif (isset($_GET['liste']) AND empty($_GET['liste'])) $this->liste();
			elseif (isset($_GET['liste'])) $this->liste_recueil($_GET['liste']);
			elseif (isset($_GET['rech-chant'])) $this->rech_chant();
			elseif (isset($_GET['choix-b'])) $this->choix_passage();
			elseif (isset($_GET['lecture-b'])) $this->lecture_biblique();
			elseif (isset($_GET['rech-b'])) $this->rech_biblique();
			elseif (isset($_GET['redirige'])) $this->redirige();
			elseif (isset($_GET['parametres'])) $this->parametres();
			elseif (isset($_GET['aide'])) $this->aide();
		}
	}

	public function accueil() {	//Page d'accueil
		$page = file_get_contents('accueil.html');
			
		$page = preg_replace('/<(h2|p.*?)>(.*?)<\/(.*?)>/is', "<$1><span>$2</span></$3>", $page);
			
		$this->page->contenu = $page;
		$this->page->numero = 'accueil';
		$this->page->titre = "Accueil | v-jemaf 7";
	}

	public function aide() {	//Page d'aide
		$page = $page = file_get_contents('aide.html');
		$page = preg_replace_callback('/\[(.*?)\]/', function($match) {
			return $this->page->svg($match[1]);
		}, $page);
		$page = preg_replace_callback('/{(.*?)}/', function($match) {
			$contenu = "";
			foreach((array) $this->default->bible->{$match[1]} as $code => $livre) {
				$contenu .= "<p><span class=\"strong copy\">$code</span> : $livre</p>\n";
			}
			return $contenu;
		}, $page);
		$this->page->contenu = $page;
		$this->page->numero = 'aide';
		$this->page->titre = "Aide | v-jemaf 7";
		$this->page->prev_titre = "Aide de v-jemaf 7";
		$this->page->liens = ['Menu', 'Codes', 'Références bibliques', 'Ancien testament', 'Nouveau testament'];
	}
	
	public function chant($code) {	//Afficher un chant
		$this->page->titre = "Ecran noir";
		$this->page->numero = $code;
		if ($code) { 
			$json = $this->getJson($code);
			if ($json) {
				$this->page->titre = $json->text->code . " - " . $json->text->title;
				$this->page->prev_titre = $json->text->title;
				
				$folder = preg_match('/perso\d+/', $json->data->picture) ? 'perso/images/' : 'img/jem@fonds/image';
				$page = "<div class=\"chant " . $this->conf->style . ' ' . (!PREV ? $this->conf->sauts : 'sauts_sans') . ($this->conf->style == 'photo_avec' && $json->data->picture ? " fond\" style=\"background-image: url(" . $folder . $json->data->picture . ".jpg);" : "") . ($this->conf->style == 'fond_image' ? " fond" : "") . "\">\n";
				$page .= "<h1><span>" . $json->text->title . ($json->data->subtitle ? '<sub><span>' . $json->data->subtitle . '</span></sub>' : '') . "</span></h1>\n";
				if ($json->text->composer) $page .= "<h2><span>" . $json->text->composer . "</span></h2>\n";
				$page .= "<h4><span>" . strtoupper($json->text->code) . ". " . $json->text->title . "\n";
				if ($json->text->reference) $page .= $json->text->reference . "\n";
				if ($json->text->author) $page .= "Texte de " . $json->text->author . "\n";
				if ($json->text->comment) $page .= $json->text->comment . "\n";
				if ($json->text->original) $page .= "Version originale : " . $json->text->original . "\n";
				$page .= $json->text->copyright;
				
				$jsonM = $this->getFile($json->text->code . 'm', 'perso');
				if ($jsonM) {
					$page .= "\n<p class=\"res-index\"><span class=\"code\">" . $jsonM->text->code . "</span>Version modifiée</p>";
				}
				$page .= "</span></h4>\n";
				
				foreach($json->text->lyrics as $i => $lyric) {
					$page .= "<a name=\"p$i\">&nbsp;</a>";
					if (PREV) $page .= "<h3><span>" . $this->getValeur($lyric->type, $this->default->afficher->parties) . (isset($lyric->part) ? " " . $lyric->part : "") . "</span></h3>";
					$dataNom = $lyric->type . (isset($lyric->part) ? $lyric->part : "");
					$this->page->addLien($dataNom);
					$page .= "<div class=\"" . ($this->conf->align == 'align_centre' ? 'center ' : '') . $lyric->style . "\" data-nom=\"" . $dataNom . "\"><span>" . $lyric->text . "</span>";
					if (!PREV && $this->conf->sauts == 'sauts_previsu' && isset($json->text->lyrics[$i + 1])) {
						$page .= "\n<p class=\"p-grey\"><span>" . preg_split('/\R/', $json->text->lyrics[$i + 1]->text)[0] . "…</span><p>";
					}
					$page .= "</div>\n";
				}
				$page .= "<div id=\"fin\"><img src=\"img/fin.png\" />";
				$this->page->contenu = $page;
			} else $this->prev_titre = "Fichier inexistant";
		} else {
			$this->page->numero = "N";
		}
	}
	
	public function liste() {	//Afficher un chant - choisir un recueil
		$this->page->titre = "Afficher un chant";
		$page = "<div><h1>" . $this->page->titre . "</h1>\n";
		$page .= "<h2>Recueil :</h2>\n";
		foreach ($this->liste_recueils as $code => $nom) {
			$page .= '<a class="recueil" href="' . PREV . 'liste=' . $code . '">' . $nom . '</a>';
		}
		$this->page->contenu = $page . "</div>";
	}
	
	private function getListeModif() {	//Liste des chants modifiés
		switch($this->conf->save) {
			case 'files': $list = scandir('../perso');
				$indexList = array_map(function($elt) { return str_replace('.json', '', $elt);}, $list); break;
			case 'session': $indexList = array_keys($this->getValue('chant', $_SESSION) ?? []);
				break;
			case 'cookies': $indexList = array_keys((array) json_decode($this->getCookie('chant')) ?? []);
				break;
		}
		return $indexList;
	}
	
	public function liste_recueil($recueil) {	//Afficher l'index d'un recueil
		if ($recueil == "perso") {
			$nom_recueil = "Chants ajoutés";
			$this->page->numero = "iperso";
			$chants = json_decode($this->getSavedFile($this->conf, 'index', 'index.json'));
		} else {
			$nom_recueil = $this->recueils[$recueil];
			$this->page->numero = "i" . $recueil;
			$chants = $this->getSimpleFile('index')->$recueil;			
		}
		$this->page->titre = "Index de « " . $nom_recueil . " »";
		$page = "<div><h1>" . $this->page->titre . "</h1>\n<div class=\"index\">";
		$oldLetter = "";
		$i = 0;
		$indexList = $this->getListeModif();
		foreach($chants as $code => $infos) {
			$letter = mb_substr($infos->title, 0, 1, 'UTF-8');
			if ($oldLetter != $letter) {
				$page .= "<a name=\"p$i\" nom=\"$letter\">&nbsp;</a><h2>$letter</h2>\n";
				$this->page->addLien($letter);
				$oldLetter = $letter;
				$i++;
			}
			$page .= $this->ligneIndex($code, $infos, $indexList);			
		}
		$page .= "</div></div>";		
		
		$this->page->contenu = $page;
	}
	
	public function rech_chant() {	//Rechercher un chant
		
		if (empty($_POST)) {
			$_POST = $this->getPost('post-chant', $_SESSION);
		}

		$this->page->titre = "Rechercher un chant";
		$page = "<div class=\"recherche\"><h1>" . $this->page->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST">
			<div class="flex-1"><label for="mots-cles">Mots-clés :</label><textarea ' . $this->getFormParam("mots_cles", 1, 'formulaire') . '>' . $this->getPost('mots-cles') . '</textarea><p class="hint">Recherche sans accent ni ponctuation</p></div>
			<div><div><label for="recueils">Recueils :</label><select ' . $this->getFormParam("recueils", 1, 'formulaire') . ">\n" . $this->getSelectOptions($this->liste_recueils, 'recueils') . '</select></div></div>
			<div><div><label for="rech-dans">Dans :</label><select ' . $this->getFormParam("rech_dans", 1, 'formulaire') . ">\n" . $this->getSelectOptions($this->default->afficher->rech_dans_c, 'rech-dans') . '</select></div></div>
			<div><div><input type="submit" class="bouton" value="Rechercher" /></div></div>
			</form>';
		
		if (empty($_POST)) {
			$page .= "<p>Aucune recherche actuellement</p>";
		} else {
			$_SESSION['post-chant'] = $_POST;
			$page .= "<h3>Recherche dans les " . $this->getPost('rech-dans') . " — Mots-clés : " . str_replace("\r\n", ", ", $this->getPost('mots-cles')) . "</h3><div class=\"index\">\n";
			$nb_total = 0;
			$cles = $this->getCles($this->getPost('mots-cles'));
			$clesPurged = [];
			foreach($cles as $cle) {
				$clesPurged[] = $this->removeAccents($cle, true);
			}
			$indexList = $this->getListeModif();
			foreach($this->getPost('recueils') as $i => $code_recueil) {
				$nom_recueil = $this->liste_recueils[$code_recueil];
				$page .= "<a name=\"p" . $i . "\" nom=\"" . $nom_recueil . "\">&nbsp;</a>\n";
				$page .= "<h2 class=\"resume\"><span class=\"drop-down\">" . $this->page->svgMenu('arrow_drop_down') . "</span><span class=\"drop-up d-none\">" . $this->page->svgMenu('arrow_drop_up') . "</span>" . $nom_recueil . "</h2>\n<div class=\"details\">";
				$this->page->addLien(strtoupper($code_recueil));
				if ($code_recueil == "perso") {
					$index = json_decode($this->getSavedFile($this->conf, 'index', 'index.json'));
				} else {
					$index = $this->getSimpleFile('index');
				}
				$nb_recueil = 0;
				foreach(($code_recueil == "perso" ? $index : $index->$code_recueil) as $code => $infos) {
					if ($_POST['rech-dans'] == 'paroles') {
						$json = $this->getJson($code);
						if (!$json) continue;
						$array = (array) $json->text;
						unset($array['lyrics']);
						foreach($json->text->lyrics as $part) {
							$array[] = $part->text;
						}
						$chant = implode('|', $array);
					}
					else $chant = $infos->title;
					$trouve_tous =  0;
					//print_r_pre([$chant, $cles], $code);
					$chant_filtre = $this->removeAccents($chant);
					foreach($clesPurged as $cle) {
						if(preg_match('/' . $cle . '/is', $chant_filtre)) $trouve_tous += 1;
					}
					if ($trouve_tous == count($cles)) {
						$page .= $this->ligneIndex($code, $infos, $indexList);
						$nb_recueil++;
					}
				}
				$page .= "</div>\n<div class=\"nb_recueil\">$nb_recueil résultat" . $this->plur($nb_recueil) . "</div>\n";
				$nb_total += $nb_recueil;
			}
			$page .= '<div class="nb_total">Total : ' . $nb_total . ' résultat' . $this->plur($nb_total) . '</div></div></div>';
		}
		
		$this->page->contenu = $page;
	}
	
	public function choix_passage() {	//Afficher un passage biblique
		$this->page->titre = "Choix du passage biblique";
		$page = "<div><div class=\"flex-column\"><h1>" . $this->page->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST" action="' . PREV . 'lecture-b">
			<div><div><label for="version">Version bible :</label><select ' . $this->getFormParam("version", 1, "formulaire") . '>' . $this->getSelectOptions($this->versions, 'version') . '</select></div></div>
			<div><label for="livre_AT">Ancien testament :</label><select ' . $this->getFormParam("livre_AT", 1, "formulaire") . ' size="' . (PREV ? 5 : 25) . '">' . $this->getSelectOptions($this->default->bible->Livres_AT, 'livre') . '</select></div>
			<div><label for="livre_NT">Nouveau testament :</label><select ' . $this->getFormParam("livre_NT", 1, "formulaire") . ' size="' . (PREV ? 5 : 25) . '">' . $this->getSelectOptions($this->default->bible->Livres_NT, 'livre') . '</select></div>
			<div class="flex-1"><div><span class="label">De :</span>
			<div class="flex">
			<div class="flex gap-0"><label for="chapitre_deb">chapitre</label><input  class="ml-2" ' . $this->getFormParam("chapitre_deb", 1, "formulaire") . ' value="' . $this->getPost('chapitre_deb') . '"/></div>
			<div class="flex gap-0"><label for="verset_deb">verset</label><input  class="ml-2" ' . $this->getFormParam("verset_deb", 1, "formulaire") . ' value="' . $this->getPost('verset_deb') . '"/></div></div>
			<br/><span class="label">À</span>
			<div class="flex">
				<div class="flex gap-0"><label for="chapitre_fin">chapitre</label><div><input class="ml-2" ' . $this->getFormParam("chapitre_fin", 1, "formulaire") . ' value="' . $this->getPost('chapitre_fin') . '"/></div></div>
				<div><div style="display:flex;"><div class="flex gap-0"><label for="verset_fin">Verset</label><div><input class="ml-2" ' . $this->getFormParam("verset_fin", 1, "formulaire") . ' value="' . $this->getPost('verset_fin') . '"/></div></div>
				<div><input  class="ml-2" ' . $this->getFormParam("check_fin", 1, "formulaire") . ' value="' . $this->getPost('checked_fin') . '"><label for="check_fin">Fin</label></div></div></div>
			</div>
			<p class="message" style="display: none;"></p>
			<input class="bouton" id="passage_bible" type="submit" value="Afficher" /></div></div>
			</form></div></div>';
				
		$this->page->contenu = $page;
	}
	
	public function lecture_biblique() {	//Afficher un passage biblique
		$code = $this->getPost('code');
		$jsonRef = new JsonRef;
		if ($code) {
			$jsonRef->fromCode($code);
		} else {
			$jsonRef->fromPost();
		}
		if ($jsonRef->getLivre()) {
			$entete = '<div class="Ref"><h1>' . $jsonRef->livreNom . "</h1>" . ($jsonRef->chapitre_deb ? "\r\n<h2>" . $jsonRef->getReference() . "</h2>" : "") . "\r\n<h4>" . strtoupper($jsonRef->code_livre) . ". " . $jsonRef->livreNom . ($jsonRef->version ? "<br/>\r\n" . $this->default->afficher->versions_long->{$jsonRef->version} : "") . "</h4></div>\r\n";
			
			$this->page->titre = $jsonRef->getRef();
			$this->page->prev_titre = $jsonRef->livreNom;

			$this->page->contenu = '<div class="div-Bible Bible">' . $entete . $jsonRef->getPassage() . '</div>';
			
			$this->page->liens = $jsonRef->liens;

			$this->page->numero = $jsonRef->getCode();

		} else if ($jsonRef->livre) {
			$this->page->contenu = '</div><p class="message Bible">Le fichier ' . $jsonRef->livre . '.txt n\'existe plus.</p>';
		}
	}
	
	public function rech_biblique() {	//Rechercher un verset biblique
		
		if (empty($_POST)) {
			$_POST = $this->getPost('post-bible', $_SESSION);
		}
		
		$livre_post = $this->getPost('rech_dans_livre');
		$rech_dans = $this->getPost('rech_dans_b');
		$livre = (($livre_post AND array_key_exists($livre_post, $this->livres_bible) AND $rech_dans == "livre") ? $livre_post : "");
		$rech_dans = (($rech_dans == "livre" AND !$livre) ? "bible" : $rech_dans);
		
		$this->page->titre = "Rechercher un verset";
		$page = "<div class=\"recherche\"><h1>" . $this->page->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST">
			<div class="flex-1"><label for="mots-cles">Mots-clés :</label><textarea ' . $this->getFormParam("mots_cles", 1, 'formulaire') . '>' . $this->getPost('mots-cles') . '</textarea><p class="hint">Recherche sans accent ni ponctuation</p></div>
			<div><div><label for="rech-version">Version :</label><select ' . $this->getFormParam("rech-version", 1, 'formulaire') . '>' . $this->getSelectOptions($this->versions, 'version') . '</select></div></div>
			<div><div><label for="rech_dans_b">Dans :</label><select ' . $this->getFormParam("rech_dans_b", 1, 'formulaire') . '>' . $this->getSelectOptions($this->default->afficher->rech_dans_b, 'rech_dans_b') . '</select></div></div>
			<div><div><input type="submit" class="bouton" value="Rechercher" />
			<div id="div-livre"><label for="rech_dans_livre">Livre :</label><input ' . $this->getFormParam("rech_dans_livre", 1, 'formulaire') . " value=\"" . $livre . "\"/>\r\n" . '<datalist id="livres-bible">' . $this->getSelectOptions($this->livres_bible, 'rech_dans_livre') . '</datalist></div>
			</div></div>
			</form>';
		
		if (empty($_POST)) 
			$page .= "<p>Aucune recherche actuellement</p>";
		else {
			$_SESSION['post-bible'] = $_POST;
			$message_erreur = "";
			if ($livre_post AND !array_key_exists($livre_post, $this->livres_bible) AND $rech_dans == "livre")
				$message_erreur = "Le livre demandé n'existe pas";
			$page .= "<p class=\"message\">" . $message_erreur . "</p>\n";
			$page .= "<h3>Recherche dans " . ($livre ? "« " . $this->livres_bible[$livre] . " »" : $this->default->bible->rech_dans->$rech_dans) . " — Mots-clés : " . $this->getMotsCles() . "</h3>";
			
			//Version de la Bible
			$version = $this->getPost('version');
			$s_version = ($version == "segond" ? "S" : "");
			
			$page .= '<p class="version-Bible"> ' . $this->default->afficher->version_aff->$version . "</p>\r\n";
			
			//Liste des livres
			$liste_livres = [];
			if ($livre) $liste_livres[] = $livre;
			else {
				$array_livres = ($rech_dans == "bible" ? $this->livres_bible : $this->default->bible->{'Livres_' . $rech_dans});
				foreach(array_keys((array) $array_livres) as $cle) $liste_livres[] = $cle;
			}
			
			$cles = $this->getCles($_POST['mots-cles']);
			$clesPurged = [];
			foreach($cles as $cle) {
				$clesPurged[] = $this->removeAccents($cle, true);
			}
			
			$page .= "<div id=\"div-res-bible\">\n";
						
			$page .= '<div class="index">' . "\n";
			$nb_total = 0;
			$jsonRef = new JsonRef;
			$j = 0;
			//Ouverture de chaque livre
			foreach($liste_livres as $code_livre) {
				$nb_livre = 0;
				$nom_livre = $this->livres_bible[$code_livre];
				$page_temp = "";
				$existe = false;
				$json = $this->getSimpleFile($code_livre, 'json/bible/' . $version);
				if ($json) {
					$existe = true;
					foreach((array) $json->chapters as $num_chapitre => $json_chapitre){
						foreach((array) $json_chapitre as $num_verset => $verset) {
							//Recherche des mots-cles
							$trouve_tous =  0;
							$verset_filter = $this->removeAccents($verset->text);
							foreach($clesPurged as $clePurged)
								if(preg_match('/' . $clePurged . '/is', $verset_filter))
									$trouve_tous += 1;
							if ($trouve_tous == count($cles)) {
								$text_verset = $jsonRef->getTexte($verset, $s_version . $code_livre . ":" . $num_chapitre . "." . $num_verset, true);
								foreach($cles as $i => $cle) {
									$text_verset = preg_replace('/(' . $cle . ')/ius', '<span class="mot-cle Coul_' . $i%5 . "\">$1</span>", $text_verset);
								}
								$page_temp .= "<div class=\"verset\">" . $text_verset . "</div>";
								$nb_livre++;
							}
						}
					}
					$page_temp .= '</div>';
				}
				$page_temp .= '<div class="nb_recueil">' . $nb_livre . ' résultat' . $this->plur($nb_livre) . "</div>\n";
				if ($nb_livre > 0 OR !$existe) {
					$page .= "<a name=\"p" . $j . "\" nom=\"" . $nom_livre . "\">&nbsp;</a>\n";
					$page .= "<h2 class=\"resume\">" . $nom_livre . "</h2>\n<div class=\"details Bible\">";
					$page .= $page_temp;
					$livres = (array) $this->default->bible->Livres_AT + (array) $this->default->bible->Livres_NT;
					$this->page->addLien($livres[$code_livre]);
					$j++;
				}
				$nb_total += $nb_livre;
			}
			$page .= '<div class="nb_total">Total : ' . $nb_total . ' résultat' . $this->plur($nb_total) . '</div></div>';
			$page .= "</div>\n";
		}
		
		$this->page->contenu = $page . "</div>";
	}
	
	public function redirige(){	//Redirection
		$code = $this->getPost('code');
		if (isset($_POST['double_ecran'])) {
			$_SESSION['double_ecran'] = $this->getPost('double_ecran');
		}
		$href = "";
		
		if (!$code) return;
		if (strtolower($code) == 'aide') {	//Aide
			$this->aide();
			return $this->getPage();
		} elseif (preg_match('/^accueil$/i', $code, $index)) {	//accueil
			$href = "accueil";
		} else if ($this->isLivre($code) OR strpos($code, ':') !== false) {	//Lecture biblique
			$href = "lecture-b";
			$this->page->titre = "Redirection…";
			echo '<form id="send_ref" method="POST" action="' . PREV . 'lecture-b' . '"><input type="hidden" name="code" value="' . $code . '"></form>';
			return;
		} elseif ($chant = $this->getNumeroFormCode($code)) {	//Chant
			$href = "chant=" . $chant;
		} elseif (preg_match('/^i(' . implode('|', array_keys($this->recueils)) . '|perso' . ')$/i', $code, $index)) {	//index
			$href = "liste=" . $index[1];
		} else {
			$href = "chant=" . $code;
		} 
		
		header('location:' . PREV . $href);		
	}

	public function parametres() {	//Modification des paramètres
		
		//Enregistrement des données
		$message = "";
		if (!empty($_POST)) {
			foreach($_POST as $cle => $nom) {	//Listes de checkbox
				$ligne_liste = [];
				if (in_array($cle, ['Recueils', 'Versions', 'Recueil_sup', 'Recueil_Util'])) {
					foreach($nom as $cle1 => $nom1) {
						if ($cle1 === "") {}
						else $ligne_liste[] =  $cle1 . " => " . $nom1;
					}
					$multiple[] = $cle . " : " . implode(', ', $ligne_liste);
				} else 	//Input simple et radio
					$simple[] = $cle . " => " . (is_array($nom) ? $nom[0] : $nom);
			}
			$this->conf->save = $_POST['save'];
			if ($this->conf->save != 'cookies') setcookie('conf', '', time() - 3600, '/');
			if ($this->conf->save == 'files') unset($_SESSION['conf']);
			$this->saveFile($this->conf, 'conf', 'conf.json', json_encode($_POST));

			header("Refresh: 0");
			if (!$message) $message = "Données enregistrées.";
		}
		
		$this->page->titre = "Paramètres du programme";
		$page = "<div><h1>" . $this->page->titre . "</h1>\n";
		
		if ($message) $page .= "<p class=\"message\">" . $message . "</p>";
		
		$page .= '<form class="param" method="POST" action="">';
		$page .= '<div><h2>Licence de projection</h2>
			<p class="comment">Pour projeter les chants de louange en église, vous devez posséder une licence (<a href="http://www.ltc-asaph.com/licence" target="_blank">http://www.ltc-asaph.com/licensing</a>)</p>
			<p><label for="licence">N° de licence : </label><input' . $this->getFormParam("licence") . " value=\"" . $this->getPostParam('licence') . '"/>' . "</div>\n";
		
		//Paramètres checkbox ou radio
		$page .= $this->getParam('save', 'Enregistrement');
		$page .= $this->getParam('align', 'Alignement du texte');
		$page .= $this->getParam('style', 'Style d\'affichage');
		$page .= $this->getParam('recueils', 'Recueils utilisés');		
		$page .= $this->getParam('versions', 'Bibles utilisées');
		$page .= $this->getParam('sauts', 'Sauts de pages');
		$page .= $this->getParam('ouv_telec', 'Ouverture initiale de la télécommande');
		$page .= $this->getParam('click_compo', 'Clic dans la composition');
		
		$page .= "<p><input " . $this->getFormParam("param_submit") . "/></form></div>";
		
		$this->page->contenu = $page;
	}
	
	public function composition() {	//Editer la composition
		
		if (isset($_POST['codes'])) {
			//Enregistrement depuis le textarea
			$this->saveFile($this->conf, 'composition', 'composition.txt', $this->getPost('codes'));
		}
		
		if (isset($_FILES['compo']) && $this->getPost('compo', $_FILES)['name']) {
			//Enregistrement depuis le drag&drop
			move_uploaded_file($_FILES['compo']['tmp_name'], 'temp/composition.txt');
			$this->saveFile($this->conf, 'composition', 'composition.txt', file_get_contents('temp/composition.txt'));
		}

		$this->page->contenu = $this->getSavedFile($this->conf, 'composition', 'composition.txt');

		//print_r_pre([$_SESSION, file_get_contents('composition.txt'), $this->page->contenu, $this->conf->save]);
		
		$liste = preg_split("/\R+/", $this->page->contenu);
		$liens = [];
			
		foreach($liste as $donnee){
			$code = $titre = $comment = "";
			if (preg_match('/^(.*?)\/\/(.*)$/i', $donnee, $match)) {
				$donnee = $match[1];
				$comment = trim($match[2]);
			}
			$donnee = strtolower(trim($donnee));
			
			//Livre biblique complet
			if ($titre = $this->isLivre($donnee)) {
				$code = $donnee;
				$titre = $titre;
			}
			//Référence biblique
			elseif (strpos($donnee, ':') !== false) {
				$jsonRef = new JsonRef;
				$jsonRef->fromCode($donnee);
				$jsonRef->getLivre();
				$code = $donnee;
				$titre = $jsonRef->getRef();
			} else if ($chant = $this->getNumeroFormCode($donnee)) {
				$code = $chant;
				$json = $this->getFile($code);
				if ($json) {
					$titre = $json->text->title;
				}
			} else $code = $donnee;
			
			$this->page->liens[] = "<li><span>" . $code . "</span><p>" . $titre . "</p>" . ($comment ? "<q>" . $comment . "</q>" : "") . "</li>";
			global $contenu, $liens;
			$contenu = $this->page->contenu;
			$liens = implode('', $this->page->liens);
		}
	}
	
	public function edition() {	//Editer un chant
		
		$editor = new Editor;

		//print_r_pre($_POST, 'POST');
		//print_r_pre($_FILES, 'FILES');

		if (isset($_FILES['import']) && $_FILES['import']['name']) {//Importer le chant			
			
			$editor->import();

		} else if ($this->getPost('code')) {	//Enregistrer le chant

			$json = $editor->fromPost();
			if ($this->getPost('action') == 'Enregistrer') {	//Enregistrement
				$jsonFound = $this->getJson($this->getPost('code'));
				//print_r_pre($jsonFound, 'jsonFound');
				if ($jsonFound && $jsonFound->data->folder == 'json') {
					$editor->message = "Fichier d'origine, vous ne pouvez pas le modifier. Veuiller ajouter l'indice \"M\" à son code.";	
				} else {
					$editor->message = $editor->enregistre($json);
				}
			}
		} else if ($code = $this->getPost('chant', $_GET)) {	//Charger le chant
			
			$editor->code = $code;
			$json = $this->getJson($this->getNumeroFormCode($code));
			if ($json) {
				$editor->fromJson($json);
				$codeM = $this->getCodeM($json->text->code);
				//print_r_pre($json, 'json');
				if ($json->data->folder == 'json' && $this->isFile($codeM, 'perso') || $json->data->folder == 'perso') {
					$editor->message = "Attention ! Une version modifiée existe déjà (" . $codeM . ".json)";
				}
				$json->text->code = strtoupper($codeM);
			}

		}		
		
		return $editor;
	}
	
	public function getPage() {	//Retourne les informations de la page
		$this->page->double = $this->getValue('double_ecran', $_SESSION) == 'double';
		return $this->page;
	}
	
}

