<?php

class ManagerApi {	//Gestion des fonctions d'API

	protected $conf;

	use Commons;

	public function api() {	//Fonctions de l'API
		//print_r_pre(['API OK', $_POST, $_FILES]);
		switch($_POST['action']) {
			case 'image-decouper': $this->decoupeImage(); break;
			case 'download-composition': $this->downloadComposition(); break;
			case 'download-chant': $this->downloadChant(); break;
			case 'delete-chant': $this->deleteChant(); break;
		}
	}

	protected function decoupeImage() {	//Enregistrement et réduction d'une image
		//print_r([$_POST, $_FILES]);
		//$proportion = 1024 / $this->getPost('left');
		$folder = '../perso/images';
		$file = $this->getValue('file', $_FILES);
		$temporaire = $folder . '/temp.jpg';
		move_uploaded_file($file['tmp_name'], $temporaire);
		$image = $file['type'] == "image/png" ? @imagecreatefrompng($temporaire) : $image = imagecreatefromjpeg($temporaire);
		$taille = array(imagesx($image), imagesy($image), 1024, 768, 620, 465);
		$proportion = array($taille[0] / $taille[1], $taille[2] / $taille[3]);
		//print_r_pre([$taille, $proportion]);
		$fond = imagecreatetruecolor($taille[2], $taille[3]);
		if ($proportion[0] < $proportion[1]) {	//Image plus haute
			imagecopyresampled($fond, $image, 0, 0, 0, round($this->getPost('top') * $taille[0] / $taille[4]), 1024, 768, $taille[0], round($taille[0] / $proportion[1]));
		} else {	//Image plus large
			imagecopyresampled($fond, $image, 0, 0, round($this->getPost('left') * $taille[1] / $taille[5]), 0, 1024, 768, round($taille[1] * $proportion[1]), $taille[1]);
		}
		
		//Prochain nom de fichier
		$fichiers = scandir($folder);
		$i = 0;
		$found = false;
		$last = 0;
		do {
			preg_match('/perso(\d{2})\.jpg/i', $fichiers[$i], $match);
			if (isset($match[1])) $last = + $match[1];
			$i++; 
		} while(!$found && isset($fichiers[$i]));
		$last++;
		$numero = ($last < 10 ? str_pad($last, 2, "0", STR_PAD_LEFT) : $last);
		
		if (imagejpeg($fond, $folder . '/perso' . $numero . '.jpg')) {
			$message = json_encode(scandir($folder));
		}
		unlink($temporaire);		
		
		echo $message;
	}

	protected function downloadComposition() {	//Téléchargement de la composition
		global $conf;
		$composition = $this->getSavedFile($conf, 'composition', 'composition.txt');
		echo json_encode($composition);
	}
	
	protected function downloadChant() {	//Téléchargement d'un chant
		global $conf;
		$this->conf = $conf;
		$json = $this->getJson($this->getNumeroFormCode($this->getPost('code')));
		echo json_encode($json);
	}

	protected function deleteChant() {	//Suppression d'un chant
		global $conf;
		$this->conf = $conf;
		$codeM = $this->getPost('code');
		$code = strtolower($this->getPost('code'));
		if ($conf->save == 'files') {
			if ($this->isFile($code, 'perso')) {
				unlink('../perso/' . $code . '.json');
			}
			$indexUrl = '../perso/index.json';
			if (file_exists($indexUrl)) {
				$index = json_decode(file_get_contents($indexUrl));
				unset($index->$codeM);
				file_put_contents($indexUrl, json_encode($index));
			}
		} else {
			$chants = $this->getCookie('chant');
			if (isset($chants->$code)) {
				unset($chants->$code);
				$this->saveCookie('chant', json_encode($chants));				
			} else {
				$chants = $this->getPost('chant', $_SESSION);
				if (isset($chants->$code)) {
					unset($chants->$code);
					$_SESSION['chant'] = json_encode($chants);
				}
			}

			$indexCookie = $this->getCookie('index');
			if ($indexCookie) {
				$index = json_decode($indexCookie);
				if (isset($index->$codeM)) {
					unset($index->$codeM);
					$this->saveCookie('index', json_encode($index));
				} else {
					$index = json_decode($this->getPost('index', $_SESSION));
					if (isset($index->$code)) {
						unset($index->$code);
						$_SESSION['index'] = json_encode($index);
					}
				}
			}
			//print_r([$_SESSION, $_COOKIE]);
		}
		echo json_encode("OK");
	}
}

