<?php

class Page {	//Contenu des pages de projection
	
	use Commons;
	
	public $double, $isLocal, $titre = 'v-jemaf 7 | Programme de vidéoprojection', $prev_titre, $contenu, $liens = [], $numero;

	public function addLien($link) {
		$this->liens[] = $link;
	}
	
	public function getLiens() {
		$liste_liens = ['<a class="actif" href="#">Titre</a>'];
		$liens = "";
		if (is_array($this->liens)) {
			foreach($this->liens as $num => $nom) 
				$liste_liens[] = '<a href="#p' . $num . '">' . $nom . '</a>';
			$liens = implode(' - ' , $liste_liens);
		}
		return $liens;
	}

	public function getTitrePrevisu() {
		return ($this->prev_titre ?? $this->prev_titre);
	}
	
	public function getLiensPrevisu() {
		global $default;
		$liste_liens[] = '<li class="actif" href="">Titre</li>';
		if (is_array($this->liens)) {
			foreach($this->liens as $name => $nom) {
				$liste_liens[] = '<li href="p' . $name . '">' . $this->getValeur($nom, $default->afficher->parties) . '</li>';
			}
			$liens = implode('' , $liste_liens);
		}
		echo $liens;
	}

	public function getNumeroPrevisu() {
		if ($this->numero OR $this->prev_titre) {
			return '<span class="prev_numero">' . $this->numero . '</span>' . (($this->numero AND $this->prev_titre) ? '. ' : '') . '<span class="prev_titre">' . $this->prev_titre . '</span>';
		}
	}

	public function svg($filename) {	//svg pour bouton
		return str_replace('<svg ', '<svg class="svg-icone" ', $this->getSvg($filename));
	}

	public function svgMenu($filename) {	//svg pour menu
		return '<span class="svg-menu-icone">' . $this->getSvg($filename) . '</span>';
	}

	private function getSvg($filename) {
		$filePath = '../img/svg/' . $filename . '.svg';
		$result = "X";
		if (file_exists($filePath)) {
			$result = file_get_contents($filePath);
		}
		return $result;
	}
}