/* Parties communes du programme v-Jemaf 7 */

function sendApi(data) {
    return new Promise(function(resolve, reject) {
        $.ajax({
            url: 'prog/prog.php?api',
            type: 'POST',
            data: data,
            processData: false,
            contentType: false,
            success: function(x) {
                if (x) {
                    resolve(JSON.parse(x)); // Résout la Promise avec la réponse
                }
            },
            error: function(jqXHR, _, error) {
                reject(jqXHR.responseText || error); // Rejette la Promise avec l'erreur
            }
        });
    });
}

function download(content, filename) {  //Création d'un fichier de téléchargement
    const blob = new Blob([content], { type: 'text/plain' });
    const url = URL.createObjectURL(blob);

    // Créer un lien temporaire pour le téléchargement
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();

    // Nettoyer
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
}

$(window).ready(function() {

    var dropZones = $('.dropZone');
    
    // Empêcher le comportement par défaut pour les événements de glisser-déposer
    dropZones.on('dragover dragleave drop', function(e) {
        e.preventDefault();
        e.stopPropagation();
        if (e.type == 'dragover') {
            $(this).addClass('dragover');
        } else {
            $(this).removeClass('dragover');
        }
        if (e.type == 'drop') {
            var files = e.originalEvent.dataTransfer.files;
            if (files.length > 0) {
                var fileInput = $(this).next('input[type="file"]')
                fileInput.prop('files', files);
                uploadFile(files[0], fileInput.attr('id'));
            } else {
                alert("Le drag&drop directement depuis le navigateur n'est pas permis.\nVeuillez d'abord enregistrer le fichier localement.");
            }
        }
    });

    dropZones.on('click', function() {
        var fileInput = $(this).next('input[type="file"]');
        fileInput.trigger('click');
    });

    $('input[type="file"]').on('change', function() {
        if (this.files.length > 0) {
            uploadFile(this.files[0], $(this).attr('id'));
        }
    });

    // Fonction pour envoyer le fichier au serveur
    function uploadFile(file, id) {
        switch (id) {
            case 'image' : showImage(file); break;
            case 'import' : importChant(file); break;
            case 'compo' : importCompo(file); break;
        }
    }
	
});