var imageDownload;

function importChant(file) {	//Importer un chant
	let message = $('#import').nextAll('.message-editor');
	if (!file.name.match(/\.(txt|json)/)) {
		message.text('Format de fichier incorrect').slideDown();
		return;
	}
	$('#import').parents('form').submit();
}

function showImage(file) {	//Affichage de l'image pour redimensionnement
	imageDownload = file;
	let message = $('#div-nv-image').nextAll('.message-editor');
	if (!['image/jpeg', 'image/png'].includes(file.type)) {
		message.text('Format de fichier incorrect').slideDown();
		return;
	}
	message.slideUp();
	var reader = new FileReader();

	reader.onload = function(e) {
		$('#div_decouper').slideDown();
		// Afficher l'image dans l'élément preview
		$('#image_decouper img').attr('src', e.target.result).show();
		image = new Image();	//Préchargement de l'image pour consulter ses attributs
		image.src = e.target.result;
		image.onload = function() {
			width = image.width;
			height = image.height;
            var ratio = width / height;
            var targetRatio = 1024 / 768;
			if (ratio < targetRatio) {
				$('#image_decouper').removeClass('.horizontal').addClass('vertical');
			} else {
				$('#image_decouper').addClass('horizontal').removeClass('vertical');
			}
		}
	};

	reader.readAsDataURL(file);		// Lire le fichier comme une URL de données
}
	

$(window).ready(function() {
	
	if ($('#edit_code').val() == "") {	//Présaisie du code
		$('#edit_code').val($('#code', window.opener.document).val());
	}
	
	$('.choix div').on('click', function(){	//Choix de la page
		$('form fieldset').fadeOut(250).delay(250);
		$('fieldset:nth(' + ($(this).index()) + ')').fadeIn(250);
	});

	$('#edit_code').on('keypress', function(e){	//Chargement avec Entrée
		if (e.key == 'Enter') {
			charger();
			return false;
		}
	});

	texteRefrain = function(){	//Changement de l'écran en refrain
		style = $(this).val();
		if (style == 'refrain') {
			$(this).parents('.line').children('textarea').addClass('refrain');
			if ($(this).nextAll('select').val() == 'Str.') {
				$(this).nextAll('select').val('Refr.');
			}
		} else $(this).parents('.line').children('textarea').removeClass('refrain');
	}
	$('#edit_paroles select[name="style[]"]').each(texteRefrain).change(texteRefrain);
	$('#edit_paroles').on('change', 'select[name="style[]"]', texteRefrain);
	
	if ($('#editeur-numero').text() != "") {	//Prévisualisation
		$('#code', window.opener.document).val($('#editeur-numero').text());
		$('#previsu', window.opener.document).trigger('click');
	}

	$('#ajout_ecrans').on('click', function() {	//Ajouter des lignes
		let last = $('#ecran_lines').children('.div-line').last();
		var index = last.index();
		for (let i = 0; i < 5; i++) {
			var $clone = last.clone();
			$clone.find('span').text(index + i + 1);
			$clone.find('input[type="text"], textarea').val('');
			$clone.find('select').prop('selectedIndex', 0);
			$('#ecran_lines').append($clone);			
		}
	})

	// Drag & drop
	let draggedItem = null;
	$("#ecran_lines > div").each(function() {
		$(this).append("<div class='placeholder'></div>");
	});
	$("#ecran_lines").prepend("<div class=\"div-line\"><div class='placeholder'></div></div>")

	// Drag
	function initDrop(items) {
		items.draggable({
			axis: "y",
			containment: "#ecran_lines",
			cursor: "move",
			handle: ".move",
			start: function() {
				draggedItem = $(this).addClass("dragging");
			},
			drag: function(_, ui) {
				var y = ui.offset.top;
				var maxTop = 0;
				
				$("#ecran_lines > div").each(function(i) {
					if ($(this).offset().top <= y) maxTop = i + 1;
				});
				$('.placeholder:visible').hide();
				$("#ecran_lines > div:nth-child(" + maxTop + ") > .placeholder").show();
			},
		});
	}
	initDrop($("#ecran_lines .line"));

	// Drop
    $("#ecran_lines").on("mouseup", function() {
        if (draggedItem) {
			draggedItem.attr('style', null).removeClass('dragging');
			var $target = $('#ecran_lines .placeholder:visible').parent();
			var $draggedParent = draggedItem.parent();
			if (!$target.closest($draggedParent).length) {
				$target.after($draggedParent);
			}
			$('.placeholder:visible').hide();
			draggedItem = null;
			refreshNum();
		}
    });

	//Autres icones
	$('.icones .copy, .icones .delete-ecran').on('click', function() {
		var $div = $(this).parents('.div-line');
		if ($(this).hasClass('copy')) {
			var $clone = $div.clone(true);
			$div.after($clone);
			initDrop($clone);
		}
		if ($(this).hasClass('delete-ecran')) {
			$div.remove();
		}
		refreshNum();
	})

	refreshNum = function() {
		$('#ecran_lines .line > span').each(function(i) {
			$(this).text(i + 1);
		})
	}
	
	$('#picture').on('click', function(){	//Clic sur le nom de l'image
		$('.choix div:nth-child(3)').trigger('click');
	});
	
	if ($('.choix .actif').length) {	//Fermeture ou non de la partie image
		$('#edit_info').hide()
		setTimeout('$(window).scrollTop($(document).height() - $(window).height())', 1000);
	} else $('#edit_images').hide();
			
	charger = function(){window.location = "edition?chant=" + $('#edit_code').val();}	//Charger un chant
	$('#edit_charger').on('click', charger);

	$('#edit_images').on('click', 'li', function(){		//Sélection d'une image
		let title = $(this).attr('title');
		let value = title.replace('jem@fonds/image', '').replace('.jpg', '');
		$('#picture').text(title);
		$('input[name="picture"]').val(value);
		if($(this).hasClass('selection')) {
			$('#edit_images li').attr('class', '');
			$('#picture').val('');
		} else {
			$('#edit_images li').addClass('disabled');
			$(this).attr('class', 'selection');
		}
	});
	
	let picture = +$('#picture').text();		//Présélection de l'image
	if (picture > 0 && picture <= 90) {
		image = $('#jem-fonds li:nth-child(' + picture + ')').trigger('click');
		image.parent().scrollTop(image.position().top);
	}
	
	$('#edit_dec_image').on('click', function(){	//Découpage d'une nouvelle image
		offset = {action: 'image-decouper', left: $('#image_decouper').scrollLeft(), top: $('#image_decouper').scrollTop()};
		formData = new FormData();
		formData.append('file', imageDownload);
		for (let key in offset) {
			formData.append(key, offset[key]);
		}
		
		sendApi(formData).then(result => {
			$('#div_decouper').slideUp();
			$('#images-autres').html('');
			result.forEach(filename => {
				let match = filename.match(/^perso\d+\.jpg/);
				if (match) {
					$('#images-autres').append('<li title="' + filename + '" style="background-image: url(perso/images/' + filename + ');" /></li>');
				}
			})
		}).catch(error => {
			$('#div-nv-image').nextAll('.message').text(error).slideDown();
		})
	});

	$('.download').on('click', function() {	//Télécharger le chant ajouté
        formData = new FormData();
		formData.append('action', 'download-chant');
		code = $('input[name=code]').val();
		formData.append('code', code);
        sendApi(formData).then(contenu => {
            download(JSON.stringify(contenu), code.toLowerCase() + '.json');
        })
    })
	
	$('.delete').on('click', function() {	//Supprimer le chant ajouté
        if (confirm('Voulez-vous vraiment supprimer ce chant ajouté ?')) {
			formData = new FormData();
			formData.append('action', 'delete-chant');
			formData.append('code', $('input[name=code]').val());
			sendApi(formData).then(() => {
				console.log('suppression');
				$('#edit_charger').trigger('click');
			})
		}
    })
});