/* Partie interactive du programme v-Jemaf 7 */

var telecWidth = {ouv_0: 267, ouv_1: 820, ouv_2: 605, ouv_3: 1148};
var composition;
var edition;

$(window).ready(function() {

	/* ******************************* SIMPLE / DOUBLE ECRAN / PREVISUALISATION ********************** */
	
	//Ecran de prévisualisation ou non
	const PREV = (window.location.href.search('prev_') > 0 ? "prev_" : "");
	
	$('#code').focus();
	
	//Affichage en douceur
	$('.chant, .div-Bible').fadeIn(2500);
	
	//Affichage du menu
	$('#menu').on('click', function(){
		if (!$('aside').queue().length) {
			if ($('aside').css('display') == "block")
				$('aside').slideUp(500);	
			else $('aside').slideDown(500);
		}
	});
	
	//Fermeture du menu
	$('aside a').on('click', function(){
		$('aside').slideUp(500);
	});
		
	//Double-clic sur le numéro
	$('#numero, #t-numero').on('dblclick', function(){
		$('#code').val($(this).text()).focus();
	});
	
	//Redirection automatique de la lecture biblique
	$('#send_ref').submit();
	
	//Clic sur un code modifié
	$('p.res-index .codeM').on('click', function(event){
		event.stopPropagation();
		let code = $(this).prev().text().toLowerCase() + 'm';
		window.location = PREV + "chant=" + code;
		if (PREV) {
			$('#code', window.parent.document).val(code);
		}
	});

	//Clic sur un lien de chant
	$('p.res-index').on('click', function(){
		let code = $(this).find('.code').text().toLowerCase();
		window.location = PREV + "chant=" + code;
		if (PREV) {
			$('#code', window.parent.document).val(code);	
		}
	});

	//Clic sur un code de l'aide
	$('.aide .copy').on('click', function(){
		$('#code', window.parent.document).val($(this).text());
	});
	
	//Clic sur un lien de verset
	$('.index .verset').on('click', function(){
		$('#code').val($(this).find('small').text());
		$('#form_code').submit();
	});
	
	//Clic sur les résumés
	$('.index .resume').on('click', function(){
		taille = Math.min(10000, $(this).next('.details').height());
		$(this).children('span').toggleClass('d-none');
		if ($(this).hasClass('ouvert')) {
			$(this).removeClass('ouvert');
			$(this).next('.details').stop().slideUp(250 + taille/2);
		}
		else {
			$(this).addClass('ouvert');
			$(this).next('.details').slideDown(250 + taille);
		}
	});
	
	//Choix du livre biblique de lecture
	$('#livre_NT').on('change', function(){
		$('#livre_AT').attr('required', false).val('');
	});
	
	$('#livre_AT').on('change', function(){
		$('#livre_NT').val('');
	});

	$('#verset_fin, #check_fin').on('change', function(){
		if ($(this).attr('id') == 'check_fin') {
			$('#verset_fin').val('');
		} else {
			$('#check_fin').prop('checked', false);
		}
	});

	var chapitres;

	//Limites de chapitres
	$('#version, #livre_AT, #livre_NT').on('change', function() {
		let version = $('#version').val();
		let livre = $('#livre_AT').val() || $('#livre_NT').val();
		if (!(version && livre)) return;
		chapitres = Bible[version][livre.toLowerCase()].ch;
		let nbCh = Object.keys(chapitres).length;
		$('#chapitre_deb, #chapitre_fin').attr('max', nbCh);
		$('#chapitre_deb, #chapitre_fin').trigger('change');
	})

	//Limites de verset chapitre début
	$('#chapitre_deb').on('change', function() {
		let chapitreDep = $(this).val();
		if (!(chapitres && chapitreDep)) return;
		let nbCh = Object.keys(chapitres).length;
		console.log(chapitreDep, nbCh, chapitreDep > nbCh);
		if (chapitreDep > nbCh) $('#chapitre_deb').val(nbCh);
		let nbVerset = chapitres[$(this).val()];
		$('#verset_deb, #verset_fin').attr('max', nbVerset);
		$('#verset_deb, #verset_fin').trigger('change');
	})

	//Limites de verset chapitre fin
	$('#chapitre_fin').on('change', function() {
		let chapitreFin = $(this).val();
		if (!chapitres) return;
		if (chapitreFin) {
			let nbCh = Object.keys(chapitres).length;
			if (chapitreFin > nbCh) $('#chapitre_fin').val(nbCh);
			let nbVerset = chapitres[$(this).val()];
			$('#verset_fin').attr('max', nbVerset);
			$('#verset_fin').trigger('change');
		} else {
			$('#chapitre_deb').trigger('change');
		}
	})		

	$('input[type="number"]').on('change', function() {
		let value = +$(this).val();
		if (!value) return;
		let max = +$(this).attr('max');
		if (value > max) $(this).val(max);
	})

	//Vérification du passage biblique
	$('#passage_bible').on('click', function() {
		$('#chapitre_deb').attr('required', $('#verset_deb').val() != '');
		$('#verset_deb').attr('required', ($('#verset_end').val() > 0 || $('#check_fin').prop('checked')));
		$('#verset_fin').attr('required', ($('#verset_deb').val() > 0 && $('#chapitre_fin').val() > 0 && !$('#check_fin').prop('checked')));
		let chapitreDeb = +$('#chapitre_deb').val();
		let chapitreFin = +$('#chapitre_fin').val();
		if (chapitreFin && chapitreFin < chapitreDeb) {
			$('.message').text("Chapitre de début > chapitre de fin").slideDown();
			return false;
		}
		let versetDeb = +$('#verset_deb').val();
		let versetFin = +$('#verset_fin').val();
		if ((!chapitreFin || chapitreDeb == chapitreFin) && versetFin && versetFin < versetDeb) {
			$('.message').text("Verset de début > verset de fin").slideDown();
			return false;
		}
		$('.message').text("").slideUp();
	})

	//Affichage du champ Livre de la Bible
	function affLivre() {
		if ($('#rech_dans_b').val() == "livre")
			$('#div-livre').fadeIn(1000);
		else $('#div-livre').fadeOut(1000);
	}
	affLivre();
	$('#rech_dans_b').on('change', affLivre);
	
	//Contrôle de saisie des paramètres
	function verifie_checkbox(param) {
		liste = $('input[name="' + param + '[]"]:checked').map(function(){return $(this).val()}).get();
		if (liste != "") $('input[name="' + param + '[]"]').attr('required', false);
	}
	
	//Suppression des required des paramètres
	$('#param_submit').on('click', function(){
		verifie_checkbox('Recueils');
		verifie_checkbox('Versions');
	});

	if ($('#contenu form, .previsu form').length) {
		window.history.replaceState({}, document.title, window.location.pathname);
	}

	//Page précédente
	$('#back').on('click', function(e){
		window.history.back();
	});
	
	/* ******************************* SIMPLE ECRAN ************************************* */
	
	if (!window.opener){
		
		//Clic sur un lien de navigation
		$('#nav-droite a').on('click', function(){
			if ($(this).index() == 0) {	// Lien Titre
				$('#contenu').scrollTop(0);
				$('#nav-droite a').removeClass('actif').removeClass('vu');
			}
			if ($(this).index() == $('#nav-droite a').length - 1) // Dernier lien
				$('#fin').fadeIn(1500).css("display","block");
			else $('#fin').fadeOut(1500);
			
			$('#nav-droite a.actif').removeClass('actif').addClass('vu');
			$(this).addClass('actif');
		});
		
		//Scroll automatique pour garder le lien actif visible lors de l'avancer ou reculer 
		scrollAuto = function(){
			position = $('#nav-droite a.actif').position().top;
			scrollTop = $('#nav-droite').scrollTop();
			if (position < 0 || position > 30) 
				$('#nav-droite').scrollTop(scrollTop + position - 7);
		}
		
		function Naviguer(i) {
			$('#nav-droite a:nth-child(' + i + ')').trigger('click');
			scrollAuto();
			$('#fin').toggle(i == $('#nav-droite a').length);
			if ($('#nav-droite a.actif').length) {
				window.location = $('#nav-droite a.actif').attr('href');
			}
		}
		
		function Avancer(){	//Clic sur le bouton Avancer
			Naviguer($('#nav-droite a.actif').index() + 2);			
		}
		
		$('#droite').on('click', Avancer);
		
		function Reculer(){
			Naviguer($('#nav-droite a.actif').index());
		}

		function Debut(){
			Naviguer(2);
			$('#nav-droite a').slice(1).removeClass('vu');
		}
		
		//Page précédente
		$('.simple-ecran').on('keydown', function(e){
			if (e.key == 'Backspace' && e.ctrlKey) {
				window.history.back();
			}
		});

		//Raccourcis clavier
		$('#code').on('keydown', function(e){
			if (['PageDown', 'ArrowDown', 'PageUp', 'ArrowUp', 'Home'].includes(e.key)) {
				e.preventDefault();
				switch (e.key) {
					case 'PageDown' : case 'ArrowDown' : Avancer(); break;
					case 'PageUp' : case 'ArrowUp' : Reculer(); break;
					case 'Home' : Debut(); break;
				}
				$('#code').focus();
			}
		});
		
		//Scroll sur la page, sur les liens
		scrollWheel = function(e, h, div){
			delta = (e.originalEvent.detail || e.originalEvent.deltaY || -e.originalEvent.wheelDelta);
			div.scrollTop(div.scrollTop() + (delta > 0 ? 1 : -1) * h);
		}
		
		//Scroll sur la page
		$('#contenu').on('DOMMouseScroll mousewheel', function(e){scrollWheel(e, 100, $(this))});
		
		//Scroll sur les liens
		$('#nav-droite').on( 'DOMMouseScroll mousewheel', function(e){scrollWheel(e, 30, $(this))});

		$('#resize-right').on('click', function() {
			$('#nav-droite').toggleClass('open');
		})
	
		
		//Ouverture de la télécommande
		$('#lien_double_ecran').on('click', function(){
			window.open('telecommande', 'telec', 'width=' + telecWidth[ouv_telec] + ',height=636,top=200,left=200,resizable=yes');
			return false;
		});

		$('#back-simple').on('click', function() {
			document.location.href = document.location.href + '&simple';
		})
	}
		
	/* ******************************* TELECOMMANDE ************************************* */
	
	else {
		//window.resizeTo(1220,702);

		var previsu;
		
		//Redimensionnement en hauteur de la fenêtre
		resizeH = function(){
			height = $(window).height();
			$('#liens').height(height - 236);
			$('#previsualisation').height(height - 60);
		}
		resizeH();
		$(window).on('resize', resizeH);

		//window.resizeTo(telecWidth[ouv_telec], window.innerHeight);
		//console.log($(window).width(), window.innerHeight, $(window).height(), $('#field_previsu').hasClass('d-none'), telecWidth, ouv_telec, telecWidth[ouv_telec]);
		
		//Réduire la télécommande
		reduire = function(mode){	//true = composition, false = prévisualisation, 
			let resizeWidth;
			if (mode) {
				resizeWidth = (!$('#field_compo').hasClass('d-none') ? -$('#field_compo').outerWidth(true) : 333);
				$('#field_compo').toggleClass('d-none');
				window.moveBy(-resizeWidth, 0);
			} else {
				resizeWidth = (!$('#field_previsu').hasClass('d-none') ? -$('#field_previsu').outerWidth(true) : 552);
				$('#field_previsu').toggleClass('d-none');
			}
			window.resizeBy(resizeWidth, 0);
		}
		
		$('.reduire').on('click', function(){
			reduire($(this).attr('id') == 'reduire_compo');
		});
				
		//Ouverture de la Composition
		$('#lien_composition, #legend_composition').on('click', function(){			
			composition = window.open('composition', 'Composition', 'width=330,height=627,top=150,left=100,resizable=yes');
		});
		
		//Ouverture de l'Edition
		$('#lien_edition, #legend_previsu').on('click', function(){
			edition = window.open('edition', 'Edition', 'width=830,height=710,top=150,left=600,resizable=yes');
		});
		
		//Prévisualisation
		function previsualiser(){
			previsu = $('iframe').contents();
			$('#code', previsu).val($('#code').val());
			$('#form_code', previsu).submit();
		}
		$('#previsu').on('click', previsualiser);
		
		//Affichage
		function afficher() {
			$('#code', window.opener.document).val($('#code').val());
			$('#double_ecran', window.opener.document).val("double");
			$('#form_code', window.opener.document).submit();
			previsualiser();
			let previsualisation = $('#previsualisation').contents();
			$('#t-numero').text(previsualisation.find('.prev_numero').html());
			$('#t-titre').text(previsualisation.find('.prev_titre').html());
			$('#liens').html(previsualisation.find('#prev_liens').html());				
		}
		$('#afficher').on('click', afficher);
		
		//Clic sur les liens
		$('#liens').on('click', 'li', function(){
			$('#liens li.actif').removeClass('actif').addClass('vu');
			href = $(this).addClass('actif').attr('href');
			scrollTop = $('#contenu', window.opener.document).scrollTop();
			offset = (href == "" ? 0 : $('a[name="' + href + '"]', window.opener.document).offset().top + scrollTop); 
			$('#contenu', window.opener.document).scrollTop(offset);
			if ($(this).index() == $('#liens li').length - 1) // Dernier lien
				$('#fin', window.opener.document).fadeIn(1500).css("display","block");
			else $('#fin', window.opener.document).fadeOut(1500);
		});
		
		//Présaisie initiale
		chargement_initial = true;
		
		//Présaisie du numéro
		$('iframe').on('load', function(){
			previsu = $('iframe').contents();
			
			if (chargement_initial) {
				$('#code').val($('#numero', window.opener.document).text());
				afficher();
				chargement_initial = false;
			} else {
				$('#code').val($('#prev_numero .prev_numero', previsu).text());
			}		
		});
		
		//Scroll automatique pour garder le lien actif visible lors de l'avancer ou reculer 
		scrollAuto = function(div, sens){
			if ($(div).length) {
				li = div + ' li.actif';
				divHeight = $(div).height();
				liHeight = $(li).outerHeight();
				position = $(li).position().top;
				scrollTop = $(div).scrollTop();
				if (position < liHeight || position > divHeight - 2 * liHeight) 
					if (sens)
						$(div).scrollTop(scrollTop + position - liHeight);
					else $(div).scrollTop(scrollTop - divHeight + position + 2 * liHeight);
			}
		}
		
		//Clic sur la Composition
		function compo_click(li){
			$('#liste-compo li.actif').attr('class', 'vu');
			href = li.addClass('actif').attr('href');
			$('#code').val(li.find('span').text());
		}
		
		//Avancer
		function telec_avancer(){
			$('#liens li:nth-child(' + ($('#liens li.actif').index() + 2) + ')').on('click', );
			scrollAuto('#liens', 1);
		}
		$('#t-droite').on('click', telec_avancer);
		
		//Reculer
		function telec_reculer(){
			$('#liens li:nth-child(' + ($('#liens li.actif').index()) + ')').on('click', );
			scrollAuto('#liens', 0);
		}
		
		//Clic sur la composition
		$('#liste-compo').on('click', 'li', function(){
			compo_click($(this));
			switch(click_compo) {
				case 'compo_2' : afficher(); break;
				case 'compo_1' : previsualiser();
			}
		});
		
		//Raccourcis clavier
		$(window).on('keyup', function(e){
			switch (e.key) {
				case 'Enter' : if (e.ctrlKey) previsualiser();
					else afficher(); break;
				case 'PageDown' : if (e.ctrlKey && $('#field_compo').css('display') != 'none') {
					compo_click($('#liste-compo li:nth-child(' + ($('#liste-compo li.actif').index() + 2) + ')'));
					scrollAuto('#liste-compo', 1);
					afficher();
					break;
				}					
				case 'ArrowDown' : telec_avancer(); break;
				case 'PageUp' : if (e.ctrlKey && $('#field_compo').css('display') != 'none') {
					compo_click($('#liste-compo li:nth-child(' + ($('#liste-compo li.actif').index()) + ')'));
					scrollAuto('#liste-compo', 0);
					afficher();
					break;
				}			
				case 'ArrowUp' : telec_reculer();
			}
		});

		//Scroll vers la page
		$('#t-droite').on('DOMMouseScroll mousewheel', function(e){
			delta = (e.originalEvent.detail || e.originalEvent.deltaY || -e.originalEvent.wheelDelta);
			$('#contenu', window.opener.document).scrollTop($('#contenu', window.opener.document).scrollTop() + (delta > 0 ? 1 : -1) * 100);
		});

		//Scroll avec les flèches
		var scrollSize = [-300, -50, 50, 300];
		var scrollInterval;
		var pressTimer;
		
		function startScrolling(index) {	// Défilement fluide
			$contenu = $('#contenu', window.opener.document);
			$contenu.stop(true, false).animate({scrollTop: $contenu.scrollTop() + scrollSize[index]}, { duration: 200, easing: 'linear' });
		}

		$('#arrows-bottom .icone').on('click mousedown mouseup mouseleave', function(e) {	//Flèches de défilement, avec clic simple ou prolongé
			let index = $(this).index();
			switch (e.type) {
				case 'mousedown': //e.preventDefault();
					startScrolling(index);	
					pressTimer = setTimeout(function() {	
						scrollInterval = setInterval(() => {
							startScrolling(index); // Défile en continu
						}, 200);
					}, 500);
					break;
				case 'mouseup': clearTimeout(pressTimer);
				case 'mouseleave': clearInterval(scrollInterval);
			}			
		})
		
		//Fin du double écran
		$(window).bind('beforeunload', function() {
    		$('#code', window.opener.document).val($('#t-numero').text());
			$('#form_code', window.opener.document).submit();
			if (composition && !composition.closed)
				composition.close();
			if (edition)
				edition.close();
		});

	}	
	
});