<?php include('../prog/prog.php');

//Affiche la composition à jour
$manager->composition();
$page = new Page;

?>

<!DOCTYPE html>
<html>
    <head>
        <title>Télécommande | v-jemaf 7</title>
		<meta charset="utf-8" />
		<link rel="stylesheet" href="prog/styles.css" type="text/css" />
		<link rel="icon" type="image/png" href="img/t-icone.png" />
    </head>
	
    <body>

		<div id="reduire_compo" class="reduire"><img class="icone" src="img/reduire.svg" title="Afficher / Masquer la composition" /></div>
		<div id="reduire_previsu" class="reduire"><img class="icone" src="img/reduire.svg" title="Afficher / Masquer la prévisualisation" /></div>
		
		<div id="div_telec">
			<fieldset id="field_compo" <?= in_array($conf->ouv_telec, ['ouv_0', 'ouv_1']) ? 'class="d-none"' : '' ?>>
				<legend id="legend_composition" class="hover">Composition<?= $page->svg('edit') ?></legend>
				
				<div class="flex-column">
					<ul id="liste-compo"><?php echo $liens; ?></ul>
				</div>
			</fieldset>
			
			<fieldset id="t-centre">
				<legend>Télécommande</legend>
				<div class="flex-column">
					<div class="icone-row">
						<input type="text" id="code" name="code"  autocomplete="off" />
						<span id="afficher" class="icone" title="Afficher"><?= $page->svg('open_in_new') ?></span>
						<span id="previsu" class="icone" title="Prévisualiser"><?= $page->svg('pageview') ?></span>
						<span id="menu" class="icone" title="Menu"><?= $page->svg('menu') ?></span>
					</div>
					
					<aside>
						<a href="prev_liste" target="prev"><?= $page->svgMenu('music_note') ?>Afficher un chant</a>
						<a href="prev_rech-chant" target="prev"><?= $page->svgMenu('search') ?>Rechercher un chant</a>
						<a href="prev_choix-b" target="prev"><?= $page->svgMenu('book') ?>Lecture Biblique</a>
						<a href="prev_rech-b" target="prev"><?= $page->svgMenu('auto_stories') ?>Rechercher un verset</a>
						<a id="lien_composition"><?= $page->svgMenu('list') ?>Composition</a>
						<a id="lien_edition"><?= $page->svgMenu('edit') ?>Editer un chant</a>
						<a href="prev_parametres" target="prev"><?= $page->svgMenu('settings') ?>Paramètres</a>
						<a href="prev_aide" target="prev"><?=  $page->svgMenu('help') ?>Aide</a>
					</aside>

					<span id="t-droite" class="icone" title="Avancer"><?= $page->svg('keyboard_arrow_right') ?>
						<span title="Scroller"><?= $page->svg('unfold_more') ?></span>
					</span>
					<div id="t-numero"></div>
					<div id="t-titre"></div>
					<ul id="liens"></ul>
					<div id="arrows-bottom" class="icone-row">
						<span class="icone" title="Remonter rapidement"><?= $page->svg('double_arrow_up') ?></span>
						<span class="icone" title="Remonter doucement"><?= $page->svg('arrow_up') ?></span>
						<span class="icone" title="Descendre doucement"><?= $page->svg('arrow_down') ?></span>
						<span class="icone" title="Descendre rapidement"><?= $page->svg('double_arrow_down') ?></span>
					</div>
				</div>
			</fieldset>
			
			<fieldset id="field_previsu" <?= in_array($conf->ouv_telec, ['ouv_0', 'ouv_2']) ? 'class="d-none"' : '' ?>>
				<legend id="legend_previsu" class="hover">Prévisualisation<?= $page->svg('edit') ?></legend>
				<iframe id="previsualisation" name="prev" src="prev_chant=accueil"></iframe>
			</fieldset>
		</div>
		
		<data data-Ouv_telec="<?php echo $conf->ouv_telec; ?>" data-Click_compo="<?php echo $conf->click_compo; ?>"></data>
		
		<script type="text/javascript" src="prog/jquery-3.7.1.min.js"></script>
		<script type="text/javascript" src="prog/jquery.js"></script>
		<script type="text/javascript" src="prog/common.js"></script>
		<script>
			var click_compo="<?= $conf->click_compo ?>";
			var ouv_telec="<?= $conf->ouv_telec ?>";
		</script>
	</body>
</html>